

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetVsaAnalyticsWorkInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetVsaAnalyticsWorkInfo.sp,v $ $Id: archGetVsaAnalyticsWorkInfo.sp,v 1.8.12.2 2018/03/20 19:53:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetVsaAnalyticsWorkInfo <<<'

IF EXISTS (select * from sysobjects where name='archGetVsaAnalyticsWorkInfo')
	drop procedure archGetVsaAnalyticsWorkInfo
IF EXISTS (select * from GxQscripts where name='archGetVsaAnalyticsWorkInfo')
	delete from GxQscripts where name = 'archGetVsaAnalyticsWorkInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetVsaAnalyticsWorkInfo')
	delete from GXDBVersions where aliasname = 'archGetVsaAnalyticsWorkInfo'
GO
print '... Creating Procedure: archGetVsaAnalyticsWorkInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetVsaAnalyticsWorkInfo
  @i_CIJobId int,
  @i_archGroupId int
AS
  DECLARE @o_clientId integer;
  DECLARE @o_backupSetId integer;
  DECLARE @o_appId integer;
SET NOCOUNT ON
declare @clientComputers table
(
	clientId int primary key,
	propertyExists tinyint
)
--
-- Joining with APP_Client since when the job executes some of the clients may be deleted.
insert into @clientComputers(clientId, propertyExists)
select
	cast(oc.value as xml).value('(/clients/@clientId)[1]', 'int') as clientId,
	0 as enabledValue
from
	dbo.GetJobOptionList (@i_CIJobId, 1810277523) oc
inner join
	APP_Client c
on
	c.id = cast(oc.value as xml).value('(/clients/@clientId)[1]', 'int')
--
-- auto enable analytics here
update
	@clientComputers
set
	propertyExists = 1
from
	@clientComputers c
inner join
	APP_ClientProp p
on
	p.componentNameId = c.clientId
	and p.attrName = 'Content Indexing Enabled'
	and modified = 0
--
begin transaction
--
INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified,ccpId)
select c.clientId, 'Content Indexing Enabled', 2, 1, dbo.GetUnixTime(getdate()), 0, 0 from @clientComputers c
where c.propertyExists = 0
--
update APP_ClientProp set attrVal = 1
from APP_ClientProp p inner join @clientComputers c on p.componentNameId = c.clientId and p.attrName = 'Content Indexing Enabled' and attrVal = '0' and modified = 0
--
commit transaction
--
select
	cc.clientId as clientId, a.backupSet as backupSetId, a.id as appId
from
	APP_Application a
inner join
	@clientComputers cc
on
	cc.clientId = a.clientId
where
a.appTypeId = 106
	and a.dataArchGrpID = @i_archGroupId
order by
	cc.clientId, a.backupSet
--
GO

IF EXISTS (select * from GxQscripts where name = 'archGetVsaAnalyticsWorkInfo')
	delete from GxQscripts where name = 'archGetVsaAnalyticsWorkInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetVsaAnalyticsWorkInfo')
	delete from GXDBVersions where aliasname = 'archGetVsaAnalyticsWorkInfo'
GO

insert into GXDBVersions values(2, 'archGetVsaAnalyticsWorkInfo',  '00010008001200020000', 'archGetVsaAnalyticsWorkInfo', '00010008001200020000')
GO

