

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetVSAChildJobsToMaterialize.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGetVSAChildJobsToMaterialize.sp                        */
/*                                                                            */
/*  Description :  Return jobs to be processed for backup copy                */
/*																			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetVSAChildJobsToMaterialize.sp,v $ $Id: archGetVSAChildJobsToMaterialize.sp,v 1.1.6.2 2018/03/23 12:46:17 dradhakrishnan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetVSAChildJobsToMaterialize <<<'

IF EXISTS (select * from sysobjects where name='archGetVSAChildJobsToMaterialize')
	drop procedure archGetVSAChildJobsToMaterialize
IF EXISTS (select * from GxQscripts where name='archGetVSAChildJobsToMaterialize')
	delete from GxQscripts where name = 'archGetVSAChildJobsToMaterialize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetVSAChildJobsToMaterialize')
	delete from GXDBVersions where aliasname = 'archGetVSAChildJobsToMaterialize'
GO
print '... Creating Procedure: archGetVSAChildJobsToMaterialize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetVSAChildJobsToMaterialize
  @i_parentJobId integer,
  @i_commcellId integer
AS
  DECLARE @o_childJobId integer
  DECLARE @o_commcellId integer
SELECT JSS.jobId, JSS.commcellId
FROM JMJobDataLink JMLINK WITH(NOLOCK) INNER JOIN JMJobSnapShotStats JSS WITH(NOLOCK) ON JMLINK.childJobId = JSS.jobId AND JMLINK.commCellId = JSS.commcellId
WHERE JMLINK.linkType = 7 AND JMLINK.parentJobId = @i_parentJobId AND JMLINK.commCellId = @i_commcellId AND JSS.materializationStatus IN (101, 102, 103)
AND (JSS.disabled & 1) = 0
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetVSAChildJobsToMaterialize')
	delete from GxQscripts where name = 'archGetVSAChildJobsToMaterialize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetVSAChildJobsToMaterialize')
	delete from GXDBVersions where aliasname = 'archGetVSAChildJobsToMaterialize'
GO

insert into GXDBVersions values(2, 'archGetVSAChildJobsToMaterialize',  '00010001000600020000', 'archGetVSAChildJobsToMaterialize', '00010001000600020000')
GO

