

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetVSAChildJobsToCatalog.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGetVSAChildJobsToCatalog.sp                            */
/*                                                                            */
/*  Description :  Return jobs to be processed for deferred catalog           */
/*																			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetVSAChildJobsToCatalog.sp,v $ $Id: archGetVSAChildJobsToCatalog.sp,v 1.1.6.2 2018/03/23 12:46:35 dradhakrishnan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetVSAChildJobsToCatalog <<<'

IF EXISTS (select * from sysobjects where name='archGetVSAChildJobsToCatalog')
	drop procedure archGetVSAChildJobsToCatalog
IF EXISTS (select * from GxQscripts where name='archGetVSAChildJobsToCatalog')
	delete from GxQscripts where name = 'archGetVSAChildJobsToCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetVSAChildJobsToCatalog')
	delete from GXDBVersions where aliasname = 'archGetVSAChildJobsToCatalog'
GO
print '... Creating Procedure: archGetVSAChildJobsToCatalog'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetVSAChildJobsToCatalog
  @i_parentJobId integer,
  @i_commcellId integer
AS
  DECLARE @o_childJobId integer
  DECLARE @o_commcellId integer
SELECT JSS.jobId, JSS.commcellId
FROM JMJobDataLink JMLINK WITH(NOLOCK) INNER JOIN JMJobSnapDeferredCatalogStats JSS WITH(NOLOCK) ON JMLINK.childJobId = JSS.jobId AND JMLINK.commCellId = JSS.commcellId
WHERE JMLINK.linkType = 7 AND JMLINK.parentJobId = @i_parentJobId AND JMLINK.commCellId = @i_commcellId AND JSS.catalogStatus IN (101, 102, 103)
AND (JSS.disabled & 1) = 0
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetVSAChildJobsToCatalog')
	delete from GxQscripts where name = 'archGetVSAChildJobsToCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetVSAChildJobsToCatalog')
	delete from GXDBVersions where aliasname = 'archGetVSAChildJobsToCatalog'
GO

insert into GXDBVersions values(2, 'archGetVSAChildJobsToCatalog',  '00010001000600020000', 'archGetVSAChildJobsToCatalog', '00010001000600020000')
GO

