

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetUnMaterializedSnaps.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGetUnMaterializedSnaps								  */
/*                                                                            */
/*  Description :  Stored proc to return jobs that are not moved to tape	  */
/*				   from last full job to current given jobId for 			  */
/*				   given subclient. 										  */
/*				   This is for an FS agent 									  */
/*				   specific feature(block level backups).					  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetUnMaterializedSnaps.sp,v $ $Id: archGetUnMaterializedSnaps.sp,v 1.2.150.9 2018/09/16 03:06:03 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetUnMaterializedSnaps <<<'

IF EXISTS (select * from sysobjects where name='archGetUnMaterializedSnaps')
	drop procedure archGetUnMaterializedSnaps
IF EXISTS (select * from GxQscripts where name='archGetUnMaterializedSnaps')
	delete from GxQscripts where name = 'archGetUnMaterializedSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetUnMaterializedSnaps')
	delete from GXDBVersions where aliasname = 'archGetUnMaterializedSnaps'
GO
print '... Creating Procedure: archGetUnMaterializedSnaps'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetUnMaterializedSnaps
  @appId integer,
  @currSnapJobId integer,
  @currSnapJobCCId integer
-- Following are the "columns" returned, in the order in which they are returned
AS
  DECLARE @retCode integer;
  DECLARE @jobId integer;
  DECLARE @jobCCId integer;
  DECLARE @bkpLevel integer;
  DECLARE @flags integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @lt_jobList table(jobId int, jobCCId int, archGrpId int, bkpLevel int,sequence int)
DECLARE @rowCount int = 0
DECLARE @cycleNum int = 0
DECLARE @lastMovedSnapServStart int = 0
DECLARE @currJobServStart int = 0
DECLARE	@checkSnapToTapeInSameJob INT = 0
SET	@flags  = 0
IF @currSnapJobId > 0
BEGIN
	-- abaglodi : Check if its a running job. Changes done in order to handle snap and backup copy done as part of the same job.
SELECT	@checkSnapToTapeInSameJob = CASE WHEN bkpAttributesEx & 0x800000 = 0x800000
																					 THEN 1 ELSE 0
																			END
	FROM	JMBkpJobInfo WITH (NOLOCK)
	WHERE	jobId = @currSnapJobId
	AND 	commcellId = @currSnapJobCCId
	IF @checkSnapToTapeInSameJob = 0
	BEGIN
		SELECT @cycleNum = fullCycleNum, @currJobServStart = servStartDate
		FROM JMBkpStats jbkp WITH(NOLOCK) WHERE jbkp.jobid = @currSnapJobId AND jbkp.commCellId = @currSnapJobCCId
	END
	ELSE
	BEGIN
		SELECT	@cycleNum =	CASE
								WHEN dbo.IsBackupLevelFull(bkpLevel) = 1 THEN ASCP.attrVal + 1
								ELSE ASCP.attrVal
							END,
						@currJobServStart = JOP.attributeValueInt
		FROM	JMBkpJobInfo JBI WITH (NOLOCK) , APP_SubClientProp ASCP WITH (NOLOCK), JMJobOptions JOP WITH (NOLOCK)
		WHERE	JBI.applicationId =  ASCP.componentNameId
			AND	JOP.jobId = JBI.jobId
AND	JOP.attributeId = 52
			AND	JOP.attributeName = 'Snap Phase End Time'  --JM_SNAP_PHASE_END_TIME_FOR_SNAPTOTAPE_NAME
			AND	JBI.commcellId = JOP.commCellId
			AND	JBI.jobId	= @currSnapJobId
			AND JBI.commcellId = @currSnapJobCCId
			AND	ASCP.attrName = 'sys:full cycle num'
			AND	ASCP.modified = 0
	END
END
ELSE
BEGIN
	--If @currSnapJobId = 0 then get latest cycle number and current time for given appId
	SELECT @cycleNum = CAST(attrVal AS INT), @currJobServStart = dbo.GetUnixTime(GETUTCDATE())
	FROM APP_SubClientProp WITH (NOLOCK)
	WHERE componentNameId = @appId
	AND		attrName = N'sys:full cycle num'
	AND		modified = 0
END
SELECT @retCode = @@ERROR, @rowCount = @@ROWCOUNT
IF @retCode <> 0 OR @rowCount = 0
	GOTO PROC_EXIT
SELECT @lastMovedSnapServStart = ISNULL(MAX(jbkp.servStartDate),0)
FROM JMBkpStats jbkp WITH(NOLOCK) inner join JMJobSnapshotStats jss WITH(NOLOCK) ON jbkp.fullCycleNum = @cycleNum AND jbkp.appId = @appId
AND jbkp.jobId = jss.jobId AND jbkp.commCellId = jss.commcellId AND jss.materializationStatus in (100, 102, 103)
AND jbkp.servStartDate < @currJobServStart
SET @retCode = @@ERROR
IF @retCode <> 0
	GOTO PROC_EXIT
INSERT @lt_jobList
SELECT jbkp.jobId, jbkp.commcellId, jbkp.dataArchgrpId, jbkp.bkpLevel,jbkp.cycleSequence
FROM JMBkpStats jbkp WITH(NOLOCK) left outer join JMJobSnapShotStats jss WITH(NOLOCK) ON jbkp.jobId = jss.jobId AND jbkp.commcellId = jss.commcellId
WHERE jbkp.fullCycleNum = @cycleNum AND jbkp.appId = @appId AND jbkp.servStartDate < @currJobServStart
AND jbkp.servStartDate > @lastMovedSnapServStart AND jbkp.opType IN (59,65) /*SNAPBACKUP , SNAPBACKUP3RD*/ AND (jss.jobId is null OR jss.materializationStatus = 101)
AND jbkp.status in (1,3,14) -- JMSUCCESS,  PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
-- Adding status check to consider only success jobs to see if they are aged. Filtering failed and killed job
SELECT @retCode = @@ERROR
IF @retCode <> 0
	GOTO PROC_EXIT
DELETE @lt_jobList
FROM @lt_jobList jList inner join ArchGroup AG WITH(NOLOCK) ON jList.archGrpId = AG.id
left outer join JMJobDataStats jds WITH(NOLOCK) ON jds.jobId = jList.jobId AND jds.commcellId = jList.jobCCId AND jds.archGrpCopyId = AG.defaultSnapCopy AND jds.status = 100 AND jds.disabled & 256 = 0
WHERE jds.jobId is null
SELECT @retCode = @@ERROR, @rowCount = @@ROWCOUNT
IF @retCode <> 0
	GOTO PROC_EXIT
IF @rowCount > 0
SET @flags = @flags | 1
ELSE
IF EXISTS
(
SELECT 1
FROM   JMBkpStats JBS WITH (NOLOCK) INNER JOIN JMJobSnapshotStats JSS WITH (NOLOCK) ON JBS.jobId = JSS.jobId AND JBS.commcellId = JSS.commcellId AND JSS.materializationStatus = 100
INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JBS.jobId = JDS.jobId AND JBS.commCellId = JDS.commCellId AND JDS.dataType = 1 AND (JDS.disabled & 256) = 256
INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON JDS.archGrpCopyId = AGC.id AND AGC.isSnapCopy = 0
WHERE  JBS.fullCycleNum = @cycleNum AND JBS.appId = @appId AND JBS.opType IN (59, 65)/*SNAPBACKUP , SNAPBACKUP3RD*/ and JBS.servStartDate <= @lastMovedSnapServStart
)
SET    @flags = @flags | 1
SET @retCode = 0
PROC_EXIT:
IF EXISTS(SELECT 1 FROM @lt_jobList)
	SELECT @retCode, jobId, jobCCId, bkpLevel, @flags
	FROM @lt_jobList ORDER BY jobId, jobCCId
ELSE
	SELECT	@retCode, 0, 0, 0, @flags
GO

IF EXISTS (select * from GxQscripts where name = 'archGetUnMaterializedSnaps')
	delete from GxQscripts where name = 'archGetUnMaterializedSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetUnMaterializedSnaps')
	delete from GXDBVersions where aliasname = 'archGetUnMaterializedSnaps'
GO

insert into GXDBVersions values(2, 'archGetUnMaterializedSnaps',  '00010002015000090000', 'archGetUnMaterializedSnaps', '00010002015000090000')
GO

