

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetSubclientsForDataSetCreation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetSubclientsForDataSetCreation.sp,v $ $Id: archGetSubclientsForDataSetCreation.sp,v 1.6.60.3 2020/06/30 04:55:53 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetSubclientsForDataSetCreation')
BEGIN
	print '>>> Drop Stored Procedure: archGetSubclientsForDataSetCreation <<<'
	drop procedure archGetSubclientsForDataSetCreation
END
IF EXISTS (select * from GxQscripts where name='archGetSubclientsForDataSetCreation')
	delete from GxQscripts where name = 'archGetSubclientsForDataSetCreation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSubclientsForDataSetCreation')
	delete from GXDBVersions where aliasname = 'archGetSubclientsForDataSetCreation'
GO
print '... Creating Procedure: archGetSubclientsForDataSetCreation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetSubclientsForDataSetCreation
  @i_archGroupCopyId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
-- Column of NVARCHAR_UTF8(MAX) type should be at the end
  DECLARE @appId INT
  DECLARE @ControlHostId INT
  DECLARE @SMRelationId INT
  DECLARE @ExtRelationId NVARCHAR(512)
  DECLARE @ClientName NVARCHAR(255)
  DECLARE @iDAName VARCHAR(255)
  DECLARE @InstanceName NVARCHAR(255)
  DECLARE @BackupsetName NVARCHAR(255)
  DECLARE @SubclientName NVARCHAR(255)
  DECLARE @CommCellName NVARCHAR(255)
SET NOCOUNT ON
DECLARE	@tblApp			TABLE (appId INT)
DECLARE	@tblRelation	TABLE (ControlHostId INT, SMRelationId INT, ExtRelationId NVARCHAR(512))
INSERT	INTO @tblApp
SELECT	DISTINCT AF.appId
FROM	archFileCopy AFC WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED)
WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = @i_archGroupCopyId
AND AFC.isValid = 0 AND (AF.flags & 2) = 2 AND (AFC.flags & 256) = 0
INSERT	INTO @tblRelation
SELECT	ControlHostId, SMRelationId, ExtRelationId
FROM	SMRelation WITH (READUNCOMMITTED)
WHERE	SMRelationId IN (SELECT SMRelationId FROM SMCopyToRelationMap WITH (READUNCOMMITTED) WHERE	ArchGroupCopyId = @i_archGroupCopyId)
DELETE	@tblApp
FROM	@tblApp A, @tblRelation B, SMDataSetToSubClientMap C WITH (READUNCOMMITTED)
WHERE	A.appId = C.appId AND C.SMRelationId = B.SMRelationId AND (C.Flags & 256) = 0
IF EXISTS(	SELECT	AG.id
			FROM	archGroup AG  WITH (READUNCOMMITTED)
					INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED)
						ON AGC.id = @i_archGroupCopyId AND AG.id = AGC.archGroupId
					INNER JOIN ArchGroupControlHost AGHOST WITH (READUNCOMMITTED)
						ON AG.id = AGHOST.ArchGroupId AND AGHOST.SMReplicationProtocolType = 1)
BEGIN
	INSERT	INTO SMDataSetToSubClientMap
	SELECT	A.AppId, MAP.ControlHostId, MAP.SMRelationId, MAP.DataSetId, MAP.Flags, MAP.ArchGroupId,
			MAP.AgedTime, MAP.AgedBy
	FROM	@tblApp A, SMDataSetToSubClientMap MAP  WITH (READUNCOMMITTED), @tblRelation REL
	WHERE	MAP.SMRelationId = REL.SMRelationId AND MAP.AppId = 0
	DELETE	FROM @tblApp
END
SELECT	A.appId, B.ControlHostId, B.SMRelationId, B.ExtRelationId,
		(SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = APP.clientId),
		(SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = APP.appTypeId),
		(SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = APP.instance),
		(SELECT name FROM APP_BackupsetName WITH (READUNCOMMITTED) WHERE id = APP.backupset),
		APP.subclientName,
		(SELECT aliasName FROM APP_CommCell WITH (READUNCOMMITTED) WHERE id = 2)
FROM	APP_Application APP WITH (READUNCOMMITTED), @tblApp A, @tblRelation B
WHERE	APP.id = A.appId
GO

IF EXISTS (select * from GxQscripts where name = 'archGetSubclientsForDataSetCreation')
	delete from GxQscripts where name = 'archGetSubclientsForDataSetCreation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSubclientsForDataSetCreation')
	delete from GXDBVersions where aliasname = 'archGetSubclientsForDataSetCreation'
GO

insert into GXDBVersions values(2, 'archGetSubclientsForDataSetCreation',  '00010006006000030000', 'archGetSubclientsForDataSetCreation', '00010006006000030000')
GO

