

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetStreamArrayFromArchFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetStreamArrayFromArchFile.sp,v $ $Id: archGetStreamArrayFromArchFile.sp,v 1.3.66.1 2018/03/20 19:47:53 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetStreamArrayFromArchFile <<<'

IF EXISTS (select * from sysobjects where name='archGetStreamArrayFromArchFile')
	drop procedure archGetStreamArrayFromArchFile
IF EXISTS (select * from GxQscripts where name='archGetStreamArrayFromArchFile')
	delete from GxQscripts where name = 'archGetStreamArrayFromArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetStreamArrayFromArchFile')
	delete from GXDBVersions where aliasname = 'archGetStreamArrayFromArchFile'
GO
print '... Creating Procedure: archGetStreamArrayFromArchFile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetStreamArrayFromArchFile
  @i_archFileId int,
  @i_copyId int,
  @i_fileType int,
  @i_CommCellId int
AS
  DECLARE @o_streamNum int
  DECLARE @o_archFileId int
  DECLARE @o_backupJobId int
  DECLARE @o_primaryCopyId int
  DECLARE @o_CommCellId int
  DECLARE @o_StreamFileCount int
  DECLARE @o_StreamCount int
/*
* First find out the jobid from archFileid.
* Insert list of streamNum, archfileids -> from job id and archfileid,copyid combo
*/
DECLARE @StreamArrayTable TABLE (StreamNum int, archFileId int, CommCellId int, StreamFileCount int)
DECLARE @o_retVal INTEGER
SET @o_retVal = 0
SELECT  @o_backupJobId = AF.jobId,
		@o_primaryCopyId = AG.defaultCopy
FROM archFile AF WITH (READUNCOMMITTED)
JOIN archGroup AG WITH (READUNCOMMITTED) ON AG.id = AF.archGroupId
WHERE AF.id = @i_archFileId
	AND AF.CommCellId = @i_CommCellId
SELECT	@o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
INSERT INTO @StreamArrayTable
SELECT AFC.streamNum, AFC.archFileId, AFC.CommCellId, 0
FROM archFileCopy AFC WITH(READUNCOMMITTED)
JOIN archFile AF WITH (READUNCOMMITTED) ON AFC.archFileId = AF.id AND AFC.CommCellId = AF.CommCellId
WHERE AFC.archCopyId = @i_copyId
	AND AF.jobId = @o_backupJobId
	AND (@i_fileType = 0 OR AF.fileType = @i_fileType)
  --AND AF.archGroupId = @i_archGroupId
	AND AF.CommCellId = @i_CommCellid
	AND AF.isValid = 1
SELECT	@o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
UPDATE SAT
SET StreamFileCount = (SELECT COUNT(distinct archFileId) FROM @StreamArrayTable where StreamNum = SAT.StreamNum)
FROM @StreamArrayTable SAT
SELECT	@o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT @o_StreamCount = COUNT(DISTINCT StreamNum) FROM @StreamArrayTable
SELECT	@o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
CX_ERROR_EXIT:
	IF(@o_retVal > 0 )
		SELECT @o_retVal, -1, -1, -1, -1, -1
	ELSE
		SELECT StreamNum, archFileId, @o_backupJobId, @o_primaryCopyId, CommCellId, StreamFileCount, @o_StreamCount from @StreamArrayTable
		ORDER BY StreamNum, archFileId

IF EXISTS (select * from GxQscripts where name = 'archGetStreamArrayFromArchFile')
	delete from GxQscripts where name = 'archGetStreamArrayFromArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetStreamArrayFromArchFile')
	delete from GXDBVersions where aliasname = 'archGetStreamArrayFromArchFile'
GO

insert into GXDBVersions values(2, 'archGetStreamArrayFromArchFile',  '00010003006600010000', 'archGetStreamArrayFromArchFile', '00010003006600010000')
GO

