

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetStoragePolicyCopySizeInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetStoragePolicyCopySizeInfo.sp,v $ $Id: archGetStoragePolicyCopySizeInfo.sp,v 1.1.2.6 2020/05/23 14:06:37 chandru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "archGetStoragePolicyCopySizeInfo"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetStoragePolicyCopySizeInfo')
BEGIN
	print '>>> Drop Stored Procedure: archGetStoragePolicyCopySizeInfo <<<'
	drop procedure archGetStoragePolicyCopySizeInfo
END
IF EXISTS (select * from GxQscripts where name='archGetStoragePolicyCopySizeInfo')
	delete from GxQscripts where name = 'archGetStoragePolicyCopySizeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetStoragePolicyCopySizeInfo')
	delete from GXDBVersions where aliasname = 'archGetStoragePolicyCopySizeInfo'
GO
print '... Creating Procedure: archGetStoragePolicyCopySizeInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetStoragePolicyCopySizeInfo
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_xml XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
DECLARE @copyTbl		TABLE (copyId int, requiresBackupsOnOrAfterDate int, oldestJobStartTime int, dataSize bigint)
DECLARE @l_policyId		INT = 0
DECLARE @l_copyId		INT = 0
DECLARE @l_allCopies    INT = 0
DECLARE @l_sizeLimit	BIGINT = 10 * 1024
DECLARE @l_oldestJobStartTimeLimit	BIGINT = dbo.GetUnixTime(DATEADD(dd, -14, GETUTCDATE()))
SET @l_policyId = (SELECT A.ref.value('@storagePolicyId', 'int') FROM @i_xml.nodes('/GuiServer_GetStoragePolicyCopySizeInfoReq/storagePolicy') A(ref));
SET @l_copyId = ISNULL((SELECT A.ref.value('@copyId', 'int') FROM @i_xml.nodes('/GuiServer_GetStoragePolicyCopySizeInfoReq/spCopy') A(ref)), 0);
SET @l_allCopies = ISNULL((SELECT A.ref.value('@allCopies', 'int') FROM @i_xml.nodes('/GuiServer_GetStoragePolicyCopySizeInfoReq/spCopy') A(ref)), 0);
IF @l_allCopies = 1
BEGIN
   SET @l_copyId = -1
END
INSERT INTO @copyTbl
SELECT	AGC.id, 0, dbo.getUnixTime(GetUTCDate()), 0
FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
WHERE	AGC.archGroupId = AG.id
		AND AGC.archGroupId = @l_policyId
		AND (@l_copyId = -1 OR AGC.id = @l_copyId OR (@l_copyId = 0 AND AG.defaultCopy = AGC.id))
UPDATE	C
SET		oldestJobStartTime = ISNULL(CI.oldestJobStartTime, dbo.getUnixTime(GetUTCDate())),
		dataSize = ISNULL(CI.applicationSize, 0)
FROM	@copyTbl C,
		(SELECT	JDS.archGrpCopyId, MIN(JBS.servStartDate) oldestJobStartTime, SUM(CASE WHEN JDS.unCompSize > 0 THEN JDS.unCompSize ELSE JDS.sizeOnMedia END)/1024.0/1024.0/1024.0 applicationSize
		FROM	@copyTbl T
INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON T.copyId = JDS.archGrpCopyId AND (JDS.disabled & (256|1)) = 0
				INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON JDS.jobId = JBS.jobId AND JDS.commCellId = JBS.commCellId
		GROUP BY JDS.archGrpCopyId) CI
WHERE	C.copyId = CI.archGrpCopyId
UPDATE	C
SET		requiresBackupsOnOrAfterDate = (CASE WHEN (oldestJobStartTime < @l_oldestJobStartTimeLimit OR dataSize > @l_sizeLimit) THEN 1 ELSE 0 END)
FROM	@copyTbl C
SELECT
	oldestJobStartTime AS '@oldestJobStartTime',
	dataSize AS '@dataSizeInGB',
	requiresBackupsOnOrAfterDate AS '@requiresBackupsOnOrAfterDate',
	(SELECT	AG.id AS '@storagePolicyId',
		AG.name AS '@storagePolicyName',
		AGC.id AS '@copyId',
		AGC.name AS '@copyName'
	FROM	archGroupCopy AGC, archGroup AG
	WHERE	AGC.id = T.copyId
		AND AGC.archGroupId = AG.id
	FOR XML PATH ('spCopy'), TYPE)
FROM @copyTbl T
FOR XML PATH('copyInfo'), ROOT('GuiServer_GetStoragePolicyCopySizeInfoResp')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archGetStoragePolicyCopySizeInfo')
	delete from GxQscripts where name = 'archGetStoragePolicyCopySizeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetStoragePolicyCopySizeInfo')
	delete from GXDBVersions where aliasname = 'archGetStoragePolicyCopySizeInfo'
GO

insert into GXDBVersions values(2, 'archGetStoragePolicyCopySizeInfo',  '00010001000200060000', 'archGetStoragePolicyCopySizeInfo', '00010001000200060000')
GO

