

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetStoragePolicyCopyInfoWithPrecedenceForAC.sp] ---------- 

--  +========================================================================+
--  | Stored Proc:  archGetStoragePolicyCopyInfoWithPrecedenceForAC
--  |
--  | Description: sets currency preference.
--  | As per @Hetal, For Admin console we need below behaviour while fetching
--  | 			the storage policy copy information with precedence
--  | 1. Use the default subclient SP\copies names for backupSetId
--  | 2. If default subclient is not associated to SP then pick top 1 subclient and its SP\copies.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetStoragePolicyCopyInfoWithPrecedenceForAC')
BEGIN
	print '>>> Drop Stored Procedure: archGetStoragePolicyCopyInfoWithPrecedenceForAC <<<'
	drop procedure archGetStoragePolicyCopyInfoWithPrecedenceForAC
END
IF EXISTS (select * from GxQscripts where name='archGetStoragePolicyCopyInfoWithPrecedenceForAC')
	delete from GxQscripts where name = 'archGetStoragePolicyCopyInfoWithPrecedenceForAC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetStoragePolicyCopyInfoWithPrecedenceForAC')
	delete from GXDBVersions where aliasname = 'archGetStoragePolicyCopyInfoWithPrecedenceForAC'
GO
print '... Creating Procedure: archGetStoragePolicyCopyInfoWithPrecedenceForAC'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetStoragePolicyCopyInfoWithPrecedenceForAC
  @i_BackupSetId INT = 0,
  @i_SubclientId INT = 0,
  @i_UserId INT = 0
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
DECLARE @tblCopyId TABLE(copyId int)
DECLARE @hasRightsOnSubClient INT = 0
DECLARE @hasRightsOnBackupSet INT = 0
DECLARE @entityType1 INT = 0
DECLARE @entityId1 INT = 0
DECLARE @entityType2 INT = 0
DECLARE @entityId2 INT = 0
DECLARE @entityType3 INT = 0
DECLARE @entityId3 INT = 0
DECLARE @entityType4 INT = 0
DECLARE @entityId4 INT = 0
DECLARE @entityType5 INT = 0
DECLARE @entityId5 INT = 0
IF @i_BackupSetId > 0
BEGIN
SET @entityType1 = 3
SET @entityType2 = 4
SET @entityType3 = 5
SET @entityType4 = 6
	SELECT 	TOP 1 @entityId1 = clientId, @entityId2 = appTypeId, @entityId3 = instance, @entityId4 = backupSet
	FROM APP_Application
	WHERE backupSet = @i_BackupSetId
	EXEC sec_checkPermissionOnEntity @i_UserId, '0', @hasRightsOnBackupSet OUTPUT, @entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityTYpe4, @entityId4
END
IF @i_SubclientId > 0
BEGIN
SET @entityType1 = 3
SET @entityType2 = 4
SET @entityType3 = 5
SET @entityType4 = 6
SET @entityType5 = 7
	SELECT 	@entityId1 = clientId, @entityId2 = appTypeId, @entityId3 = instance, @entityId4 = backupSet, @entityId5 = id
	FROM APP_Application
	WHERE id = @i_SubclientId
	EXEC sec_checkPermissionOnEntity @i_UserId, '0', @hasRightsOnSubClient OUTPUT, @entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityTYpe4, @entityId4, @entityType5, @entityId5
END
IF OBJECT_ID('tempdb.dbo.#tmpAssociatedCopy') IS NOT NULL DROP TABLE #tmpAssociatedCopy
CREATE  TABLE #tmpAssociatedCopy (copyId int)
CREATE CLUSTERED INDEX tmpAssociatedCopy_copyId_Idx ON #tmpAssociatedCopy (copyId)
EXEC sec_getNonIdaObjectsForThisUser @i_UserId, 18, 0, '#tmpAssociatedCopy'
-- Use the default subclient SP\copies names if backupSetId provided.
-- Or all SP\copies if subclientId is provided.
INSERT INTO @tblCopyId
SELECT DISTINCT JOB.archGrpCopyId FROM JMJobDataStats JOB
INNER JOIN APP_Application APP ON JOB.appId = APP.id
INNER JOIN #tmpAssociatedCopy AS TAC ON JOB.archGrpCopyId = TAC.copyId
WHERE (((@i_BackupSetId > 0 AND APP.backupSet = @i_BackupSetId) AND (APP.subclientStatus & 0x00008) = 0x00008 AND @hasRightsOnBackupSet = 1)
							OR
		(@i_SubclientId > 0 AND APP.id = @i_SubclientId AND @hasRightsOnSubClient = 1))
IF NOT EXISTS(SELECT TOP 1 copyId FROM @tblCopyId) AND @i_BackupSetId > 0
BEGIN
	-- If default subclient is not associated to SP then pick top 1 subclient and its SP\copies for provided backupSetId.
	DECLARE @topSubclientId INT = 0
	SELECT TOP 1 @topSubclientId = APP.id
				FROM APP_Application APP
				INNER JOIN JMJobDataStats JOB ON APP.id = JOB.appId
				INNER JOIN #tmpAssociatedCopy AS TAC ON JOB.archGrpCopyId = TAC.copyId
WHERE ((APP.backupSet = @i_BackupSetId) AND ((APP.subclientStatus & 0x00008) <> 0x00008) AND @hasRightsOnBackupSet = 1)
	INSERT INTO @tblCopyId
		SELECT DISTINCT JOB.archGrpCopyId
		FROM JMJobDataStats JOB
		INNER JOIN #tmpAssociatedCopy AS TAC ON JOB.archGrpCopyId = TAC.copyId
		WHERE JOB.appId = @topSubclientId
END
IF EXISTS(SELECT TOP 1 copyId FROM @tblCopyId)
BEGIN
	SET @o_xml = ISNULL ((SELECT(SELECT DISTINCT
											AGC.copy '@precedence',
											AG.id 'archiveGroupCopy/@storagePolicyId',
											AG.name 'archiveGroupCopy/@storagePolicyName',
											AGC.id 'archiveGroupCopy/@copyId',
											AGC.name 'archiveGroupCopy/@copyName'
									FROM archGroupCopy AGC WITH (READUNCOMMITTED)
									JOIN @tblCopyId C ON AGC.id = C.copyId
									JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId=AG.id
WHERE ((AGC.flags & 524288) = 0
											AND AGC.copy <> -1 AND AGC.id > 0
AND AGC.type NOT IN (5, 8))
							FOR XML PATH('copyInfo'), TYPE)
					FOR XML PATH('App_GetStoragePolicyCopyPrecedenceResp'), TYPE),N'<App_GetStoragePolicyCopyPrecedenceResp/>')
END
ELSE
BEGIN
	SET @o_xml = '<App_GetStoragePolicyCopyPrecedenceResp/>'
END
-- Send storage policy copy precedence information.
SELECT @o_xml as 'o_xml'
IF OBJECT_ID('tempdb.dbo.#tmpAssociatedCopy') IS NOT NULL DROP TABLE #tmpAssociatedCopy
IF OBJECT_ID('tempdb.dbo.#tmpAssociatedSubClients') IS NOT NULL DROP TABLE #tmpAssociatedSubClients
END
GO

IF EXISTS (select * from GxQscripts where name = 'archGetStoragePolicyCopyInfoWithPrecedenceForAC')
	delete from GxQscripts where name = 'archGetStoragePolicyCopyInfoWithPrecedenceForAC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetStoragePolicyCopyInfoWithPrecedenceForAC')
	delete from GXDBVersions where aliasname = 'archGetStoragePolicyCopyInfoWithPrecedenceForAC'
GO

insert into GXDBVersions values(2, 'archGetStoragePolicyCopyInfoWithPrecedenceForAC',  '00000000000000000000', 'archGetStoragePolicyCopyInfoWithPrecedenceForAC', '00000000000000000000')
GO

