

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetSourceClientsForMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetSourceClientsForMA.sp,v $ $Id: archGetSourceClientsForMA.sp,v 1.1.2.1 2018/03/22 21:07:09 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetSourceClientsForMA <<<'

IF EXISTS (select * from sysobjects where name='archGetSourceClientsForMA')
	drop procedure archGetSourceClientsForMA
IF EXISTS (select * from GxQscripts where name='archGetSourceClientsForMA')
	delete from GxQscripts where name = 'archGetSourceClientsForMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSourceClientsForMA')
	delete from GXDBVersions where aliasname = 'archGetSourceClientsForMA'
GO
print '... Creating Procedure: archGetSourceClientsForMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetSourceClientsForMA
  @i_clientId integer
AS
--1. if  client is a file system then we will have to check storage policies that are associated to the sc's and get the primary's ddb ma
DECLARE @copyIds TABLE( copyId int  primary key)
INSERT INTO @copyIds
SELECT DISTINCT copyId
FROM MMDataPath dp WITH (READUNCOMMITTED) JOIN MMDrivePool drvp WITH (READUNCOMMITTED) ON dp.DrivePoolId = drvp.DrivePoolId
WHERE drvp.clientId = @i_clientId
SELECT distinct SubClient.clientId
FROM @copyIds t INNER JOIN archGroup AS StoragePolicy ON t.CopyId = StoragePolicy.defaultCopy INNER JOIN APP_Application AS SubClient ON StoragePolicy.id = SubClient.dataArchGrpID OR StoragePolicy.id = SubClient.logArchGrpID
WHERE SubClient.clientId <> @i_clientId
UNION
SELECT distinct drvp.clientID
FROM MMDataPath dp WITH (READUNCOMMITTED) JOIN MMDrivePool drvp WITH (READUNCOMMITTED) ON dp.DrivePoolId = drvp.DrivePoolId,
(SELECT CASE WHEN agc.sourceCopyId > 0 THEN agc.sourceCopyId ELSE ag.defaultCopy END AS srcCopyId
	FROM @copyIds c INNER JOIN archGroupCopy AS agc WITH (READUNCOMMITTED) ON c.CopyId = agc.id INNER JOIN Archgroup AS ag WITH (READUNCOMMITTED) ON ag.id = agc.archGroupId
    WHERE agc.id <> ag.defaultCopy) t
 WHERE t.srcCopyId = dp.copyId AND drvp.clientID <> @i_clientId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetSourceClientsForMA')
	delete from GxQscripts where name = 'archGetSourceClientsForMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSourceClientsForMA')
	delete from GXDBVersions where aliasname = 'archGetSourceClientsForMA'
GO

insert into GXDBVersions values(2, 'archGetSourceClientsForMA',  '00010001000200010000', 'archGetSourceClientsForMA', '00010001000200010000')
GO

