

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetSourceClientsForDDBMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetSourceClientsForDDBMA.sp,v $ $Id: archGetSourceClientsForDDBMA.sp,v 1.1.2.4 2018/11/03 03:22:19 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetSourceClientsForDDBMA')
BEGIN
	print '>>> Drop Stored Procedure: archGetSourceClientsForDDBMA <<<'
	drop procedure archGetSourceClientsForDDBMA
END
IF EXISTS (select * from GxQscripts where name='archGetSourceClientsForDDBMA')
	delete from GxQscripts where name = 'archGetSourceClientsForDDBMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSourceClientsForDDBMA')
	delete from GXDBVersions where aliasname = 'archGetSourceClientsForDDBMA'
GO
print '... Creating Procedure: archGetSourceClientsForDDBMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetSourceClientsForDDBMA
  @i_clientId integer
AS
--1. if  client is a file system then we will have to check storage policies that are associated to the sc's and get the primary's ddb ma
DECLARE @storeIds TABLE( storeId int  primary key)
INSERT INTO @storeIds
SELECT DISTINCT SIDBStoreId
FROM IDXSIDBSubStore WITH (READUNCOMMITTED)
WHERE clientId = @i_clientId
SELECT DISTINCT drvp.clientID
FROM @storeIds subStore
INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.SIDBStoreId = subStore.storeId AND ((CS.Flags & 4) > 0)
	INNER JOIN archGroupCopy agc WITH (READUNCOMMITTED) ON agc.id = CS.copyId
	INNER JOIN MMDataPath dp WITH (READUNCOMMITTED) ON dp.copyId = agc.id
	INNER JOIN MMDrivePool drvp WITH (READUNCOMMITTED) ON dp.DrivePoolId = drvp.DrivePoolId AND drvp.clientID <> @i_clientId
UNION
SELECT DISTINCT drvp.clientID
FROM MMDataPath dp WITH (READUNCOMMITTED) JOIN MMDrivePool drvp WITH (READUNCOMMITTED) ON dp.DrivePoolId = drvp.DrivePoolId,
	(SELECT CASE WHEN agc.sourceCopyId > 0 THEN agc.sourceCopyId ELSE ag.defaultCopy END AS srcCopyId
	FROM @storeIds subStore
INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.SIDBStoreId = subStore.storeId AND ((CS.Flags & 4) > 0)
		INNER JOIN archGroupCopy agc WITH (READUNCOMMITTED) ON agc.id = CS.copyId
		INNER JOIN archGroup ag WITH (READUNCOMMITTED) ON ag.id = agc.archGroupId AND agc.id <> ag.defaultCopy) t
WHERE t.srcCopyId = dp.copyId AND drvp.clientID <> @i_clientId
UNION
SELECT DISTINCT aa.clientID
FROM @storeIds subStore
INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.SIDBStoreId = subStore.storeId AND ((CS.Flags & 4) > 0)
	INNER JOIN archGroupCopy agc WITH (READUNCOMMITTED) ON agc.id = CS.copyId
	INNER JOIN ArchGroup ag WITH (READUNCOMMITTED) ON ag.defaultCopy = agc.id AND ag.id = agc.archGroupId
	INNER JOIN APP_Application aa WITH (READUNCOMMITTED) ON aa.dataArchGrpID = ag.id OR aa.logArchGrpID = ag.id AND aa.clientID <> @i_clientId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetSourceClientsForDDBMA')
	delete from GxQscripts where name = 'archGetSourceClientsForDDBMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSourceClientsForDDBMA')
	delete from GXDBVersions where aliasname = 'archGetSourceClientsForDDBMA'
GO

insert into GXDBVersions values(2, 'archGetSourceClientsForDDBMA',  '00010001000200040000', 'archGetSourceClientsForDDBMA', '00010001000200040000')
GO

