

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetSiloChunksByCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetSiloChunksByCopy.sp,v $ $Id: archGetSiloChunksByCopy.sp,v 1.34.210.4 2018/09/08 03:32:58 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetSiloChunksByCopy <<<'

IF EXISTS (select * from sysobjects where name='archGetSiloChunksByCopy')
	drop procedure archGetSiloChunksByCopy
IF EXISTS (select * from GxQscripts where name='archGetSiloChunksByCopy')
	delete from GxQscripts where name = 'archGetSiloChunksByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSiloChunksByCopy')
	delete from GXDBVersions where aliasname = 'archGetSiloChunksByCopy'
GO
print '... Creating Procedure: archGetSiloChunksByCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetSiloChunksByCopy
  @i_copyId int,
  @i_hostClientId int,
  @i_option int
AS
  DECLARE @o_CommCellNumber int;
  DECLARE @o_ccGUID NVARCHAR(256);
  DECLARE @o_SIDBStoreId int;
  DECLARE @o_MountPathId int;
  DECLARE @o_MountPathName NVARCHAR(1024);
  DECLARE @o_UserName varchar(1024);
  DECLARE @o_UserPassword varchar(2048);
  DECLARE @o_VolumeId int;
  DECLARE @o_VolumeName varchar(112);
  DECLARE @o_ChunkId bigint;
  DECLARE @o_ChunkToSiloFlags int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@minHrsAfterVolFull	int
DECLARE	@minVolumeFullTime	int
DECLARE	@maxNumOfChunks		int
DECLARE	@numOfChunks		int
DECLARE	@nVol				int
DECLARE	@l_volumeId			int
SET		@minHrsAfterVolFull = 8
SET		@maxNumOfChunks		= 50000
SELECT	@minHrsAfterVolFull = value
FROM	MMConfigs
WHERE	name = 'MMCONFIGS_BACKUP_SILO_AFTER_VOLUME_FULL_HOURS'
SET		@minVolumeFullTime	= (dbo.GetUnixTime(GETUTCDATE()) - 3600*@minHrsAfterVolFull)
SELECT	@maxNumOfChunks = value
FROM	MMConfigs
WHERE	name = 'MMCONFIGS_BACKUP_SILO_MAX_NUMBER_OF_CHUNKS'
CREATE	TABLE #SiloChunk(ChunkId bigint, CommCellId int, ChunkToSiloFlags int, SIDBStoreId int,
VolumeId int, VolumeName varchar(112), MediaSideId int)
CREATE	TABLE #SiloVolume(MediaSideId int, VolumeId int, numOfChunks int)
SELECT	@i_copyId = sourceCopyId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId AND (flags & 524288) <> 0
INSERT	INTO #SiloChunk
SELECT	AC.archChunkId, AC.commCellId, AC.flags, V.SIDBStoreId, V.VolumeId, V.VolumeName, V.MediaSideId
FROM	archChunkToSilo AC WITH (NOLOCK), MMVolume V WITH (NOLOCK), archCopySIDBStore I WITH (NOLOCK)
WHERE	AC.volumeId = V.VolumeId
	AND V.SIDBStoreId = I.SIDBStoreId
	AND V.SiloStatus = 1
	AND V.VolumeFlags IN (2, 6) /*VOL_FULL, VOL_RECYCLE*/
	AND V.VolumeFullTime < @minVolumeFullTime
	AND I.CopyId = @i_copyId
DELETE	#SiloChunk
FROM	#SiloChunk T, IdxSIDBStore I WITH (NOLOCK)
WHERE	I.SIDBStoreId = T.SIDBStoreId AND (I.flags & 128) <> 0
DELETE	#SiloChunk
FROM	#SiloChunk T, archFileSiloVolume SV WITH (NOLOCK)
WHERE	SV.siloVolumeId = T.VolumeId
	AND (T.ChunkId < SV.lastSiloChunkId
OR T.ChunkId = SV.lastSiloChunkId AND (SV.flags & (1 | 2)) <> 0)
DELETE	#SiloChunk
WHERE	VolumeId IN (SELECT VolumeId FROM MMResource WHERE ReservationType = 2)
IF @i_option = 0
BEGIN
	-- Only return chunks for one silo at a time
	DECLARE	@l_STDBStoreId	INT
	SELECT	@l_STDBStoreId = MIN(SIDBStoreId) FROM #SiloChunk
	DELETE	#SiloChunk
	WHERE	SIDBStoreId <> @l_STDBStoreId
	INSERT	INTO #SiloVolume
	SELECT	MediaSideId, VolumeId, COUNT(ChunkId)
	FROM	#SiloChunk
	GROUP BY MediaSideId, VolumeId
	ORDER BY MediaSideId DESC, VolumeId DESC
	SELECT	@numOfChunks = SUM(numOfChunks) FROM #SiloVolume
	WHILE	@numOfChunks > @maxNumOfChunks
	BEGIN
			SELECT	@nVol = COUNT(*)/2 FROM #SiloVolume
			IF	@nVol = 0
				BREAK
			DELETE	#SiloVolume
			FROM	(SELECT TOP (@nVol) VolumeId FROM #SiloVolume) T
			WHERE	#SiloVolume.VolumeId = T.VolumeId
			SELECT	@numOfChunks = SUM(numOfChunks) FROM #SiloVolume
	END
	CREATE	TABLE #MountPath (MediaSideId int, MountPathId int, MountPathName nvarchar(1024), UserName varchar(1024), UserPassword varchar(2048), CredentialAssocId int)
	INSERT	INTO #MountPath
	SELECT	MP.MediaSideId, MP.MountPathId, MP.MountPathName, MP.UserName, MP.UserPassword, 0
	FROM	MMMountPath MP WITH (NOLOCK), (SELECT DISTINCT MediaSideId FROM #SiloVolume) T
	WHERE	MP.MediaSideId = T.MediaSideId AND MP.MountPathTypeId = 0
	INSERT	INTO #MountPath
	SELECT	DISTINCT MP.MediaSideId, MP.MountPathId,
			CASE
				WHEN RIGHT(DC.Folder, 1) IN ('/', '\') THEN (DC.Folder + MP.MountPathName)
				ELSE (DC.Folder + (CASE WHEN LEFT(DC.Folder, 1) = '/' THEN '/' ELSE '\' END) + MP.MountPathName)
			END,
			DC.UserName, DC.UserPassword, DC.CredentialAssocId
			FROM	MMMountPath MP WITH (NOLOCK), (SELECT DISTINCT MediaSideId FROM #SiloVolume) T,
			MMMountPathToStorageDevice PD WITH (NOLOCK), MMDeviceController DC WITH (NOLOCK)
	WHERE	MP.MediaSideId = T.MediaSideId
		AND MP.MountPathTypeId IN (4,5,7) /*4-MOUNT_PATH_SHARED_STATIC, 5-MOUNT_PATH_SHARED_REPLICA, 7-MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
		AND MP.MountPathId = PD.MountPathId AND PD.DeviceId = DC.DeviceId
		AND (@i_hostClientId = 0 OR DC.ClientId = @i_hostClientId)
	IF @i_hostClientId > 0
		INSERT	INTO #MountPath
		SELECT	DISTINCT MP.MediaSideId, MP.MountPathId, MP.MountPathName, MP.UserName, MP.UserPassword, MDC.CredentialAssocId
		FROM	MMMountPath MP WITH (NOLOCK)
				INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK) ON MSD.MountPathId = MP.MountPathId
				INNER JOIN MMDevice MD WITH (NOLOCK) ON MD.DeviceId = MSD.DeviceId
				INNER JOIN MMDeviceController MDC WITH (NOLOCK) ON MDC.DeviceId = MD.DeviceId, (SELECT DISTINCT MediaSideId FROM #SiloVolume) T
		WHERE	MP.MediaSideId = T.MediaSideId
			AND MP.MountPathTypeId IN (4,5,7) /*4-MOUNT_PATH_SHARED_STATIC, 5-MOUNT_PATH_SHARED_REPLICA, 7-MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			AND MP.MediaSideId NOT IN (SELECT MediaSideId FROM #MountPath)
	DELETE	#SiloChunk
	FROM	#SiloChunk C LEFT OUTER JOIN #SiloVolume V
			ON C.VolumeId = V.VolumeId
	WHERE	V.VolumeId IS NULL
	INSERT	INTO #SiloChunk
	SELECT	SUM(numOfChunks), -9999, 0, @l_STDBStoreId, COUNT(DISTINCT VolumeId), '', -COUNT(DISTINCT MediaSideId)
	FROM	#SiloVolume
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#MountPath', 'CredentialAssocId', 'UserName', 'UserPassword'
	SELECT	ISNULL(CC.number, -9999), ISNULL(CC.csGUID, ''), T.SIDBStoreId,
			ISNULL(MP.MountPathId, T.MediaSideId), ISNULL(MP.MountPathName, ''), ISNULL(MP.UserName, ''), ISNULL(MP.UserPassword, ''),
			T.VolumeId, T.VolumeName, T.ChunkId, T.ChunkToSiloFlags
	FROM	#SiloChunk T
			LEFT JOIN #MountPath MP ON MP.MediaSideId = T.MediaSideId
			LEFT JOIN APP_CommCell CC WITH (NOLOCK) ON CC.id = T.CommCellId
	ORDER BY ISNULL(CC.number, -9999), ISNULL(MP.MountPathId, T.MediaSideId), T.VolumeId, T.ChunkId
	DROP TABLE #SiloVolume
	DROP TABLE #MountPath
END
ELSE
--IF @i_option = 1
	SELECT	TOP 1 0, '', T.SIDBStoreId, (SELECT VolumeFlags FROM MMVolume WITH (NOLOCK) WHERE VolumeId = T.VolumeId),
			'', '', '', T.VolumeId, T.VolumeName, T.ChunkId, T.ChunkToSiloFlags
	FROM	#SiloChunk T
	ORDER BY T.SIDBStoreId, T.MediaSideId, T.VolumeName, T.ChunkId
DROP TABLE #SiloChunk
GO

IF EXISTS (select * from GxQscripts where name = 'archGetSiloChunksByCopy')
	delete from GxQscripts where name = 'archGetSiloChunksByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSiloChunksByCopy')
	delete from GXDBVersions where aliasname = 'archGetSiloChunksByCopy'
GO

insert into GXDBVersions values(2, 'archGetSiloChunksByCopy',  '00010034021000040000', 'archGetSiloChunksByCopy', '00010034021000040000')
GO

