

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetSecondaryFilesToContentIndex.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetSecondaryFilesToContentIndex.sp,v $ $Id: archGetSecondaryFilesToContentIndex.sp,v 1.4.12.4 2019/01/24 18:01:09 pankajkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetSecondaryFilesToContentIndex')
BEGIN
	print '>>> Drop Stored Procedure: archGetSecondaryFilesToContentIndex <<<'
	drop procedure archGetSecondaryFilesToContentIndex
END
IF EXISTS (select * from GxQscripts where name='archGetSecondaryFilesToContentIndex')
	delete from GxQscripts where name = 'archGetSecondaryFilesToContentIndex'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSecondaryFilesToContentIndex')
	delete from GXDBVersions where aliasname = 'archGetSecondaryFilesToContentIndex'
GO
print '... Creating Procedure: archGetSecondaryFilesToContentIndex'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetSecondaryFilesToContentIndex
  @i_lastArchFileId integer,
  @i_lastCommCellId integer,
  @i_rows integer,
  @i_cloudId integer,
  @i_reserveParam integer
AS
  DECLARE @o_archFileId integer
  DECLARE @o_commCellId integer
  DECLARE @o_backupSet integer
  DECLARE @o_AppId integer
  DECLARE @o_AppType integer
  DECLARE @o_clientId integer
  DECLARE @o_BackupJobId bigint
  DECLARE @o_StartTime integer
  DECLARE @o_EndTime integer
--
SET NOCOUNT ON
--delete aged backup jobs which are deleted from media
DELETE  T
FROM archContentIndexingSecondary T
JOIN (SELECT AFC.archFileId, AFC.commCellId
						FROM   archFileCopy AFC WITH (NOLOCK)
						GROUP BY AFC.archFileId, AFC.commCellId
HAVING MIN( AFC.flags & 256 )  > 0  --CVA_AGED_DATA_FLAG  =256
						) TEMP ON T.archFileId = TEMP.archFileId AND T.commCellId = TEMP.commCellId
--delete jobs whose archfiles are not present into archfile table
DELETE  T
FROM archContentIndexingSecondary T
LEFT JOIN archFile AF (NOLOCK) ON T.archFileId = AF.Id AND T.commCellId = AF.commCellId
WHERE AF.ID IS NULL
IF (OBJECT_ID('tempdb.dbo.#ArchFileForJob') IS NOT NULL) DROP TABLE #ArchFileForJob
CREATE TABLE #ArchFileForJob
(
	ArchFileId 	int not null,
	CommCellId 	int not null,
	BkpJobId	int not null
	Primary Key (ArchFileId, CommCellId)
)
--
insert into #ArchFileForJob (ArchFileId, CommCellId, BkpJobId)
select
	min(a.ArchFileId), a.commCellId, a.BackupJobId
from
	archContentIndexingSecondary a
group by
	a.BackupJobId, a.commCellId
order by
	a.BackupJobId
--
select
	top(@i_rows) s.ArchFileId, s.commCellId, a.backupSet, s.AppId, a.appTypeId, a.clientId, s.BackupJobId, s.StartTime, s.EndTime
from
	archContentIndexingSecondary s
inner join #ArchFileForJob afj
on
	afj.ArchFileId = s.ArchFileId and afj.CommCellId = s.CommCellId
inner join
	APP_Application a with (nolock)
on
	a.id = s.AppId
inner join
	archFile af with (nolock)
on
	af.id = s.ArchFileId and af.commCellId = s.commCellId
inner join
	archGroup g with (nolock)
on
	g.id = af.archGroupId
inner join
	archContentIndexingRules r with (nolock)
on
r.archGroupId = g.Id and r.cloudId = @i_cloudId AND r.operationType = 1
where
	s.commCellId > @i_lastCommCellId and s.ArchFileId > @i_lastArchFileId
order by
	s.commCellId, s.archFileId  DESC
--
IF (OBJECT_ID('tempdb.dbo.#ArchFileForJob') IS NOT NULL) DROP TABLE #ArchFileForJob
SET NOCOUNT OFF
--
GO

IF EXISTS (select * from GxQscripts where name = 'archGetSecondaryFilesToContentIndex')
	delete from GxQscripts where name = 'archGetSecondaryFilesToContentIndex'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetSecondaryFilesToContentIndex')
	delete from GXDBVersions where aliasname = 'archGetSecondaryFilesToContentIndex'
GO

insert into GXDBVersions values(2, 'archGetSecondaryFilesToContentIndex',  '00010004001200040000', 'archGetSecondaryFilesToContentIndex', '00010004001200040000')
GO

