

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetReUsableChunkId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetReUsableChunkId.sp,v $ $Id: archGetReUsableChunkId.sp,v 1.6.2.7 2018/04/13 14:02:22 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetReUsableChunkId <<<'

IF EXISTS (select * from sysobjects where name='archGetReUsableChunkId')
	drop procedure archGetReUsableChunkId
IF EXISTS (select * from GxQscripts where name='archGetReUsableChunkId')
	delete from GxQscripts where name = 'archGetReUsableChunkId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetReUsableChunkId')
	delete from GXDBVersions where aliasname = 'archGetReUsableChunkId'
GO
print '... Creating Procedure: archGetReUsableChunkId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetReUsableChunkId
  @i_archFileId INT,
  @i_commCellId INT,
  @i_volumeId INT,
  @i_archCopyId INT
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @retVal INT
  DECLARE @archChunkId BIGINT
  DECLARE @chunkCommCellId INT
  DECLARE @physicalOffset BIGINT
  DECLARE @logicalOffset BIGINT
  DECLARE @physicalSize BIGINT
  DECLARE @logicalSize BIGINT
  DECLARE @unCompSize BIGINT
  DECLARE @afPhysicalSize BIGINT
  DECLARE @afLogicalSize BIGINT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_rowCount INT = 0
DECLARE @l_retCode INT = 0
IF NOT EXISTS (	SELECT	*
			FROm	MMConfigs WITH (NOLOCK)
			WHERE	name = 'MMCONFIG_IGNORE_EDGEDRIVE_CHUNK_REUSE' AND Value = 0)
BEGIN
		SELECT @l_retCode = 0, @l_rowCount = 0
		GOTO CX_EXIT
END
DECLARE @l_archChunkId	BIGINT = 0
DECLARE @l_chunkCommCellId	INT = 0
DECLARE @l_physicalOffset	BIGINT = 0
DECLARE @l_logicalOffset	BIGINT = 0
DECLARE @l_physicalSize	BIGINT = 0
DECLARE @l_logicalSize	BIGINT = 0
DECLARE @l_unCompSize	BIGINT = 0
DECLARE @l_afPhysicalSize	BIGINT = 0
DECLARE @l_afLogicalSize	BIGINT = 0
DECLARE @l_drivePoolId INT = 0
DECLARE @l_appId INT = 0
DECLARE @l_minChunkSizeMB BIGINT = 0
SELECT	@l_archChunkId = ACM.archChunkId, @l_chunkCommCellId = ACM.chunkCommCellId, @l_physicalOffset = ACM.physicalOffset,
		@l_logicalOffset = ACM.logicalOffset, @l_physicalSize = ACM.physicalSize, @l_logicalSize = ACM.logicalSize, @l_unCompSize = ACM.unCompSize,
		@l_afPhysicalSize = AFC.physicalSize, @l_afLogicalSize = AFC.logicalSize,
		@l_drivePoolId = drivePoolId, @l_appId = AF.appId
FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),
		archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
WHERE	AF.id = @i_archFileId
		AND AF.commCellId = @i_commCellId
		AND AFC.archFileId = @i_archFileId
		AND AFC.commCellId = @i_commCellId
		AND AFC.archCopyId = @i_archCopyId
		AND AFC.archFileId = ACM.archFileId
		AND AFC.commCellId = ACM.CommCellId
		AND AFC.archCopyId = ACM.archCopyId
		AND AFC.lastChunkNumber = ACM.chunkNumber
		AND ACM.archChunkId = AC.id
		AND ACM.chunkCommCellId = AC.CommCellId
		AND AC.VolumeId = @i_volumeId
		AND ACM.chunkNumber > 1 -- We do not want to reuse first chunk to get first chunk create time for archive file during DDB recon case MR:
AND (AF.flags & (32768|2097152)) > 0	-- Edge Drive archive files or reusable archive files
AND (AFC.flags & (64 | 8192)) = 0 -- It is not multiplexed and is not marked bad
AND (AFC.flags & (4 + 16)) != 0 -- It is deduped
		AND AFC.mediaType = 10001 -- Magnetic Media
AND (AC.flags & (2048 | 8192)) = 0
SELECT	@l_retCode	= @@ERROR, @l_rowCount = @@ROWCOUNT
IF	@l_retCode != 0 GOTO CX_EXIT
SELECT @l_minChunkSizeMB = ChunkSizeMB FROM MMDataPath WHERE copyId = @i_archCopyId AND drivePoolId = @l_drivePoolId
SELECT	@l_retCode	= @@ERROR
IF	@l_retCode != 0 GOTO CX_EXIT
IF @l_minChunkSizeMB > 0 AND @l_minChunkSizeMB <= @l_physicalSize/1024/1024
BEGIN
	SET	@l_retCode = -1
	GOTO CX_EXIT
END
ELSE IF @l_minChunkSizeMB = 0 AND
              EXISTS (SELECT *
              FROM   APP_Application A, APP_iDAType I
              WHERE  A.id = @l_appId
                           AND A.appTypeId = I.type
                           AND ISNUMERIC(chunkSizeMB) = 1
                           AND chunkSizeMB <= @l_physicalSize/1024/1024)
BEGIN
	SET	@l_retCode = -1
	GOTO CX_EXIT
END
SELECT	@l_retCode	= @@ERROR
IF	@l_retCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF (@l_retCode != 0 OR @l_rowCount = 0)
		SELECT @l_retCode, 0, 0, 0, 0, 0, 0, 0, 0, 0
	ELSE
	BEGIN
		UPDATE	archChunk
SET		flags |= (2048 | 524288)
		WHERE	id = @l_archChunkId
				AND CommCellId = @l_chunkCommCellId
		SELECT @l_retCode, @l_archChunkId, @l_chunkCommCellId, @l_physicalOffset,
			   @l_logicalOffset, @l_physicalSize, @l_logicalSize, @l_unCompSize,
			   @l_afPhysicalSize, @l_afLogicalSize
	END
GO

IF EXISTS (select * from GxQscripts where name = 'archGetReUsableChunkId')
	delete from GxQscripts where name = 'archGetReUsableChunkId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetReUsableChunkId')
	delete from GXDBVersions where aliasname = 'archGetReUsableChunkId'
GO

insert into GXDBVersions values(2, 'archGetReUsableChunkId',  '00010006000200070000', 'archGetReUsableChunkId', '00010006000200070000')
GO

