

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetPrunableSILOList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetPrunableSILOList.sp,v $ $Id: archGetPrunableSILOList.sp,v 1.21.12.6 2020/07/21 23:45:08 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetPrunableSILOList')
BEGIN
	print '>>> Drop Stored Procedure: archGetPrunableSILOList <<<'
	drop procedure archGetPrunableSILOList
END
IF EXISTS (select * from GxQscripts where name='archGetPrunableSILOList')
	delete from GxQscripts where name = 'archGetPrunableSILOList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetPrunableSILOList')
	delete from GXDBVersions where aliasname = 'archGetPrunableSILOList'
GO
print '... Creating Procedure: archGetPrunableSILOList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetPrunableSILOList
  @i_danglingSILO INTEGER,
  @i_dummy INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SIDBStoreId INTEGER;
  DECLARE @o_volumeId INTEGER;
  DECLARE @o_CommCellId INTEGER;
  DECLARE @o_clientId INTEGER;
  DECLARE @o_MountPathId INTEGER;
  DECLARE @o_MountPathTypeId INTEGER;
  DECLARE @o_MountPathName NVARCHAR(2048);
  DECLARE @o_UserName varchar(1024);
  DECLARE @o_UserPassword varchar(1024);
  DECLARE @o_volumeAttribute INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	-- Constants that are enums.
	DECLARE @MOUNT_PATH_MAGNETIC				INTEGER
	DECLARE @MOUNT_PATH_CENTERA					INTEGER
	DECLARE @MOUNT_PATH_DYNAMIC_SHARED	INTEGER
	DECLARE @MOUNT_PATH_TAPE						INTEGER
	DECLARE @MOUNT_PATH_SHARED_STATIC		INTEGER
	DECLARE @MOUNT_PATH_SHARED_REPLICA	INTEGER
	DECLARE @MOUNT_PATH_DRU							INTEGER
	DECLARE @MOUNT_PATH_EXTERNAL_REMOTE_HOST							INTEGER
	SET @MOUNT_PATH_MAGNETIC				=	0
	SET @MOUNT_PATH_CENTERA					=	1
	SET @MOUNT_PATH_DYNAMIC_SHARED	=	2
	SET @MOUNT_PATH_TAPE						=	3
	SET @MOUNT_PATH_SHARED_STATIC		=	4
	SET @MOUNT_PATH_SHARED_REPLICA	=	5
	SET @MOUNT_PATH_DRU							=	6
	SET @MOUNT_PATH_EXTERNAL_REMOTE_HOST							=	7
	DECLARE	@errorCode 	INTEGER
	SET			@errorCode 	= 0
	/*************************** Create Temp Tables ***************************/
	if object_id('tempdb.dbo.#PrunableSiloList') is not null DROP TABLE #PrunableSiloList
	if object_id('tempdb.dbo.#PrunableSiloVolumeInfo') is not null DROP TABLE #PrunableSiloVolumeInfo
	CREATE	TABLE #PrunableSiloList (
			SIDBStoreId INT,
			commCellId	INT,
			PRIMARY KEY (SIDBStoreId, commCellId))
	CREATE	TABLE #PrunableSiloVolumeInfo (
			SIDBStoreId 			INT,
			volumeId 					INT,
			commCellId				INT,
			mountPathId				INT,
			libraryId					INT,
			mountPathTypeId		INT,
			deviceCntrlPath 	NVARCHAR(2048),
			mountPathName 		NVARCHAR(2048),
			userName		 			NVARCHAR(1024),
			UserPassword			NVARCHAR(1024),
			clientId 					INT,
			volumeAttribute		INT,
			mountPathAttribute  INT,
			credentialAssocId INT,
			PRIMARY KEY (VolumeId))
	-- Get only those SIDBStoreId that have recyclable volumes
	INSERT INTO #PrunableSiloList
	SELECT DISTINCT V.SIDBStoreId, (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	FROM MMVolume V WITH (NOLOCK), archFileSiloVolume SV WITH (NOLOCK)
	WHERE	V.VolumeId = SV.siloVolumeId
	AND		V.SIDBStoreId > 0
	AND		V.VolumeFlags = 6	-- Recyclable Volumes
	UNION
	SELECT DISTINCT V.SIDBStoreId, (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	FROM MMVolume V WITH (NOLOCK), IDXSIDBStore SS WITH (NOLOCK)
	WHERE V.SIDBStoreId = SS.SIDBStoreId
	AND	(CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END) = SS.commCellId
AND	(SS.flags & 2097152) > 0
	AND		V.SIDBStoreId > 0
	AND		V.VolumeFlags = 6	-- Recyclable Volumes
	UNION
	SELECT DISTINCT SS.SIDBStoreId, SS.commCellId
	FROM IdxSIDBStore SS WITH (NOLOCK) LEFT OUTER JOIN MMVolume V WITH (NOLOCK)
	ON SS.SIDBStoreId = V.SIDBStoreId
	AND	SS.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	WHERE V.SIDBStoreId IS NULL
	AND		SS.SIDBStoreId > 0
AND		SS.flags & 256 = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Remove the ACTIVE SIDBStoreId (All SIDBStoreId that exists in archGroupCopy table are still active)
	DELETE #PrunableSiloList
	FROM #PrunableSiloList PSL, archCopySIDBStore ACS WITH (NOLOCK)
    WHERE PSL.SIDBStoreId = ACS.SIDBStoreId
AND ACS.flags & 4 > 0
    AND     PSL.commCellId = 2  -- Active commcell SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Remove the NOT PRUNABLE SIDBStoreId if there is atleast one non-recyclable volume
	DELETE #PrunableSiloList
	FROM #PrunableSiloList PSL, MMVolume V WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = V.SIDBStoreId
	AND		PSL.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	AND		V.VolumeFlags <> 6
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Remove the SIDBStoreId if there is atleast one volume referenced in archChunk table
	DELETE #PrunableSiloList
	FROM #PrunableSiloList PSL, MMVolume V WITH (NOLOCK), archChunk AC WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = V.SIDBStoreId
	AND		PSL.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	AND		V.VolumeId = AC.VolumeId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Remove the SIDBStoreId if the SILO tape backup job is currently running for that store
	DELETE #PrunableSiloList
	FROM #PrunableSiloList PSL, archCopySIDBStore ACSS WITH (NOLOCK),
		 archGroupCopy AGC WITH (NOLOCK), IDXSIDBStore SS WITH (NOLOCK),
		 JMJobInfo JI WITH (NOLOCK), JMBkpJobInfo BJI WITH (NOLOCK),
		 JMJobOptions JO WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = SS.SIDBStoreId
	AND		PSL.commCellId = SS.CommCellId
AND		(SS.flags & 128) = 0
	AND		SS.SIDBStoreId = ACSS.SIDBStoreId
	AND		SS.commCellId = ACSS.CommCellId
	AND		ACSS.CopyId = AGC.id
	AND		AGC.siloAppId = BJI.applicationId
	AND		BJI.jobId = JI.jobId
	AND		BJI.commcellId = JI.commCellId
	AND		JI.opType = 4
	AND		JI.jobId = JO.jobId
	AND		JI.commcellId = JO.commCellId
	AND		JO.attributeId = 21
	AND		JO.attributeValueInt = PSL.SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Set the recyclable flag on the IdxSIDBStore table for the stores that are prunable
	UPDATE IdxSIDBStore WITH (PAGLOCK)
SET flags = (flags | 128)
	FROM IdxSIDBStore S, #PrunableSiloList PSL
	WHERE S.SIDBStoreId = PSL.SIDBStoreId
	AND		S.CommCellId = PSL.CommCellId
AND		(S.flags & 128) = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Get prunable SILO Volume information
	INSERT INTO #PrunableSiloVolumeInfo
	SELECT DISTINCT PSL.SIDBStoreId, V.volumeId, (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END),
									MP.mountPathId, MP.libraryId, MP.mountPathTypeId, '', MP.mountPathName,
									(CASE WHEN MP.mountPathTypeId IN (@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_DRU, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
												THEN ''
												ELSE MP.UserName
									END),
									(CASE WHEN MP.mountPathTypeId IN (@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_DRU, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
												THEN ''
												ELSE MP.UserPassword
									END),	0, V.origCCvolumeID, MP.Attribute, 0
	FROM #PrunableSiloList PSL, MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	PSL.SIDBStoreId = V.SIDBStoreId
	AND		PSL.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
--  Jai - Mon Aug 25 18:24:20 EDT 2008
--	Get the mountpathInfo for the 'transformed' MPId of the volume.
--	AND		V.mediaSideId = MP.mediaSideId
	AND		V.CurrMountPathId = MP.MountPathId
AND		(V.Attributes & 2) = 0
--	AND		(MP.Attribute & MNTPTH_ATTRIB_DATA_PRUNING) = MNTPTH_ATTRIB_DATA_PRUNING
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Remove the volume that is referenced by chunk, that is not needed as parevious check already takes care of it.
	-- Remove the volume that is reserved
	DELETE #PrunableSiloVolumeInfo
	FROM	#PrunableSiloVolumeInfo PSVI, MMResource res WITH (NOLOCK), MMResourceToJob restojob WITH (NOLOCK)
	WHERE	PSVI.VolumeId = res.VolumeId
	AND		res.ReservationId = resToJob.ReservationId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Get clientId for regular mountPath
	UPDATE #PrunableSiloVolumeInfo
	SET clientId = LC.clientId
	FROM #PrunableSiloVolumeInfo PSVI, MMLibraryController LC WITH (NOLOCK), MMHost H WITH (NOLOCK)
	WHERE	PSVI.mountPathTypeId NOT IN (@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_DRU, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	AND		PSVI.libraryId = LC.libraryId
	AND 	LC.LibraryControllerActive = 1
	AND 	LC.LibraryControllerEnabled = 1
	AND		LC.clientId = H.clientId
	AND 	H.MmHostEnabled = 1
	AND		H.MmHostSoftState = 1
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Get device controller path, clientId, userName, userPassword for shared mountpath
	UPDATE #PrunableSiloVolumeInfo
	SET deviceCntrlPath = DC.Folder, clientId = DC.clientId, userName = DC.UserName, UserPassword = DC.UserPassword, credentialAssocId = DC.CredentialAssocId
	FROM #PrunableSiloVolumeInfo PSVI, MMMountPathToStorageDevice MPSD WITH (NOLOCK),
				MMDevice D WITH (NOLOCK),
				MMDeviceController DC WITH (NOLOCK),
				MMHost H WITH (NOLOCK)
	WHERE	PSVI.mountPathTypeId IN (@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_DRU)
	AND		PSVI.mountPathId = MPSD.MountPathId
	AND		MPSD.DeviceId = D.DeviceId
	AND		D.DeviceEnabled = 1
	AND 	D.DeviceBroken = 0
	AND		D.DeviceId = DC.DeviceId
	AND 	DC.DeviceControllerEnabled = 1
	AND 	(DC.DeviceAccessType & 2) = 2			-- Write Access Device Controller
	AND		DC.clientId = H.clientId
	AND 	H.MmHostEnabled = 1
	AND		H.MmHostSoftState = 1
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Get the computed info from MMMountPathOnlineStatus for these types of mountPaths - /*MOUNT_PATH_SHARED_STATIC*/, /*MOUNT_PATH_SHARED_REPLICA*/, /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	UPDATE #PrunableSiloVolumeInfo
	SET deviceCntrlPath = MP.Folder,
	clientId = MP.HostId,
	userName = MP.UserName,
	userPassword = MP.UserPassword
	FROM #PrunableSiloVolumeInfo PSVI, MMMountPathOnlineStatus MP WITH (NOLOCK)
	WHERE PSVI.mountPathTypeId IN (@MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	AND PSVI.mountPathId = MP.MountPathId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#PrunableSiloVolumeInfo', 'credentialAssocId', 'userName', 'UserPassword'
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	IF @i_danglingSILO = 0
	BEGIN
	SELECT DISTINCT PSVI.SIDBStoreId, PSVI.volumeId, PSVI.commCellId, PSVI.clientId, PSVI.mountPathId, PSVI.mountPathTypeId,
				(CASE WHEN PSVI.mountPathTypeId IN (@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_DRU, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
							THEN PSVI.deviceCntrlPath + '\' + PSVI.mountPathName
							ELSE PSVI.mountPathName
				END)AS MountPathName, PSVI.userName, PSVI.UserPassword, PSVI.volumeAttribute
	FROM #PrunableSiloVolumeInfo PSVI
WHERE PSVI.clientId > 0 AND (PSVI.mountPathAttribute & 8) = 8
	ORDER BY PSVI.SIDBStoreId, PSVI.mountPathId
	END
	ELSE
	BEGIN
	SELECT DISTINCT PSL.SIDBStoreId, PSVI.volumeId, PSL.commCellId, PSVI.clientId, PSVI.mountPathId, PSVI.mountPathTypeId,
				(CASE WHEN PSVI.mountPathTypeId IN (@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_DRU, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
							THEN PSVI.deviceCntrlPath + '\' + PSVI.mountPathName
							ELSE PSVI.mountPathName
				END)AS MountPathName, PSVI.userName, PSVI.UserPassword, PSVI.volumeAttribute
	FROM 	#PrunableSiloList PSL LEFT OUTER JOIN #PrunableSiloVolumeInfo PSVI
	ON	PSL.SIDBStoreId = PSVI.SIDBStoreId
	AND	PSL.commCellId = PSVI.commCellId
	WHERE PSVI.SIDBStoreId IS NULL
	END
	RETURN
CX_ERROR_EXIT:
	SELECT -1 AS SIDBStoreId, -1 AS volumeId, -1 AS commCellId, -1 AS clientId, -1 AS mountPathId, -1 AS mountPathTypeId,
					'' AS MountPathName, '' AS userName, '' AS UserPassword, -1 AS volumeAttribute
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archGetPrunableSILOList')
	delete from GxQscripts where name = 'archGetPrunableSILOList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetPrunableSILOList')
	delete from GXDBVersions where aliasname = 'archGetPrunableSILOList'
GO

insert into GXDBVersions values(2, 'archGetPrunableSILOList',  '00010021001200060000', 'archGetPrunableSILOList', '00010021001200060000')
GO

