

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetMissingMAFromStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetMissingMAFromStoragePool.sp,v $ $Id: archGetMissingMAFromStoragePool.sp,v 1.1.2.17 2020/03/11 01:00:14 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetMissingMAFromStoragePool')
BEGIN
	print '>>> Drop Stored Procedure: archGetMissingMAFromStoragePool <<<'
	drop procedure archGetMissingMAFromStoragePool
END
IF EXISTS (select * from GxQscripts where name='archGetMissingMAFromStoragePool')
	delete from GxQscripts where name = 'archGetMissingMAFromStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMissingMAFromStoragePool')
	delete from GXDBVersions where aliasname = 'archGetMissingMAFromStoragePool'
GO
print '... Creating Procedure: archGetMissingMAFromStoragePool'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetMissingMAFromStoragePool
  @i_StoragePoolId integer,
  @i_ClientGroupId integer,
  @i_MountPathId integer,
  @i_MAAccessTypeXML varchar(1024),
  @i_LibraryId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName nvarchar(1024)
  DECLARE @o_DeviceId integer	
  DECLARE @o_Folder varchar(1024)
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_UserPassword varchar(2048)
  DECLARE @o_MAId integer	
  DECLARE @o_numWriters integer
  DECLARE @o_deviceAccessType integer 
  DECLARE @o_StoragePoolName nvarchar(2048)
  DECLARE @o_CredentialId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @storagePoolName nvarchar(2048)
DECLARE @libraryId integer = 0
DECLARE @dataServerBits INT = 16 | 32 |128
DECLARE @inputControllerInfo TABLE(maId int, DeviceAccessType int)
DECLARE @scaleOutSP integer = 0
IF @i_MAAccessTypeXML <> ''
BEGIN
	DECLARE @testXML XML
	SELECT  @testXML = CONVERT(XML, @i_MAAccessTypeXML)
	INSERT INTO @inputControllerInfo
	SELECT [Value] = CAST(T.c.value('@Id','varchar(20)') AS int),  [Value] = CAST(T.c.value('@AccessType','varchar(20)') AS int)
	FROM @testXML.nodes('/ControllerInfo/MAWithAccessType') T(c)
END
SELECT @scaleOutSP = 1 FROM MMSDSStoragePool WHERE GDSPId = @i_StoragePoolId
--The input to this proc are mutually exclusive
--Either (i_ClientGroupId AND i_StoragePoolId) can be specified or i_MountPathId can be specified
IF @i_ClientGroupId <> 0
BEGIN
	SET @i_MountPathId = 0
	SET @i_LibraryId = 0
END
ELSE
BEGIN
	SET @i_ClientGroupId = 0
	SET @i_StoragePoolId = 0
END
IF OBJECT_ID('tempdb.dbo.#deviceAndMissingMA') IS NOT NULL
DROP TABLE #deviceAndMissingMA
CREATE TABLE #deviceAndMissingMA (mpId int, mountPathName nvarchar(1024), deviceId int,
								  folder varchar(1024), userName  varchar(1024), userPassword varchar(2048),
								  maId int, numWriters int, deviceAccessType int, credentialId int)
IF OBJECT_ID('tempdb.dbo.#TempDeviceAndMissingMA') IS NOT NULL
DROP TABLE #TempDeviceAndMissingMA
CREATE TABLE #TempDeviceAndMissingMA (mpId int, mountPathName nvarchar(1024), deviceId int,
								  folder varchar(1024), userName  varchar(1024), userPassword varchar(2048),
								  maId int, numWriters int, deviceAccessType int, credentialId int, rowNumber int)
IF @i_ClientGroupId <> 0
BEGIN
	SET @storagePoolName = ISNULL( (SELECT name from ArchGroup where id = @i_StoragePoolId), '')
	--MountPathTypeId = 7 -- Cloud
	INSERT INTO #deviceAndMissingMA
	SELECT MP.MountPathId, MPVIEW.MountPathName, MPD.DeviceId,
					(CASE WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0 OR @scaleOutSP = 1) THEN MPD.Folder ELSE '' END),
					(CASE WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0) THEN MPD.UserName ELSE '' END),
					(CASE WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0) THEN MPD.UserPassword ELSE '' END),
					H.ClientId,
					ISNULL(DPool.MaxDrivesToSwitch, -1) AS NumWriters,
					(CASE WHEN (MP.MountPathTypeId = 7 OR @scaleOutSP = 1) THEN MPD.DeviceAccessType
ELSE (CASE WHEN @dataServerBits & MPD.DeviceAccessType > 0 THEN (@dataServerBits & MPD.DeviceAccessType)  | ISNULL(INPUTMA.DeviceAccessType, 4)
WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0) THEN ISNULL(INPUTMA.DeviceAccessType & ~@dataServerBits, (MPD.DeviceAccessType & (4 | 2)))
ELSE 16 | ISNULL(INPUTMA.DeviceAccessType, 4)
									 END)
						  END) AS DeviceAccessType, MPD.credentialId
	FROM   MMMountPath MP WITH (READUNCOMMITTED)
		   INNER JOIN
				  (
						SELECT 	DISTINCT MPool1.LibraryId
						FROM	ArchGroupCopy AGC WITH (READUNCOMMITTED)
								INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON AGC.id = DPath.CopyId
								INNER JOIN MMDrivePool DPool1 WITH (READUNCOMMITTED) ON DPool1.DrivePoolId = DPath.DrivePoolId
								INNER JOIN MMMasterPool MPool1 WITH (READUNCOMMITTED) ON MPool1.MasterPoolId = DPool1.MasterPoolId
						WHERE	AGC.archGroupId = @i_StoragePoolId
				  ) AS LIB ON MP.LibraryId = LIB.LibraryId
				  INNER JOIN MMS2getMountPathNameGUIView MPVIEW WITH (READUNCOMMITTED) ON MPVIEW.MountPathId = MP.MountPathId
				  INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.MountPathId = MP.MountPathId
				  INNER JOIN (SELECT DeviceControllerId, DeviceId, DeviceAccessType, Folder, MDC.UserName, MDC.UserPassword, ISNULL(ACA.credentialId, 0) AS credentialId,
								ROW_NUMBER() OVER (PARTITION BY DeviceId ORDER BY (DeviceAccessType & @dataServerBits) DESC,
								CASE WHEN DeviceAccessType & 8 > 0 THEN 0 ELSE 1 END,
								CASE WHEN DeviceAccessType & 2 > 0 THEN 0 ELSE 1 END, DeviceControllerId) as RowNumber
								FROM MMDeviceController MDC WITH (READUNCOMMITTED)
								LEFT OUTER JOIN APP_CredentialAssoc ACA WITH (READUNCOMMITTED) ON ACA.assocId = MDC.CredentialAssocId) AS MPD
								ON MPSD.DeviceId = MPD.DeviceId
								AND MPD.RowNumber = 1
				  INNER JOIN APP_ClientGroupAssoc CGA WITH (READUNCOMMITTED) ON CGA.clientGroupId = @i_ClientGroupId
				  INNER JOIN MMHost H WITH (READUNCOMMITTED) ON CGA.clientId = H.ClientId
INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON C.Id = H.ClientId AND C.releaseId >= 16
				  INNER JOIN MMMasterPool MPool WITH (READUNCOMMITTED) ON MP.LibraryId = MPool.LibraryId
				  LEFT JOIN MMDrivePool DPool WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DPool.MasterPoolId AND H.ClientId = DPool.ClientId
				  LEFT JOIN (SELECT MIN(DeviceControllerId) DeviceControllerId, ClientId FROM MMDeviceController WITH (READUNCOMMITTED) GROUP BY ClientId) AS MA ON DPool.ClientId = MA.ClientId
				  --LEFT JOIN MMDeviceController MADC WITH (READUNCOMMITTED) ON MA.DeviceControllerId = MADC.DeviceControllerId
				  LEFT JOIN @inputControllerInfo INPUTMA ON INPUTMA.maId = DPool.ClientId
				  LEFT OUTER JOIN MMDeviceController EDC WITH (READUNCOMMITTED) ON MPSD.DeviceId = EDC.DeviceId AND MA.ClientId = EDC.ClientId
	WHERE  EDC.ClientId IS NULL
END
ELSE --Identify based on the input MountPath
BEGIN
	IF @i_LibraryId > 0
	BEGIN
		SET @libraryId = @i_LibraryId
	END
	ELSE
	BEGIN
		--Identify if this mountpath (i_MountPathId) is part of storagepool
		SELECT @libraryId = MP.LibraryId FROM MMMountPath MP WITH (READUNCOMMITTED)
			WHERE MP.MountPathId = @i_MountPathId
	END
	--From the library get the archGroup
	DECLARE @storagePool TABLE (storagePoolId int)
	INSERT INTO @storagePool
	SELECT DISTINCT AGC.archGroupId
	FROM MMDrivePool DRP WITH (READUNCOMMITTED), MMDataPath DAP WITH (READUNCOMMITTED),
		 MMMasterPool MP WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE MP.LibraryId = @libraryId AND DAP.DrivePoolId = DRP.DrivePoolId
AND DRP.MasterPoolId = MP.MasterPoolId AND DRP.DrivePoolType = 10001 AND DAP.CopyId=AGC.id
AND (AGC.dedupeFlags & 268435456 > 0 OR AGC.extendedFlags & 4096 > 0)  --take only global polocies
	SET @storagePoolName = ISNULL( (select stuff( 	(select ',' + AG.name FROM @storagePool sp JOIN archGroup AG WITH(READUNCOMMITTED) ON sp.storagePoolId = AG.id
														 FOR XML PATH('')),1,1,'')), '')
	INSERT INTO #deviceAndMissingMA
	SELECT MP.MountPathId, MPVIEW.MountPathName, MPD.DeviceId,
				(CASE WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0 OR @scaleOutSP = 1) THEN MPD.Folder ELSE '' END),
				(CASE WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0) THEN MPD.UserName ELSE '' END),
				(CASE WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0) THEN MPD.UserPassword ELSE '' END),
			  MA.ClientId,
			  ISNULL(DPool.MaxDrivesToSwitch, -1) AS NumWriters,
	          CASE WHEN (MP.MountPathTypeId = 7 OR @scaleOutSP = 1) THEN MPD.DeviceAccessType
ELSE (CASE WHEN @dataServerBits & MPD.DeviceAccessType > 0 THEN (@dataServerBits & MPD.DeviceAccessType)  | ISNULL(INPUTMA.DeviceAccessType, 4)
WHEN MPD.Folder <> '' AND ((MPD.UserName <> '' AND MPD.UserPassword <> '') OR  MPD.credentialId > 0) THEN ISNULL(INPUTMA.DeviceAccessType & ~@dataServerBits, (MPD.DeviceAccessType & (4 | 2)))
ELSE 16 | ISNULL(INPUTMA.DeviceAccessType, 4)
                                END)
                     END, MPD.credentialId
	FROM   MMMountPath MP WITH (READUNCOMMITTED)
			INNER JOIN
			(
				SELECT 	DISTINCT MPool1.LibraryId
				FROM	@storagePool SP
						INNER JOIN ArchGroupCopy AGC WITH (READUNCOMMITTED) ON SP.storagePoolId = AGC.archGroupId
						INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON AGC.id = DPath.CopyId
						INNER JOIN MMDrivePool DPool1 WITH (READUNCOMMITTED) ON DPool1.DrivePoolId = DPath.DrivePoolId
						INNER JOIN MMMasterPool MPool1 WITH (READUNCOMMITTED) ON MPool1.MasterPoolId = DPool1.MasterPoolId
			) AS LIB ON MP.LibraryId = LIB.LibraryId
				  INNER JOIN MMS2getMountPathNameGUIView MPVIEW WITH (READUNCOMMITTED) ON MPVIEW.MountPathId = MP.MountPathId
				  INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.MountPathId = MP.MountPathId
				  INNER JOIN (SELECT DeviceControllerId, DeviceId, DeviceAccessType, Folder, MDC.UserName, MDC.UserPassword, ISNULL(ACA.credentialId, 0) AS credentialId,
								ROW_NUMBER() OVER (PARTITION BY DeviceId ORDER BY (DeviceAccessType & @dataServerBits) DESC,
								CASE WHEN DeviceAccessType & 8 > 0 THEN 0 ELSE 1 END,
								CASE WHEN DeviceAccessType & 2 > 0 THEN 0 ELSE 1 END, DeviceControllerId) as RowNumber
								FROM MMDeviceController MDC WITH (READUNCOMMITTED)
								LEFT OUTER JOIN APP_CredentialAssoc ACA WITH (READUNCOMMITTED) ON ACA.assocId = MDC.CredentialAssocId) AS MPD ON MPSD.DeviceId = MPD.DeviceId
					AND MPD.RowNumber = 1
				  INNER JOIN MMMasterPool MPool WITH (READUNCOMMITTED) ON MP.LibraryId = MPool.LibraryId
				  INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DPool.MasterPoolId
INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON C.Id = DPool.ClientId AND C.releaseId >= 16
				  INNER JOIN (SELECT MIN(DeviceControllerId) DeviceControllerId, ClientId FROM MMDeviceController WITH (READUNCOMMITTED) GROUP BY ClientId) AS MA ON DPool.ClientId = MA.ClientId
				  --INNER JOIN MMDeviceController MADC WITH (READUNCOMMITTED) ON MA.DeviceControllerId = MADC.DeviceControllerId
				  LEFT JOIN @inputControllerInfo INPUTMA ON INPUTMA.maId = DPool.ClientId
				  LEFT OUTER JOIN MMDeviceController EDC WITH (READUNCOMMITTED) ON MPSD.DeviceId = EDC.DeviceId AND MA.ClientId = EDC.ClientId
	WHERE  EDC.ClientId IS NULL
END
-- This section is not needed, but leaving it here for now, in case we need it
-- Update user name and password for entries that use credentials
-- EXEC MMS2GetDeviceControllerCredentials '#deviceAndMissingMA', 'credentialAssocId', 'userName', 'userPassword'
INSERT INTO #TempDeviceAndMissingMA(mpId, mountPathName, deviceId, folder, userName, userPassword, maId, numWriters, deviceAccessType, credentialId, rowNumber)
SELECT *, ROW_NUMBER() OVER(PARTITION BY deviceId, maId ORDER BY mpId) AS rowNumber FROM #deviceAndMissingMA
DELETE FROM #TempDeviceAndMissingMA WHERE rowNumber > 1
SELECT mpId, mountPathName, deviceId, folder, userName, userPassword, maId, numWriters, deviceAccessType, @storagePoolName as storagePoolName, credentialId FROM #TempDeviceAndMissingMA
IF OBJECT_ID('tempdb.dbo.#deviceAndMissingMA') IS NOT NULL
DROP TABLE #deviceAndMissingMA
IF OBJECT_ID('tempdb.dbo.#TempDeviceAndMissingMA') IS NOT NULL
DROP TABLE #TempDeviceAndMissingMA
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archGetMissingMAFromStoragePool')
	delete from GxQscripts where name = 'archGetMissingMAFromStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMissingMAFromStoragePool')
	delete from GXDBVersions where aliasname = 'archGetMissingMAFromStoragePool'
GO

insert into GXDBVersions values(2, 'archGetMissingMAFromStoragePool',  '00010001000200170000', 'archGetMissingMAFromStoragePool', '00010001000200170000')
GO

