

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetMinableJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetMinableJobs.sp,v $ $Id: archGetMinableJobs.sp,v 1.9.88.1 2018/03/22 00:58:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetMinableJobs <<<'

IF EXISTS (select * from sysobjects where name='archGetMinableJobs')
	drop procedure archGetMinableJobs
IF EXISTS (select * from GxQscripts where name='archGetMinableJobs')
	delete from GxQscripts where name = 'archGetMinableJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMinableJobs')
	delete from GXDBVersions where aliasname = 'archGetMinableJobs'
GO
print '... Creating Procedure: archGetMinableJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetMinableJobs
  @i_miningAppId INTEGER,
  @i_miningJobId INTEGER,
  @i_miningCommCellId INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_jobId INTEGER 
  DECLARE @o_commCellId INTEGER 
  DECLARE @o_miningStatus INTEGER 
SET NOCOUNT ON
DECLARE	@l_miningJobId	INT
DECLARE	@l_miningCCId	INT
DECLARE	@l_miningAGId	INT
DECLARE	@l_appId		INT
DECLARE	@l_startDate	INT
DECLARE	@l_archGroupId	INT
SET		@l_miningJobId	= 0
SET		@l_miningCCId	= 0
SET		@l_miningAGId	= 0
SET		@l_appId		= 0
SET		@l_startDate	= 0
SET		@l_archGroupId	= 0
SELECT	@l_appId = CONVERT(int, attrVal)
FROM	APP_SubClientProp WITH (NOLOCK)
WHERE	ComponentNameId = @i_miningAppId AND attrName = N'Minable Subclient Id' AND modified = 0
SELECT	TOP 1 @l_miningJobId = miningJobId, @l_miningCCId = miningCommCellId
FROM	JMJobMiningStats WITH (NOLOCK)
WHERE	miningAppId = @i_miningAppId
IF	@l_miningJobId = @i_miningJobId
BEGIN
	SELECT	jobId, commCellId, miningStatus
	FROM	JMJobMiningStats WITH (NOLOCK)
	WHERE	miningAppId = @i_miningAppId AND miningJobId = @i_miningJobId AND miningCommCellId = @i_miningCommCellId
	ORDER BY jobId ASC
	GOTO FINISH
END
ELSE
BEGIN
	DECLARE @result int;
	EXEC @result = sp_getapplock @Resource = 'archGetMinableJobsLock',
					@LockMode = 'Exclusive', @LockTimeout = 60000
	IF (@result NOT IN (0, 1))
	BEGIN
		-- EXEC @result = sp_releaseapplock @Resource = 'archGetMinableJobsLock'
		SELECT	-1, 0, 0
		GOTO FINISH
	END
	IF	@l_miningJobId <> 0
		DELETE	FROM JMJobMiningStats
		FROM	JMJobMiningStats
		WHERE	miningAppId = @i_miningAppId
	SELECT	TOP 1 @l_startDate = B.servStartDate
	FROM	JMBkpStats B
			LEFT OUTER JOIN JMPreparedJob P ON B.jobId = P.preparedJobId AND B.commCellId = P.preparedJobCCId
	WHERE	P.preparedJobId IS NULL
		AND B.appId = @l_appId AND B.status IN (1, 3, 14) AND B.bkpLevel IN (1, 64, 128, 1024, 32768) AND B.opType IN (59, 65)
	ORDER BY B.servStartDate DESC
	IF	@l_startDate > 0
	BEGIN
		SELECT	@l_miningAGId = dataArchGrpId
		FROM	APP_Application WITH (NOLOCK)
		WHERE	id = @i_miningAppId
		INSERT	INTO JMJobMiningStats
		SELECT	B.jobId, B.commCellId, B.appId, @i_miningAppId, @l_miningAGId, 0, @i_miningJobId, @i_miningCommCellId, 0
		FROM	JMBkpStats B
				LEFT OUTER JOIN JMPreparedJob P ON B.jobId = P.preparedJobId AND B.commCellId = P.preparedJobCCId
		WHERE	P.preparedJobId IS NULL
			AND B.appId = @l_appId AND B.status IN (1, 3, 14) AND B.servStartDate >= @l_startDate AND B.opType IN (59, 65)
	END
	SELECT	jobId, commCellId, miningStatus
	FROM	JMJobMiningStats
	WHERE	miningAppId = @i_miningAppId AND miningJobId = @i_miningJobId AND miningCommCellId = @i_miningCommCellId
	ORDER BY jobId ASC
	EXEC @result = sp_releaseapplock @Resource = 'archGetMinableJobsLock'
END
FINISH:
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetMinableJobs')
	delete from GxQscripts where name = 'archGetMinableJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMinableJobs')
	delete from GXDBVersions where aliasname = 'archGetMinableJobs'
GO

insert into GXDBVersions values(2, 'archGetMinableJobs',  '00010009008800010000', 'archGetMinableJobs', '00010009008800010000')
GO

