

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetMediaRefreshCopyProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetMediaRefreshCopyProperties')
BEGIN
	print '>>> Drop Stored Procedure: archGetMediaRefreshCopyProperties <<<'
	drop procedure archGetMediaRefreshCopyProperties
END
IF EXISTS (select * from GxQscripts where name='archGetMediaRefreshCopyProperties')
	delete from GxQscripts where name = 'archGetMediaRefreshCopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMediaRefreshCopyProperties')
	delete from GXDBVersions where aliasname = 'archGetMediaRefreshCopyProperties'
GO
print '... Creating Procedure: archGetMediaRefreshCopyProperties'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetMediaRefreshCopyProperties
  @m_iArchGroupCopyId integer,
  @m_iArchGroupId integer
AS
  DECLARE @errorCode integer;	-- newly added for error code.
  DECLARE @id integer; -- -- copy id
  DECLARE @policyName VARCHAR(1024);
  DECLARE @copyName VARCHAR(1024);
  DECLARE @archGroupId integer;
  DECLARE @srcCopyId integer;
  DECLARE @copyStartTime integer;
  DECLARE @copyType integer;
  DECLARE @spFlags integer;
  DECLARE @copyFlags integer;
  DECLARE @copyFlagsExt integer;
  DECLARE @copyLevel integer;
  DECLARE @deferredDays integer;
--:DECLARE--  startReadTime integer;
  DECLARE @markCopiedTime integer;
  DECLARE @maxMultiplex integer;
  DECLARE @dedupeFlags integer;
  DECLARE @encType integer;
  DECLARE @encKeyLen integer;
  DECLARE @isSnapCopy integer;
  DECLARE @isMirrorCopy integer;
  DECLARE @isNasCopy integer;
  DECLARE @isActive integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--#define  MAX_DEFAULT_REC_SIZE              64
--#define CVA_SIDB_STORE_ENABLED_FLAG        262144
--#define CVA_BACKUP_SILO_ENABLED_FLAG		2097152
DECLARE @m_iPrimaryCopyId INTEGER = 0
DECLARE @m_iPrimarySnapCopyId	  INTEGER = 0
DECLARE @isCopyActive INTEGER = 0
--- Start Code
IF object_id('tempdb.dbo.#archGroupCopyTemp') IS NOT null DROP TABLE #archGroupCopyTemp
-- Define errocodes for time being HERE. Need to put them into some header.
-- success 0
-- copy not active 1
-- copy does not exists 2
-- snapcopy auxcopy can't be run 3
-- no secondary copy for sp      4
-- is Primary Copy				 5
-- is Snap Primary Copy			 6
-- These are defined in AuxCopyDefs.h
-- /* getJonParameters sp return codes. */
--#define CVA_AUXCOPY_COPY_NOT_ACTIVE						1
--#define CVA_AUXCOPY_POLICY_COPY_NOT_EXISTS						2
--#define CVA_AUXCOPY_AUXCOPY_NOT_RUN_DUETO_SNAP			3
--#define CVA_AUXCOPY_NO_SECONDARY_COPY						4
-- We need to get copy properties in an map.
-- Given copyid, we need to get its poperties and its srcopy properties.
-- If the copy id is 0 then we need to get all copy propertie except snapcopies.
-- remove the unneccessary fields in #archGroupCopyTemp
CREATE TABLE #archGroupCopyTemp
	(
	errorCode			integer, -- newly added for error code.
	id					integer, -- copy id
    policyName VARCHAR(1024),
    copyName VARCHAR(1024),
    archGroupId integer,
    srcCopyId integer,
    copyStartTime integer,
    copyType integer,
    spFlags integer,
    copyFlags integer,
    copyFlagsExt integer,
    copyLevel integer,
    deferredDays integer,
--  startReadTime integer;
    markCopiedTime integer,
    maxMultiplex integer,
    dedupeFlags integer,
    encType integer,
    encKeyLen integer,
    isSnapCopy integer,
    isMirrorCopy integer,
    isNasCopy integer,
    isActive integer
	);;
IF @m_iArchGroupCopyId <> 0
BEGIN
	-- If @m_iArchGroupCopyId is non zero, get archGroupId
	SELECT @m_iArchGroupId = AGC.archGroupId, @m_iPrimaryCopyId = defaultCopy,  @m_iPrimarySnapCopyId = defaultSnapCopy
	FROM archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE AGC.id = @m_iArchGroupCopyId
			AND AGC.archGroupId = AG.id
	IF @@ROWCOUNT = 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (2, @m_iArchGroupCopyId);
		SELECT * FROM #archGroupCopyTemp
		RETURN
	END
	IF @m_iArchGroupId <= 0
	BEGIN
INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (2, @m_iArchGroupCopyId);
		SELECT * FROM #archGroupCopyTemp
		RETURN
	END
	-- THESE ARE DEFAULTS. Check when they are updated.
	--copyInfo.copyStartTime	= 0; -- DONE
	--copyInfo.startReadTime	= 0; -- NOT THERE
	--copyInfo.markCopiedTime	= time(NULL); -- TO BE DONE
	--copyInfo.copyLevel		= 1; -- DONE
	--copyInfo.isSnapCopy		= false; -- DONE
	--copyInfo.isMirrorCopy	= false; -- DONE
	--copyInfo.isNasCopy		= false; -- DONE
	--copyInfo.isActive		= true; -- DONE
	INSERT INTO #archGroupCopyTemp
	SELECT 0, @m_iArchGroupCopyId,
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
	   WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
	   ELSE CASE
			WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy > 0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
	   END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	1 /* copyLevel*/, delayedDays /* defered days */, dbo.GetUnixTime(GetUTCDate()) /* markCopiedTime */,
CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE AGC.id = @m_iArchGroupCopyId AND AGC.archGroupId = AG.id
AND AGC.type = 5
	-- If copy is not active return from here, caller will log error that copy is not active.
	SELECT @isCopyActive = isActive FROM #archGroupCopyTemp
	WHERE id = @m_iArchGroupCopyId
	IF @isCopyActive = 0
	BEGIN
UPDATE #archGroupCopyTemp SET errorCode = 1 WHERE id = @m_iArchGroupCopyId
		--INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (CVA_AUXCOPY_COPY_NOT_ACTIVE, @m_iArchGroupCopyId);
		SELECT * FROM #archGroupCopyTemp
		RETURN
	END
	IF @m_iArchGroupCopyId = @m_iPrimaryCopyId
	BEGIN
UPDATE #archGroupCopyTemp SET errorCode = 7 WHERE id = @m_iArchGroupCopyId
		SELECT * FROM #archGroupCopyTemp
		RETURN
	END
	IF @m_iArchGroupCopyId = @m_iPrimarySnapCopyId
	BEGIN
UPDATE #archGroupCopyTemp SET errorCode = 8 WHERE id = @m_iArchGroupCopyId
		SELECT * FROM #archGroupCopyTemp
		RETURN
	END
	-- If @m_iArchGroupCopyId is not zero, get the srcCopy properties.
	-- Get the copy info for the source copy like above.
	DECLARE @sourceCopyId INTEGER
	SELECT @sourceCopyId = srcCopyId
	FROM #archGroupCopyTemp
	WHERE id = @m_iArchGroupCopyId
	INSERT INTO #archGroupCopyTemp
	SELECT 0, @sourceCopyId, -- Inserting soource copyid in #archGroupCopyTemp
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
		WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
		ELSE CASE
			WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy >0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
		END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	-1 /* copyLevel*/, delayedDays /* defered days */, dbo.GetUnixTime(GetUTCDate()) /* markCopiedTime */,
CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE AGC.id = @sourceCopyId AND AGC.archGroupId = AG.id
AND AGC.type = 5
END
ELSE
BEGIN
	INSERT INTO #archGroupCopyTemp
	SELECT 0, AGC.id,
	AG.name, AGC.name,AG.id,
	/*AGC.sourceCopyId, */
	CASE
		WHEN AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy THEN 0
		ELSE CASE
			WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
			ELSE CASE
				WHEN (((AGC.sourceCopyId ) <=0 AND AGC.isSnapCopy > 0 )) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END
			END
		END,
	AGC.startTime, AGC.type, AG.flags /*spFlags*/, AGC.flags, AGC.extendedFlags,
	--1 /* copyLevel*/,
	CASE
			WHEN AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy THEN -1 ELSE 1 END,
	AGC.delayedDays /* defered days */, 0 /* markCopiedTime */,
CASE WHEN (((AGC.dedupeFlags & (262144 | 2097152)) = 262144)) THEN 1 ELSE AGC.maxMultiplex END,
	AGC.dedupeFlags, AGC.encType, AGC.encKeyLen, AGC.isSnapCopy,
	AGC.isMirrorCopy,
	0, /* isNasCopy */ -- need to update after this
	AGC.isActive
	FROM archGroupCopy AGC WITH (READUNCOMMITTED),archGroupCopy AGC1 WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE AGC.archGroupId = @m_iArchGroupId AND AG.id = @m_iArchGroupId
AND AGC.type = 5 AND AGC1.id = AGC.sourceCopyId AND (AGC1.flags & 33554432) > 0
	-- Send error when there are no active copies.
	-- Check whether secondary copy exists?
	IF (SELECT count(*) from #archGroupCopyTemp ) <= 1
	BEGIN
UPDATE #archGroupCopyTemp SET errorCode = 4 WHERE id = @m_iArchGroupCopyId
		--INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (CVA_AUXCOPY_NO_SECONDARY_COPY, @m_iArchGroupCopyId);
		SELECT * FROM #archGroupCopyTemp
		RETURN;
	END
	-- Check whether there are active copies
	IF (SELECT count(*) from #archGroupCopyTemp WHERE isActive = 1 ) <= 0
	BEGIN
UPDATE #archGroupCopyTemp SET errorCode = 1 WHERE id = @m_iArchGroupCopyId
		--INSERT INTO #archGroupCopyTemp (errorCode, id) VALUES (CVA_AUXCOPY_COPY_NOT_ACTIVE, @m_iArchGroupCopyId);
		SELECT * FROM #archGroupCopyTemp
		RETURN;
	END
END
-- Find whether copy is nasCopy. If it is a nasCopy set the flag isNasCopy to true.
UPDATE #archGroupCopyTemp SET isNasCopy = 1
FROM #archGroupCopyTemp AGCT
	JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGCT.id = AGC.id
	JOIN MMDataPath MMD WITH (READUNCOMMITTED) ON MMD.CopyId = AGCT.id
	JOIN MMDrivePool MMDP WITH (READUNCOMMITTED) ON MMDP.DrivePoolId = MMD.DrivePoolId
WHERE MMDP.DrivePoolType = 3 --3
-- order by errorCode so that caller can check error first.
SELECT *
FROM #archGroupCopyTemp
ORDER BY errorCode
GO
-- End code

IF EXISTS (select * from GxQscripts where name = 'archGetMediaRefreshCopyProperties')
	delete from GxQscripts where name = 'archGetMediaRefreshCopyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMediaRefreshCopyProperties')
	delete from GXDBVersions where aliasname = 'archGetMediaRefreshCopyProperties'
GO

insert into GXDBVersions values(2, 'archGetMediaRefreshCopyProperties',  '00000000000000000000', 'archGetMediaRefreshCopyProperties', '00000000000000000000')
GO

