

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetMaxRetentionOnSP.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetMaxRetentionOnSP.sp,v $ $Id: archGetMaxRetentionOnSP.sp,v 1.2.200.2 2018/03/22 01:11:14 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  archGetMaxRetentionOnSP()
--  |
--  | Description:  Get Max Days retention on Storage Policy.
--	|								For Non-Snap copies only
--	|								Skip media refresh transitive copies
--	|								This will be used by Reference copy Synth Full jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetMaxRetentionOnSP <<<'

IF EXISTS (select * from sysobjects where name='archGetMaxRetentionOnSP')
	drop procedure archGetMaxRetentionOnSP
IF EXISTS (select * from GxQscripts where name='archGetMaxRetentionOnSP')
	delete from GxQscripts where name = 'archGetMaxRetentionOnSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMaxRetentionOnSP')
	delete from GXDBVersions where aliasname = 'archGetMaxRetentionOnSP'
GO
print '... Creating Procedure: archGetMaxRetentionOnSP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetMaxRetentionOnSP
  @i_appId INTEGER
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_MaxRetention INTEGER
SET NOCOUNT ON
	DECLARE @MAXINT		INT
	SET			@MAXINT		= 2147483647
	DECLARE @dataArchGrpId		INT
	SET			@dataArchGrpId		= 0
	DECLARE @logArchGrpId		INT
	SET			@logArchGrpId		= 0
	DECLARE @incrArchGrpId		INT
	SET			@incrArchGrpId		= 0
	SET		@o_ErrorCode = 0
	SET 	@o_MaxRetention = 0
	SELECT @dataArchGrpId = dataArchGrpId, @logArchGrpId = logArchGrpId
	FROM App_Application WITH (NOLOCK)
	WHERE id = @i_appId
	SELECT	@o_ErrorCode = @@ERROR
	IF (@o_ErrorCode != 0) GOTO CX_ERROR_EXIT
	SELECT @incrArchGrpId = incrSP
	FROM archGroup WITH (NOLOCK)
	WHERE id = @dataArchGrpId
	SELECT	@o_ErrorCode = @@ERROR
	IF (@o_ErrorCode != 0) GOTO CX_ERROR_EXIT
	--Reference Copy Subclient will be regular FS agent, so consider only regular RetentionDays
	--DO NOT consider retentionDays of copy that is marked deleted
	--DO NOT consider transitive copy for media refresh or SILO copy
	--DO NOT consider retentionDays of Snap copies since Reference Copy subclient will be regular Non-Snap backup
	--DO NOT consider retentionDays of Extended Retention criteria, since Reference Copy Subclient do not honor extended retention.
	SELECT	@o_MaxRetention = ISNULL(MAX(CASE WHEN AAR.retentionDays < 0 THEN @MAXINT ELSE AAR.retentionDays END), 0)
	FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
	WHERE AGC.archGroupId IN (@dataArchGrpId, @logArchGrpId, @incrArchGrpId)
AND 	AGC.type != 5
AND		AGC.flags & (524288 | 1073741824) = 0
	AND		AGC.isSnapCopy = 0
	AND		AGC.id = AAR.copyId
	SELECT	@o_ErrorCode = @@ERROR
	IF (@o_ErrorCode != 0) GOTO CX_ERROR_EXIT
	IF @o_MaxRetention = @MAXINT
		SET @o_MaxRetention = -1
	SELECT 0, @o_MaxRetention
	RETURN 0
CX_ERROR_EXIT:
	SELECT   @o_ErrorCode, -1
	RETURN   @o_ErrorCode
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archGetMaxRetentionOnSP')
	delete from GxQscripts where name = 'archGetMaxRetentionOnSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetMaxRetentionOnSP')
	delete from GXDBVersions where aliasname = 'archGetMaxRetentionOnSP'
GO

insert into GXDBVersions values(2, 'archGetMaxRetentionOnSP',  '00010002020000020000', 'archGetMaxRetentionOnSP', '00010002020000020000')
GO

