

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetJobsToDeferredCatalog.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archGetJobsToDeferredCatalog.sp                            */
/*                                                                            */
/*  Description :  Return jobs to be processed for deferred catalog           */
/*																			  */
/*  Author      :  Praveen                                                    */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetJobsToDeferredCatalog.sp,v $ $Id: archGetJobsToDeferredCatalog.sp,v 1.1.54.3.62.1 2021/02/12 04:27:10 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archGetJobsToDeferredCatalog')
BEGIN
	print '>>> Drop Stored Procedure: archGetJobsToDeferredCatalog <<<'
	drop procedure archGetJobsToDeferredCatalog
END
IF EXISTS (select * from GxQscripts where name='archGetJobsToDeferredCatalog')
	delete from GxQscripts where name = 'archGetJobsToDeferredCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetJobsToDeferredCatalog')
	delete from GXDBVersions where aliasname = 'archGetJobsToDeferredCatalog'
GO
print '... Creating Procedure: archGetJobsToDeferredCatalog'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archGetJobsToDeferredCatalog
  @i_archGroupId integer,
  @i_searchFlags integer,
  @i_WFJobId integer
AS
  DECLARE @errorCode integer
  DECLARE @commcellId integer
  DECLARE @jobId integer
  DECLARE @archgroupId integer
  DECLARE @copyId integer
  DECLARE @appId integer
  DECLARE @catalogStatus integer
  DECLARE @catalogJobId integer
SET NOCOUNT ON
DECLARE @i_appId INT = 0
DECLARE @l_deferredJobsExist BIT = 0
IF(@i_WFJobId > 0)
BEGIN
	--Get AppId
	SELECT @i_appId = ISNULL(CONVERT(INT, value), 0)
    FROM dbo.GetAllJobOptions(@i_WFJobId)
WHERE optionId = 140007
    IF (@i_appId <= 0) AND (@i_ArchGroupId <= 0)
    BEGIN
SET @errorCode = 221 --Both appId and ArchGroupId cannot be 0
		GOTO ERROR_EXIT
    END
END
ELSE IF(@i_ArchGroupId <= 0)
BEGIN
SET @errorCode = 221 --Both WFJobId and ArchGroupId cannot be 0
	GOTO ERROR_EXIT
END
IF @i_appId < 0 SET @i_appId = 0
IF @i_ArchGroupId < 0 SET @i_ArchGroupId = 0
DECLARE @l_now INT
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
IF OBJECT_ID('tempdb.dbo.#archGroupList') IS NOT NULL DROP TABLE #archGroupList
CREATE TABLE #archGroupList (
		archGroupId 	INTEGER,
		copyId 				INTEGER,
		deferredDays 	INTEGER
		PRIMARY KEY (archGroupId, copyId)
)
IF OBJECT_ID('tempdb.dbo.#ArchGroupIds') IS NOT NULL DROP TABLE #ArchGroupIds
CREATE TABLE #ArchGroupIds (
	agId INTEGER
	PRIMARY KEY (agId)
)
IF OBJECT_ID('tempdb.dbo.#tmpappId') IS NOT NULL DROP TABLE #tmpappId
CREATE TABLE #tmpappId (
	appId		INTEGER
	PRIMARY KEY (appId)
)
IF OBJECT_ID('tempdb.dbo.#lt_jobs') IS NOT NULL DROP TABLE #lt_jobs
CREATE TABLE #lt_jobs (
	jobId 			INT,
	commCellId 	INT,
	archGrpId 	INT,
	Status 			INT,
	matJobId 		INT,
	appId 			INT
)
CREATE CLUSTERED INDEX IX_jobId_commcellId on #lt_jobs (jobId ASC, commCellId ASC)
IF OBJECT_ID('tempdb.dbo.#jobsDetails') IS NOT NULL DROP TABLE #jobsDetails
	CREATE TABLE #jobsDetails(
	errorCode 	INT,
	commcellId 	INT,
	jobId 			INT,
	archGrpId 	INT,
	copyId 			INT,
	appId 			INT,
	Status 			INT,
	matJobId 		INT,
	startDate		INT
)
-- If VSA V2 Parent subclient, then return jobs of all associated child VMs
IF(@i_appId > 0)
BEGIN
IF @i_appId IN (SELECT DISTINCT parentAppId FROM JMJobDataLink WITH (NOLOCK) WHERE linkType = 7) --VSA V2 Parent subclient
	BEGIN
		INSERT INTO #tmpappId
SELECT DISTINCT childAppId FROM JMJobDataLink WITH (NOLOCK) WHERE parentAppId = @i_appId AND linkType = 7
		UNION
		SELECT @i_appId
	END
	ELSE
	BEGIN
		INSERT INTO #tmpappId
		SELECT @i_appId
	END
END
IF(@i_ArchGroupId > 0)
	INSERT INTO #ArchGroupIds
	SELECT @i_ArchGroupId
ELSE
	INSERT INTO #ArchGroupIds
	SELECT DISTINCT S.archGrpId
FROM JMJobSnapDeferredCatalogStats S WITH (NOLOCK), #tmpappId T
	WHERE S.appId = T.appId
AND catalogStatus IN (101, 102, 103)
INSERT INTO #archGroupList
SELECT AG.id, case when PROP.sourceCopyId > 0 then PROP.sourceCopyId else AG.defaultSnapCopy end, PROP.deferredDays
FROM ArchDeferredCatalogProp PROP WITH(NOLOCK) INNER JOIN archGroup AG WITH(NOLOCK) ON PROP.archGroupId = AG.id
INNER JOIN #ArchGroupIds AGIds ON AG.id = AGIds.agId
WHERE PROP.enabled = 1
INSERT	INTO #lt_jobs
SELECT	A.jobId, A.commCellId, A.archGrpId, A.catalogStatus, A.catalogJobId, A.appId
FROM	JMJobSnapDeferredCatalogStats A WITH (NOLOCK)
		INNER JOIN App_Application app WITH (NOLOCK) ON A.appId = app.id AND A.archGrpId = app.dataArchGrpId
		INNER JOIN APP_CommCell B WITH (NOLOCK) ON B.id = A.commCellId AND B.type = 1
		INNER JOIN #archGroupList AGList ON AGList.archGroupId = A.archGrpId
		LEFT OUTER JOIN JMJobDataStats D WITH (NOLOCK) ON D.commCellId = A.commCellId AND D.jobId = A.jobId AND D.archGrpCopyId = AGList.copyId
		LEFT OUTER JOIN #tmpappId T ON A.appId = T.appId
WHERE	A.catalogStatus IN (101, 102, 103) AND A.disabled & 1 = 0 AND B.id = 2
AND	(T.appId IS NOT NULL OR @i_appId = 0)
GROUP BY A.jobId, A.commCellId, A.archGrpId, A.catalogStatus, A.catalogJobId, A.appId
HAVING MAX(IsNull(D.status, 0)) = 100
--Skip further queries if there is no job that can be backup copied
IF NOT EXISTS (SELECT 1 FROM #lt_jobs)
	GOTO NO_JOB_TO_PROCESS_EXIT
/*
Filter subclients which are already being processed by some workflow job. It can be subclient level workflow or storage policy level workflow or inline backup copy.
This should cover all 3 cases
*/
IF(OBJECT_ID('tempdb..#tblRunningWorkFlows') IS NOT NULL)
	DROP TABLE #tblRunningWorkFlows
CREATE TABLE #tblRunningWorkFlows (WFJobId int, commcellId int, applicationId int, primary key(WFJobId, commcellId, applicationId))
--These are the workflow jobs currently running with backup copies pending for some suclients
INSERT INTO #tblRunningWorkFlows
SELECT DISTINCT JWF.jobId, JWF.commcellId, JWF.applicationId
FROM JMJobWF JWF WITH(NOLOCK) INNER JOIN JMJobInfo JI WITH(NOLOCK) ON JWF.jobId = JI.jobId AND JWF.commcellId = JI.commcellId AND
JI.opType = 95 --DELAYEDCATALOGWORKFLOW = 95
WHERE JWF.childJobId = 0 AND JWF.submitStatus <> 2 /* enum CVWFJobSubmitStatus{ CVWFJOB_NOTSUBMITTED=0, CVWFJOB_SUBMITTING, CVWFJOB_SUBMITTED_COMPLETE} */
--If the workflow had any backup copy job failed for subclient, then workflow will not process these any more. So remove those subclients from running workflow list
/*
In one of the customer sites SQL server reads all rows of JMBkpStats and then matches with other tables which isn't optimal.
Forcing Order here so that JMBkpStats look up will be clustered index seek based on result from the previous join.
*/
DELETE #tblRunningWorkFlows
FROM #tblRunningWorkFlows T INNER JOIN JMJobWF JWF WITH(NOLOCK) ON T.WFJobId = JWF.jobId AND T.commcellId = JWF.commcellId AND T.applicationId = JWF.applicationId
INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON JWF.childJobId = JBKP.jobId AND JWF.commcellId = JBKP.commcellId AND JBKP.status NOT IN (1, 3, 14)
OPTION(FORCE ORDER)
DELETE L
FROM #lt_jobs L INNER JOIN
--All snap subclients processed by workflows
(
SELECT DISTINCT applicationId FROM #tblRunningWorkFlows
UNION
--To handle inline backup copy and currently running backup copies
SELECT DISTINCT JWF.applicationId FROM JMJobWF JWF WITH(NOLOCK) INNER JOIN JMJobInfo JI WITH(NOLOCK) ON JWF.ChildJobId = JI.jobId AND JWF.commcellId = JI.commcellId AND
JI.subOpType = 96 -- DELAYEDCATALOG
) App
ON L.appId = App.applicationId
IF(OBJECT_ID('tempdb..#tblRunningWorkFlows') IS NOT NULL)
	DROP TABLE #tblRunningWorkFlows
--Return Parent VSA V2 jobs too whether picked\not picked, moved\not moved for JM to group parent-to-child VMs
INSERT	INTO #jobsDetails
SELECT	0/*error code*/, J.commCellId, J.JobID, J.archGrpId, AGList.copyId, B.appId, J.Status, J.matJobId, B.servStartDate
FROM	#lt_jobs J
		INNER JOIN JMBkpStats B WITH (NOLOCK)
		ON	J.commCellId = B.commCellId AND J.jobId = B.jobId
		INNER JOIN #archGroupList AGList ON AGList.archGroupId = J.archGrpId
WHERE	B.dataStatus = 0
--Jobs deferred due to storage policy property
DELETE J
FROM #jobsDetails J INNER JOIN #archGroupList AGList ON J.archGrpId = AGList.archGroupId
WHERE (J.startDate + AGList.deferredDays * 24 * 3600) > @l_now
SET @l_deferredJobsExist = @@ROWCOUNT /*This is a bit datatype. If @@ROWCOUNT > 0 the variable will get set to 1*/
--Skip VM snap jobs for backup copy if the corresponding parent VSA job is still running
DELETE #jobsDetails
FROM #jobsDetails T, JMJobDataLink JDL WITH (READUNCOMMITTED), JMJobInfo JI WITH (READUNCOMMITTED)
WHERE T.jobId = JDL.childJobId
AND 	T.commCellId = JDL.commCellId
AND		JDL.linkType = 7
AND		JDL.parentJobId = JI.jobId
AND 	JDL.commCellId = JI.commCellId
--Get parent VSA V2 job details if not there already
INSERT	INTO #jobsDetails
SELECT	DISTINCT 0/*error code*/, J.commCellId, J.JobId, J.dataArchGrpId, ISNULL(AGList.copyId, 0), J.appId,
ISNULL(SS.catalogStatus, 0), ISNULL(SS.catalogJobId, 0), J.servStartDate
FROM	JMBkpStats J WITH (READUNCOMMITTED)
			INNER JOIN JMJobDataLink JDL WITH (READUNCOMMITTED)
			ON J.jobId = JDL.parentJobId
			AND J.commCellId = JDL.commCellId
			INNER JOIN #jobsDetails T
			ON T.jobId = JDL.childJobId
			AND T.commCellId = JDL.commCellId
			LEFT OUTER JOIN #archGroupList AGList
			ON J.dataArchGrpId = AGList.archGroupId
LEFT OUTER JOIN JMJobSnapDeferredCatalogStats SS WITH (READUNCOMMITTED)
			ON J.jobId = SS.jobId
			AND J.commCellId = SS.commCellId
WHERE JDL.linkType = 7
AND NOT EXISTS (SELECT TMP.jobId
								FROM #jobsDetails TMP
								WHERE TMP.jobId = J.JobId
								AND		TMP.commCellId = J.commCellId)
NO_JOB_TO_PROCESS_EXIT:
IF NOT EXISTS (SELECT 1 FROM #jobsDetails)
BEGIN
	IF(@l_deferredJobsExist > 0)
	BEGIN
SET @errorCode = 363
		GOTO ERROR_EXIT
	END
END
SELECT * FROM #jobsDetails ORDER BY startDate
if OBJECT_ID('tempdb.dbo.#lt_jobs') IS NOT NULL DROP TABLE #lt_jobs
if OBJECT_ID('tempdb.dbo.#jobsDetails') IS NOT NULL DROP TABLE #jobsDetails
IF OBJECT_ID('tempdb.dbo.#archGroupList') IS NOT NULL DROP TABLE #archGroupList
IF OBJECT_ID('tempdb.dbo.#ArchGroupIds') IS NOT NULL DROP TABLE #ArchGroupIds
IF OBJECT_ID('tempdb.dbo.#tmpappId') IS NOT NULL DROP TABLE #tmpappId
RETURN;
ERROR_EXIT:
SELECT @errorCode, 0, 0, 0, 0, 0, 0, 0
if OBJECT_ID('tempdb.dbo.#lt_jobs') IS NOT NULL DROP TABLE #lt_jobs
if OBJECT_ID('tempdb.dbo.#jobsDetails') IS NOT NULL DROP TABLE #jobsDetails
IF OBJECT_ID('tempdb.dbo.#archGroupList') IS NOT NULL DROP TABLE #archGroupList
IF OBJECT_ID('tempdb.dbo.#ArchGroupIds') IS NOT NULL DROP TABLE #ArchGroupIds
IF OBJECT_ID('tempdb.dbo.#tmpappId') IS NOT NULL DROP TABLE #tmpappId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetJobsToDeferredCatalog')
	delete from GxQscripts where name = 'archGetJobsToDeferredCatalog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetJobsToDeferredCatalog')
	delete from GXDBVersions where aliasname = 'archGetJobsToDeferredCatalog'
GO

insert into GXDBVersions values(2, 'archGetJobsToDeferredCatalog',  'v1.1.54.3.62.1', 'archGetJobsToDeferredCatalog', 'v1.1.54.3.62.1')
GO

