

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetJobSizeInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetJobSizeInfo.sp,v $ $Id: archGetJobSizeInfo.sp,v 1.4.32.1 2018/03/22 01:05:44 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetJobSizeInfo <<<'

IF EXISTS (select * from sysobjects where name='archGetJobSizeInfo')
	drop procedure archGetJobSizeInfo
IF EXISTS (select * from GxQscripts where name='archGetJobSizeInfo')
	delete from GxQscripts where name = 'archGetJobSizeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetJobSizeInfo')
	delete from GXDBVersions where aliasname = 'archGetJobSizeInfo'
GO
print '... Creating Procedure: archGetJobSizeInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetJobSizeInfo
  @i_dummy integer
AS
DECLARE @retVal	integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@retVal = 0
/*
--Create this temp table from the caller code
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
*/
--For Backup jobs
UPDATE #tmpJobSizeInfo
SET totalBackupSize = ISNULL(JBK.totalBackupSize, 0), totalAppSize = ISNULL(JBK.totalUncompBytes, 0)
FROM #tmpJobSizeInfo T, JMBkpStats JBK WITH (NOLOCK)
WHERE T.JobId = JBK.JobId
AND		T.CommCellId = JBK.CommCellId
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
--For DR Backup and Info Management (Legalhold) jobs
UPDATE #tmpJobSizeInfo
SET totalBackupSize = ISNULL(JAS.totalBackupSize, 0), totalAppSize = (CASE WHEN (ISNULL(JAS.uncompBytes, 0) != 0) THEN ISNULL(JAS.uncompBytes, 0) ELSE ISNULL(JAS.totalBackupSize, 0) END)
FROM #tmpJobSizeInfo T, JMAdminJobStatsTable JAS WITH (NOLOCK)
WHERE T.JobId = JAS.JobId
AND		T.CommCellId = JAS.CommCellId
AND		JAS.opType IN (11, 64) --DR Backup, Legal Hold
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
--Calculate Index Size for Backup jobs
UPDATE #tmpJobSizeInfo
SET totalIndexSize = TMP.totalIndexSize
FROM #tmpJobSizeInfo JS, (	SELECT T.JobId, T.CommCellId, SUM(ISNULL(JBAS.unCompBytes, 0)) AS totalIndexSize
														FROM 	#tmpJobSizeInfo T, JMBkpStats JBK WITH (NOLOCK), JMBkpAtmptStats JBAS WITH (NOLOCK), JMOpTable JOP WITH (NOLOCK), JMPhase JMP WITH (NOLOCK)
														WHERE T.JobId = JBK.JobId
														AND		T.CommCellId = JBK.CommCellId
														AND 	JBK.JobId = JBAS.JobId
														AND		JBK.CommCellId = JBAS.CommCellId
														AND 	JBK.opType = JOP.operation
														AND 	JBK.appType = JOP.appTypeType
														AND		JOP.id = JMP.opTableId
														AND 	JBAS.phase = JMP.phase
														AND 	(JMP.name = 'Archive Index' OR JMP.startExec = 'archiveIndex.exe')
														GROUP BY T.JobId, T.CommCellId) TMP
WHERE JS.JobId = TMP.JobId AND JS.CommCellId = TMP.CommCellId
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
--Calculate Index Size for DR Backup and Info Management (Legalhold) jobs
UPDATE #tmpJobSizeInfo
SET totalIndexSize = TMP.totalIndexSize
FROM #tmpJobSizeInfo JS, (	SELECT T.JobId, T.CommCellId, SUM(ISNULL(JBAS.unCompBytes, 0)) AS totalIndexSize
														FROM 	#tmpJobSizeInfo T, JMAdminJobStatsTable JAS WITH (NOLOCK), JMAdminJobAttemptStatsTable JBAS WITH (NOLOCK), JMOpTable JOP WITH (NOLOCK), JMPhase JMP WITH (NOLOCK)
														WHERE T.JobId = JAS.JobId
														AND		T.CommCellId = JAS.CommCellId
														AND 	JAS.JobId = JBAS.JobId
														AND		JAS.CommCellId = JBAS.CommCellId
														AND		JAS.opType IN (11, 64) 								--DR Backup, Legal Hold
														AND 	JAS.opType = JOP.operation
														AND		JOP.appTypeType IN (1000) 						--Checking only for DR Backup and Legal Hold appType since JMAdminJobStatsTable table does not have appType column
														AND		JOP.id = JMP.opTableId
														AND 	JBAS.phaseNum = JMP.phase
														AND 	(JMP.name = 'Archive Index' OR JMP.startExec = 'archiveIndex.exe')
														GROUP BY T.JobId, T.CommCellId) TMP
WHERE JS.JobId = TMP.JobId AND JS.CommCellId = TMP.CommCellId
SET	@retVal	=	@@ERROR
IF	@retVal != 0 GOTO CX_EXIT
CX_EXIT:
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archGetJobSizeInfo')
	delete from GxQscripts where name = 'archGetJobSizeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetJobSizeInfo')
	delete from GXDBVersions where aliasname = 'archGetJobSizeInfo'
GO

insert into GXDBVersions values(2, 'archGetJobSizeInfo',  '00010004003200010000', 'archGetJobSizeInfo', '00010004003200010000')
GO

