

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetEncKeysToAdjust.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetEncKeysToAdjust.sp,v $ $Id: archGetEncKeysToAdjust.sp,v 1.1.6.3.8.1 2021/04/29 01:35:06 cliu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	Procedure: "archGetEncKeysToAdjust"									|
--	|	Description: Returns encKeys which needs to be adjusted				|
--	|				 on destination copy									|
--	|																		|
--  |	Author: 	Prasad Nara												|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archGetEncKeysToAdjust')
BEGIN
	print '>>> Drop Stored Procedure: archGetEncKeysToAdjust <<<'
	drop procedure archGetEncKeysToAdjust
END
IF EXISTS (select * from GxQscripts where name='archGetEncKeysToAdjust')
	delete from GxQscripts where name = 'archGetEncKeysToAdjust'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetEncKeysToAdjust')
	delete from GXDBVersions where aliasname = 'archGetEncKeysToAdjust'
GO
print '... Creating Procedure: archGetEncKeysToAdjust'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archGetEncKeysToAdjust
  @i_optionFlags integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archFileId integer
  DECLARE @o_commCellId integer
  DECLARE @o_encRSA integer
  DECLARE @o_encKey varchar(1024)
  DECLARE @o_srcCopyId integer
  DECLARE @o_destCopyId integer
  DECLARE @o_destKeyCopyId integer
  DECLARE @o_destSIDBStoreId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Options 1 is for adjust enckey for dedupe copy with RSA as CVA_AFC_ENC_DATAKEY_SOURCE_COPY_RSA
-- Options 2 is for fix missing enckey for non-dedupe copy
IF @i_optionFlags = 0 OR @i_optionFlags = 1
BEGIN
	--
	--	Update Keys in AFK if AFC has adjusted key for dest copy
	--
	UPDATE	AFK
	SET		encRSA = AFC.encRSA,
			encKeyType = AFC.encKeyType,
			encKey = AFC.encKey
	FROM	ArchFileCopy AFC WITH(READUNCOMMITTED),
			ArchGroupCopy AGC WITH(READUNCOMMITTED),
			ArchFileSIDBKeys AFK WITH(READUNCOMMITTED)
	WHERE	AFC.archCopyId = AGC.id
			AND AGC.SIDBStoreId = AFK.SIDBStoreId
			AND AFC.archFileId = AFK.archFileId
			AND AFC.commCellId = AFK.commCellId
AND AFK.encRSA & 4 > 0
AND AFC.encRSA & 4 = 0
	SELECT	DAFK.archFileId, DAFK.commCellId, DAFK.encRSA, DAFK.encKey, SAGC.id srcCopyId, DAFK.archCopyId destCopyId, DAGC.id destKeyCopyId, DAGC.SIDBStoreId destSIDBStoreId
	FROM	ArchFileSIDBKeys DAFK WITH(READUNCOMMITTED),
			ArchFileSIDBKeys SAFK WITH(READUNCOMMITTED),
			IdxSIDBStore DS WITH(READUNCOMMITTED),
			IdxSIDBStore DSS WITH(READUNCOMMITTED),
			ArchGroupCopy DAGC WITH(READUNCOMMITTED),
			IdxSIDBStore SS WITH(READUNCOMMITTED),
			IdxSIDBStore SSS WITH(READUNCOMMITTED),
			ArchGroupCopy SAGC WITH(READUNCOMMITTED)
	WHERE	DAFK.archFileId = SAFK.archFileId
			AND DAFK.commCellId = SAFK.commCellId
			AND DAFK.encKey = SAFK.encKey
AND DAFK.encRSA & 4 > 0
AND SAFK.encRSA & 4 = 0
			AND DAFK.SIDBStoreId = DS.SIDBStoreId
			AND DS.SIDBStoreAliasName = DSS.SIDBStoreAliasName
			AND DSS.SIDBStoreId = DAGC.SIDBStoreId
AND DAGC.dedupeFlags & 134217728 = 0
			AND SAFK.SIDBStoreId = SS.SIDBStoreId
			AND SS.SIDBStoreAliasName = SSS.SIDBStoreAliasName
			AND SSS.SIDBStoreId = SAGC.SIDBStoreId
AND SAGC.dedupeFlags & 134217728 = 0
END
ELSE IF @i_optionFlags = 2
BEGIN
	IF OBJECT_ID('tempdb.dbo.#copyNeedFix') IS NOT NULL DROP TABLE #copyNeedFix
	CREATE TABLE #copyNeedFix
	(
		srcCopyId	integer,
		destCopyId	integer,
		destCopyFlag integer,
		need_adjust	tinyint
	)
	CREATE CLUSTERED INDEX Idx_tempcopyNeedFix_primary ON #copyNeedFix (destCopyId)
	CREATE INDEX Idx_tempcopyNeedFix_srcCopy ON #copyNeedFix (srcCopyId)
	IF OBJECT_ID('tempdb.dbo.#archFileNeedFix') IS NOT NULL DROP TABLE #archFileNeedFix
	CREATE TABLE #archFileNeedFix
	(
		srcCopyId	integer,
		destCopyId	integer,
		commCellId 	integer,
		archFileId	integer,
		encRSA		tinyint,
		encKeyType	tinyint,
		encKey		varchar(1024),
		encKeyId	integer,
		needAdjust	tinyint
	)
	CREATE INDEX Idx_temparchFileNeedFix_primary ON #archFileNeedFix (commcellId, destCopyId, archFileId)
	CREATE INDEX Idx_temparchFileNeedFix_srcCopy ON #archFileNeedFix (commcellId, srcCopyId, archFileId)
	INSERT INTO #copyNeedFix
	SELECT 	DISTINCT CASE WHEN srcCopy.Id > 0 THEN srcCopy.Id ELSE sp.defaultCopy END, destCopy.Id, destCopy.flags, 0
	FROM	ArchGroupCopy destCopy WITH (NOLOCK)
			LEFT JOIN ArchGroupCopy srcCopy WITH (NOLOCK) ON destCopy.sourceCopyId = srcCopy.Id AND srcCopy.Id > 0
			INNER JOIN ArchGroup sp WITH (NOLOCK) ON destCopy.archGroupId = sp.Id AND destCopy.Id != sp.defaultCopy
WHERE	destCopy.dedupeFlags & 262144 = 0
	AND		destCopy.isSnapCopy = 0
	IF OBJECT_ID('tempdb.dbo.#appNeedFix') IS NOT NULL DROP TABLE #appNeedFix
	CREATE TABLE #appNeedFix
	(
		appId	integer
	)
	INSERT INTO #appNeedFix
	SELECT DISTINCT App.Id
	FROM	App_Application App WITH(NOLOCK)
			INNER JOIN App_ClientProp CP WITH(NOLOCK) ON App.clientId = CP.componentNameId
	WHERE	CP.attrName = N'Encrypt: restoreAccess'
	AND		CP.attrVal = '1'  /*ENC_RESTORE_PASSPHRASE*/
	AND		CP.modified = 0
	-- ArchFileCopy rows missing encryption info when subclient is set as passPhraseProtected
	INSERT INTO #archFileNeedFix
	SELECT	DISTINCT srcCopy.archCopyId, destCopy.archCopyId, destCopy.commCellId, destCopy.archFileId, srcCopy.encRSA, srcCopy.encKeyType, srcCopy.encKey, srcCopy.encKeyId, 0
	FROM 	#appNeedFix a
			INNER JOIN ArchFile archFile WITH (NOLOCK) ON a.appId = archFile.appId
			INNER JOIN ArchFileCopy destCopy WITH (NOLOCK) ON archFile.Id = destCopy.archfileid AND archFile.commCellId = destCopy.commCellId
			INNER JOIN #copyNeedFix copy WITH (NOLOCK) ON destCopy.archCopyId = copy.destCopyId
			INNER JOIN ArchFileCopy srcCopy WITH (NOLOCK) ON copy.srcCopyId = srcCopy.archCopyId
	WHERE	destCopy.archFileId = srcCopy.archfileid AND destCopy.commCellId = srcCopy.commCellId
	AND		destCopy.encKeyType = 0 AND srcCopy.encKeyType > 0
	-- -- ArchFileCopy rows missing encryption info when subclient is set as passPhraseProtected but data is aged
	INSERT INTO #archFileNeedFix
	SELECT	A.srcCopyId, A.destCopyId, A.commCellId, A.archFileId, A.encRSA, A.encKeyType, A.encKey, A.encKeyId, A.needAdjust
	FROM	(
				SELECT	DISTINCT srcCopy.archCopyId srcCopyId, destCopy.archCopyId destCopyId, destCopy.commCellId, destCopy.archFileId, srcCopy.encRSA, srcCopy.encKeyType, srcCopy.encKey, srcCopy.encKeyId, 0 as needAdjust
				FROM 	#appNeedFix a
						INNER JOIN ArchFile archFile WITH (NOLOCK) ON a.appId = archFile.appId
						INNER JOIN ArchFileCopy destCopy WITH (NOLOCK) ON archFile.Id = destCopy.archfileid AND archFile.commCellId = destCopy.commCellId
						INNER JOIN #copyNeedFix copy WITH (NOLOCK) ON destCopy.archCopyId = copy.destCopyId
						INNER JOIN ArchFileSIDBKeys srcCopy WITH (NOLOCK) ON copy.srcCopyId = srcCopy.archCopyId
				WHERE	destCopy.archFileId = srcCopy.archfileid AND destCopy.commCellId = srcCopy.commCellId
				AND		(destCopy.encKeyType = 0 AND destCopy.EncKeyId = 0)
				AND		(srcCopy.encKeyType > 0 OR srcCopy.encKeyId > 0)
			) A
			LEFT JOIN #archFileNeedFix B ON A.destCopyId = B.destCopyId AND A.commCellId = B.commCellId AND A.archFileId = B.archFileId
	WHERE	B.archFileId IS NULL
	-- ArchFileCopy rows missing encryption info which copy has option "CVA_AUXCOPY_PASSTHRU_ENCRYPT" set
	INSERT INTO #archFileNeedFix
	SELECT A.srcCopyId, A.destCopyId, A.commCellId, A.archFileId, A.encRSA, A.encKeyType, A.encKey, A.encKeyId, A.needAdjust
	FROM	(
				SELECT	DISTINCT copy.srcCopyId AS srcCopyId, copy.destCopyId AS destCopyId, destCopy.commCellId AS commCellId,
						destCopy.archFileId AS archFileId, srcCopy.encRSA AS encRSA, srcCopy.encKeyType AS encKeyType, srcCopy.encKey AS encKey, srcCopy.encKeyId AS encKeyId,
						1 AS needAdjust
				FROM 	#copyNeedFix copy
						INNER JOIN ArchFileCopy destCopy WITH (NOLOCK) ON copy.destCopyId = destCopy.archCopyId
						INNER JOIN ArchFileCopy srcCopy WITH (NOLOCK) ON copy.srcCopyId = srcCopy.archCopyId
WHERE	(copy.destCopyFlag & 1048576) > 0
				AND		destCopy.archFileId = srcCopy.archfileid AND destCopy.commCellId = srcCopy.commCellId
				AND		(destCopy.encKeyType = 0 AND destCopy.encKeyId = 0)
				AND		srcCopy.encKeyType > 0
			) A
			LEFT JOIN #archFileNeedFix B ON A.destCopyId = B.destCopyId AND A.commCellId = B.commCellId AND A.archFileId = B.archFileId
	WHERE	B.archFileId IS NULL
	-- ArchFileCopy rows missing encryption info which copy has option "CVA_AUXCOPY_PASSTHRU_ENCRYPT" set but data is aged
	INSERT INTO #archFileNeedFix
	SELECT A.srcCopyId, A.destCopyId, A.commCellId, A.archFileId, A.encRSA, A.encKeyType, A.encKey, A.encKeyId, A.needAdjust
	FROM	(
				SELECT	DISTINCT copy.srcCopyId AS srcCopyId, copy.destCopyId AS destCopyId, destCopy.commCellId AS commCellId,
						destCopy.archFileId AS archFileId, srcCopy.encRSA AS encRSA, srcCopy.encKeyType AS encKeyType, srcCopy.encKey AS encKey, srcCopy.encKeyId AS encKeyId,
						1 AS needAdjust
				FROM 	#copyNeedFix copy
						INNER JOIN ArchFileCopy destCopy WITH (NOLOCK) ON copy.destCopyId = destCopy.archCopyId
						INNER JOIN ArchFileSIDBKeys srcCopy WITH (NOLOCK) ON copy.srcCopyId = srcCopy.archCopyId
WHERE	(copy.destCopyFlag & 1048576) > 0
				AND		destCopy.archFileId = srcCopy.archfileid AND destCopy.commCellId = srcCopy.commCellId
				AND		(destCopy.encKeyType = 0 AND destCopy.encKeyId = 0)
				AND		(srcCopy.encKeyType > 0 OR srcCopy.encKeyId > 0)
			) A
			LEFT JOIN #archFileNeedFix B ON A.destCopyId = B.destCopyId AND A.commCellId = B.commCellId AND A.archFileId = B.archFileId
	WHERE	B.archFileId IS NULL
	UPDATE	archFileCopy
SET		flags = CASE WHEN fix.needAdjust = 0 THEN flags | 4096 ELSE flags END,
encRSA = CASE WHEN (fix.encRSA & 2) > 0 THEN ((fix.encRSA & ~2) | 4) ELSE fix.encRSA END,
			encKeyType = CASE WHEN LEN(fix.encKey) = 0 AND fix.encKeyId > 0 THEN keys.encKeyType ELSE fix.encKeyType END,
			encKey = CASE WHEN LEN(fix.encKey) = 0 AND fix.encKeyId > 0 THEN keys.encKey ELSE fix.encKey END,
			encKeyId = fix.encKeyId
	FROM 	archFileCopy AFC
			INNER JOIN #archFileNeedFix fix ON AFC.archCopyId = fix.destCopyId AND AFC.commCellId = fix.commCellId AND AFC.archFileId = fix.archFileId
			LEFT JOIN ArchEncKeys keys WITH (NOLOCK) ON fix.encKeyId = keys.encKeyId
	SELECT	archFileId, commCellId, encRSA, '', srcCopyId, destCopyId, 0, 0
	FROM	#archFileNeedFix
	WHERE	needAdjust > 0
	IF OBJECT_ID('tempdb.dbo.#copyNeedFix') IS NOT NULL DROP TABLE #copyNeedFix
	IF OBJECT_ID('tempdb.dbo.#archFileNeedFix') IS NOT NULL DROP TABLE #archFileNeedFix
	IF OBJECT_ID('tempdb.dbo.#appNeedFix') IS NOT NULL DROP TABLE #appNeedFix
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetEncKeysToAdjust')
	delete from GxQscripts where name = 'archGetEncKeysToAdjust'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetEncKeysToAdjust')
	delete from GXDBVersions where aliasname = 'archGetEncKeysToAdjust'
GO

insert into GXDBVersions values(2, 'archGetEncKeysToAdjust',  'v1.1.6.3.8.1', 'archGetEncKeysToAdjust', 'v1.1.6.3.8.1')
GO

