

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetEncKeyProvider.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetEncKeyProvider.sp,v $ $Id: archGetEncKeyProvider.sp,v 1.1.2.7 2018/07/28 04:01:31 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archGetEncKeyProvider"								|
--	|																		|
--	| Returns encryption key provider properties							|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetEncKeyProvider <<<'

IF EXISTS (select * from sysobjects where name='archGetEncKeyProvider')
	drop procedure archGetEncKeyProvider
IF EXISTS (select * from GxQscripts where name='archGetEncKeyProvider')
	delete from GxQscripts where name = 'archGetEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archGetEncKeyProvider'
GO
print '... Creating Procedure: archGetEncKeyProvider'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetEncKeyProvider
  @i_userId int,
  @i_keyProviderId int = 0,
  @i_propertyLevel int = 1, 
  @i_providerType int = 0 
AS
BEGIN
  DECLARE @o_keyProvidersXml xml
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET @o_keyProvidersXml = '<App_GetEncKeyProvidersResp />'
	--
	--Security check
	--
	IF OBJECT_ID('tempdb..#lt_SecAssocEntities') IS NOT NULL DROP TABLE #lt_SecAssocEntities
	CREATE TABLE #lt_SecAssocEntities (entityId INT)
	--Get all associated key providers
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 178 /*KEY_MANAGEMENT_SERVER_ENTITY*/,  0 /*permissionId*/, '#lt_SecAssocEntities'
	--Built-in is visible to all
	IF NOT EXISTS(SELECT 1 FROM #lt_SecAssocEntities WHERE entityId = 1 /*Built-in provider*/)
		INSERT INTO #lt_SecAssocEntities VALUES(1)
	IF @i_keyProviderId > 0 AND @i_propertyLevel = 30 /*App::ListPropertyLevels_AllProperties*/
	BEGIN
		--Get KeyProvider Associations
		DECLARE @l_assocXml			xml
		IF OBJECT_ID ('tempdb..#lt_AssocEntities') IS NOT NULL DROP TABLE #lt_AssocEntities
        CREATE TABLE #lt_AssocEntities (entityType1 int, entityId1 int, entityType2 int, entityId2 int, entityType3 int,
		entityId3 int, entityType4 int, entityId4 int, entityType5 int, entityId5 int, includeAll int, genericEntityAssociated xml)
		INSERT 	INTO #lt_AssocEntities(entityType1, entityId1, includeAll)
		SELECT 	EntityType, EntityId, 0
		FROM	ArchEncKeyProviderAssoc WITH(READUNCOMMITTED)
		WHERE	KeyProviderId = @i_keyProviderId
		EXEC EntityIdToNameConverterDynamic '#lt_AssocEntities', 'entity'
		SET	@l_assocXml =
		(
			SELECT 	genericEntityAssociated as associations
			FROM	#lt_AssocEntities
			FOR XML PATH (''),TYPE
		)
		--Get Security Associations
		DECLARE @l_secAssocXml			xml
EXEC sec_getSecurityForEntity @i_userId, @l_secAssocXml OUTPUT, 178 /*KEY_MANAGEMENT_SERVER_ENTITY*/, @i_keyProviderId
		SET @o_keyProvidersXml =
		(
			SELECT	KP.KeyProviderType AS '@keyProviderType',
					KP.EncType AS '@encryptionType',
					KP.EncKeyLength AS '@encryptionKeyLength',
					KP.KeyProviderId AS 'provider/@keyProviderId',
					KP.KeyProviderName AS 'provider/@keyProviderName',
					CAST(REPLACE(KP.Properties,  'App_EncKeyProviderProperties', 'properties') as xml),
					@l_assocXml,
					(SELECT @l_secAssocXml FOR XML PATH ('securityAssociations'),TYPE)
			FROM	ArchEncKeyProvider KP WITH(READUNCOMMITTED), #lt_SecAssocEntities SEC
			WHERE	KP.KeyProviderId = @i_keyProviderId
					AND KP.KeyProviderId = SEC.entityId
			FOR XML PATH ('keyProviders'), ROOT ('App_GetEncKeyProvidersResp')
		)
	END
	ELSE IF @i_propertyLevel = 20 /*App::ListPropertyLevels_ExtendedProperties*/
	BEGIN
		SET @o_keyProvidersXml =
		(
			SELECT	KP.KeyProviderType AS '@keyProviderType',
					KP.EncType AS '@encryptionType',
					KP.EncKeyLength AS '@encryptionKeyLength',
					KP.KeyProviderId AS 'provider/@keyProviderId',
					KP.KeyProviderName AS 'provider/@keyProviderName',
					CAST(REPLACE(KP.Properties,  'App_EncKeyProviderProperties', 'properties') as xml)
			FROM	ArchEncKeyProvider KP WITH(READUNCOMMITTED), #lt_SecAssocEntities SEC
			WHERE	(@i_keyProviderId = 0 OR KeyProviderId = @i_keyProviderId)
					AND (@i_providerType = 0 OR KeyProviderType = @i_providerType)
					AND KP.KeyProviderId = SEC.entityId
			FOR XML PATH ('keyProviders'), ROOT ('App_GetEncKeyProvidersResp')
		)
	END
	ELSE
	BEGIN
		SET @o_keyProvidersXml =
		(
			SELECT	KP.KeyProviderType AS '@keyProviderType',
					KP.KeyProviderId AS 'provider/@keyProviderId',
					KP.KeyProviderName AS 'provider/@keyProviderName'
			FROM	ArchEncKeyProvider KP WITH(READUNCOMMITTED), #lt_SecAssocEntities SEC
			WHERE	(@i_keyProviderId = 0 OR KeyProviderId = @i_keyProviderId)
					AND (@i_providerType = 0 OR KeyProviderType = @i_providerType)
					AND KP.KeyProviderId = SEC.entityId
			FOR XML PATH ('keyProviders'), ROOT ('App_GetEncKeyProvidersResp')
		)
	END
	SELECT @o_keyProvidersXml
	IF OBJECT_ID ('tempdb..#lt_AssocEntities') IS NOT NULL DROP TABLE #lt_AssocEntities
	IF OBJECT_ID('tempdb..#lt_SecAssocEntities') IS NOT NULL DROP TABLE #lt_SecAssocEntities
END

IF EXISTS (select * from GxQscripts where name = 'archGetEncKeyProvider')
	delete from GxQscripts where name = 'archGetEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archGetEncKeyProvider'
GO

insert into GXDBVersions values(2, 'archGetEncKeyProvider',  '00010001000200070000', 'archGetEncKeyProvider', '00010001000200070000')
GO

