

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetDependentMediaForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------------------------------------------------------------------
--
-- This stored procedure returns dependent media.
-- Change: Optimized 19 July 2013
--
-- ------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetDependentMediaForAuxCopy <<<'

IF EXISTS (select * from sysobjects where name='archGetDependentMediaForAuxCopy')
	drop procedure archGetDependentMediaForAuxCopy
IF EXISTS (select * from GxQscripts where name='archGetDependentMediaForAuxCopy')
	delete from GxQscripts where name = 'archGetDependentMediaForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDependentMediaForAuxCopy')
	delete from GXDBVersions where aliasname = 'archGetDependentMediaForAuxCopy'
GO
print '... Creating Procedure: archGetDependentMediaForAuxCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetDependentMediaForAuxCopy
  @inVolumeIdList VARCHAR(MAX),
  @i_adminJobId INT,
  @i_destCopyId INT,
  @i_srcStream INT,
  @i_destStream INT
AS
  DECLARE @o_bucketId INT;
  DECLARE @o_VolumeId INT;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Create the input and result tables to run archMediaRefreshGetDependentMedia.
IF object_id('tempdb.dbo.#InVolumeList') IS NOT NULL DROP TABLE #InVolumeList
CREATE TABLE #InVolumeList(VolumeId INT)
IF object_id('tempdb.dbo.#VolumeGroups') IS NOT NULL DROP TABLE #VolumeGroups
CREATE TABLE #VolumeGroups (BucketId INT, VolumeId INT)
IF object_id('tempdb.dbo.#TmpVolume') IS NOT NULL DROP TABLE #TmpVolume
CREATE TABLE #TmpVolume (VolumeId INT)
IF object_id('tempdb.dbo.#TmpBucketIds') IS NOT NULL DROP TABLE #TmpBucketIds
CREATE TABLE #TmpBucketIds (BucketId INT)
IF object_id('tempdb.dbo.#TmparchChunkToCopy') IS NOT NULL DROP TABLE #TmparchChunkToCopy
CREATE TABLE #TmparchChunkToCopy(commCellId INT, archFileId INT,VolumeId INT)
CREATE INDEX TmparchChunkToCopy_Idx1 ON #TmparchChunkToCopy (commCellId, archFileId, volumeId)
CREATE INDEX TmparchChunkToCopy_Idx2 ON #TmparchChunkToCopy (volumeId)
CREATE INDEX TmparchChunkToCopy_Idx3 ON #TmparchChunkToCopy (archFileId)
CREATE INDEX VolumeGroups_Idx1 ON #VolumeGroups( VolumeId, BucketId)
CREATE INDEX VolumeGroups_Idx2 ON #VolumeGroups( VolumeId)
DECLARE @tmpAFID INT
DECLARE @tmpCommcellId INT
DECLARE @tmpNextBucketId INT
DECLARE @tmpMinBucketId INT
SET @tmpNextBucketId  = 1
INSERT INTO #InVolumeList
SELECT CONVERT(INT,T._ID)
FROM	dbo.SplitIDs(@inVolumeIdList) T
INSERT INTO #TmparchChunkToCopy
SELECT  DISTINCT commCellId, archFileId, ACC.volumeId
FROM	archChunkToCopy ACC WITH (NOLOCK), #InVolumeList T
WHERE	ACC.VolumeId = T.VolumeId
		AND adminJobId	= @i_adminJobId
		AND destCopyId	= @i_destCopyId
		AND streamNum	= @i_srcStream
		AND destStream	= @i_destStream
DECLARE GrpVolumesForSpannedMediaCur CURSOR FAST_FORWARD FOR
SELECT commCellId, archFileId
FROM	#TmparchChunkToCopy
GROUP BY commCellId, archFileId
ORDER BY COUNT(DISTINCT(volumeId)) DESC
OPEN GrpVolumesForSpannedMediaCur
FETCH NEXT FROM GrpVolumesForSpannedMediaCur  INTO @tmpCommcellId , @tmpAFID
WHILE @@FETCH_STATUS = 0
BEGIN
	TRUNCATE TABLE #TmpVolume
	INSERT INTO #TmpVolume
	SELECT  DISTINCT VolumeId
	FROM	#TmparchChunkToCopy
	WHERE	CommCellId = @tmpCommcellId AND archFileId = @tmpAFID
	TRUNCATE TABLE #TmpBucketIds
	INSERT INTO #TmpBucketIds
	SELECT  DISTINCT VG.BucketId
	FROM	#VolumeGroups VG,#TmpVolume V
	WHERE	VG.VolumeId = V.VolumeId
	IF NOT EXISTS (SELECT * FROM #TmpBucketIds)
	BEGIN
		INSERT INTO #VolumeGroups
		SELECT  @tmpNextBucketId,VolumeId
		FROM	#TmpVolume
		SET @tmpNextBucketId  = @tmpNextBucketId + 1
	END
	ELSE
	BEGIN
		-- if we got multiple bucket ids it means that these are same. Update all rows of these bucketIds with MIN bucketid
		SELECT @tmpMinBucketId  = MIN(BucketId) FROM #TmpBucketIds
		IF ( (SELECT COUNT(*) FROM #TmpBucketIds) > 1)
		BEGIN
			UPDATE #VolumeGroups  SET BucketId = @tmpMinBucketId
			FROM  #TmpBucketIds T
			WHERE	#VolumeGroups.BucketId = T.BucketId
		END
		INSERT INTO #VolumeGroups
		SELECT  @tmpMinBucketId,T.VolumeId
		FROM	#TmpVolume T
		LEFT OUTER JOIN #VolumeGroups VG
			ON VG.VolumeID = T.VolumeId
		WHERE	VG.VolumeID IS NULL
	END
	FETCH NEXT FROM GrpVolumesForSpannedMediaCur  INTO @tmpCommcellId , @tmpAFID
END
CLOSE		GrpVolumesForSpannedMediaCur
DEALLOCATE	GrpVolumesForSpannedMediaCur
SELECT  DISTINCT BucketId, VolumeID
FROM	#VolumeGroups
ORDER BY BucketId,VolumeId
IF object_id('tempdb.dbo.#InVolumeList') IS NOT NULL DROP TABLE #InVolumeList
IF object_id('tempdb.dbo.#VolumeGroups') IS NOT NULL DROP TABLE #VolumeGroups
IF object_id('tempdb.dbo.#TmpVolume') IS NOT NULL DROP TABLE #TmpVolume
IF object_id('tempdb.dbo.#TmpBucketIds') IS NOT NULL DROP TABLE #TmpBucketIds
IF object_id('tempdb.dbo.#TmparchChunkToCopy') IS NOT NULL DROP TABLE #TmparchChunkToCopy
GO

IF EXISTS (select * from GxQscripts where name = 'archGetDependentMediaForAuxCopy')
	delete from GxQscripts where name = 'archGetDependentMediaForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDependentMediaForAuxCopy')
	delete from GXDBVersions where aliasname = 'archGetDependentMediaForAuxCopy'
GO

insert into GXDBVersions values(2, 'archGetDependentMediaForAuxCopy',  '00000000000000000000', 'archGetDependentMediaForAuxCopy', '00000000000000000000')
GO

