

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetDataPathsForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetDataPathsForCopy.sp,v $ $Id: archGetDataPathsForCopy.sp,v 1.1.2.10 2020/08/27 18:13:31 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetDataPathsForCopy')
BEGIN
	print '>>> Drop Stored Procedure: archGetDataPathsForCopy <<<'
	drop procedure archGetDataPathsForCopy
END
IF EXISTS (select * from GxQscripts where name='archGetDataPathsForCopy')
	delete from GxQscripts where name = 'archGetDataPathsForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDataPathsForCopy')
	delete from GXDBVersions where aliasname = 'archGetDataPathsForCopy'
GO
print '... Creating Procedure: archGetDataPathsForCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetDataPathsForCopy
  @archGroupCopyId integer,
  @defDrivePoolId integer,
  @selectmode integer,
  @archGroupId integer,
  @archGroupTypeId integer,
  @showMAsForLibrary integer,
  @showDrivePoolsForMA integer,
  @showMagDrivePoolsForSilo integer
AS
-- archGroupId is used to determine if only NAS datapaths should be shown, or if Centera Mountpaths should be excluded.
-- archGroupTypeId only needs to be passed in if this is a storage policy creation and no archGroup exists yet,
-- otherwise this is just determined from the archGroupId or CopyId.
-- pass in 0 for a new copy that is to be created, else pass in the copyid.
-- Selectmode: 0 = show everything
--	       1 = show only datapaths, whose index cache matches exactly that of the drive pool given (round robin)
--	       2 = show only datapaths, whose index cache matches exactly that of the drivepool given - but also show
--		   datapaths whose index cache is different, but where another datapath for that library does have the
--		   same index cache.
--	 modifier flags for select mode:
--	     128 = enable restrict mode (take archGroupId, showMAsForLibrary, showDrivePoolsForMA into account) -if off, ignore
--	     		256  = (restrict mode flag) display libraries as output result
--	     		512  = (restrict mode flag) display MAs as output result
--	    		1024 = (restrict mode flag) display drivepools as output result (will automatically turn on above 2)
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_ENABLE                 128
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_SHOW_LIBRARIES         256
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_SHOW_MAS               512
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_SHOW_DRIVEPOOLS   1024
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_NO_NDMP              2048
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_SILO_DATAPATH        4096
--	 #define FAILOVER_CANDIDATE_RESTRICT_FLAG_REPLICATIONPATH			 8192
--4096 = return data path for silo, no magnetic datapath should be returned.
-- the datapathid returned gives an id if configured for a given storage policy copy and -1 if not configured.
-- Note: if no storage policy copy is specified, -1 is always returned.
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @dataPathId integer
  DECLARE @drivePoolId integer
  DECLARE @drivePoolName NVARCHAR(255)
  DECLARE @drivePoolType integer
  DECLARE @mountPathTypeId integer
  DECLARE @drivePoolNumDrives integer
  DECLARE @mediaAgentId integer
  DECLARE @mediaAgentName char(255)
  DECLARE @mediaAgentReleaseId integer
  DECLARE @libraryId integer
  DECLARE @libraryName char(255)
  DECLARE @libraryTypeId integer
  DECLARE @libraryAliasName NVARCHAR(255)
  DECLARE @libraryAttribute integer
  DECLARE @spareGroupId integer
  DECLARE @spareGroupName NVARCHAR(255)
  DECLARE @indexCacheId integer
  DECLARE @indexCacheName NVARCHAR(255)
  DECLARE @DPChunkSizeMB integer
  DECLARE @DPBlockSizeKB integer
  DECLARE @HWCompressionPossible integer
  DECLARE @clientId integer
  DECLARE @HWEncryptionPossible integer
  DECLARE @DeviceTypeId integer
	-- Handle input variables
	declare @i_copyId									integer
	declare	@i_defaultDrivePoolId			integer
	declare @i_selectmode							integer
	declare @i_archGroupId						integer
	declare @i_archGroupTypeId				integer
	declare @i_showMAsForLibrary			integer
	declare @i_showDrivePoolsForMA		integer
	declare @i_showMagDrivePoolsForSilo		integer
	declare @l_showOnlyMagLibs				integer
	set @i_copyId 					= @archGroupCopyId
	set @i_defaultDrivePoolId		= @defDrivePoolId
	set @i_selectmode				= @selectmode
	set @i_archGroupId 				= @archGroupId
	set @i_archGroupTypeId			= @archGroupTypeId
	set @i_showMAsForLibrary		= @showMAsForLibrary
	set @i_showDrivePoolsForMA		= @showDrivePoolsForMA
	set @i_showMagDrivePoolsForSilo	= @showMagDrivePoolsForSilo
	-- declare local variables
	declare @MOUNT_PATH_MAGNETIC		integer
	declare @MOUNT_PATH_CENTERA			integer
	declare @MOUNT_PATH_DYNAMIC_SHARED	integer
	declare @MOUNT_PATH_TAPE			integer
	declare @MOUNT_PATH_SHARED_STATIC	integer
	declare @MOUNT_PATH_SHARED_REPLICA	integer
	declare @MOUNT_PATH_DRU				integer
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST	integer
	set @MOUNT_PATH_MAGNETIC			=	0
	set @MOUNT_PATH_CENTERA				=	1
	set @MOUNT_PATH_DYNAMIC_SHARED		=	2
	set @MOUNT_PATH_TAPE				=	3
	set @MOUNT_PATH_SHARED_STATIC		=	4
	set @MOUNT_PATH_SHARED_REPLICA		=	5
	set @MOUNT_PATH_DRU					=	6
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST	=	7
	declare @l_defaultClientId	integer
	declare @l_IdxCacheId		integer
	declare @l_sidb_enabled		integer = 0
	declare @l_restrictEnabled	integer
	declare @l_siloDataPath		integer
	declare @l_selectModeFlags	integer
	declare @l_archGroupType		integer = @i_archGroupTypeId
	declare @l_extendedCopyFlags	bigint = 0
	DECLARE @l_archGroupId		INTEGER = @i_archGroupId
	DECLARE @l_dedupeFlags	INTEGER = 0
	DECLARE @l_copyEncType	INTEGER = 0
    DECLARE @l_destMediaCopyId INTEGER = 0
	DECLARE @l_globalPolicyCopyId	INTEGER = 0
	IF (@i_copyId > 0)
	BEGIN
		SELECT @l_archGroupId  = archGroupId, @l_dedupeFlags = dedupeFlags, @l_extendedCopyFlags = extendedFlags, @l_copyEncType = encType, @l_destMediaCopyId = destMediaCopyId
		FROM archGroupCopy WITH(READUNCOMMITTED) WHERE id = @i_copyId
set @l_sidb_enabled = (@l_dedupeFlags & 262144)
IF (@l_dedupeFlags & 134217728) > 0 OR (@l_extendedCopyFlags & (2 | 8192)) > 0
		BEGIN
			SELECT  @l_globalPolicyCopyId = GC.defaultCopy
			FROM    archGroupCopy DC WITH(READUNCOMMITTED)
			INNER JOIN archCopyToGlobalPolicy DC2GC WITH(READUNCOMMITTED) ON DC.id = DC2GC.copyId
			INNER JOIN archGroup GC WITH(READUNCOMMITTED)
			ON GC.id = DC2GC.globalPolicyId
   	        WHERE	DC.id = @i_copyId
		END
	END
	-- set to show both NAS and non NAS DP... rest can be done later
	declare @l_showNonNasDP	integer
	declare @l_showNasDP		integer
	declare @l_showCentera	integer
    declare @showHiddenLibConfig integer = 0
	set @l_showNonNasDP = 1
	set @l_showNasDP = 1
	set @l_showCentera = 1
	SET @l_showOnlyMagLibs = 0
	declare @l_selectRelease10 integer
	set @l_selectRelease10 = 0
	-- figure out if restrict mode is on ( meaning to restrict the result to certain Libraries or MAs)
	set @l_restrictEnabled = 	CASE
						WHEN (@i_selectmode & 128) > 0 THEN 1
						ELSE 0
					END
	-- initialize variables we need if restricted mode is on
	if (@i_selectmode & 8192) > 0
	BEGIN
		SET @l_showOnlyMagLibs = 1
		-- replication datapath option - we should show only maglibs.
	END
    -------------------------------------------------
	-- Get 'MMCONFIG_SHOW_HIDDEN_LIBRARIES' value from MMConfigs
	-------------------------------------------------
	SELECT @showHiddenLibConfig = value
	FROM    MMConfigs WITH (NOLOCK)
	WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_LIBRARIES'
	if (@i_selectmode & 4096) > 0
	begin
		set @l_siloDataPath = 1
		set @l_restrictEnabled = 0
		set @l_selectModeFlags = 1792 + (@i_selectmode & 4096)
		-- SILO: Return data path from all media agents, not only the one used by the copy
		-- set @i_archGroupId 				= 0
		set @i_copyId 					= 0
		--set @i_defaultDrivePoolId		= 0
		set @i_showMAsForLibrary		= 0
		set @i_showDrivePoolsForMA		= 0
		set	@l_sidb_enabled = 0
	end
	else
	if (@i_selectmode & 8192) > 0
	begin
		set @l_restrictEnabled = 0
		set @l_selectModeFlags = 1792 + (@i_selectmode & 8192)
		-- DDR: Return data path from all media agents, not only the one used by the copy
		set @i_archGroupId 				= 0
		set @i_copyId 					= 0
		set @i_defaultDrivePoolId		= 0
		set @i_showMAsForLibrary		= 0
		set @i_showDrivePoolsForMA		= 0
	end
	else
	if (@l_restrictEnabled = 1)
	begin
		set @l_selectModeFlags = @i_selectmode & 3840
		-- 3840 = 256 + 512 + 1024 + 2048
		-- automatically set Libraries and MA flag when Drivepool flag is set
		if ((@l_selectModeFlags & 1024) > 0)
		begin
			set @l_selectModeFlags = @l_selectModeFlags | 768
		end
	end
	else
	begin
		set @l_selectModeFlags = 1792 + (@i_selectmode & 2048)
		-- 1792 = 256 + 512 + 1024
		-- 2048 = filter out NAS drivepools
	end
	-- get the actual select mode from the lower 7 bits
	set @i_selectmode = @i_selectmode & 127
	-- get default DP MA if there is such a thing
	if (@i_defaultDrivePoolId = 0)
	begin
		set @l_defaultClientId = 0
	end else
	begin
		-- a specific drive pool to use was specified, get the default MA from that, this will work for NAS too
		set @l_defaultClientId = isnull((select ClientId from MMDrivePool WHERE DrivePoolId = @i_defaultDrivePoolId), 0)
	end
-- based on emails exchanged with Duncan on 5/21/2007 - we need the following logic
-- if a default datapath drivepool is not supplied (because we are adding the first datapath of the copy) then the logic goes as follows:
--     - If this is the default copy: Allow NAS and Non-NAS
--     - If this is not the default copy: base decision on whether to allow NAS on source copys default datapath drivepool type  if it is NAS, allow both NAS and non-NAS, else just allow non-NAS.
-- If a default datapath is supplied then
--     - If it is NAS, allow only NAS.
--     - If it is non-NAS, allow only non-NAS
	DECLARE @l_decisionDrivepool INTEGER
	IF (@i_defaultDrivePoolId > 0)
	BEGIN
		-- we are changing the default copy's datapath, so base decisions on this.
		set @l_decisionDrivepool = @i_defaultDrivePoolId
	END ELSE
	BEGIN
		-- no default drivepool supplied - this must be the first
		-- drivepool for a copy
		DECLARE @l_defCopyId INTEGER
		SELECT @l_defCopyId = defaultcopy
		FROM archgroup
		WHERE id = @l_archGroupId
		IF ((@i_copyId > 0) AND (@l_defCopyId <> @i_copyId)) OR (@i_copyId = 0)
		BEGIN
			-- This is not the default copy we are trying to
			-- add the first datapath for.
			-- base the decision on the source copy.
			DECLARE @l_srcCopyId INTEGER
			IF (@i_copyId > 0)
			BEGIN
			    SELECT @l_srcCopyId = sourceCopyId
			    FROM ArchGroupCopy
			    WHERE id = @i_copyId
			--	MR: 92122 if we deconfigured the library and then add new data path to same copy which had previous library
			-- then we have to check the Drivepool type of destination copy for this source copy.
			-- otherwise we end up in scenario where destination copy has NAS attached library and source as MA attached library.
				IF EXISTS (SELECT * FROM archgroupcopy AGC, MMDataPath MMDP, MMDrivepool MMD
					WHERE MMDP.CopyId = AGC.id
					AND MMDP.DrivePoolId = MMD.DrivePoolId
					AND AGC.archGroupId = @l_archGroupId
					AND AGC.sourceCopyId = @i_copyId
					AND MMD.DrivePoolType = 3)
				SET @l_showNonNasDP = 0
			END
			-- @i_copyId  would be 0 for a new secondary copy
			IF ((0 = @l_srcCopyId) OR (@l_srcCopyId is null))
			BEGIN
				SET @l_srcCopyId = @l_defCopyId
			END
			SET  @l_decisionDrivepool =
			( 	SELECT TOP 1 drivePoolId
			  	FROM	MMDataPath as DPath
				WHERE copyid = @l_srcCopyId
				ORDER BY (Flag & 1) desc
			)
		END
		--if it is the default copy and its CCM migrated NAS copy: Allow only NAS
		ELSE IF EXISTS(select 1 from archGroupCopy where id = @l_defCopyId
											AND flags & 536870912 <> 0 ) --CVA_USES_DIRECT_ATTACHED_NAS_DRIVEPOOL
		BEGIN
				set @l_showNonNasDP = 0
		END
		--	MR: 92122 if we deconfigured the library added to default copy and then add new data path to default copy
		--  then we have to check the Drivepool type of destination.
		-- otherwise we end up in scenario where destination copy has NAS and source has MA.
		ELSE IF ((@i_copyId > 0) AND (@l_defCopyId = @i_copyId))
		BEGIN
			IF EXISTS (SELECT * FROM archgroupcopy AGC, MMDataPath MMDP, MMDrivepool MMD
			WHERE MMDP.CopyId = AGC.id
			AND MMDP.DrivePoolId = MMD.DrivePoolId
			AND AGC.archGroupId = @l_archGroupId
			AND AGC.sourceCopyId = 0
			AND MMD.DrivePoolType = 3)
			SET @l_showNonNasDP = 0
		END
		-- else if it is the default copy, leave the decision drivepool NULL
	END
	-- if we got the drivepool of the decision drivepool, then let's make the decision
	IF (@l_decisionDrivepool is not null)
	BEGIN
		IF ((SELECT drivePoolType FROM MMDrivePool WHERE DrivePoolId = @l_decisionDrivepool) <> 3)
		BEGIN
			set @l_showNasDP = 0
		END ELSE
		BEGIN
			-- we have a NAS drivepool in the decision drivepool. This means to
			-- show non-NAS drivepools, which is already defaulted to 1.
			-- but if this is NOT the first datapath in the copy, we should NOT show
			-- non-NAS drivepools (only NAS drivepools should be shown).
			-- Not the first Datapath means a default drivepool must have been passed in.
			IF (@i_defaultDrivePoolId > 0)
			BEGIN
			   set @l_showNonNasDP = 0
			END
		END
	END
	-- If we had some kind of logic error, or this is the default copy and no default drivepool
	-- was passed in, @l_decisionDrivepool would be null and we will show NAS datapaths in addition
	-- to Non-NAS (a good fall back better show too many than too few)
	-- NEXT STEP
	-- filter datapath types based on storage policy type
	-- do not allow NAS or Centera drivepools if archive group type is ER
	-- do not allow NAS if Data Migrator
	-- get archive group type if we do not have it
	IF ((@l_archGroupId > 0) AND (@l_archGroupType = 0))
	BEGIN
			SET @l_archGroupType  = (SELECT type FROM archGroup WHERE id = @l_archGroupId)
	END
	IF (@l_archGroupType = 2) OR
		-- 2 is Disaster Recovery
		 (
		 		( @l_archGroupId  > 0) and
				(  exists (SELECT id FROM APP_Application WHERE apptypeId = 1000 AND dataArchGrpId = @l_archGroupId ) )
		 )
	BEGIN
			--set @l_showNasDP = 0
			set @l_showCentera = 0
	END
	IF (@l_archGroupType = 3)
	-- 3 is Data Migrator - do not allow NAS datapaths
	BEGIN
			set @l_showNasDP = 0
	END
	-- get index cache to check against
	if (@i_selectmode = 0)
	BEGIN
	  	set @l_IdxCacheId = 0
	END ELSE IF @i_copyId > 0
                AND EXISTS(SELECT * from MMConfigs WHERE name = 'MMS2_CONFIG_DATAPATH_NOT_SHARING_INDEX_CACHE' AND value > 0)
				AND NOT EXISTS (select * from MMDataPath a, APP_Client b where a.HostClientId = b.id and b.releaseId < 15 and a.copyId = @i_copyId)
	BEGIN
		set @l_IdxCacheId = 0
		set @l_selectRelease10 = 1
	END ELSE
	BEGIN
		set @l_IdxCacheId = isNull
		(
			(
				select IdxAccessPath.IdxCacheId
				from IdxAccessPath INNER JOIN IdxCache ON IdxCache.IdxCacheId = IdxAccessPath.IdxCacheId and IdxCache.IdxCacheType = 1
				where IdxAccessPath.ClientId = @l_defaultClientId
			 ), 0
		)
	END
	IF object_id('tempdb.dbo.#tmpFailOverCandidates') IS NOT NULL DROP TABLE #tmpFailOverCandidates
	create table #tmpFailOverCandidates(
						DataPathId		integer,
						DrivePoolId 		integer,
						DrivePoolType		integer,
						MountPathTypeId	integer,
						DrivePoolName		nvarchar(255),
	        	MAClientId		integer,
	-- difference between MAClientId and displayClientId:
		-- for NAS, the displayClientId is not the MA name which handles Indexing, but the clientId of the filer
						displayClientId		integer,
						net_hostName		varchar(255),
	        	LibraryId		integer,
						SpareGroupId		integer,
						SpareGroupName		nvarchar(255),
						IdxCacheId		integer,
						DPChunkSizeMB		integer,
						DPFlushBlockSizeKB	integer,
						HWCompressionPossible	integer,
						HWEncryptionPossible	integer	)
	-- insert non-magnetic drive types
		-- drive pool types: 0 = invalid, 1 = regular, 2 = san, 3 = NAS
IF (@l_showOnlyMagLibs = 0)
BEGIN
	insert into #tmpFailOverCandidates
	select distinct -1, dp.drivepoolid,dp.DrivepoolType, 0, dp.DrivePoolName, dp.ClientId, dp.ClientId, '', mmp.libraryId,
	SpareGroupId = msg.SpareGroupId, msg.SpareGroupName, 0, 0, 0, 1, 1
	from MMDrivePool as dp, MMMasterPool as mmp,
	MMLibrary as ml, MMSpareGroup as msg
	where dp.MasterpoolId = mmp.MasterPoolId and
	mmp.libraryId = ml.LibraryId and ml.LibraryId != 0 and
	msg.LibraryId = ml.LibraryId and msg.SpareGroupType in(1, 2) and
	-- show MAs for particular Library restriction
	(	(@l_restrictEnabled = 0) OR
		(@l_restrictEnabled = 1 AND
			(
				(@i_showMAsForLibrary = 0) or
				(ml.LibraryId = @i_showMAsForLibrary)
			)
		)
	) AND
	(
		-- combination of showNonNAS/ShowNAS (always applies) and
		  -- show drivepools/Libraries for a particular MA or NDMP Host when result restriction is on
		-- non NAS - clientID is dp.clientid
		( dp.drivePoolType in(1, 2) and @l_showNonNasDP = 1 and
			(	@i_showDrivePoolsForMA = 0 OR
				( @l_restrictEnabled = 1 and dp.ClientId = @i_showDrivePoolsForMA )
			)
		) OR
		-- this is NAS -- clientID needs to be checked
		( dp.drivePoolType = 3 and @l_showNasDP = 1 and
			(	@i_showDrivePoolsForMA = 0 OR
				(	@l_restrictEnabled = 1 AND
					@i_showDrivePoolsForMA = (	SELECT 	NDMPH.ClientId
																			FROM 		MMNDMPHostInfo AS NDMPH
																			WHERE 	NDMPH.NDMPHostId = DP.NDMPHostId
																		)
				)
			)
		)
	)
END
	-- now do Magnetic if we are not only showing NAS datapaths. Magnetic libraries are never NAS
	if (@l_showNonNasDP = 1)
	BEGIN
		insert into #tmpFailOverCandidates
		select distinct -1, dp.drivepoolid,dp.DrivepoolType,
		MountPathTypeId = isnull (
								(
		  						select top 1 MP.MountPathTypeId
		  						from MMMedia AS MM, MMMediaSide AS MS, MMMountPath as MP
		  						where MM.libraryid= ml.libraryId AND MS.MediaId = MM.MediaId AND MP.MediaSideId = MS.MediaSideId
		  					), 0),
		dp.DrivePoolName, dp.ClientId, dp.ClientId, '',
		mmp.libraryId, SpareGroupId = 0, 'N/A', 0, 0, 0, 1, 1
		from MMDrivePool as dp, MMMasterPool as mmp, MMLibrary as ml
		where  dp.MasterpoolId = mmp.MasterPoolId and
		mmp.libraryId = ml.LibraryId and ml.LibraryId != 0 and
		(	@l_restrictEnabled = 0 OR
			(
				 @i_showMAsForLibrary = 0 OR
				(@i_showMAsForLibrary <> 0 AND ml.LibraryId = @i_showMAsForLibrary)
			) AND
			(
				@i_showDrivePoolsForMA = 0 OR
				(@i_showDrivePoolsForMA <> 0 AND 	@i_showDrivePoolsForMA = dp.ClientId)
			)
		) AND
		dp.drivePoolType = 10001
		-- we added all types of magnetic libraries. Filter out Centera datapaths if we do not want them
		IF (@l_showCentera = 0)
		BEGIN
			DELETE FROM #tmpFailOverCandidates
			WHERE MountPathTypeId = 1
		END
	END
	-- mode 2 means: same library as default DP
	if ((@i_selectmode = 2) and (@i_defaultDrivePoolId > 0))
	begin
		-- add candidates that share the same libraryId as the default drivepool.
		DECLARE @l_defaultLibId INTEGER
		SET @l_defaultLibId  =
		(
			SELECT LibraryId
			FROM MMDrivePool AS DP, MMMasterPool AS MP
			WHERE DP.DrivePoolId = @i_defaultDrivePoolId  AND
				MP.MasterPoolId = DP.MasterPoolId
		)
		INSERT into #tmpFailOverCandidates
		SELECT distinct -1, dp.drivepoolid,dp.DrivepoolType,
		MountPathTypeId = isnull (
								(
		  						select top 1 MP.MountPathTypeId
		  						from MMMedia AS MM, MMMediaSide AS MS, MMMountPath as MP
		  						where MM.libraryid= ml.libraryId AND MS.MediaId = MM.MediaId AND MP.MediaSideId = MS.MediaSideId
		  					), 0),
		dp.DrivePoolName, dp.ClientId, dp.ClientId, '', mmp.libraryId,
		SpareGroupId	= (Case dp.drivePoolType When 10001 Then 0 Else msg.SpareGroupId End),
		SpareGroupName	= (Case dp.drivePoolType When 10001 Then 'N/A' Else msg.SpareGroupName End),
		0, 0, 0, 1, 1
		FROM MMDrivePool as dp, MMMasterPool as mmp, MMLibrary as ml, MMSpareGroup as msg
		WHERE dp.MasterpoolId = mmp.MasterPoolId and
		mmp.libraryId = ml.LibraryId and ml.LibraryId != 0 and
		ml.LibraryId = @l_defaultLibId and
		(	(@l_restrictEnabled = 0) OR
			(@l_restrictEnabled = 1 AND @i_showMAsForLibrary = 0) OR
			(@l_restrictEnabled = 1 AND @i_showMAsForLibrary <> 0 AND ml.LibraryId = @i_showMAsForLibrary)
		) AND
		(
			-- Non-NAS, also including magnetic
			( dp.drivePoolType in(1, 2, 10001) and @l_showNonNasDP = 1 and
				(	(@l_restrictEnabled = 0) OR
					(@i_showDrivePoolsForMA <> 0 AND @i_showDrivePoolsForMA = dp.ClientId)
				)
			) OR
			-- NAS
			( dp.drivePoolType = 3 and @l_showNasDP = 1 and
				(	(@l_restrictEnabled = 0) OR
					(@i_showDrivePoolsForMA <> 0 AND @i_showDrivePoolsForMA = (	SELECT 	NDMPH.ClientId
																				FROM 	MMNDMPHostInfo AS NDMPH
																				WHERE 	NDMPH.NDMPHostId = DP.NDMPHostId
																				)
																				)
				)
			)
		) and
		((msg.LibraryId = ml.LibraryId and msg.SpareGroupType in(1, 2)) or dp.drivePoolType = 10001)
	end
	-- HW compression not possible Optical (2), Mag (3), StdAln Optical (5)
	update #tmpFailOverCandidates
	set HWCompressionPossible = 0, HWEncryptionPossible = 0
	from MMLibrary as ML, #tmpFailOverCandidates  as tt
	where tt.LibraryId = ML.LibraryId  and LibraryTypeId IN (2,3,5)
	-- for NAS, get the filer name as the MA name (right now the client Id in #tmpFailOverCandidates  is the ProxyMA)
	update #tmpFailOverCandidates
	set 	net_hostname = cc.Name, displayClientId = cc.id
	from MMDrivePool as MDP, MMNDMPHostInfo as mnh, #tmpFailOverCandidates as tt, APP_Client as cc
	where MDP.DrivePoolId = tt.DrivePoolId and mdp.NDMPHostId = mnh.NDMPHostId and cc.id = mnh.ClientId
	and tt.DrivePoolType = 3
	-- for Non-Nas just use what we got above
	update #tmpFailOverCandidates
	set 	net_hostname = cl.Name
	from APP_Client as cl, #tmpFailOverCandidates as tt
	where cl.id = tt.MAClientId and tt.DrivePoolType <> 3
	update #tmpFailOverCandidates
	set #tmpFailOverCandidates.DrivePoolName = 'N/A'
	where #tmpFailOverCandidates.DrivePoolType = 10001
	--Removing Spare Disk Library from list
    DELETE #tmpFailOverCandidates FROM #tmpFailOverCandidates TT, MMLibrary ML
    WHERE TT.LibraryId = ML.LibraryId
    AND (ML.ExtendedAttributes & 8388608) = 8388608        -- MMS2_LIBRARY_EXT_SPARE_DISK_LIBRARY
	-- begin handling of code dealing with shared magnetic libraries
	-- select the usable shared magnetic drive pool with media agent
	declare @replicaDrivePoolWithMA table (DrivePoolId int, MAClientId int, LibraryId int)
	-- find out all the drive pool and media agent combinations,
	-- which media agent have write access to any of the mount paths in that drive pool
	insert into @replicaDrivePoolWithMA
	select distinct tt.DrivePoolId, tt.MAClientId, tt.LibraryId
	from 	#tmpFailOverCandidates as tt,
		MMDeviceController as MDC, MMMountPathToStorageDevice as MP2SD,
		MMMountPath as MP,
		MMMediaSide as MS,
		MMMedia as MM
	where 	tt.DrivePoolType = 10001
	AND	tt.MountPathTypeId in (@MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	-- 2 (like in Unix rwx) is write, so abort if no write permission
	AND (MDC.deviceaccesstype & 2) > 0
	-- joins follow
	AND  MM.LibraryId = tt.LibraryId
	AND  MDC.ClientId = tt.MAClientId
	AND  MDC.DeviceId = MP2SD.DeviceId
	AND  MP2SD.MountPathId = MP.MountPathId
	AND  MP.MediaSideId =  MS.MediaSideId
	AND  MS.MediaId = MM.MediaId
	-- remove any drive pool and media agent from shared magnetic library that
	-- media agent have no write access to any of the mount path (devices) in that drive pool.
	delete #tmpFailOverCandidates
	from #tmpFailOverCandidates tt
	where tt.DrivePoolType = 10001 and tt.MountPathTypeId in (@MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	and not exists (select DrivePoolId from @replicaDrivePoolWithMA
					where DrivePoolId = tt.DrivePoolId
					and   MAClientId = tt.MAClientId
					and   LibraryId = tt.LibraryId)
	-- end shared mag library code
	-- figure out existing datapath IDs for candidates
	-- 1024 means show drivepools
	if ((@i_copyId > 0) AND ((@l_selectModeFlags & 1024) > 0))
	BEGIN
		-- now update the datapath Ids for ones that are already configured
		update #tmpFailOverCandidates
		set 	DataPathId = mcf.DataPathId,
			DPChunkSizeMB = mcf.ChunkSizeMB,
			DPFlushBlockSizeKB = mcf.FlushBlockSizeKB
		from MMDataPath as mcf, #tmpFailOverCandidates as tt
		where mcf.DrivePoolId = tt.DrivePoolId
		  and mcf.SpareGroupId = tt.SpareGroupId
		  and mcf.CopyId = @i_copyId
	END
	-- MR 90808, cliu, Check based on Copy Level Encryption.
	-- If the Media Agent is 6.1 version, and copy has been set to do AuxCopy Encryption,
	-- we cannot select such MA for datapath due to compatibility issue.
	-- SIM_ID_GX_REL70 / 12
	if (@l_copyEncType > 0)
	BEGIN
		delete #tmpFailOverCandidates
		from	#tmpFailOverCandidates as tt, App_Client as cl
		where tt.displayClientId = cl.id and cl.releaseId < 12
	END
if ((@l_extendedCopyFlags & 1) > 0)
	BEGIN
			-- Filter out magnetic data path for copy with global auxcopy policy enabled
-- #define 1			1
			delete from	#tmpFailOverCandidates
			WHERE drivepooltype = 10001
			OR (DataPathId > 0 AND DataPathId In (SELECT DataPathId FROM MMDataPath WHERE CopyId = @i_copyId))
	END
	if (@l_globalPolicyCopyId > 0)
	BEGIN
            -- Filter out the datapaths which do not match the parent global policy's datapath config.
			delete #tmpFailOverCandidates
			from	#tmpFailOverCandidates T
			left outer join MMDataPath MM on T.DrivePoolId = MM.DrivePoolId and T.MAClientId = MM.HostClientId and T.SpareGroupId = MM.SpareGroupId
					and MM.CopyId = @l_globalPolicyCopyId
			WHERE MM.DataPathId is null
	END
	if @l_sidb_enabled > 0
	BEGIN
			-- Filter out tape data path for copy with single instance (de-duplication) enabled
			-- Filter out existing silo data path and replic data path
			-- #define MMS2_SILO_FAILOVER						8
			-- #define MMS2_REPLICATION_DATAPATH				16
			delete from	#tmpFailOverCandidates
			WHERE drivepooltype <> 10001
			OR (DataPathId > 0 AND DataPathId In (SELECT DataPathId FROM MMDataPath WHERE CopyId = @i_copyId AND Flag & (8|16) > 0))
	END
	if @l_siloDataPath > 0
	BEGIN
			-- Filter out magnetic data path and data path on NetWare Media Agent
			delete from	#tmpFailOverCandidates
			WHERE drivepooltype = 10001 and @i_showMagDrivePoolsForSilo = 0
			OR MAClientId in (
				SELECT	cl.Id
				FROM	App_Client as cl, simOperatingSystem O
				WHERE	cl.simOperatingSystemId = O.Id AND
						O.type = 'NetWare'
				)
	END
	-- MR 90273, cliu, Check based on copy single instance property
	-- If the single instance enabled, we cannot select library with hardware single instance
	-- Jun Lu: For a single instanced copy, all data paths should be accessible from all MAs
	-- CVA_SIDB_STORE_ENABLED_FLAG / 262144
	-- MMS2_LIBRARY_SINGLE_INSTANCE_DATA / 268435456
	-- cliu 09/15/2009, check Cloud Storage Library.
	-- If the copy has single instance enabled, we cannot select Cloud Storage library.
	-- MOUNT_PATH_EXTERNAL_REMOTE_HOST / 7 (MountPathTypeId)
	if (@l_sidb_enabled > 0)
	BEGIN
		delete #tmpFailOverCandidates
		from	#tmpFailOverCandidates as tt, MMLibrary as ml
		where (ml.LibraryAttribute & 268435456) > 0 and tt.libraryId = ml.libraryId
		-- Filter out Media Agents that cannot access the libraries in the existing DataPaths
		-- Filter out Libraries that cannot be accessed by the Media Agent in the existing DataPaths.
		DECLARE @currMA table (ClientId int)
		insert into @currMA
		select distinct dp.ClientId
		from	MMDrivePool as dp, MMMasterPool as mp, #tmpFailoverCandidates as tmp
		where	dp.MasterPoolId = mp.MasterPoolId
		and		mp.LibraryId = tmp.LibraryId
		and		tmp.DataPathId > 0
		DECLARE @newMA table (ClientId int, LibraryId int)
		insert into @newMA
		select distinct dp.ClientId, tmp.LibraryId
		from	MMDrivePool as dp, MMMasterPool as mp, #tmpFailoverCandidates as tmp
		where	dp.MasterPoolId = mp.MasterPoolId
		and		mp.LibraryId = tmp.LibraryId
		and		tmp.DataPathId <= 0
		if exists(select 1 from @currMA)
		begin
			delete #tmpFailOverCandidates
			from #tmpFailOverCandidates as tt
			where ( exists (select * from @currMA where clientId not IN (select clientId from @newMA where LibraryId = tt.libraryId))
			or exists (select * from @newMA where clientId not In (select clientId from @currMA) and libraryId = tt.libraryId) )
			and dataPathId < 0
		end
		-- remove following check for 9.0
		---- remove cloud library if copy is silo enabled
		if (@l_dedupeFlags & 2097152 > 0) --CVA_BACKUP_SILO_ENABLED_FLAG
		begin
			delete #tmpFailOverCandidates
			from #tmpFailOverCandidates as tt, MMMountPath as mp
			where tt.libraryId = mp.libraryId and mp.MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST
		end
	END
	-- When display drivepool as output, we also need to check the compatibility between drivepool and sparegroup.
	-- This situation only happens in mix drive library. Therefore, the drive of given default drivepool should
	-- always support the default media type of the spare group.
	if ((@l_selectModeFlags & 1024 ) > 0)
	BEGIN
		delete #tmpFailOverCandidates
		from #tmpFailOverCandidates as tmp,
				(
					select DISTINCT a.drivePoolId as drivePoolId, a.spareGroupId as spareGroupId
					from  (
									select DISTINCT tt.DrivePoolId as drivePoolId, md.DriveTypeId as driveTypeId,
												tt.SpareGroupId as spareGroupId, msg.MediaTypeId as mediaTypeId
									from	#tmpFailOverCandidates as tt, MMDrive as md, MMDrivePool as mdp, MMSpareGroup as msg
									where tt.DrivePoolId = mdp.DrivePoolId
									and		mdp.MasterPoolId = md.MasterPoolId
									and		tt.SpareGroupId = msg.SpareGroupId
									and		tt.SpareGroupId > 0
									and		msg.SpareGroupType <> 2
								 ) a
								LEFT JOIN MMRecFmtMedTyp as rfmt
								ON a.driveTypeId = rfmt.DriveTypeId and a.mediaTypeId = rfmt.MediaTypeId
					where rfmt.RecordingFormatId is NULL
				) b
		where tmp.DrivePoolId = b.drivePoolId and tmp.SpareGroupId = b.spareGroupId
	END
	if (@l_selectRelease10 > 0)
	BEGIN
		delete #tmpFailOverCandidates
		from	#tmpFailOverCandidates as tt, App_Client as cl, MMDrivePool as mdp
		where mdp.clientId = cl.id and cl.releaseId < 15 and tt.DrivePoolId = mdp.DrivePoolId
	END
	-- Get all the drive pool and its devices
	DECLARE @tblDriveDevice TABLE (DrivePoolId INT, DeviceTypeId INT)
	 --INSERT only Drive pools which are configured with current CS
	INSERT INTO @tblDriveDevice
	SELECT DISTINCT DPO.DrivePoolId, DC.DisplayDeviceTypeId
	FROM MMDrivePool DPO,
		MMMasterPool MPO,
		MMDevice DC,
		MMDeviceController as MDC,
		MMMountPathToStorageDevice as MP2SD,
		MMMountPath as MP
	WHERE DPO.MasterPoolId = MPO.MasterPoolId
	AND DPO.ClientId = MDC.ClientId
	AND  MP.LibraryId = MPO.LibraryId
	AND  MDC.DeviceId = DC.DeviceId
	AND  MDC.DeviceId = MP2SD.DeviceId
	AND  MP2SD.MountPathId = MP.MountPathId
	AND  DC.origCCId IN (0,2)
	--INSERT remaining Drive pools which are with CCM case
	INSERT INTO @tblDriveDevice
	SELECT DISTINCT DPO.DrivePoolId, DC.DisplayDeviceTypeId
	FROM MMDrivePool DPO,
		MMMasterPool MPO,
		MMDevice DC,
		MMDeviceController as MDC,
		MMMountPathToStorageDevice as MP2SD,
		MMMountPath as MP
	WHERE DPO.MasterPoolId = MPO.MasterPoolId
	AND DPO.ClientId = MDC.ClientId
	AND  MP.LibraryId = MPO.LibraryId
	AND  MDC.DeviceId = DC.DeviceId
	AND  MDC.DeviceId = MP2SD.DeviceId
	AND  MP2SD.MountPathId = MP.MountPathId
	AND  DPO.DrivePoolId NOT IN(select DrivePoolId from @tblDriveDevice)
    -- End for getting all the drive pool and its devices
	-- Now select data
	select distinct
          dataPathId							=   case when (@l_selectModeFlags & 1024) > 0 then tt.DataPathId else 0 end,
          drivePoolId		        	=   case when (@l_selectModeFlags & 1024) > 0 then tt.DrivePoolId else 0 end,
          drivePoolName  					=   case when (@l_selectModeFlags & 1024) > 0 then tt.DrivePoolName else '' end,
          drivePoolType		        =   case when (@l_selectModeFlags & 1024) > 0 then mdp.DrivePoolType else 0 end,
          mountPathTypeId         =   case when (@l_selectModeFlags & 1024) > 0 then tt.mountPathTypeId  else 0 end,
         	drivePoolNumDrives			=   case when (@l_selectModeFlags & 1024) > 0 then (select count (*) from MMDriveController where drivePoolId = tt.DrivePoolId) else 0 end,
          mediaAgentId		        =   tt.displayClientId,
          mediaAgentName			=   tt.net_hostName,
          mediaAgentReleaseId	    =   cl.releaseId,
          libraryId		        		=   case when (@l_selectModeFlags &  256) > 0 then tt.LibraryId else 0 end,
          libraryName		        	=   case when (@l_selectModeFlags &  256) > 0 then ml.LibraryName else '' end,
          libraryTypeId						=		case when (@l_selectModeFlags &  256) > 0 then ml.LibraryTypeId else 0 end,
          libraryAliasName	      =   case when (@l_selectModeFlags &  256) > 0 then ml.AliasName else '' end,
          libraryAttribute				=   case when (@l_selectModeFlags &  256) > 0 then ml.LibraryAttribute else 0 end,
          spareGroupId		        =   case when (@l_selectModeFlags &  1024) > 0 then tt.SpareGroupId else 0 end,
          spareGroupName					=   case when (@l_selectModeFlags &  1024) > 0 then isnull(tt.SpareGroupName, 'N/A') else '' end,
          tt.IdxCacheId,
          '',
          DPChunkSizeMB		        =   case when (@l_selectModeFlags & 1024) > 0 then tt.DPChunkSizeMB else 0 end,
          DPBlockSizeKB		        =   case when (@l_selectModeFlags & 1024) > 0 then tt.DPFlushBlockSizeKB else 0 end,
          HWCompressionPossible	  =   case when (@l_selectModeFlags &  256) > 0 then tt.HWCompressionPossible else 0 end,
          clientId					=	case when (@l_selectModeFlags & 1024) > 0 then mdp.clientId else 0 end,
          HWEncryptionPossible	  =   case when (@l_selectModeFlags &  256) > 0 then tt.HWEncryptionPossible else 0 end,
		  DeviceTypeId = isnull((select TOP 1 DeviceTypeId from @tblDriveDevice where drivePoolId = tt.DrivePoolId), 0)
	from 	#tmpFailOverCandidates as tt, MMDrivePool as mdp,
		MMLibrary as ml, App_Client as cl
	where tt.DrivePoolId = mdp.DrivePoolId
AND  tt.LibraryId = ml.LibraryId AND ( (@showHiddenLibConfig = 1) OR (ml.ExtendedAttributes & 33554432 = 0) )
	AND  tt.displayClientId = cl.id
AND ml.LibraryTypeId <> 10
	order by libraryAliasName ASC, mediaAgentName ASC, drivePoolId ASC
	drop table #tmpFailOverCandidates
GO

IF EXISTS (select * from GxQscripts where name = 'archGetDataPathsForCopy')
	delete from GxQscripts where name = 'archGetDataPathsForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDataPathsForCopy')
	delete from GXDBVersions where aliasname = 'archGetDataPathsForCopy'
GO

insert into GXDBVersions values(2, 'archGetDataPathsForCopy',  '00010001000200100000', 'archGetDataPathsForCopy', '00010001000200100000')
GO

