

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetDFMStorageServiceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetDFMStorageServiceInfo.sp,v $ $Id: archGetDFMStorageServiceInfo.sp,v 1.2.52.1 2018/03/20 19:50:02 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetDFMStorageServiceInfo <<<'

IF EXISTS (select * from sysobjects where name='archGetDFMStorageServiceInfo')
	drop procedure archGetDFMStorageServiceInfo
IF EXISTS (select * from GxQscripts where name='archGetDFMStorageServiceInfo')
	delete from GxQscripts where name = 'archGetDFMStorageServiceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDFMStorageServiceInfo')
	delete from GXDBVersions where aliasname = 'archGetDFMStorageServiceInfo'
GO
print '... Creating Procedure: archGetDFMStorageServiceInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetDFMStorageServiceInfo
  @i_ArchCopyId INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @o_ControlHostId INTEGER;
  DECLARE @o_ExtRelationIdInt INTEGER;
  DECLARE @o_ExtRelationId NVARCHAR(512);
  DECLARE @o_ExtNodeIdInt INTEGER;
  DECLARE @o_ExtNodeId NVARCHAR(512);
  DECLARE @o_NumOfNodes INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @errCode INTEGER
DECLARE @rowCount INTEGER
SET @errCode = 0
DECLARE @outputTable TABLE (
  retVal INTEGER,
  ControlHostId INTEGER,
  ExtRelationIdInt INTEGER,
  ExtRelationId NVARCHAR(512),
  ExtNodeIdInt INTEGER,
  ExtNodeId NVARCHAR(512),
  NumOfNodes INTEGER
)
INSERT INTO @outputTable
SELECT	0,
		CRM.ControlHostId AS ControlHostId,
		(CASE WHEN ISNUMERIC(R.ExtRelationId) = 1 THEN CAST(R.ExtRelationId AS INTEGER) ELSE 0 END) AS ExtRelationIdInt,
		R.ExtRelationId AS ExtRelationId,
		(CASE WHEN ISNUMERIC(RN.ExtNodeId) = 1 THEN CAST(RN.ExtNodeId AS INTEGER) ELSE 0 END) AS ExtNodeIdInt,
		RN.ExtNodeId,
		(SELECT COUNT(*) FROM SMRelationNode RT WHERE RT.SMRelationId = CRM.SMRelationId)
FROM	SMCopyToRelationMap CRM WITH (READUNCOMMITTED), SMRelationNode RN WITH (READUNCOMMITTED), SMRelation R WITH (READUNCOMMITTED)
WHERE	CRM.ArchGroupCopyId = @i_ArchCopyId
		AND CRM.SMRelationNodeId = RN.SMRelationNodeId
		AND CRM.SMRelationId = R.SMRelationId
SELECT @errCode = @@ERROR, @rowCount = @@ROWCOUNT
IF (@errCode = 0 AND @rowCount = 0)
	SET @errCode = -1
IF (@errCode != 0)
	SELECT @errCode, 0, 0, N'', 0, N'', 0
ELSE
	SELECT	*
	FROM	@outputTable
GO

IF EXISTS (select * from GxQscripts where name = 'archGetDFMStorageServiceInfo')
	delete from GxQscripts where name = 'archGetDFMStorageServiceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDFMStorageServiceInfo')
	delete from GXDBVersions where aliasname = 'archGetDFMStorageServiceInfo'
GO

insert into GXDBVersions values(2, 'archGetDFMStorageServiceInfo',  '00010002005200010000', 'archGetDFMStorageServiceInfo', '00010002005200010000')
GO

