

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetDDBAgentsForClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetDDBAgentsForClients.sp,v $ $Id: archGetDDBAgentsForClients.sp,v 1.1.2.3 2018/11/03 03:15:34 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetDDBAgentsForClients')
BEGIN
	print '>>> Drop Stored Procedure: archGetDDBAgentsForClients <<<'
	drop procedure archGetDDBAgentsForClients
END
IF EXISTS (select * from GxQscripts where name='archGetDDBAgentsForClients')
	delete from GxQscripts where name = 'archGetDDBAgentsForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDDBAgentsForClients')
	delete from GXDBVersions where aliasname = 'archGetDDBAgentsForClients'
GO
print '... Creating Procedure: archGetDDBAgentsForClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetDDBAgentsForClients
  @i_clientId integer
AS
--1. if  client is a file system then we will have to check storage policies that are associated to the sc's and get the primary's ddb ma
DECLARE @copyIDs TABLE( copyId int  primary key)
INSERT INTO @copyIDs
SELECT DISTINCT ag.defaultCopy
FROM archGroup ag WITH (READUNCOMMITTED), APP_Application aa WITH (READUNCOMMITTED)
WHERE (aa.dataArchGrpID = ag.id OR aa.logArchGrpID = ag.id) AND ag.defaultCopy > 0
AND aa.clientID = @i_clientId
--2. if the client is a MA as well, then fetch datapaths on the client/MA and get the DDB
INSERT INTO @copyIDs
SELECT DISTINCT dp.copyID
FROM  MMDrivePool drvp WITH (READUNCOMMITTED),MMDataPath dp WITH (READUNCOMMITTED) LEFT JOIN @copyIDs c ON c.copyId = dp.copyID
WHERE drvp.clientID = @i_clientId /*clientID*/
AND dp.DrivePoolId = drvp.DrivePoolId
AND c.CopyId IS NULL
select DISTINCT i.ClientId
FROM @copyIds t, archGroupCopy agc WITH (READUNCOMMITTED)
INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON AGC.id = CS.copyID AND ((CS.Flags & 4) > 0)
		INNER JOIN IdxSIDBSubStore i  WITH (READUNCOMMITTED) ON CS.SIDBStoreId = i.SIDBStoreId
WHERE t.copyId = agc.id
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetDDBAgentsForClients')
	delete from GxQscripts where name = 'archGetDDBAgentsForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDDBAgentsForClients')
	delete from GXDBVersions where aliasname = 'archGetDDBAgentsForClients'
GO

insert into GXDBVersions values(2, 'archGetDDBAgentsForClients',  '00010001000200030000', 'archGetDDBAgentsForClients', '00010001000200030000')
GO

