

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetDB2LogByLogNumber.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetDB2LogByLogNumber.sp,v $ $Id: archGetDB2LogByLogNumber.sp,v 1.4.204.2 2018/03/22 01:17:00 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetDB2LogByLogNumber <<<'

IF EXISTS (select * from sysobjects where name='archGetDB2LogByLogNumber')
	drop procedure archGetDB2LogByLogNumber
IF EXISTS (select * from GxQscripts where name='archGetDB2LogByLogNumber')
	delete from GxQscripts where name = 'archGetDB2LogByLogNumber'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDB2LogByLogNumber')
	delete from GXDBVersions where aliasname = 'archGetDB2LogByLogNumber'
GO
print '... Creating Procedure: archGetDB2LogByLogNumber'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetDB2LogByLogNumber
  @i_commCellId integer,
  @i_clientId integer,
  @i_instanceId integer,
  @i_backupSetId integer,
  @i_archiveName NVARCHAR(2048),
  @i_logNumber integer,
  @i_copyPrec integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_afileId integer;
  DECLARE @r_afileName NVARCHAR(2048);
  DECLARE @r_appId integer;
  DECLARE @r_createTime integer;
  DECLARE @r_backupLevel integer;
  DECLARE @r_agroupId integer;
  DECLARE @r_copyId integer;
  DECLARE @r_firstLogTime integer;
  DECLARE @r_lastLogTime integer;
  DECLARE @r_firstLogNumber integer;
  DECLARE @r_lastLogNumber integer;
  DECLARE @r_commCellId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @firstTime	    integer
	SET @firstTime = (SELECT MIN(B.firstLogTime)
	FROM 	archFile A, archDB2Log B
	WHERE A.id = B.archFileId
	AND A.commCellId = B.commCellId
	AND A.isValid = 1
	AND UPPER(A.name) LIKE UPPER(@i_archiveName + '%')
	AND A.appId IN (
		SELECT id FROM APP_Application WHERE clientId = @i_clientId AND
		(@i_instanceId = 0 OR instance = @i_instanceId) AND
		(@i_backupSetId = 0 OR backupSet = @i_backupSetId))
	AND (@i_logNumber = 0 OR B.firstLogNumber <= @i_logNumber)
	AND B.lastLogNumber >= @i_logNumber)
	SELECT A.id, A.name, A.appId, A.cTime, A.backupLevel,
		B.firstLogTime, B.lastLogTime, B.firstLogNumber, B.lastLogNumber, A.commCellId
	INTO 	#tempAFList
	FROM 	archFile A, archDB2Log B
	WHERE A.id = B.archFileId
	AND A.commCellId = B.commCellId
	AND A.isValid = 1
	AND UPPER(A.name) LIKE UPPER(@i_archiveName + '%')
	AND B.firstLogTime >= @firstTime
	AND A.appId IN (
		SELECT id FROM APP_Application WHERE clientId = @i_clientId AND
		(@i_instanceId = 0 OR instance = @i_instanceId) AND
		(@i_backupSetId = 0 OR backupSet = @i_backupSetId))
	SELECT A.id, A.name, A.appId, A.cTime, A.backupLevel, A.firstLogTime, A.lastLogTime,
		A.firstLogNumber, A.lastLogNumber, C.archGroupId, A.commCellId, MIN(C.copy) AS copy
	INTO 	#tempAFCopyList
	FROM	#tempAFList A, archFileCopy B, archGroupCopy C
	WHERE	B.archFileId = A.id AND B.commCellId = A.commCellId
	  AND B.archCopyId = C.id
	  AND B.isValid > 0
	  AND C.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	  AND (@i_copyPrec = -1 OR (@i_copyPrec = 0 AND C.copy < 1001) OR (@i_copyPrec <> 0 AND C.copy = @i_copyPrec))
	  AND (@i_includeAgedData <> 0 OR (B.flags & 256) = 0)
	GROUP BY A.id, A.name, A.appId, A.cTime, A.backupLevel, A.firstLogTime, A.lastLogTime,
		A.firstLogNumber, A.lastLogNumber, C.archGroupId, A.commCellId
	SELECT A.id, A.name, A.appId, A.cTime, A.backupLevel, A.archGroupId, B.id,
		A.firstLogTime, A.lastLogTime, A.firstLogNumber, A.lastLogNumber, A.commCellId
	FROM	#tempAFCopyList A, archGroupCopy B
	WHERE	A.archGroupId = B.archGroupId AND A.copy = B.copy
	ORDER BY A.cTime DESC
	DROP TABLE #tempAFList
	DROP TABLE #tempAFCopyList
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetDB2LogByLogNumber')
	delete from GxQscripts where name = 'archGetDB2LogByLogNumber'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetDB2LogByLogNumber')
	delete from GXDBVersions where aliasname = 'archGetDB2LogByLogNumber'
GO

insert into GXDBVersions values(2, 'archGetDB2LogByLogNumber',  '00010004020400020000', 'archGetDB2LogByLogNumber', '00010004020400020000')
GO

