

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetCopyAppRegionMap.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetCopyAppRegionMap.sp,v $ $Id: archGetCopyAppRegionMap.sp,v 1.1.2.3 2020/06/30 00:14:22 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetCopyAppRegionMap')
BEGIN
	print '>>> Drop Stored Procedure: archGetCopyAppRegionMap <<<'
	drop procedure archGetCopyAppRegionMap
END
IF EXISTS (select * from GxQscripts where name='archGetCopyAppRegionMap')
	delete from GxQscripts where name = 'archGetCopyAppRegionMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetCopyAppRegionMap')
	delete from GXDBVersions where aliasname = 'archGetCopyAppRegionMap'
GO
print '... Creating Procedure: archGetCopyAppRegionMap'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetCopyAppRegionMap
  @i_copyId integer,
  @i_appId integer = 0,
  @i_srcRegionId integer	= 0
AS
  DECLARE @o_srcRegionId integer
  DECLARE @o_srcRegionName varchar(1024)
  DECLARE @o_srcRegionCode varchar(1024)
  DECLARE @o_destRegionId integer
  DECLARE @o_destRegionName varchar(1024)
  DECLARE @o_destRegionCode varchar(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb..#TmpRegionMappingTbl') IS NOT NULL DROP TABLE #TmpRegionMappingTbl
CREATE TABLE #TmpRegionMappingTbl(srcRegionId	integer, srcRegionName	varchar(1024), srcRegionCode	varchar(1024),
								  destRegionId	integer, destRegionName	varchar(1024), destRegionCode	varchar(1024) )
INSERT INTO #TmpRegionMappingTbl
SELECT 	RM.srcRegionId, SR.RegionName, SR.RegionCode, RM.destRegionId, DR.RegionName, DR.RegionCode
FROM	ArchCopyAppRegionMap RM WITH (NOLOCK), App_CloudVendorRegion SR WITH (NOLOCK), App_CloudVendorRegion DR WITH (NOLOCK)
WHERE	RM.copyId = @i_copyId
		AND RM.appId = @i_appId
		AND (@i_srcRegionId = 0 OR RM.srcRegionId = @i_srcRegionId)
		AND RM.srcRegionId = SR.id
		AND RM.destRegionId = DR.id
-- if no subclient level mapping then return only copy level mapping
IF (NOT EXISTS(SELECT 1 FROM #TmpRegionMappingTbl)) AND @i_appId > 0
BEGIN
	INSERT INTO #TmpRegionMappingTbl
	SELECT 	RM.srcRegionId, SR.RegionName, SR.RegionCode, RM.destRegionId, DR.RegionName, DR.RegionCode
	FROM	ArchCopyAppRegionMap RM WITH (NOLOCK), App_CloudVendorRegion SR WITH (NOLOCK), App_CloudVendorRegion DR WITH (NOLOCK)
	WHERE	RM.copyId = @i_copyId
			AND RM.appId = 0
			AND (@i_srcRegionId = 0 OR RM.srcRegionId = @i_srcRegionId)
			AND RM.srcRegionId = SR.id
			AND RM.destRegionId = DR.id
END
SELECT srcRegionId, srcRegionName, srcRegionCode, destRegionId, destRegionName, destRegionCode FROM #TmpRegionMappingTbl
IF OBJECT_ID('tempdb..#TmpRegionMappingTbl') IS NOT NULL DROP TABLE #TmpRegionMappingTbl
GO

IF EXISTS (select * from GxQscripts where name = 'archGetCopyAppRegionMap')
	delete from GxQscripts where name = 'archGetCopyAppRegionMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetCopyAppRegionMap')
	delete from GXDBVersions where aliasname = 'archGetCopyAppRegionMap'
GO

insert into GXDBVersions values(2, 'archGetCopyAppRegionMap',  '00010001000200030000', 'archGetCopyAppRegionMap', '00010001000200030000')
GO

