

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetContentIndexingAgedFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetContentIndexingAgedFiles.sp,v $ $Id: archGetContentIndexingAgedFiles.sp,v 1.8.2.8 2018/08/23 14:19:58 pankajkumar Exp $";
-- This stored procedure is supposed to return archive files which need to be pruned from Content
-- Indexing if they have been indexed using SOLR.
-- In case of Turbo pruning, also ensure that we do not return archive files if any future synthetic
-- full jobs are present which are yet to be content indexed.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetContentIndexingAgedFiles <<<'

IF EXISTS (select * from sysobjects where name='archGetContentIndexingAgedFiles')
	drop procedure archGetContentIndexingAgedFiles
IF EXISTS (select * from GxQscripts where name='archGetContentIndexingAgedFiles')
	delete from GxQscripts where name = 'archGetContentIndexingAgedFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetContentIndexingAgedFiles')
	delete from GXDBVersions where aliasname = 'archGetContentIndexingAgedFiles'
GO
print '... Creating Procedure: archGetContentIndexingAgedFiles'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetContentIndexingAgedFiles
  @i_cloudId integer,
  @i_lastArchFileId integer = 0,
  @i_maxRows integer = 100,
  @o_error integer	OUTPUT
AS
  DECLARE @o_archFileId integer
  DECLARE @o_commCellNum integer
  DECLARE @o_cloudId integer
  DECLARE @o_clientId integer
  DECLARE @o_appId integer
  DECLARE @o_pruneType integer
SET NOCOUNT ON
--
-- Check if DA is enabled before proceeding
--
declare @l_isDAEnabled integer
set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
if (@l_isDAEnabled = 0)
begin
set @o_error = -1000
	select 0, 0, @i_cloudId, 0, 0, 0 where 1 = 2 -- return empty resultset
    return
end
declare @ciTurboOption bit = 1
set @o_error = 0 -- no error
--
if exists (select top 1 1 from GXGlobalParam (NOLOCK) where name = N'Content Indexing Turbo Option' and value = N'0')
begin
	set @ciTurboOption = 0
end
--
if not exists(select componentId from APP_ComponentProp where propertyTypeId = 1014
and componentType = 2 and stringVal like '%Solr%' AND modified = 0 AND componentId = @i_cloudId)
begin
	set @o_error = 1 -- not a Solr cloud
	select 0, 0, @i_cloudId, 0, 0, 0 where 1 = 2 -- return empty resultset
	return
end
--
--
if (@ciTurboOption = 0)
begin
	select
		top(@i_maxRows) A.archFileId, C.number, A.cloudId, isnull(app.clientId, 0), A.appId, A.pruneType
	from
		archContentIndexingAged A with (NOLOCK)
	inner join
		APP_CommCell C with (NOLOCK)
	on
A.commCellId = C.id AND A.operationType = 1
	left outer join
		APP_Application app with (NOLOCK)
	on
		app.id = A.appId and app.OrigCCId = c.id
	where
		A.cloudId = @i_cloudId
								--lastarchfileId check is not needed, it should pass all avaiable archfiles for pruning.
								--rows are anyway getting deleted from aged table as soon as pruning is done.
end
else begin
	-- We should not send any AGED files for pruning in case a future synthetic full
	-- has not been content indexed for a particular subclient.
	-- Files which need to be pruned for reason where user has DELETED a Content Indexing
	-- job or where a subclient is DELETED should be pruned immediately.
	IF OBJECT_ID('tempdb.dbo.#SubclientInfoAgedAFs') IS NOT NULL DROP TABLE #SubclientInfoAgedAFs
	create table #SubclientInfoAgedAFs
	(
		AppId 		int,
		CommCellId	int,
		MaxContentIndexedArchFileId int,  -- max archive file per subclient in the aged table
		Primary Key(AppId, CommCellId)
	)
	--
	insert into #SubclientInfoAgedAFs(AppId, CommCellId, MaxContentIndexedArchFileId)
	select
		a.appId, a.commCellId, max(a.archFileId)
	from
		archContentIndexingAged a with (NOLOCK)
	where
a.pruneType = 3 AND a.operationType = 1
		AND A.cloudId = @i_cloudId
	group by
		commCellId, appId
	-- Get the subclients which have aged files and have future SF not indexed
	IF OBJECT_ID('tempdb.dbo.#SubclientPendingSynthfull') IS NOT NULL DROP TABLE #SubclientPendingSynthfull
	create table #SubclientPendingSynthfull
	(
		appId int,
		cloudId int,
		primary key (appId, cloudId)
	)
	--
	insert into #SubclientPendingSynthfull(appId, cloudId)
	SELECT DISTINCT T.AppId, R.cloudId
	FROM #SubclientInfoAgedAFs T
JOIN archContentIndexingAged aged (NOLOCK) on aged.AppId = T.AppId AND aged.cloudId = @i_cloudId  AND aged.operationType = 1
		JOIN APP_Application App WITH (NOLOCK) on T.AppId = App.Id
		JOIN APP_ClientProp cp WITH (NOLOCK) on cp.componentNameId = App.clientId and cp.attrName = N'Content Indexing Enabled'	and	cp.attrVal = N'1'
JOIN archContentIndexingRules R WITH (NOLOCK) on R.archGroupId = App.dataArchGrpId and aged.cloudId = R.cloudId	and R.enabled = 1 and R.operationType = 1
		JOIN archFile af with (nolock) ON af.appId = T.AppId  AND af.commCellId = T.CommCellId
		JOIN JMBkpStats j with (nolock)	on	j.jobId = af.jobId and j.commCellId = af.commCellId
		WHERE		(af.id > T.MaxContentIndexedArchFileId and af.commCellId = T.CommCellId)
				AND j.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
AND af.flags & (16 | 32 | 128) > 0
				AND j.status = 1 -- completed backup jobs
AND af.fileType = 1
	--
	-- Select the archive files from the remaining subclients
	select
		top(@i_MaxRows) A.archFileId, C.number, A.cloudId, isnull(app.clientId, 0), A.appId, A.pruneType
	from
		archContentIndexingAged A with (NOLOCK)
	inner join
		APP_CommCell C with (NOLOCK)
	on
A.commCellId = C.id	AND A.operationType = 1
	left outer join
		APP_Application app with (NOLOCK)
	on
		app.id = A.appId and app.OrigCCId = c.id
	left outer join #SubclientPendingSynthfull t on
		t.appId = A.appId
		and t.cloudId = A.cloudId
	where
		A.cloudId = @i_cloudId
									--lastarchfileId check is not needed, it should pass all avaiable archfiles for pruning.
									--rows are anyway getting deleted from aged table as soon as pruning is done.
and (A.pruneType <> 3 or t.appId IS NULL)
	IF OBJECT_ID('tempdb.dbo.#SubclientInfoAgedAFs') IS NOT NULL DROP TABLE #SubclientInfoAgedAFs
	IF OBJECT_ID('tempdb.dbo.#SubclientPendingSynthfull') IS NOT NULL DROP TABLE #SubclientPendingSynthfull
end
--
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archGetContentIndexingAgedFiles')
	delete from GxQscripts where name = 'archGetContentIndexingAgedFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetContentIndexingAgedFiles')
	delete from GXDBVersions where aliasname = 'archGetContentIndexingAgedFiles'
GO

insert into GXDBVersions values(2, 'archGetContentIndexingAgedFiles',  '00010008000200080000', 'archGetContentIndexingAgedFiles', '00010008000200080000')
GO

