

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetClientEncryptionSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetClientEncryptionSettings.sp,v $ $Id: archGetClientEncryptionSettings.sp,v 1.1.2.5 2020/05/16 00:48:05 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetClientEncryptionSettings')
BEGIN
	print '>>> Drop Stored Procedure: archGetClientEncryptionSettings <<<'
	drop procedure archGetClientEncryptionSettings
END
IF EXISTS (select * from GxQscripts where name='archGetClientEncryptionSettings')
	delete from GxQscripts where name = 'archGetClientEncryptionSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetClientEncryptionSettings')
	delete from GXDBVersions where aliasname = 'archGetClientEncryptionSettings'
GO
print '... Creating Procedure: archGetClientEncryptionSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetClientEncryptionSettings
  @i_clientId int
AS
  DECLARE @o_encryptionSetting int;
  DECLARE @o_restoreAccess int;
  DECLARE @o_drToolAccess int;
  DECLARE @o_encType int;
  DECLARE @o_encKeyLen int;
  DECLARE @o_RSAPubKey varchar(1024);
  DECLARE @o_RSAPriKeyBPF varchar(1024);
  DECLARE @o_RSAPriKeyUPF varchar(1024);
  DECLARE @o_companyId int;
  DECLARE @o_companyGUID uniqueidentifier;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@o_encryptionSetting = 3
SET @o_restoreAccess = 0
SET	@o_drToolAccess	= 0
SET	@o_encType		= 0
SET	@o_encKeyLen	= 0
SET	@o_RSAPubKey	= ''
SET	@o_RSAPriKeyBPF	= ''
SET	@o_RSAPriKeyUPF	= ''
SET	@o_companyId	= 0
DECLARE @l_currentUtcTime INT = dbo.GetUnixTime(GETUTCDATE())
/*
	If below temp table is created in caller then results will be inserted into this table and select will be suppressed
	IF OBJECT_ID('tempdb..#lt_ClientEncSettings') IS NOT NULL DROP TABLE #lt_ClientEncSettings
	CREATE TABLE #lt_ClientEncSettings (encryptionSetting int, restoreAccess int, drToolAccess int, encType int, encKeyLen int,
			rsaPubKey varchar(1024), rsaPriKeyUPF varchar(1024), rsaPriKeyBPF varchar(1024), companyId int, companyGUID uniqueidentifier)
*/
/*
	Prasad Nara, Feb 15, 2018
	Encryption settings can be defined at client, plan and company levels,
	client inherits settings from plan and company levels, below is the order for inheritance.
	1. Company - When encryption is set on company and client is not overriding settings.
	2. Plan   - When no company level encryption, encryption is set on any plan and client is not overriding settings.
	3. Client - all other cases (No company or No plan or Overriding on client).
*/
DECLARE @l_overrideGlobalSettings INT = 3
DECLARE @l_globalEntityId INT = -1
DECLARE @l_globalEntityType INT = -1
DECLARE @l_companyId INT = -1
SELECT	@l_overrideGlobalSettings = CAST(ISNULL([Override Global Encryption Settings], 3) as int),
@o_restoreAccess = CAST(ISNULL([Encrypt: restoreAccess], 0) as int),
@o_RSAPubKey = CAST(ISNULL([Encrypt: rsaPubKey], '') as varchar(1024)),
@o_RSAPriKeyBPF = CAST(ISNULL([Encrypt: rsaPriKeyUPF], '') as varchar(1024)),
@o_RSAPriKeyUPF = CAST(ISNULL([Encrypt: rsaPriKeyBPF], '') as varchar(1024)),
@l_globalEntityId = CAST(ISNULL([Override Encryption Settings From EntityId], -1) as int),
@l_globalEntityType = CAST(ISNULL([Override Encryption Settings From EntityType], -1) as int),
@l_companyId = CAST(ISNULL([KMS Company ID], -1) as int)
FROM
(
	SELECT	attrVal, attrName
	FROM	APP_ClientProp WITH (READUNCOMMITTED)
	WHERE	componentNameId = @i_clientId AND modified = 0
			AND attrName IN
			(
'Override Global Encryption Settings',
'Encrypt: restoreAccess',
'Encrypt: rsaPubKey',
'Encrypt: rsaPriKeyUPF',
'Encrypt: rsaPriKeyBPF',
'Override Encryption Settings From EntityId',
'Override Encryption Settings From EntityType',
'KMS Company ID'
			)
) AS Prop
PIVOT
(
	MAX(attrVal)
	FOR attrName IN
	(
[Override Global Encryption Settings],
[Encrypt: restoreAccess],
[Encrypt: rsaPubKey],
[Encrypt: rsaPriKeyUPF],
[Encrypt: rsaPriKeyBPF],
[Override Encryption Settings From EntityId],
[Override Encryption Settings From EntityType],
[KMS Company ID]
	)
) AS Pvt
IF @o_restoreAccess <> 1 /*ENC_RESTORE_PASSPHRASE*/
BEGIN
	--New clients may not get the inherited entity property if there is any delay in processing work queue token
	--So sync settings if not set already
IF @l_globalEntityId = -1
	BEGIN
DECLARE @l_xml  xml = '<Api_SyncEncryptionSettingsReq entityId="'+ cast(@i_clientId as varchar) +'" entityType="3" operationType="3" />'
		IF OBJECT_ID('tempdb..#lt_SyncSettingsOutput') IS NOT NULL DROP TABLE #lt_SyncSettingsOutput
		CREATE TABLE #lt_SyncSettingsOutput (o_xml xml)
		EXEC AppSyncEncryptionSettings @l_xml
		IF OBJECT_ID('tempdb..#lt_SyncSettingsOutput') IS NOT NULL DROP TABLE #lt_SyncSettingsOutput
SELECT	@l_globalEntityId = CAST(ISNULL([Override Encryption Settings From EntityId], -1) as int),
@l_globalEntityType = CAST(ISNULL([Override Encryption Settings From EntityType], -1) as int),
@l_companyId = CAST(ISNULL([KMS Company ID], -1) as int)
		FROM
		(
			SELECT	attrVal, attrName
			FROM	APP_ClientProp WITH (READUNCOMMITTED)
			WHERE	componentNameId = @i_clientId AND modified = 0
					AND attrName IN
					(
'Override Encryption Settings From EntityId',
'Override Encryption Settings From EntityType',
'KMS Company ID'
					)
		) AS Prop
		PIVOT
		(
			MAX(attrVal)
			FOR attrName IN
			(
[Override Encryption Settings From EntityId],
[Override Encryption Settings From EntityType],
[KMS Company ID]
			)
		) AS Pvt
	END
	--
	--Check if KMS is set at company level
	--if so override at client level is not supported and client must follow company settings
	--and we dedupe within clients of company, this is supported only when client is v11 SP12 or higher
	--
	IF @l_companyId > 0
		AND EXISTS
		(
			SELECT 1
			FROM 	App_Client CN WITH(READUNCOMMITTED)
					INNER JOIN simInstalledPackages CNV WITH(READUNCOMMITTED)
ON CN.id = CNV.clientId AND CNV.simPackageId IN (1, 1002)
			WHERE	CN.id = @i_clientId
					AND
					(
CN.releaseId > 16
OR (CN.releaseId = 16 AND CNV.HighestSP >= 12)
					)
		)
	BEGIN
		SELECT 	@o_restoreAccess = 2 /*ENC_RESTORE_COMPANY*/,
				@o_companyId = @l_companyId, @o_companyGUID = GUID,
@l_overrideGlobalSettings = 0,
@l_globalEntityId = @l_companyId, @l_globalEntityType = 61
		FROM	UMDSProviders WITH(READUNCOMMITTED)
		WHERE	id = @l_companyId
	END
	--Check for plan and company level settings only when override is not ON and not passphrase
IF @l_overrideGlobalSettings <> 1
	BEGIN
		IF @l_globalEntityId > 0
		BEGIN
			-- Check plan level encryption settings
IF @l_globalEntityType = 158
			BEGIN
SELECT	@o_encryptionSetting = CAST(ISNULL([Encryption Settings], 3) as int),
@o_drToolAccess = CAST(ISNULL([Encrypt: drToolAccess], 0) as int),
@o_encType = CAST(ISNULL([Encrypt: Type], 0) as int),
@o_encKeyLen = CAST(ISNULL([Encrypt: Key Length], 0) as int)
				FROM
				(
					SELECT	attrVal, attrName
					FROM	App_PlanProp WITH (READUNCOMMITTED)
						WHERE	componentNameId = @l_globalEntityId AND modified = 0
							AND attrName IN
							(
'Encryption Settings',
'Encrypt: Type',
'Encrypt: Key Length',
'Encrypt: drToolAccess'
							)
				) AS Prop
				PIVOT
				(
					MAX(attrVal)
					FOR attrName IN
					(
[Encryption Settings],
[Encrypt: drToolAccess],
[Encrypt: Type],
[Encrypt: Key Length]
					)
				) AS Pvt
			END
			--Look for company level settings
ELSE IF @l_globalEntityType = 61
			BEGIN
SELECT	@o_encryptionSetting = CAST(ISNULL([Encryption Settings], 3) as int),
@o_drToolAccess = CAST(ISNULL([Encrypt: drToolAccess], 0) as int),
@o_encType = CAST(ISNULL([Encrypt: Type], 0) as int),
@o_encKeyLen = CAST(ISNULL([Encrypt: Key Length], 0) as int)
				FROM
				(
					SELECT	attrValInt, attrName
					FROM	App_CompanyProp WITH (READUNCOMMITTED)
							WHERE	componentNameId = @l_globalEntityId AND modified = 0
							AND attrName IN
							(
'Encryption Settings',
'Encrypt: Type',
'Encrypt: Key Length',
'Encrypt: drToolAccess'
							)
				) AS Prop
				PIVOT
				(
					MAX(attrValInt)
					FOR attrName IN
					(
[Encryption Settings],
[Encrypt: drToolAccess],
[Encrypt: Type],
[Encrypt: Key Length]
					)
				) AS Pvt
			END
		END
	END
END
--All other cases look for client level
IF @o_encryptionSetting = 3
BEGIN
SELECT	@o_encryptionSetting = CAST(ISNULL([Encryption Settings], 0) as INT),
@o_drToolAccess = CAST(ISNULL([Encrypt: drToolAccess], 0) as INT),
@o_encType = CAST(ISNULL([Encrypt: Type], 0) as INT),
@o_encKeyLen = CAST(ISNULL([Encrypt: Key Length], 0) as INT)
	FROM
	(
		SELECT	attrVal, attrName
		FROM	APP_ClientProp WITH (READUNCOMMITTED)
		WHERE	componentNameId = @i_clientId AND modified = 0
				AND attrName IN
				(
'Encryption Settings',
'Encrypt: Type',
'Encrypt: Key Length',
'Encrypt: drToolAccess'
				)
	) AS Prop
	PIVOT
	(
		MAX(attrVal)
		FOR attrName IN
		(
[Encryption Settings],
[Encrypt: drToolAccess],
[Encrypt: Type],
[Encrypt: Key Length]
		)
	) AS Pvt
END
--if encryption is not set on any level default it to use storage policy settings
IF @o_encryptionSetting = 3
SET @o_encryptionSetting = 0
IF OBJECT_ID('tempdb..#lt_ClientEncSettings') IS NOT NULL
BEGIN
	INSERT INTO #lt_ClientEncSettings
	(
			encryptionSetting,
			restoreAccess,
			drToolAccess,
			encType,
			encKeyLen,
			rsaPubKey,
			rsaPriKeyUPF,
			rsaPriKeyBPF,
			companyId,
			companyGUID
	)
	SELECT	@o_encryptionSetting,
			@o_restoreAccess,
			@o_drToolAccess,
			@o_encType,
			@o_encKeyLen,
			@o_RSAPubKey,
			@o_RSAPriKeyBPF,
			@o_RSAPriKeyUPF,
			@o_companyId,
			@o_companyGUID
END
ELSE
BEGIN
	SELECT	@o_encryptionSetting 	AS encryptionSetting,
			@o_restoreAccess 		AS restoreAccess,
			@o_drToolAccess 		AS drToolAccess,
			@o_encType 				AS encType,
			@o_encKeyLen 			AS encKeyLen,
			@o_RSAPubKey 			AS RSAPubKey,
			@o_RSAPriKeyBPF 		AS RSAPriKeyBPF,
			@o_RSAPriKeyUPF 		AS RSAPriKeyUPF,
			@o_companyId			AS companyId,
			@o_companyGUID			AS companyGUID
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetClientEncryptionSettings')
	delete from GxQscripts where name = 'archGetClientEncryptionSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetClientEncryptionSettings')
	delete from GXDBVersions where aliasname = 'archGetClientEncryptionSettings'
GO

insert into GXDBVersions values(2, 'archGetClientEncryptionSettings',  '00010001000200050000', 'archGetClientEncryptionSettings', '00010001000200050000')
GO

