

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetChunkInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetChunkInfo.sp,v $ $Id: archGetChunkInfo.sp,v 1.1.2.7.20.1 2021/03/13 04:05:08 chandru Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archGetChunkInfo')
BEGIN
	print '>>> Drop Stored Procedure: archGetChunkInfo <<<'
	drop procedure archGetChunkInfo
END
IF EXISTS (select * from GxQscripts where name='archGetChunkInfo')
	delete from GxQscripts where name = 'archGetChunkInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetChunkInfo')
	delete from GXDBVersions where aliasname = 'archGetChunkInfo'
GO
print '... Creating Procedure: archGetChunkInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archGetChunkInfo
  @i_archFileId INTEGER,
  @i_commCellId INTEGER,
  @i_copyId INTEGER,
  @i_usePhyOrLogOffset INTEGER,
  @i_physicalOffset BIGINT,
  @i_logicalOffset BIGINT,
  @i_isGetNextChunk INTEGER,
  @i_currentChunkId BIGINT
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archFileId INTEGER 
  DECLARE @o_commCellId INTEGER 
  DECLARE @o_chunkNumber INTEGER 
  DECLARE @o_physicalOffset BIGINT 
  DECLARE @o_logicalOffset BIGINT 
  DECLARE @o_physicalSize BIGINT 
  DECLARE @o_logicalSize BIGINT
  DECLARE @o_chunkId BIGINT 
  DECLARE @o_chunkCommCellId INTEGER 
  DECLARE @o_volumeId INTEGER 
  DECLARE @o_fileMarkerNo INTEGER
  DECLARE @o_version INTEGER
  DECLARE @o_chunkPhysicalSize BIGINT 
  DECLARE @o_chunkLogicalSize BIGINT
  DECLARE @o_hwEncKey varchar(114)
  DECLARE @o_IsCloudLaptopClientAF INTEGER
	SET NOCOUNT ON
	DECLARE	@archChunkId		BIGINT = 0
	DECLARE	@chunkCommCellId	INT = 0
DECLARE @chunkHwEncKey		varchar(114) = ''
	-- Is this cloud laptop client archive files
	DECLARE @IsCloudLaptopClientAF INT = 0
	SELECT	@IsCloudLaptopClientAF = 1
	FROM	archFile AF WITH (READUNCOMMITTED), APP_Application A WITH (READUNCOMMITTED), CommCellCloudLaptopClients C WITH (READUNCOMMITTED)
	WHERE	AF.id = @i_archFileId
			AND AF.commCellId = @i_commCellId
			AND AF.AppId = A.id
			AND A.clientId = C.ClientId
	BEGIN TRY
		IF (@i_isGetNextChunk = 0)
		BEGIN
			IF (@i_usePhyOrLogOffset = 0)
			BEGIN
				SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
				FROM	archChunkMapping ACM WITH (READUNCOMMITTED)
				WHERE	ACM.archFileId = @i_archFileId
						AND ACM.CommCellID = @i_commCellId
						AND ACM.archCopyID = @i_copyId
						AND @i_physicalOffset BETWEEN ACM.physicalOffSet AND (ACM.physicalOffSet + ACM.physicalSize - 1)
				-- For cloud laptop scenario, if we have last chunk with physicalSize 0 and chunkNumber, return that
				IF (@archChunkId = 0 AND @IsCloudLaptopClientAF = 1)
				BEGIN
					SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
					FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
					WHERE	ACM.archFileId = @i_archFileId
							AND ACM.CommCellID = @i_commCellId
							AND ACM.archCopyID = @i_copyId
							AND ACM.physicalOffSet <= @i_physicalOffset
							--Will return last chunk even if we have received commit message from MA
							--In some conditions, we are seeing chunk being written after sending commit message
							--AND ACM.physicalSize = 0
							AND ACM.archFileID = AFC.archFileId
							AND ACM.commCellId = AFC.commCellId
							AND ACM.archCopyId = AFC.archCopyId
							AND ACM.chunkNumber = AFC.lastChunkNumber
							AND ACM.chunkNumber >= 1
							AND AFC.isValid = 1
				END
			END
			ELSE
			BEGIN
				SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
				FROM	archChunkMapping ACM WITH (READUNCOMMITTED)
				WHERE	ACM.archFileId = @i_archFileId
						AND ACM.CommCellID = @i_commCellId
						AND ACM.archCopyID = @i_copyId
						AND @i_logicalOffset BETWEEN ACM.logicalOffset AND (ACM.logicalOffset + ACM.logicalSize - 1)
			END
		END
		ELSE
		BEGIN
			IF (@i_currentChunkId = 0)
			BEGIN
				SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
				FROM	archChunkMapping ACM WITH (READUNCOMMITTED)
				WHERE	ACM.archFileId = @i_archFileId
						AND ACM.CommCellID = @i_commCellId
						AND ACM.archCopyID = @i_copyId
						AND ACM.chunkNumber = 1
						AND ACM.physicalSize > 0
				-- For cloud laptop scenario, if we have last chunk with physicalSize 0 and chunkNumber, return that
				IF (@archChunkId = 0 AND @IsCloudLaptopClientAF = 1)
				BEGIN
					SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
					FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
					WHERE	ACM.archFileId = @i_archFileId
							AND ACM.CommCellID = @i_commCellId
							AND ACM.archCopyID = @i_copyId
							--Will return last chunk even if we have received commit message from MA
							--In some conditions, we are seeing chunk being written after sending commit message
							--AND ACM.physicalSize = 0
							AND ACM.archFileID = AFC.archFileId
							AND ACM.commCellId = AFC.commCellId
							AND ACM.archCopyId = AFC.archCopyId
							AND ACM.chunkNumber = AFC.lastChunkNumber
							AND ACM.chunkNumber = 1
							AND AFC.isValid = 1
				END
			END
			ELSE
			BEGIN
				DECLARE @currentChunkNumber INT = 0
				SELECT	@currentChunkNumber = ACM.chunkNumber
				FROM	archChunkMapping ACM WITH (READUNCOMMITTED)
				WHERE	ACM.archFileId = @i_archFileId
						AND ACM.CommCellID = @i_commCellId
						AND ACM.archCopyID = @i_copyId
						AND ACM.archChunkId = @i_currentChunkId
				SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
				FROM	archChunkMapping ACM WITH (READUNCOMMITTED)
				WHERE	ACM.archFileId = @i_archFileId
						AND ACM.CommCellID = @i_commCellId
						AND ACM.archCopyID = @i_copyId
						AND ACM.chunkNumber = @currentChunkNumber + 1
						AND ACM.physicalSize > 0
				-- For cloud laptop scenario, if we have last chunk with physicalSize 0 and chunkNumber, return that
				IF (@archChunkId = 0 AND @IsCloudLaptopClientAF = 1)
				BEGIN
					SELECT	@archChunkId = archChunkId, @chunkCommCellId = chunkCommCellId
					FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
					WHERE	ACM.archFileId = @i_archFileId
							AND ACM.CommCellID = @i_commCellId
							AND ACM.archCopyID = @i_copyId
							AND ACM.physicalSize = 0
							AND ACM.archFileID = AFC.archFileId
							AND ACM.commCellId = AFC.commCellId
							AND ACM.archCopyId = AFC.archCopyId
							AND ACM.chunkNumber = AFC.lastChunkNumber
							AND ACM.chunkNumber = @currentChunkNumber + 1
							AND AFC.isValid = 1
				END
			END
		END
IF EXISTS (SELECT 1 FROM ArchChunk WITH (READUNCOMMITTED) WHERE id = @archChunkId AND commCellId = @chunkCommCellId AND flags & 1048576 > 0)
		BEGIN
			SELECT @chunkHwEncKey = med.hwEncKey
			FROM	MMMedia med WITH (READUNCOMMITTED), MMVolume vol WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
			WHERE	chunk.id = @archChunkId AND chunk.commCellId = @chunkCommCellId
			AND		vol.VolumeId = chunk.VolumeId
			AND		med.MediaId = vol.MediaId
		END
		SELECT	ACM.archFileId, ACM.commCellId, ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffSet, ACM.physicalSize, ACM.logicalSize,
				AC.id, AC.commCellId, AC.volumeId, AC.fileMarkerNo, AC.version, AC.physicalSize, AC.logicalSize, CASE WHEN LEN(@chunkHwEncKey)>0 THEN @chunkHwEncKey ELSE AC.hwEncKey END, @IsCloudLaptopClientAF
		FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archChunk AC WITH (READUNCOMMITTED)
		WHERE	ACM.archChunkId = @archChunkId
				AND ACM.chunkCommCellID = @chunkCommCellId
				AND ACM.archChunkId = AC.id
				AND ACM.chunkCommCellId = AC.commCellId
				AND ACM.archFileId = @i_archFileId
				AND ACM.commCellId = @i_commCellId
				AND ACM.archCopyID = @i_copyId
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
		IF (@@TRANCOUNT > 0)
                THROW;
	END CATCH
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archGetChunkInfo')
	delete from GxQscripts where name = 'archGetChunkInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetChunkInfo')
	delete from GXDBVersions where aliasname = 'archGetChunkInfo'
GO

insert into GXDBVersions values(2, 'archGetChunkInfo',  'v1.1.2.7.20.1', 'archGetChunkInfo', 'v1.1.2.7.20.1')
GO

