

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetChunkCommitInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetChunkCommitInfo.sp,v $ $Id: archGetChunkCommitInfo.sp,v 1.1.2.7 2018/03/22 01:10:50 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  archGetChunkCommitInfo()
--  |
--  | Description:  Get the parameters selected for DataAging
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetChunkCommitInfo <<<'

IF EXISTS (select * from sysobjects where name='archGetChunkCommitInfo')
	drop procedure archGetChunkCommitInfo
IF EXISTS (select * from GxQscripts where name='archGetChunkCommitInfo')
	delete from GxQscripts where name = 'archGetChunkCommitInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetChunkCommitInfo')
	delete from GXDBVersions where aliasname = 'archGetChunkCommitInfo'
GO
print '... Creating Procedure: archGetChunkCommitInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetChunkCommitInfo
  @JobId INTEGER,
  @CommCellId INTEGER,
  @flags INTEGER,
  @chunksInfoXML NVARCHAR(MAX)
AS
  DECLARE @o_ErrorCode INTEGER;
  DECLARE @o_ChunkId BIGINT;
  DECLARE @o_VolumeId INTEGER;
  DECLARE @o_Status BIGINT;
SET NOCOUNT ON
	DECLARE 	@retVal		INTEGER
	SET 		@retVal 	= 0
	DECLARE		@jobStartTime INTEGER = 0
	DECLARE @l_currentTime INT = dbo.GetUnixTime(GetUTCDate())
	DECLARE		@l_chunksInfoXML XML = @chunksInfoXML
	SELECT	@jobStartTime = jobStartTime
	FROM	JMJobInfo
	WHERE	JobId = @JobId
			AND CommCellId = @CommCellId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	if object_id('tempdb.dbo.#ChunkCommitInfo') is not null DROP TABLE #ChunkCommitInfo
	CREATE TABLE #ChunkCommitInfo (
		chunkId				BIGINT,
		volumeId			INTEGER,
		status				BIGINT,
		PRIMARY KEY(chunkId, volumeId)
		)
	INSERT INTO #ChunkCommitInfo
	SELECT	Chunks.Node.value('@chunkId', 'BIGINT') chunkId,
			Chunks.Node.value('@volumeId', 'INTEGER') volumeId,
			Chunks.Node.value('@status', 'BIGINT') status
	FROM	@l_chunksInfoXML.nodes('/ChunkCommitInfoXML/CHUNK') Chunks(Node)
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	UPDATE	T
SET		T.Status |= (CASE WHEN AC.id IS NULL THEN 2 ELSE 1 END)
	FROM	#ChunkCommitInfo T	LEFT OUTER JOIN archChunk AC WITH (READUNCOMMITTED) ON T.chunkId = AC.id	AND T.volumeId = AC.volumeId
								LEFT OUTER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	WHERE	AC.id IS NULL
			OR (
					AC.createTime < @jobStartTime
AND ((AC.flags & (2048)) = 0 AND ACM.chunkNumber > 0)
				)
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
CX_EXIT:
	IF (@retVal <> 0)
		SELECT	-1 AS o_ErrorCode,
				-1 AS o_ChunkId,
				-1 AS o_VolumeId,
				-1 AS o_Status
	ELSE
		SELECT	0 AS o_ErrorCode,
				chunkId AS o_ChunkId,
				volumeId AS o_VolumeId,
				status AS o_Status
		FROM	#ChunkCommitInfo
if object_id('tempdb.dbo.#ChunkCommitInfo') is not null DROP TABLE #ChunkCommitInfo
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archGetChunkCommitInfo')
	delete from GxQscripts where name = 'archGetChunkCommitInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetChunkCommitInfo')
	delete from GXDBVersions where aliasname = 'archGetChunkCommitInfo'
GO

insert into GXDBVersions values(2, 'archGetChunkCommitInfo',  '00010001000200070000', 'archGetChunkCommitInfo', '00010001000200070000')
GO

