

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetBackupCopyScheduleInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archGetBackupCopyScheduleInfo"						|
--	|																		|
--	| To check for any Snap to tape schedule present on storage				|
--	|	policy and its status.												|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetBackupCopyScheduleInfo')
BEGIN
	print '>>> Drop Stored Procedure: archGetBackupCopyScheduleInfo <<<'
	drop procedure archGetBackupCopyScheduleInfo
END
IF EXISTS (select * from GxQscripts where name='archGetBackupCopyScheduleInfo')
	delete from GxQscripts where name = 'archGetBackupCopyScheduleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetBackupCopyScheduleInfo')
	delete from GXDBVersions where aliasname = 'archGetBackupCopyScheduleInfo'
GO
print '... Creating Procedure: archGetBackupCopyScheduleInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetBackupCopyScheduleInfo
  @i_policyId integer
AS
  DECLARE @o_taskId integer
  DECLARE @o_enabled integer
  DECLARE @o_isPlanAssociated integer
IF EXISTS(
SELECT 1 FROM APP_PlanProp WITH(NOLOCK) WHERE attrName='Storage policy' AND attrVal = CAST(@i_policyId AS NVARCHAR(12))
	UNION ALL
	SELECT 1 FROM App_PlanRule WITH(NOLOCK) WHERE storagePolicyId = @i_policyId
	UNION ALL
	SELECT 1
	FROM TM_AssocEntity AE WITH(NOLOCK)
		 INNER JOIN TM_Task T WITH(NOLOCK) ON AE.taskId = T.taskId
INNER JOIN TM_SubTask ST WITH(NOLOCK) ON ST.taskId = T.taskId AND ST.flags & 0x2000000 > 0
AND ST.operationType = 4028
	WHERE AE.policyId = @i_policyId
		  AND T.deleted = 0
)
BEGIN
	SET @o_isPlanAssociated = 1
END
ELSE
	SET @o_isPlanAssociated = 0
IF @o_isPlanAssociated =0
BEGIN
	SELECT @o_taskId = T.taskId,
				 @o_enabled = (1 & (~T.disabled))
	FROM TM_AssocEntity AE WITH(NOLOCK)
INNER JOIN TM_Task T WITH(NOLOCK) ON AE.taskId = T.taskId AND T.taskType = 2
INNER JOIN TM_SubTask ST WITH(NOLOCK) ON ST.taskId = T.taskId AND ST.flags & 0x4000000 > 0
AND ST.operationType = 4028
	WHERE AE.policyId = @i_policyId
		  AND T.deleted = 0;
END
IF @o_taskId IS NULL OR @o_isPlanAssociated = 1
	SELECT 0,0,IIF(@o_isPlanAssociated = 1,1,0)
ELSE
	SELECT @o_taskId, @o_enabled, 0
GO

IF EXISTS (select * from GxQscripts where name = 'archGetBackupCopyScheduleInfo')
	delete from GxQscripts where name = 'archGetBackupCopyScheduleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetBackupCopyScheduleInfo')
	delete from GXDBVersions where aliasname = 'archGetBackupCopyScheduleInfo'
GO

insert into GXDBVersions values(2, 'archGetBackupCopyScheduleInfo',  '00000000000000000000', 'archGetBackupCopyScheduleInfo', '00000000000000000000')
GO

