

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetBackedupInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	This stored procedure get all necessary information to show backed up information for GDPR app
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetBackedupInfo')
BEGIN
	print '>>> Drop Stored Procedure: archGetBackedupInfo <<<'
	drop procedure archGetBackedupInfo
END
IF EXISTS (select * from GxQscripts where name='archGetBackedupInfo')
	delete from GxQscripts where name = 'archGetBackedupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetBackedupInfo')
	delete from GXDBVersions where aliasname = 'archGetBackedupInfo'
GO
print '... Creating Procedure: archGetBackedupInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetBackedupInfo
  @i_subclientList NVARCHAR(MAX), -- list of subclientIds, separated by comma
  @i_appTypeIdList NVARCHAR(MAX) -- list of appTypeId, separated by comma
AS
BEGIN
	DECLARE @SEPARATOR CHAR = ','
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	;WITH appTypeIdList (appTypeId)
	AS
	(
		SELECT CAST(Data AS INT) FROM dbo.split(@i_appTypeIdList, @SEPARATOR)
	),
	subclientIdList (subclientId)
	AS
	(
		SELECT CAST(Data AS INT) FROM dbo.split(@i_subclientList, @SEPARATOR)
	)
	SELECT  AA.id											AS subClientId,
			AA.subclientName								AS subclientName,
			CASE
				-- in case of exchange one pass, always return CI information,
				-- for other app types, only return CI information when client has content indexing enabled AND storage policy has content indexing enabled
WHEN AA.appTypeId = 137 -- CV_APPTYPE_EXCHANGE_ONEPASS
							OR
							(
								EXISTS(SELECT TOP 1 1
									FROM APP_ClientProp AC
									WHERE AA.clientId = AC.componentNameId AND attrName = 'Content Indexing Enabled' AND attrVal = '1' AND modified = 0)
								AND
								EXISTS(SELECT TOP 1 1
									FROM archContentIndexingRules AR
									WHERE AA.dataArchGrpID = AR.archGroupId AND AR.enabled = 1)
							)
						THEN ISNULL(ContentIndexTable.contentIndexTime,0)
				ELSE 0
			END AS contentIndexTime
	FROM subclientIdList S
		JOIN APP_Application AS AA
			ON S.subclientId = AA.id
		JOIN appTypeIdList AS AType
			ON AA.appTypeId = AType.appTypeId
		LEFT JOIN
			(
				SELECT appId,
					contentIndexTime
				FROM (	SELECT  appId,
								contentIndexTime,
								ROW_NUMBER() OVER (PARTITION BY appId ORDER BY contentIndexTime DESC) AS rn
						FROM archFile af
							JOIN subclientIdList s ON af.appid = s.subclientid
WHERE flags & 64 = 64 AND filetype = 1) AS T
				WHERE T.rn = 1 -- to get the latest timestamp when this subclient was CIed
			) AS ContentIndexTable
			ON AA.id = ContentIndexTable.appId
END
GO

IF EXISTS (select * from GxQscripts where name = 'archGetBackedupInfo')
	delete from GxQscripts where name = 'archGetBackedupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetBackedupInfo')
	delete from GXDBVersions where aliasname = 'archGetBackedupInfo'
GO

insert into GXDBVersions values(2, 'archGetBackedupInfo',  '00000000000000000000', 'archGetBackedupInfo', '00000000000000000000')
GO

