

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetArchGroupToAppAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetArchGroupToAppAssociations.sp,v $ $Id: archGetArchGroupToAppAssociations.sp,v 1.1.2.10 2020/03/17 20:41:13 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetArchGroupToAppAssociations')
BEGIN
	print '>>> Drop Stored Procedure: archGetArchGroupToAppAssociations <<<'
	drop procedure archGetArchGroupToAppAssociations
END
IF EXISTS (select * from GxQscripts where name='archGetArchGroupToAppAssociations')
	delete from GxQscripts where name = 'archGetArchGroupToAppAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetArchGroupToAppAssociations')
	delete from GXDBVersions where aliasname = 'archGetArchGroupToAppAssociations'
GO
print '... Creating Procedure: archGetArchGroupToAppAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetArchGroupToAppAssociations
  @i_AGId INTEGER,
  @i_operationType INTEGER,
  @i_inputXML varchar(MAX) = ''
AS
/* -Caller needs to create this table for storing the output.
	CREATE TABLE #archGroupToAppId (
	archGroupId			INTEGER,
	AppId				INTEGER
	)
	CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
*/
/* -Caller needs to create this table for giving multiple storage policies as input, make sure if the caller is creating this table then the input agID is 0
   - also isExclusionList and srcCopyId is populated inside this proc, caller needs to insert agId only.
	CREATE TABLE #archGroupIdToProcess ( archGroupId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0)
	primary key 	(archGroupId)
	)
*/
IF OBJECT_ID('tempdb.dbo.#tempArchGroupToApp') IS NOT NULL DROP TABLE #tempArchGroupToApp
CREATE TABLE #tempArchGroupToApp (
	ArchGroupId		INTEGER,
	OperationType   SMALLINT,
	clientId 	INTEGER,
	appTypeId 	INTEGER,
	instanceId 	INTEGER,
	backupSetId INTEGER,
	subClientId INTEGER,
	clientGroupId INTEGER,
	exclude INTEGER,
	assocType INTEGER
)
CREATE CLUSTERED INDEX tempArchGroupToApp_CopyId_ClientId_AssocType_ClientGroupId on #tempArchGroupToApp (ArchGroupId, clientId, AssocType, ClientGroupId)
DECLARE @bIsAGIdTableCreeatedHere BIT = 0
DECLARE @isExclusionList BIT = 0
DECLARE @bAppsOutTableCretedHere BIT = 0
if @i_AGId <> 0
BEGIN
	IF object_id('tempdb.dbo.#archGroupIdToProcess') is null
	BEGIN
		CREATE TABLE #archGroupIdToProcess ( archGroupId  INTEGER,  isExclusionList BIT DEFAULT(0), srcCopyId INTEGER DEFAULT(0)
		primary key 	(archGroupId)
		)
		SET @bIsAGIdTableCreeatedHere = 1
	END
	IF NOT EXISTS (SELECT 1 FROM  #archGroupIdToProcess WHERE archGroupId = @i_AGId)
		INSERT INTO #archGroupIdToProcess (archGroupId) values(@i_AGId)
END
ELSE IF object_id('tempdb.dbo.#archGroupIdToProcess') is null -- caller did not populate the input table neither it sent an AGID
BEGIN
	--SELECT -1,-1,-1
	GOTO CX_EXIT
END
IF @i_inputXML <> ''
BEGIN
	DECLARE @i_xmlStr XML = convert(XML,@i_inputXML)
	INSERT INTO #tempArchGroupToApp
	SELECT
		t.archGroupId,
		@i_operationType,
		ISNULL((doc.col.value('@clientId', 'INT')),0),
		ISNULL((doc.col.value('@applicationId', 'INT')),0),
		ISNULL((doc.col.value('@instanceId', 'INT')),0),
		ISNULL((doc.col.value('@backupsetId', 'INT')),0),
		ISNULL((doc.col.value('@subclientId', 'INT')),0),
		ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
		ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
		ISNULL((doc.col.value('@_type_', 'INT')),0)
	FROM @i_xmlStr.nodes('//listEntities') doc(col), #archGroupIdToProcess t
	IF @@ROWCOUNT = 0 -- for no association in edit tab, we shaould still show the preview of what is selected
		INSERT INTO #tempArchGroupToApp
		SELECT
			t.archGroupId,
			@i_operationType, 0,0,0,0,0,0,0,-1
		FROM #archGroupIdToProcess t
END
ELSE
BEGIN
	INSERT INTO #tempArchGroupToApp
	SELECT A.*
	FROM archGroupToApp A WITH (READUNCOMMITTED), #archGroupIdToProcess t
	WHERE A.archGroupId = t.archGroupId AND A.operationType= @i_operationType
END
IF object_id('tempdb.dbo.#archGroupToAppId') IS NOT NULL
BEGIN
	IF NOT EXISTS (SELECT 1 FROM  #archGroupToAppId)
	BEGIN
		-- we need to pick only entities associated to the storage policy because of bug with VSA parent child linkages
		IF object_id('tempdb.dbo.#tmpGroupApps') is null -- if null then create and destroy the table here. THis table would already be created and populated when the proc is called from archCopyAppSubset or archCopyAppSubsetForGuI
		BEGIN
			SET @bAppsOutTableCretedHere = 1
			CREATE TABLE #tmpGroupApps (appId INT, clientId INT, appTypeId INT, instance INT, backupSet INT, subclientName NVARCHAR(512), isSelected INT)
			IF @i_operationType = 1
				UPDATE #archGroupIdToProcess
				SET srcCopyId = p.sourceCopyId
				FROM ArchMaterializeSnapshotProp p WITH (NOLOCK), #archGroupIdToProcess t WHERE p.archGroupId = t.archGroupId
			ELSE
				UPDATE #archGroupIdToProcess
				SET srcCopyId = p.sourceCopyId
				FROM ArchDeferredCatalogProp  p WITH (NOLOCK), #archGroupIdToProcess t WHERE p.archGroupId = t.archGroupId
			IF  EXISTS (SELECT 1 FROM #archGroupIdToProcess WHERE ISNULL(srcCopyId,0) = 0)
				UPDATE #archGroupIdToProcess
				SET srcCopyId = ag.defaultSnapCopy
				FROM archGroup ag WITH (NOLOCK), #archGroupIdToProcess s WHERE Ag.id = s.archGroupId AND ISNULL(s.srcCopyId,0) = 0
			--Get list of subclients having non-aged jobs on source copy
			INSERT INTO #tmpGroupApps
			SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
			FROM	APP_Application A WITH (NOLOCK)
			WHERE   EXISTS (
								SELECT TOP 1 1 FROM JMJobDatastats JDS WITH (NOLOCK), #archGroupIdToProcess s
								WHERE JDS.archGrpCopyId = s.srcCopyId
								AND status IN (100, 101, 102, 103)
AND (disabled & 256) = 0
								AND A.id = JDS.appId
						    )
			CREATE INDEX tmpGroupApps_idx1 ON #tmpGroupApps (appId)
			--Get list of subclients that are currently associated to storage policy
			INSERT INTO #tmpGroupApps
			SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
			FROM	APP_Application A WITH (NOLOCK) INNER JOIN #archGroupIdToProcess AG ON A.dataArchGrpId = AG.archGroupId
						OR (
								A.logArchGrpId = AG.archGroupId
AND A.appTypeId IN (22, 104, 61, 37, 5, 81, 3, 125)
							 )  LEFT OUTER JOIN #tmpGroupApps B ON A.id = B.appId
			WHERE	B.appId IS NULL
			--Get list of subclients associated with storage policy having incremental storage policy configured
			INSERT INTO #tmpGroupApps
			SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
			FROM	APP_Application A WITH (NOLOCK) LEFT OUTER JOIN #tmpGroupApps B ON A.id = B.appId
			INNER JOIN archGroup AG WITH (NOLOCK) ON A.dataArchGrpId = AG.id INNER JOIN #archGroupIdToProcess AGTP ON AG.incrSP = AGTP.archgroupId
			WHERE	B.appId IS NULL
			--Skip DDB subclients\Indexing Subclients
			DELETE #tmpGroupApps
			FROM #tmpGroupApps T, App_SubclientProp A WITH (NOLOCK)
			WHERE 	T.appId = A.componentNameId
				AND		A.attrName IN ('Index SubClient', 'DDB Backup')
				AND		A.attrVal = '1'
				AND		A.modified = 0
			IF @i_operationType = 2
			BEGIN
				--Skip Subclients that does not support deferred catalog
				DELETE #tmpGroupApps
				WHERE dbo.IsDeferredCatalogSupported(appId) = 0
			END
		END
		INSERT INTO #archGroupToAppId
		SELECT	DISTINCT t.archGroupId, B.id
		FROM	#tempArchGroupToApp A , APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, #tmpGroupApps  TGA
		WHERE	A.archGroupId = t.archGroupId AND exclude = 0 AND TGA.appId = B.Id
		AND		 B.clientId = A.clientId AND
			  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
           (A.instanceId = 0 OR A.instanceId = B.instance AND
           (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
           (A.subClientId = 0 OR A.subClientId = B.id))))
		UNION
		SELECT	DISTINCT t.archGroupId, B.id
		FROM	#tempArchGroupToApp A , APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, #tmpGroupApps  TGA
		WHERE	A.archGroupId = t.archGroupId AND exclude = 0 AND TGA.appId = B.Id
		AND 	A.ClientId =  0 AND A.assocType = 2
		UNION
		SELECT	DISTINCT t.archGroupId, B.id
		FROM	#tempArchGroupToApp A , APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, #tmpGroupApps  TGA, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
		WHERE	A.archGroupId = t.archGroupId AND exclude = 0 AND TGA.appId = B.Id
		AND		A.clientId = 0 AND B.clientId = CG.clientID AND (CG.clientGroupId = A.clientGroupId OR (A.clientGroupId = 0 AND A.assocType = 27))
		-- Ideally there shouldn't be any copies in the below condition as we only call this proc if something exists on the SP.
		INSERT INTO #archGroupToAppId
		SELECT	DISTINCT t.archGroupId, B.id
		FROM	APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, #tmpGroupApps  TGA
		WHERE 	NOT EXISTS(SELECT 1 FROM #tempArchGroupToApp A WHERE A.archGroupId = t.archGroupId)
		AND 	TGA.appId = B.id
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		INSERT INTO #archGroupToAppId
		SELECT DISTINCT t.archGroupId, jdl.childAppId
		FROM #archGroupToAppId t, JMJobDataLink jdl WITH (READUNCOMMITTED), #tmpGroupApps  TGA
WHERE jdl.parentAPpId = t.appId AND jdl.linkType IN (7, 8)  AND NOT EXISTS ( SELECT 1 FROM #archGroupToAppId ti WHERE ti.appID = jdl.childAppId AND ti.archGroupId = t.archGroupId )
		AND	  TGA.appId = jdl.childAppId
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA, JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.childAppId = AGA.appid AND jdl.linkType IN (7, 8)
		AND EXISTS
		(
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = jdl.parentAppId AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = jdl.parentAppId AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		IF @bAppsOutTableCretedHere = 1
		BEGIN
			DROP TABLE #tmpGroupApps
		END
	END
	ELSE
	BEGIN
		-- Insert all the VSA parent AppIds
		INSERT INTO #archGroupToAppId
		SELECT DISTINCT t.archGroupId, jdl.parentAppId
		FROM #archGroupToAppId t, JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.childAppId = t.appId AND jdl.linkType IN (7, 8)  AND NOT EXISTS ( SELECT 1 FROM #archGroupToAppId ti WHERE ti.appID = jdl.parentAppId AND ti.archGroupId = t.archGroupId )
		-- remove if none of the parent entities is associated
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA
		WHERE NOT EXISTS
		(
			SELECT	t.archGroupId, B.id
			FROM	#tempArchGroupToApp A WITH (READUNCOMMITTED) , APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 0 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	t.archGroupId, B.id
			FROM	#tempArchGroupToApp A WITH (READUNCOMMITTED) , APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 0 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND (A.ClientId = 0 AND A.assocType = 2)
			UNION
			SELECT	t.archGroupId, B.id
			FROM   #tempArchGroupToApp A WITH (READUNCOMMITTED), APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 0 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND (CG.clientGroupId = A.clientGroupId OR (A.clientGroupId = 0 AND A.assocType = 27))
			UNION
			SELECT	t.archGroupId, B.id
			FROM   APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	 B.id = AGA.appid AND NOT EXISTS (SELECT 1 FROM  #tempArchGroupToApp A WITH (READUNCOMMITTED) WHERE A.archGroupId = t.archGroupId)
		)
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		INSERT INTO #archGroupToAppId
		SELECT DISTINCT t.archGroupId, jdl.childAppId
		FROM #archGroupToAppId t, JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.parentAPpId = t.appId AND jdl.linkType IN (7, 8)  AND NOT EXISTS ( SELECT 1 FROM #archGroupToAppId ti WHERE ti.appID = jdl.childAppId AND ti.archGroupId = t.archGroupId )
		-- should remove excluded entities first then delete if no associations found	so that the left join is on a reduced data set, but we need the exclude to run after the insertion due to VSA links
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = AGA.appid AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		DELETE #archGroupToAppId
		FROM #archGroupToAppId AGA, JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.childAppId = AGA.appid AND jdl.linkType IN (7, 8)
		AND EXISTS
		(
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = jdl.parentAppId AND AGA.archGroupId = t.archGroupId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.archGroupId, B.id
			FROM	#tempArchGroupToApp A, APP_Application B WITH (READUNCOMMITTED), #archGroupIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.archGroupId = t.archGroupId AND exclude = 1 AND B.id = jdl.parentAppId AND AGA.archGroupId = t.archGroupId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
	END
END
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tempArchGroupToApp') IS NOT NULL DROP TABLE #tempArchGroupToApp
	IF @i_AGId <> 0
	BEGIN
		SELECT @isExclusionList = isExclusionList FROM #archGroupIdToProcess WHERE @i_AGId = archGroupId
		IF @bIsAGIdTableCreeatedHere = 1
			IF OBJECT_ID('tempdb.dbo.#archGroupIdToProcess') IS NOT NULL DROP TABLE #archGroupIdToProcess
		RETURN @isExclusionList
	END
	ELSE
		RETURN -1
GO

IF EXISTS (select * from GxQscripts where name = 'archGetArchGroupToAppAssociations')
	delete from GxQscripts where name = 'archGetArchGroupToAppAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetArchGroupToAppAssociations')
	delete from GXDBVersions where aliasname = 'archGetArchGroupToAppAssociations'
GO

insert into GXDBVersions values(2, 'archGetArchGroupToAppAssociations',  '00010001000200100000', 'archGetArchGroupToAppAssociations', '00010001000200100000')
GO

