

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetArchCopyToAppAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetArchCopyToAppAssociations.sp,v $ $Id: archGetArchCopyToAppAssociations.sp,v 1.1.2.11 2020/08/16 22:19:05 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archGetArchCopyToAppAssociations')
BEGIN
	print '>>> Drop Stored Procedure: archGetArchCopyToAppAssociations <<<'
	drop procedure archGetArchCopyToAppAssociations
END
IF EXISTS (select * from GxQscripts where name='archGetArchCopyToAppAssociations')
	delete from GxQscripts where name = 'archGetArchCopyToAppAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetArchCopyToAppAssociations')
	delete from GXDBVersions where aliasname = 'archGetArchCopyToAppAssociations'
GO
print '... Creating Procedure: archGetArchCopyToAppAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archGetArchCopyToAppAssociations
  @i_copyId INTEGER,
  @i_inputXML varchar(MAX) = ''
AS
/* -Caller needs to create this table for storing the output.
	CREATE TABLE #archCopyToAppId (
	copyId			INTEGER,
	AppId				INTEGER
	)
	CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
*/
/* -Caller needs to create this table for giving multiple storage policies as input, make sure if the caller is creating this table then the input agID is 0
   - also isExclusionList and srcCopyId is populated inside this proc, caller needs to insert copy only.
	CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0)
	primary key 	(copyId)
	)
*/
IF OBJECT_ID('tempdb.dbo.#tempArchCopyToApp') IS NOT NULL DROP TABLE #tempArchCopyToApp
CREATE TABLE #tempArchCopyToApp (
	copyId		INTEGER,
	clientId 	INTEGER,
	appTypeId 	INTEGER,
	instanceId 	INTEGER,
	backupSetId INTEGER,
	subClientId INTEGER,
	clientGroupId INTEGER,
	exclude INTEGER,
	assocType INTEGER
)
CREATE CLUSTERED INDEX tempArchCopyToApp_CopyId_ClientId_AssocType_ClientGroupId on #tempArchCopyToApp (copyId, clientId, AssocType, ClientGroupId)
DECLARE @bIsCopyIdTableCreeatedHere BIT = 0
DECLARE @isExclusionList BIT = 0
DECLARE @bAppsOutTableCretedHere BIT = 0
if @i_copyId <> 0
BEGIN
	IF object_id('tempdb.dbo.#copyIdToProcess') is null
	BEGIN
		CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList BIT DEFAULT(0), srcCopyId INTEGER DEFAULT(0)
		primary key 	(copyId)
		)
		SET @bIsCopyIdTableCreeatedHere = 1
	END
	IF NOT EXISTS (SELECT 1 FROM  #copyIdToProcess WHERE copyId = @i_copyId)
		INSERT INTO #copyIdToProcess (copyId) values(@i_copyId)
END
ELSE IF object_id('tempdb.dbo.#copyIdToProcess') is null
	 OR NOT EXISTS (SELECT 1 FROM #copyIdToProcess) -- caller did not populate the input table neither it sent an copy
BEGIN
	--SELECT -1,-1,-1
	GOTO CX_EXIT
END
IF @i_inputXML <> ''
BEGIN
	DECLARE @i_xmlStr XML = convert(XML,@i_inputXML)
	INSERT INTO #tempArchCopyToApp
	SELECT
		t.copyId,
		ISNULL((doc.col.value('@clientId', 'INT')),0),
		ISNULL((doc.col.value('@applicationId', 'INT')),0),
		ISNULL((doc.col.value('@instanceId', 'INT')),0),
		ISNULL((doc.col.value('@backupsetId', 'INT')),0),
		ISNULL((doc.col.value('@subclientId', 'INT')),0),
		ISNULL((doc.col.value('@clientGroupId', 'INT')),0),
		ISNULL((doc.col.value(N'(flags/@exclude)[1]', N'int')),0),
		ISNULL((doc.col.value('@_type_', 'INT')),0)
	FROM @i_xmlStr.nodes('//listEntities') doc(col), #copyIdToProcess t
	IF @@ROWCOUNT = 0 -- for no association in edit tab, we shaould still show the preview of what is selected
		INSERT INTO #tempArchCopyToApp
		SELECT
			t.copyId, 0,0,0,0,0,0,0,-1
		FROM  #copyIdToProcess t
END
ELSE
BEGIN
	INSERT INTO #tempArchCopyToApp
	SELECT A.*
	FROM archCopyToApp A WITH (READUNCOMMITTED), #copyIdToProcess t
	WHERE A.copyId = t.copyId
END
IF object_id('tempdb.dbo.#archCopyToAppId') IS NOT NULL
BEGIN
	IF NOT EXISTS (SELECT 1 FROM #archCopyToAppId)		-- no pre-populated rows
	BEGIN
		-- we need to pick only entities associated to the storage policy because of bug with VSA parent child linkages
		IF object_id('tempdb.dbo.#tmpCopyApps') is null -- if null then create and destroy the table here. THis table would already be created and populated when the proc is called from archCopyAppSubset or archCopyAppSubsetForGuI
		BEGIN
			SET @bAppsOutTableCretedHere = 1
			CREATE TABLE #tmpCopyApps (id int, clientId int, appTypeId int, instance int, backupSet int, subclientName nvarchar(512), isSelected int)
			DECLARE @l_archGroupId INTEGER
			SELECT @l_archGroupId = archGroupID
			FROM archGroupCopy where id IN (SELECT TOP (1) copyId FROM #copyIdToProcess )
--
-- BEGIN: archCopyToAppGetAGApps.spb
--
		INSERT INTO #tmpCopyApps
		SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
		FROM	APP_Application A WITH (READUNCOMMITTED)
		WHERE 	EXISTS (SELECT TOP 1 1 FROM JMJobDatastats JDS WITH (READUNCOMMITTED) WHERE archGrpId = @l_archGroupId
					AND status IN (100, 101, 102, 103) AND (disabled & (1 + 256)) = 0 AND A.id = JDS.appId )
		CREATE INDEX tmpCopyApps_idx1 ON #tmpCopyApps (id)
		INSERT INTO #tmpCopyApps
		SELECT	DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
		FROM	APP_Application A WITH (READUNCOMMITTED) LEFT OUTER JOIN #tmpCopyApps B ON A.id = B.id
		WHERE	B.id IS Null
AND (A.dataArchGrpId = @l_archGroupId or (A.logArchGrpId = @l_archGroupId AND A.appTypeId in (22, 104, 61, 37, 5, 81, 3, 125)) )
AND A.appTypeId <> 1030
		INSERT INTO #tmpCopyApps
		SELECT	DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.backupSet, A.subclientName, 0
FROM	APP_Application A WITH (READUNCOMMITTED) INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON (A.dataArchGrpId = AG.Id or (A.logArchGrpId = AG.Id AND A.appTypeId in (22, 104, 61, 37, 5, 81, 3, 125)) ) LEFT OUTER JOIN #tmpCopyApps B ON A.id = B.id
		WHERE	B.id IS Null
			AND AG.incrSP = @l_archGroupId
AND A.appTypeId <> 1030
--
-- END: archCopyToAppGetAGApps.spb
--
		END
		-- this query inserting the associated entities when the exclusion list is disabled
		INSERT INTO #archCopyToAppId
		SELECT	DISTINCT t.copyId, B.id
		FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, #tmpCopyApps TCA
		WHERE	A.copyId = t.CopyId AND exclude = 0
		AND		 B.clientId = A.clientId AND
			  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
           (A.instanceId = 0 OR A.instanceId = B.instance AND
           (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
           (A.subClientId = 0 OR A.subClientId = B.id))))
		AND B.id = TCA.id
		UNION
		SELECT	DISTINCT t.CopyId, B.id
		FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, #tmpCopyApps TCA
		WHERE	A.copyId = t.CopyId AND exclude = 0
		AND 	(A.ClientId = 0 AND A.assocType = 2)
		AND 	B.id = TCA.id
		UNION
		SELECT	DISTINCT t.CopyId, B.id
		FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, #tmpCopyApps TCA, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
		WHERE	A.copyId = t.CopyId AND exclude = 0
		AND		A.clientId = 0 AND B.clientId = CG.clientID AND (CG.clientGroupId = A.clientGroupId OR (A.clientGroupId = 0 AND A.assocType = 27))
		AND B.id = TCA.id
		-- Ideally there shouldn't be any copies in the below condition as we only call this proc if something exists on the copy.
		INSERT INTO #archCopyToAppId
		SELECT	DISTINCT t.copyId, B.id
		FROM	APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, #tmpCopyApps TCA
		WHERE 	NOT EXISTS(SELECT 1 FROM #tempArchCopyToApp A WHERE A.copyId = t.copyId)
				AND B.id = TCA.id
		DELETE #archCopyToAppId
		FROM #archCopyToAppId ACA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.copyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		INSERT INTO #archCopyToAppId
		SELECT DISTINCT t.copyId, jdl.childAppId
		FROM #archCopyToAppId t, JMJobDataLink jdl WITH (READUNCOMMITTED), #tmpCopyApps TCA
WHERE jdl.parentAPpId = t.appId AND jdl.linkType IN (7, 8)  AND NOT EXISTS ( SELECT 1 FROM #archCopyToAppId ti WHERE ti.appID = jdl.childAppId AND ti.copyId = t.copyId )
		AND jdl.childAppId = TCA.id
		DELETE #archCopyToAppId
		FROM #archCopyToAppId ACA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.copyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		--excluded VSA clients should force exclusion on thier Child VMs too
		DELETE #archCopyToAppId
		FROM #archCopyToAppId ACA , JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.childAppId = ACA.appid AND jdl.linkType IN (7, 8)
		AND EXISTS
		(
			SELECT	DISTINCT t.copyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = jdl.parentAppId  AND ACA.copyId = t.copyId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = jdl.parentAppId AND ACA.copyId = t.copyId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		IF @bAppsOutTableCretedHere = 1
		BEGIN
			DROP TABLE #tmpCopyApps
		END
	END
	ELSE
	BEGIN
		-- Insert all the VSA parent AppIds
		INSERT INTO #archCopyToAppId
		SELECT DISTINCT t.copyId, jdl.parentAPpId
		FROM #archCopyToAppId t, JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.childAppId = t.appId AND jdl.linkType IN (7, 8)  AND NOT EXISTS ( SELECT 1 FROM #archCopyToAppId ti WHERE ti.appID = jdl.parentAPpId AND ti.copyId = t.copyId )
		-- remove if none of the parent entities is associated
		DELETE #archCopyToAppId
		FROM #archCopyToAppId ACA
		WHERE NOT EXISTS
		(
			SELECT	DISTINCT t.copyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 0 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 0 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND (A.clientId = 0 AND A.assocType = 2)
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.copyId = t.CopyId AND exclude = 0 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND (CG.clientGroupId = A.clientGroupId OR (A.clientGroupId = 0 AND A.assocType = 27))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	B.id = ACA.appid AND ACA.copyId = t.copyId
			AND 	NOT EXISTS (SELECT 1 FROM #tempArchCopyToApp A WHERE A.copyId = t.CopyId)
		)
		INSERT INTO #archCopyToAppId
		SELECT DISTINCT t.copyId, jdl.childAppId
		FROM #archCopyToAppId t, JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.parentAPpId = t.appId AND jdl.linkType IN (7, 8)  AND NOT EXISTS ( SELECT 1 FROM #archCopyToAppId ti WHERE ti.appID = jdl.childAppId AND ti.copyId = t.copyId )
		-- should remove excluded entities first then delete if no associations found	so that the left join is on a reduced data set, but we need the exclude to run after the insertion due to VSA links
		DELETE #archCopyToAppId
		FROM #archCopyToAppId ACA
		WHERE EXISTS
		(
			SELECT	DISTINCT t.copyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = ACA.appid AND ACA.copyId = t.copyId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
		--excluded VSA clients should force exclusion on thier Child VMs too
		DELETE #archCopyToAppId
		FROM #archCopyToAppId ACA , JMJobDataLink jdl WITH (READUNCOMMITTED)
WHERE jdl.childAppId = ACA.appid AND jdl.linkType IN (7, 8)
		AND EXISTS
		(
			SELECT	DISTINCT t.copyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = jdl.parentAppId AND ACA.copyId = t.copyId
			AND		 B.clientId = A.clientId AND
				  (A.appTypeId = 0 OR A.appTypeId = B.appTypeId AND
			   (A.instanceId = 0 OR A.instanceId = B.instance AND
			   (A.backupSetId = 0 OR A.backupSetId = B.backupSet AND
			   (A.subClientId = 0 OR A.subClientId = B.id))))
			UNION
			SELECT	DISTINCT t.CopyId, B.id
			FROM	#tempArchCopyToApp A, APP_Application B WITH (READUNCOMMITTED), #copyIdToProcess t, APP_ClientGroupAssoc CG WITH (READUNCOMMITTED)
			WHERE	A.copyId = t.CopyId AND exclude = 1 AND B.id = jdl.parentAppId AND ACA.copyId = t.copyId
			AND		A.clientId = 0 AND B.clientId = CG.clientID AND CG.clientGroupId = A.clientGroupId
		)
	END
END
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tempArchCopyToApp') IS NOT NULL DROP TABLE #tempArchCopyToApp
	IF @i_copyId <> 0
	BEGIN
		SELECT @isExclusionList = isExclusionList FROM #copyIdToProcess WHERE @i_copyId = copyId
		IF @bIsCopyIdTableCreeatedHere = 1
			IF OBJECT_ID('tempdb.dbo.#copyIdToProcess') IS NOT NULL DROP TABLE #copyIdToProcess
		RETURN @isExclusionList
	END
	ELSE
		RETURN -1
GO

IF EXISTS (select * from GxQscripts where name = 'archGetArchCopyToAppAssociations')
	delete from GxQscripts where name = 'archGetArchCopyToAppAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetArchCopyToAppAssociations')
	delete from GXDBVersions where aliasname = 'archGetArchCopyToAppAssociations'
GO

insert into GXDBVersions values(2, 'archGetArchCopyToAppAssociations',  '00010001000200110000', 'archGetArchCopyToAppAssociations', '00010001000200110000')
GO

