

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetAllocatedStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetAllocatedStream.sp,v $ $Id: archGetAllocatedStream.sp,v 1.9.2.14 2020/12/12 03:37:44 cliu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archGetAllocatedStream')
BEGIN
	print '>>> Drop Stored Procedure: archGetAllocatedStream <<<'
	drop procedure archGetAllocatedStream
END
IF EXISTS (select * from GxQscripts where name='archGetAllocatedStream')
	delete from GxQscripts where name = 'archGetAllocatedStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetAllocatedStream')
	delete from GXDBVersions where aliasname = 'archGetAllocatedStream'
GO
print '... Creating Procedure: archGetAllocatedStream'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archGetAllocatedStream
  @i_jobId integer,
  @i_copyId integer,
  @i_clientToken integer,
  @i_streamReaderId integer = 0,
  @i_clientId integer = 0,
  @i_isCoreMAOverrideApplicable integer = 0,
  @i_streamNum integer = 0,
  @i_skipInUse integer = 0
AS
  DECLARE @o_ArchGroupId integer
  DECLARE @o_CopyId integer
  DECLARE @o_StreamId integer
  DECLARE @o_RCID integer
  DECLARE @o_ReservationId integer
  DECLARE @o_VolumeId integer
  DECLARE @o_MediaId integer
  DECLARE @o_DriveId integer
  DECLARE @o_MediaAgentId integer
  DECLARE @o_DrivePoolId integer
  DECLARE @o_DrivePoolType integer
  DECLARE @o_MasterPoolId integer
  DECLARE @o_MediaGroupId integer
  DECLARE @o_LibraryId integer
  DECLARE @o_HWCompressed integer
  DECLARE @o_HostAttribute integer
  DECLARE @o_MediaAgentName char(255)
  DECLARE @o_LibraryName char(255)
  DECLARE @o_SIDBStoreId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_RCID = 0
IF (@i_isCoreMAOverrideApplicable > 0)
BEGIN
	SELECT	@o_CopyId = id,
			@o_ArchGroupId = archGroupId
	FROM	archGroupCopy AGC WITH (NOLOCK)
	WHERE	AGC.id = @i_copyId
	SELECT	@o_MediaGroupId = mediaGroupId
	FROm	archStream S
	WHERE	S.archGroupCopyId = @i_copyId
			AND S.Stream = @i_streamNum
	SELECT	TOP 1 @o_DrivePoolId = DP.DrivePoolId,
			@o_HWCompressed = IsHardwareCompressed
	FROM	MMDataPath	DP WITH (NOLOCK)
	WHERE	DP.CopyId = @o_CopyId
			-- TO DO - Add default datapath selection here
	SELECT	@o_MediaAgentId = ClientId,
			@o_DrivePoolType = DrivePoolType,
			@o_MasterPoolId = MasterPoolId
	FROM	MMDrivePool DP WITH (NOLOCK)
	WHERE	DP.DrivePoolId = @o_DrivePoolId
	SELECT	@o_HostAttribute = Attribute
	FROM	MMHost H
	WHERE	H.ClientId = @o_MediaAgentId
	SELECT	@o_MediaAgentName = net_hostname
	FROM	APP_Client WITH (NOLOCK)
	WHERE	id = @o_MediaAgentId
	SELECT	@o_LibraryId = L.LibraryId,
			@o_LibraryName = AliasName
	FROM	MMMasterPool MP WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
	WHERE	MP.MasterPoolId	= @o_MasterPoolId
			AND MP.LibraryId = L.LibraryId
	SELECT	@o_StreamId = @i_streamNum,
			@o_RCID	= 0,
			@o_ReservationId = 0,
			@o_VolumeId = 0,
			@o_MediaId = 0,
			@o_DriveId = 0
	SELECT	@o_ArchGroupId,
			@o_CopyId,
			@o_StreamId,
			@o_RCID,
			@o_ReservationId,
			@o_VolumeId,
			@o_MediaId,
			@o_DriveId,
			@o_MediaAgentId,
			@o_DrivePoolId,
			@o_DrivePoolType,
			@o_MasterPoolId,
			@o_MediaGroupId,
			@o_LibraryId,
(CASE WHEN @o_DrivePoolType = 10001 THEN 0 ELSE @o_HWCompressed END),
			@o_HostAttribute,
			@o_MediaAgentName,
			@o_LibraryName,
			0 AS SIDBStoreId
	RETURN
END
ELSE IF (@i_streamReaderId = 0)
BEGIN
	DECLARE @pendingReleaseRCIdList TABLE (ReservationId int, RCId int)
	-- If there is pending reservation release request, make sure the selected reservation will not be released later
	IF EXISTS (SELECT RequestId FROM RMReservationRequest WITH (NOLOCK)
				WHERE JobId = @i_jobId
AND		RequestCategory in (0)
				AND		ErrorCode = -1
			)
	BEGIN
		INSERT INTO @pendingReleaseRCIdList
		SELECT DISTINCT ISNULL(params.value('@reservationId', 'int'), 0) as ReservationId,
						ISNULL(params.value('@RCID', 'int'), 0) as RCId
		FROM (
				SELECT  CAST (xmlParams AS xml) AS xmlParams
				FROM	RMReservationRequest WITH (NOLOCK)
				WHERE	JobId = @i_jobId
AND		RequestCategory in (0)
				AND		ErrorCode = -1
			) A
		CROSS APPLY xmlParams.nodes('/ResourceManager_RmReleaseJobStreamsArgs_t[1]') AS R(params)
	END
	-- Excluside the reservations created but haven't return yet
	IF EXISTS (SELECT RequestId FROM  RMReservationRequest WITH (NOLOCK)
				WHERE JobId = @i_jobId
AND		RequestCategory in (2,8)
				AND		RequestTime != -1
				AND		ErrorCode = 0)
	BEGIN
		INSERT INTO @pendingReleaseRCIdList
		SELECT	DISTINCT b.ReservationId, b.RCId
		FROM	RMReservationRequest a WITH (NOLOCK), RMReservations b WITH (NOLOCK)
		WHERE	a.JobId = @i_jobId
AND		a.RequestCategory in (2,8)
		AND		a.RequestTime != -1
		AND		a.ErrorCode = 0
		AND		a.RequestId = b.RequestId
	END
	SELECT	TOP 1 @o_RCID		= A.RCID,
			@o_ReservationId	= B.ReservationId,
			@o_VolumeId			= B.VolumeId,
			@o_MediaId			= B.MediaId,
			@o_DriveId			= B.DriveId,
			@o_DrivePoolId		= B.DrivePoolId,
			@o_MediaGroupId		= B.MediaGroupId,
			@o_CopyId			= B.CopyId
	FROM	MMResourceToJob A WITH (NOLOCK), MMResource B WITH (NOLOCK)
	WHERE	B.ReservationId = A.ReservationId
		AND A.JobId_l = @i_jobId
		AND (@i_skipInUse = 1 OR A.InUse = 0)
		AND (@i_clientToken = 0 OR A.ClientTokenId = @i_clientToken)
		AND (@i_copyId = 0 OR B.CopyId = @i_copyId)
		AND (HasJobInterrupted = 0 AND IntrJobId_l = 0)
	ORDER BY CASE WHEN EXISTS (SELECT 1 FROM @pendingReleaseRCIdList WHERE ReservationId = A.ReservationId OR RCId = A.RCId) THEN 1 ELSE 0 END,
sign(A.ReleaseTime), (A.ReserveBitMask & 1/*RM_JM_RESERVED*/) desc,
			CASE WHEN @i_clientId > 0 AND @i_clientId = B.ClientId THEN 0 ELSE 1 END,
			A.ReleaseTime, B.ReservationTime desc, A.RCID desc
END
ELSE -- Match the Stream Reader in ArchJobStream Status table and get the corresponding Resource Information
BEGIN
	SELECT	TOP 1 @o_RCID		= A.RCID,
			@o_ReservationId	= B.ReservationId,
			@o_VolumeId			= B.VolumeId,
			@o_MediaId			= B.MediaId,
			@o_DriveId			= B.DriveId,
			@o_DrivePoolId		= B.DrivePoolId,
			@o_MediaGroupId		= B.MediaGroupId,
			@o_CopyId			= B.CopyId
	FROM	MMResourceToJob A WITH (NOLOCK), MMResource B WITH (NOLOCK), ArchJobStreamStatus S WITH (NOLOCK)
	WHERE	B.ReservationId = A.ReservationId
		AND A.JobId_l = @i_jobId
		AND A.InUse = 0
		AND (@i_clientToken = 0 OR A.ClientTokenId = @i_clientToken)
		AND (@i_copyId = 0 OR B.CopyId = @i_copyId)
		AND S.JobId = @i_jobId
		AND S.StreamReaderId = @i_streamReaderId
		AND S.DestCopyId = @i_copyId
		AND S.DestRCId = A.RCID
	ORDER BY A.ReleaseTime, B.ReservationTime desc, A.RCID desc
END
IF @o_RCID <> 0
BEGIN
	UPDATE	MMResourceToJob
	SET		InUse = 1, ReleaseTime = 0
	WHERE	RCID = @o_RCID
	SELECT	@o_DrivePoolType	= DrivePoolType,
			@o_MasterPoolId		= MasterPoolId,
			@o_MediaAgentId		= ClientId
	FROM	MMDrivePool WITH (NOLOCK)
	WHERE	DrivePoolId = @o_DrivePoolId
	SELECT	@o_LibraryId		= LibraryId
	FROM	MMMasterPool WITH (NOLOCK)
	WHERE	MasterPoolId = @o_MasterPoolId
	DECLARE @SpareGroupId 	int
	SET @SpareGroupId = 0
	SELECT	@SpareGroupId = SpareGroupId
	FROM	MMMedia WITH (NOLOCK)
	WHERE	MediaId = @o_MediaId
	SELECT	(select archGroupId from archGroupCopy where id = @o_CopyId),
			@o_CopyId,
			(select Stream from archStream where archGroupCopyId = @o_CopyId and mediaGroupId = @o_MediaGroupId),
			@o_RCID,
			@o_ReservationId,
			@o_VolumeId,
			@o_MediaId,
			@o_DriveId,
			@o_MediaAgentId,
			@o_DrivePoolId,
			@o_DrivePoolType,
			@o_MasterPoolId,
			@o_MediaGroupId,
			@o_LibraryId,
			(SELECT	TOP 1
(CASE WHEN @o_DrivePoolType = 10001 THEN 0 ELSE IsHardwareCompressed END)
				FROM MMDataPath WITH (NOLOCK) WHERE CopyId = @o_CopyId AND DrivePoolId = @o_DrivePoolId AND (@SpareGroupId = 0 OR SpareGroupId = @SpareGroupId)),
			(SELECT Attribute FROM MMHost WITH (NOLOCK) WHERE ClientId = @o_MediaAgentId),
			(SELECT net_hostname FROM APP_Client WITH (NOLOCK) WHERE id = @o_MediaAgentId),
			(SELECT AliasName FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = @o_LibraryId),
			(SELECT SIDBStoreId FROM MMVolume WITH(READUNCOMMITTED) WHERE VolumeId = @o_VolumeId) AS SIDBStoreId
	--FROM	archStream S WITH (NOLOCK)
	--WHERE	S.mediaGroupId = @o_MediaGroupId
END
ELSE
	SELECT	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', 0
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archGetAllocatedStream')
	delete from GxQscripts where name = 'archGetAllocatedStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetAllocatedStream')
	delete from GXDBVersions where aliasname = 'archGetAllocatedStream'
GO

insert into GXDBVersions values(2, 'archGetAllocatedStream',  '00010009000200140000', 'archGetAllocatedStream', '00010009000200140000')
GO

