

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archGetAFAndChunkList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archGetAFAndChunkList.sp,v $ $Id: archGetAFAndChunkList.sp,v 1.3.208.1 2018/03/20 00:07:02 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archGetAFAndChunkList <<<'

IF EXISTS (select * from sysobjects where name='archGetAFAndChunkList')
	drop procedure archGetAFAndChunkList
IF EXISTS (select * from GxQscripts where name='archGetAFAndChunkList')
	delete from GxQscripts where name = 'archGetAFAndChunkList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetAFAndChunkList')
	delete from GXDBVersions where aliasname = 'archGetAFAndChunkList'
GO
print '... Creating Procedure: archGetAFAndChunkList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archGetAFAndChunkList
  @i_copyId INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SIDBStoreId INTEGER 
  DECLARE @o_mountPathId INTEGER 
  DECLARE @o_VolumeId INTEGER 
  DECLARE @o_archChunkId BIGINT 
  DECLARE @o_archFileId INTEGER 
  DECLARE @o_LastAccessTime INTEGER
	SET NOCOUNT ON
	DECLARE 	@commCellId 	INTEGER
	SET 			@commCellId		= 0
	DECLARE @errorCode			INTEGER
	SET			@errorCode			= 0
	IF object_id('tempdb.dbo.#archFileAndChunkList') is not null DROP TABLE #archFileAndChunkList
	CREATE	TABLE #archFileAndChunkList (
		SIDBStoreId 	INTEGER,
		mountPathId		INTEGER,
		VolumeId			INTEGER,
		archChunkId 	BIGINT,
		archFileId 		INTEGER,
		LastAccessTime	INTEGER
	)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @commCellId = CASE origCCcommCellId WHEN 0 THEN 2 ELSE origCCcommCellId END
	FROM archGroupCopy WITH (NOLOCK)
	WHERE id = @i_copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all archFile and archChunk list for given copyId
	INSERT INTO #archFileAndChunkList
	SELECT 0, 0, AC.volumeId, ACM.archChunkId, ACM.archFileId, 0
	FROM archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
	WHERE ACM.archChunkId = AC.id
	AND		ACM.chunkCommCellId = AC.commCellId
	AND		ACM.archCopyId = @i_copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #archFileAndChunkList
	SET SIDBStoreId = V.SIDBStoreId,
			mountPathId = MP.mountPathId
	FROM #archFileAndChunkList AFC, MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE AFC.volumeId = V.volumeId
	AND		V.mediaSideId = MP.mediaSideId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #archFileAndChunkList
	SET LastAccessTime = S.LastAccessTime
	FROM #archFileAndChunkList AFC, IDXSIDBStore S WITH (NOLOCK)
	WHERE AFC.SIDBStoreId = S.SIDBStoreId
	AND	  S.commCellId  =  @commCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT AFC.SIDBStoreId, AFC.mountPathId, AFC.VolumeId, AFC.archChunkId, AFC.archFileId, AFC.LastAccessTime
	FROM   #archFileAndChunkList AFC
	ORDER BY AFC.SIDBStoreId, AFC.mountPathId, AFC.VolumeId, AFC.archChunkId, AFC.archFileId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF object_id('tempdb.dbo.#archFileAndChunkList') is not null DROP TABLE #archFileAndChunkList
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archGetAFAndChunkList')
	delete from GxQscripts where name = 'archGetAFAndChunkList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archGetAFAndChunkList')
	delete from GXDBVersions where aliasname = 'archGetAFAndChunkList'
GO

insert into GXDBVersions values(2, 'archGetAFAndChunkList',  '00010003020800010000', 'archGetAFAndChunkList', '00010003020800010000')
GO

