

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFullCycleByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFullCycleByJob.sp,v $ $Id: archFullCycleByJob.sp,v 1.9.46.7 2019/07/18 16:01:35 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFullCycleByJob')
BEGIN
	print '>>> Drop Stored Procedure: archFullCycleByJob <<<'
	drop procedure archFullCycleByJob
END
IF EXISTS (select * from GxQscripts where name='archFullCycleByJob')
	delete from GxQscripts where name = 'archFullCycleByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFullCycleByJob')
	delete from GXDBVersions where aliasname = 'archFullCycleByJob'
GO
print '... Creating Procedure: archFullCycleByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFullCycleByJob
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @o_jobId INTEGER
  DECLARE @o_commCellId INTEGER
  DECLARE @o_appId INTEGER
  DECLARE @o_appTypeId INTEGER
  DECLARE @o_opType INTEGER
  DECLARE @o_backupLevel INTEGER
  DECLARE @o_attributes BIGINT
  DECLARE @o_startDate INTEGER
  DECLARE @o_endDate INTEGER
  DECLARE @o_sizeOfApp BIGINT
  DECLARE @o_sizeOnMedia BIGINT
  DECLARE @o_status INTEGER
  DECLARE @o_disabled INTEGER
  DECLARE @o_flags INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblJobs TABLE (
		jobId INT, commCellId INT, appId INT, appType INT, optype INT, backupLevel INT, attributes BIGINT,
		startDate INT, endDate INT, sizeOfApp BIGINT, sizeOnMedia BIGINT, status INT, disabled INT, flags INT)
DECLARE	@tblCopyCount TABLE (
		jobId INT, commCellId INT, dataType INT, copyCount INT)
INSERT	INTO @tblJobs
SELECT	jobId, commCellId, appID, 1000, optype, 0, ER_BkpLevel, servStart, servEnd,
		(case when TotalSize > 0 then TotalSize else totalBackupSize end), 0, 0, 0, 0
FROM	JMAdminJobStatsTable WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
IF @@ROWCOUNT = 0
BEGIN
	DECLARE @appId		INT
	DECLARE @fullCycleNum INT
	DECLARE @lastCycleNum	INT
	DECLARE @bkpAttributesEx	BIGINT
	SELECT	@appId = appId,
			@fullCycleNum = fullCycleNum,
			@bkpAttributesEx = bkpAttributesEx
	FROM	JMBkpStats WITH (NOLOCK)
	WHERE	jobId = @i_jobId
	AND		commCellId = @i_commCellId
	INSERT	INTO @tblJobs
	SELECT	jobId, commCellId, appId, appType, opType, bkpLevel, bkpAttributes, servStartDate, servEndDate, totalUncompBytes, 0, 0, 0, 0
	FROM	JMBkpStats JBKP WITH (NOLOCK)
	WHERE	appId = @appId
	AND		status IN (1, 3, 14)
	AND		fullCycleNum = @fullCycleNum
	AND		EXISTS (SELECT 1 FROM archFile WITH (NOLOCK)
						WHERE	jobId = JBKP.jobId
						AND		commCellId = JBKP.commCellId)
	SELECT @lastCycleNum = MAX(fullCycleNum)
	FROM JMBkpStats WITH (NOLOCK)
	WHERE appId = @appId
	AND status IN ( 1, 3, 14)
	AND bkpLevel IN ( 1, 64, 128, 1024, 32768)
	IF	@fullCycleNum = @lastCycleNum
		UPDATE	@tblJobs
SET	flags = (flags | 2)
	INSERT	INTO @tblJobs
	SELECT	BKP.jobId, BKP.commCellId, BKP.appId, BKP.appType, BKP.opType, BKP.bkpLevel, BKP.bkpAttributes,
			BKP.servStartDate, BKP.servEndDate, BKP.totalUncompBytes, 0, 0, 0, 0
	FROM	JMBkpStats BKP WITH (NOLOCK),
			(SELECT	A.childJobId, A.commCellId
			FROM	JMJobDataLinkViewForDA A WITH (NOLOCK), @tblJobs B
			WHERE 	A.parentJobId = B.jobId
			AND		A.commCellId = B.commCellId ) JDL
	WHERE	BKP.jobId = JDL.childJobId
	AND		BKP.commCellId = JDL.commCellId
	AND		BKP.status IN ( 1, 3, 14)
	AND		EXISTS ( SELECT 1 FROM archFile WITH (NOLOCK)
					WHERE jobId = BKP.jobId
					AND commCellId = BKP.commCellId)
	AND		NOT EXISTS (SELECT * FROM @tblJobs
						WHERE jobId = JDL.childJobId
						AND commCellId = JDL.commCellId)
IF @bkpAttributesEx & 0x40000  > 0
	BEGIN
		INSERT	INTO @tblJobs
		SELECT	JBKP.jobId, JBKP.commCellId, JBKP.appId, JBKP.appType, JBKP.opType, JBKP.bkpLevel, JBKP.bkpAttributes, JBKP.servStartDate, JBKP.servEndDate, JBKP.totalUncompBytes, 0, 0, 0, 0
		FROM	JMBkpStats JBKP WITH (NOLOCK), JMVSAAppJobLink VSA WITH (NOLOCK), @tblJobs t
		WHERE VSA.childJobId = JBKP.jobId AND VSA.commCellId = JBKP.commCellId
		AND VSA.parentJobId = t.jobId AND VSA.commCellId = t.commCellId
	END
END
IF @i_copyId = 0
	SELECT	jobId, commCellId, appId, appType, opType, backupLevel, attributes,
			startDate, endDate, sizeOfApp, sizeOnMedia,	status, disabled, flags
	FROM	@tblJobs
	ORDER BY startDate ASC
ELSE
BEGIN
	UPDATE	@tblJobs
	SET		status	= (case when (B.minStatus = 100 and B.maxStatus = 101) then 103 else B.maxStatus end),
			disabled= B.disabled, sizeOnMedia = B.sizeOnMedia
	FROM	@tblJobs A,
			(SELECT	J.jobId, J.commCellId,
					MIN(J.status) AS minStatus, MAX(J.status) AS maxStatus, MAX(J.disabled) AS disabled, SUM(J.sizeOnMedia) AS sizeOnMedia
			FROM	@tblJobs T, JMJobDataStats J WITH (NOLOCK)
			WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = @i_copyId
AND (J.disabled & 256) = 0
			GROUP BY J.jobId, J.commCellId) B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
	IF	EXISTS (SELECT * FROM archGroup WHERE defaultCopy = @i_copyId AND defaultSnapCopy > 0)
		UPDATE	@tblJobs SET status = 101
		WHERE	status = 0
	ELSE
		DELETE	@tblJobs
		WHERE	status = 0
	INSERT	INTO @tblCopyCount
	SELECT	J.jobId, J.commCellId, J.dataType, COUNT(DISTINCT J.archGrpCopyId)
	FROM	@tblJobs T, JMJobDataStats J WITH (NOLOCK)
WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.status = 100 AND (J.disabled & 256) = 0
	GROUP BY J.jobId, J.commCellId, J.dataType
	UPDATE	@tblJobs
SET		flags = (flags | 1)
	FROM	@tblJobs A, (SELECT	jobId, commCellId, MIN(copyCount) AS copyCount FROM @tblCopyCount GROUP BY jobId, commCellId) B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.copyCount <= 1
	SELECT	jobId, commCellId, appId, appType, opType, backupLevel, attributes, startDate, endDate,
			sizeOfApp, sizeOnMedia, status, disabled, flags
	FROM	@tblJobs
	ORDER BY startDate ASC
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFullCycleByJob')
	delete from GxQscripts where name = 'archFullCycleByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFullCycleByJob')
	delete from GXDBVersions where aliasname = 'archFullCycleByJob'
GO

insert into GXDBVersions values(2, 'archFullCycleByJob',  '00010009004600070000', 'archFullCycleByJob', '00010009004600070000')
GO

