

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFreePipeUseCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFreePipeUseCount <<<'

IF EXISTS (select * from sysobjects where name='archFreePipeUseCount')
	drop procedure archFreePipeUseCount
IF EXISTS (select * from GxQscripts where name='archFreePipeUseCount')
	delete from GxQscripts where name = 'archFreePipeUseCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFreePipeUseCount')
	delete from GXDBVersions where aliasname = 'archFreePipeUseCount'
GO
print '... Creating Procedure: archFreePipeUseCount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFreePipeUseCount
  @i_interface1 CHAR(255),
  @i_interface2 CHAR(255),
  @i_jobId INTEGER,
  @i_commCellId INTEGER
AS
  DECLARE @retVal INTEGER	
SET NOCOUNT ON
DECLARE @plId    INTEGER = 0
DECLARE @rc      INTEGER = 0
SET @plId = ISNULL((SELECT TOP 1 id FROM archPipeline WITH (READUNCOMMITTED)
             WHERE  (srcInterface = @i_interface1 AND destInterface = @i_interface2)
                 OR (destInterface = @i_interface1 AND srcInterface = @i_interface2)), 0)
IF @plId <> 0
BEGIN
   -- Update the usage count of the DIP for the jobId.
   UPDATE archPipelineJobList
   SET count = count - 1
   WHERE id = @plId AND jobId = @i_jobId AND commCellId = @i_commCellId
   IF ((SELECT count FROM archPipelineJobList WITH (READUNCOMMITTED) WHERE id = @plId AND jobId = @i_jobId AND commCellId = @i_commCellId) = 0)
   BEGIN
	   DELETE archPipelineJobList
	   WHERE  id = @plId AND jobId = @i_jobId AND commCellId = @i_commCellId
   END
END
ELSE
BEGIN
   -- pipelineId not found. Probably the DIP has been deleted. We do not need to track usage against it now.
   DELETE archPipelineJobList
   WHERE jobId = @i_jobId AND commCellId = @i_commCellId
END
SELECT @@ERROR
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archFreePipeUseCount')
	delete from GxQscripts where name = 'archFreePipeUseCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFreePipeUseCount')
	delete from GXDBVersions where aliasname = 'archFreePipeUseCount'
GO

insert into GXDBVersions values(2, 'archFreePipeUseCount',  '00000000000000000000', 'archFreePipeUseCount', '00000000000000000000')
GO

