

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSubStoreVerify.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSubStoreVerify.sp,v $ $Id: archFileSubStoreVerify.sp,v 1.13.50.12 2020/11/17 15:27:06 chandru Exp $";
--  +========================================================================+
--  | Stored Proc:  archFileSubStoreVerify()
--  |
--  | Description:  Get the parameters selected for DataAging
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archFileSubStoreVerify')
BEGIN
	print '>>> Drop Stored Procedure: archFileSubStoreVerify <<<'
	drop procedure archFileSubStoreVerify
END
IF EXISTS (select * from GxQscripts where name='archFileSubStoreVerify')
	delete from GxQscripts where name = 'archFileSubStoreVerify'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSubStoreVerify')
	delete from GXDBVersions where aliasname = 'archFileSubStoreVerify'
GO
print '... Creating Procedure: archFileSubStoreVerify'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archFileSubStoreVerify
  @JobId INTEGER,
  @SIDBStoreId INTEGER,
  @SIDBSubStoreIds VARCHAR(256),
  @LastArchFileId INTEGER,
  @LastPacket INTEGER,
  @afXML NVARCHAR(MAX)
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_LastArchFileId integer;
  DECLARE @o_NextLastArchFileId integer;
  DECLARE @o_ExistOnlyOnSIDBCount integer;
  DECLARE @o_ExistOnlyOnCSCount integer;
  DECLARE @o_ExistOnBothWithDiffCount integer;
  DECLARE @o_jobIdStr NVARCHAR(1024);
SET NOCOUNT ON
	DECLARE 	@retVal		INTEGER
	SET 		@retVal 	= 0
	DECLARE		@l_xmlAFList XML = @afXML
	if object_id('tempdb.dbo.#receivedAFTempFromSIDB') is not null DROP TABLE #receivedAFTempFromSIDB
	if object_id('tempdb.dbo.#receivedAFTemp') is not null DROP TABLE #receivedAFTemp
	if object_id('tempdb.dbo.#receivedAFTempResult') is not null DROP TABLE #receivedAFTempResult
	if object_id('tempdb.dbo.#corruptedSIDBSubStoreList') is not null DROP TABLE #corruptedSIDBSubStoreList
	CREATE TABLE #corruptedSIDBSubStoreList(SIDBSubStoreId INT, SplitNumber	int)
	CREATE TABLE #receivedAFTempFromSIDB (
		archFileId			int,
		SIDBSubStoreId			int,
		primaryObjects		bigint,
		secondaryObjects	bigint,
		SplitNumber			int
		)
	CREATE TABLE #receivedAFTempResult (
		JobId				int,
		archFileId			int,
		SIDBSubStoreId		int,
		primaryObjects		bigint,
		secondaryObjects	bigint,
		SplitNumber			int,
		DiffType			int,
		IgnoreReason		int
		)
	DECLARE	@AFTempResultWithCountOnSIDBHigher TABLE (archFileId INTEGER, SIDBSubStoreId INTEGER)
	DECLARE	@AFTempResultExistOnCSDBOnly TABLE (archFileId INTEGER, SIDBSubStoreId INTEGER)
	DECLARE	@AFTempResultExistOnCSDBOnlyANDMMDeletedAF TABLE (archFileId INTEGER, SIDBSubStoreId INTEGER, SubStoreBitField INTEGER, MountPathId INTEGER, Status INTEGER)
	DECLARE @jobList NVARCHAR(MAX) = NULL
	DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
	INSERT INTO #corruptedSIDBSubStoreList
	SELECT	CONVERT(INT,T._ID), 0
	FROM	dbo.SplitIDs(@SIDBSubStoreIds) T
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	UPDATE	#corruptedSIDBSubStoreList
	SET		SplitNumber = S.SplitNumber
	FROM	#corruptedSIDBSubStoreList C,
		(SELECT	SubStoreId, (ROW_NUMBER() OVER (ORDER BY SubStoreId ASC)) -1 AS SplitNumber
		FROM	IdxSIDBSubStore WITH (NOLOCK)
		WHERE	SIDBStoreId =  @SIDBStoreId) S
	WHERE	C.SIDBSubStoreId = S.SubStoreId
	INSERT INTO	#receivedAFTempFromSIDB
	SELECT	T.archFileId, S.SubStoreId, T.primaryObjects, T.secondaryObjects, T.SplitNumber
	FROM
		(SELECT	AFs.Node.value('@archFileId', 'INTEGER') archFileId,
				AFs.Node.value('@SplitNumber', 'INTEGER') SplitNumber,
				AFs.Node.value('@primaryObjects', 'BIGINT') primaryObjects,
				AFs.Node.value('@secondaryObjects', 'BIGINT') secondaryObjects
		FROM	@l_xmlAFList.nodes('//SIDBAFVerifyXML/AF') AFs(Node)) T,
		(SELECT	SubStoreId, (ROW_NUMBER() OVER (ORDER BY SubStoreId ASC)) -1 AS SplitNumber
		FROM	IdxSIDBSubStore WITH (NOLOCK)
		WHERE	SIDBStoreId =  @SIDBStoreId) S
	WHERE	S.SplitNumber = T.SplitNumber
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	SELECT	@o_nextLastArchFileId = ISNULL(MAX(archFileId),  2147483647)
	FROM	#receivedAFTempFromSIDB
	IF (@LastPacket = 1)
		SET @o_nextLastArchFileId = 2147483647
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	SELECT	F.archFileId, F.SIDBSubStoreId, F.primaryObjects, (F.primaryObjects + F.secondaryObjects) AS secondaryObjects, T.SplitNumber
	INTO	#receivedAFTemp
	FROM	archFileSubStore F WITH (NOLOCK), #corruptedSIDBSubStoreList T
	WHERE	F.SIDBStoreId = @SIDBStoreId
			AND F.SIDBSubStoreId = T.SIDBSubStoreId
			AND F.archFileId > @LastArchFileId
			AND F.archFileId <= @o_nextLastArchFileId
			-- AND (F.primaryObjects > 0 OR F.secondaryObjects > 0)
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	/* If archFile is picked for pruning and exist on SIDB side, we would like to initiate the pruning phase to prune those archive files */
	DELETE  T
	FROM	#receivedAFTemp T INNER JOIN #receivedAFTempFromSIDB S ON T.archFileId = S.archFileId AND T.SIDBSubStoreId = S.SIDBSubStoreId,
			MMDeletedAF MD WITH (NOLOCK)
	WHERE	T.archFileId = MD.archFileId
			AND @SIDBStoreId = MD.SIDBStoreID
AND (MD.Status & 2) != 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	/* If archFile exists on CS but with no chunkMapping then also we would like to initiate pruning phase to prune those AFs */
	DELETE T
	FROM #receivedAFTemp T INNER JOIN #receivedAFTempFromSIDB S ON T.archFileId = S.archFileId AND T.SIDBSubStoreId = S.SIDBSubStoreId
		INNER JOIN archFileCopyDeDup AFCD WITH (NOLOCK) ON AFCD.archFileId = T.archFileId AND AFCD.SIDBStoreId = @SIDBStoreId
		LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK) ON AFCD.archFileId = ACM.archFileId AND AFCD.archCopyId = ACM.archCopyId
							AND AFCD.commCellId = ACM.commCellId
	WHERE ACM.archFileId IS NULL
	INSERT INTO #receivedAFTempResult
SELECT	@JobId, *, 1, 0
	FROM	#receivedAFTempFromSIDB
	EXCEPT
SELECT	@JobId, *, 1, 0
	FROM	#receivedAFTemp
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	INSERT INTO #receivedAFTempResult
SELECT	@JobId, *, 2, 0
	FROM	#receivedAFTemp
	EXCEPT
SELECT	@JobId, *, 2, 0
	FROM	#receivedAFTempFromSIDB
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	INSERT INTO @AFTempResultWithCountOnSIDBHigher
	SELECT T1.archFileId, T1.SIDBSubStoreId
	FROM	#receivedAFTempResult T1, #receivedAFTempResult T2
	WHERE	T1.archFileId = T2.archFileId
			AND T1.SIDBSubStoreId = T2.SIDBSubStoreId
AND T1.DiffType = 1
AND T2.DiffType = 2
			AND T1.primaryObjects >= T2.primaryObjects
			AND T1.secondaryObjects >= T2.secondaryObjects
			/* Above two statement are equivalent to below three statement because when both primary and secondary are same it is filtered by previous SQL statements
			AND (
					(T1.primaryObjects > T2.primaryObjects AND T1.secondaryObjects > T2.secondaryObjects)
					OR (T1.primaryObjects = T2.primaryObjects AND T1.secondaryObjects > T2.secondaryObjects)
					OR (T1.primaryObjects > T2.primaryObjects AND T1.secondaryObjects = T2.secondaryObjects)
				)
			*/
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore the rows which had the auto commit, and either primary and secondary object count is greater on SIDB side
	-- Based on suggestions from Manoj and Deepak We will ignore when primary object count or secondary object cound is greater on SIDB side irrespective of AUTO_COMMIT_FLAG set
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 16
	FROM #receivedAFTempResult R,
			@AFTempResultWithCountOnSIDBHigher T
	WHERE	T.archFileId = R.archFileId
			AND T.SIDBSubStoreId = R.SIDBSubStoreId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore and Set the Invalid chunk existed flag when CVA_AFSS_INVALID_CHUNKS_EXISTED, CVA_AFSS_EXTRA_CHUNKS_WERE_DELETED flags are set
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 2
	FROM #receivedAFTempResult R, archFileSubStore S WITH (NOLOCK)
	WHERE	R.archFileId = S.archFileId
			AND @SIDBStoreId = S.SIDBStoreID
			AND R.SIDBSubStoreId = S.SIDBSubStoreId
AND (S.flags & (1 | 2)) <> 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore and Set the Invalid chunk existed flag when count is higher on SIDB side
	-- We would ignore more because arch file is being still written by other substore.
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 8
	FROM #receivedAFTempResult R, archFileCopyDeDup AFCD WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), @AFTempResultWithCountOnSIDBHigher A
	WHERE	R.archFileId = AFCD.archFileID
			AND @SIDBStoreId = AFCD.SIDBStoreID
			AND AFCD.archFileId = ACM.archFileId
			AND AFCD.commCellId = ACM.commCellId
			AND AFCD.archCopyId = ACM.archCopyId
			AND ACM.chunkNumber = 0
			AND R.archFileId = A.archFileId
			AND R.SIDBSubStoreId = A.SIDBSubStoreId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore and Set the Invalid chunk existed flag when only invalid chunks existed
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 2
	FROM #receivedAFTempResult R, archFileSubStore S WITH (NOLOCK)
	WHERE	R.archFileId = S.archFileId
			AND @SIDBStoreId = S.SIDBStoreID
AND (S.flags & (1 | 2)) <> 0
			AND S.SIDBSubStoreId = 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore and Set the Corrupted chunk existed flag
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 2048
	FROM #receivedAFTempResult R, archFileCopyDedup AFCD WITH (NOLOCK), archChunkMapping ACM WITH (READUNCOMMITTED), ArchChunkToRecoverDDBFailedChunks F WITH (NOLOCK)
	WHERE	R.archFileId = AFCD.archFileId
			AND @SIDBStoreId = AFCD.SIDBStoreID
			AND AFCD.archFileId = ACM.archFileId
			AND AFCD.commCellid = ACM.commCellId
			AND AFCD.archCopyId = ACM.archCopyId
			AND ACM.archChunkId = F.chunkId
			AND ACM.chunkCommCellId = F.chunkCommCellId
			AND F.AdminJobId = @JobId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore and Set the Corrupted chunk existed flag
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 2048
	FROM #receivedAFTempResult R, archFileCopyDedup AFCD WITH (NOLOCK), archChunkMapping ACM WITH (READUNCOMMITTED), ArchChunkToSyncDDBFailedChunks F WITH (NOLOCK)
	WHERE	R.archFileId = AFCD.archFileId
			AND @SIDBStoreId = AFCD.SIDBStoreID
			AND AFCD.archFileId = ACM.archFileId
			AND AFCD.commCellid = ACM.commCellId
			AND AFCD.archCopyId = ACM.archCopyId
			AND ACM.archChunkId = F.chunkId
			AND ACM.chunkCommCellId = F.chunkCommCellId
			AND F.AdminJobId = @JobId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 2048
	FROM #receivedAFTempResult R, archFileCopyDedup AFCD WITH (NOLOCK), archChunkToSyncDDBHistory F WITH (NOLOCK)
	WHERE	R.archFileId = AFCD.archFileId
			AND @SIDBStoreId = AFCD.SIDBStoreID
			AND AFCD.archFileId = F.archFileId
			AND AFCD.commCellid = F.commCellId
			AND AFCD.archCopyId = F.archCopyId
			AND F.AdminJobId = @JobId
AND (F.extraFlags & 2) > 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- We dont need to ignore this because DDB backups runs on primary copy as none deduplication backups
	-- UPDATE #receivedAFTempResult
	-- SET		IgnoreReason |= CVA_AFCDVH_IGNORE_DDB_BACKUP
	-- FROM #receivedAFTempResult R, archFileCopyDeDup AFCD WITH (NOLOCK), archFile AF WITH (NOLOCK)
	-- WHERE	R.archFileId = AFCD.archFileID
	-- 		AND @SIDBStoreId = AFCD.SIDBStoreID
	-- 		AND AFCD.archFileId = AF.id
	-- 		AND AFCD.commCellId = AF.commCellId
	-- 		AND AF.appId IN (SELECT componentNameID
	-- 						FROM APP_SubClientProp SC
	-- 						WHERE	SC.attrName = 'DDB Backup'
	-- 							AND SC.attrVal = '1'
	-- 							AND SC.modified = 0)
	-- SELECT	@retVal = @@ERROR
	-- IF (@retVal != 0) GOTO CX_EXIT
	-- UPDATE #receivedAFTempResult
	-- SET		IgnoreReason |= CVA_AFCDVH_IGNORE_MMDELETEDAF_EXIST
	-- FROM #receivedAFTempResult R, MMDeletedAF MD WITH (NOLOCK)
	-- WHERE	R.archFileId = MD.archFileId
	-- 		AND @SIDBStoreId = MD.SIDBStoreID
	-- SELECT	@retVal = @@ERROR
	-- IF (@retVal != 0) GOTO CX_EXIT
	-- UPDATE #receivedAFTempResult
	-- SET		IgnoreReason |= CVA_AFCDVH_IGNORE_MMDELETEDAF_EXIST
	-- FROM	#receivedAFTempResult R ,
	-- 		archFile AF, JMJobDataStats J WITH (NOLOCK), archCopySIDBStore S WITH (NOLOCK)
	-- WHERE	AF.id = R.archFileId
	-- 		AND AF.jobId = J.jobId
	-- 		AND AF.commCellId = J.commCellId
	-- 		AND AF.fileType = J.dataType
	-- 		AND J.archGrpCopyId = S.CopyId
	-- 		AND S.SIDBStoreId = @SIDBStoreId
-- 		AND R.DiffType = 1
	-- 		AND NOT EXISTS (SELECT 1 FROM #receivedAFTempResult T
-- 			WHERE R.archFileId = T.archFileId AND R.SIDBSubStoreId = T.SIDBSubStoreId AND R.DiffType = 1 AND T.DiffType = 2)
	-- 		AND J.status IN (101, 102, 103)
	-- SELECT	@retVal = @@ERROR
	-- IF (@retVal != 0) GOTO CX_EXIT
	INSERT INTO @AFTempResultExistOnCSDBOnly
	SELECT	CR.archFileId, CR.SIDBSubStoreId
	FROM	#receivedAFTempResult CR LEFT OUTER JOIN #receivedAFTempResult SR
				ON	SR.archFileId = CR.archFileId
					AND SR.SIDBSubStoreId = CR.SIDBSubStoreId
AND SR.DiffType = 1
AND CR.DiffType = 2
		WHERE	SR.archFileID IS NULL
AND CR.DiffType = 2
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore if the archFile exist only in archFileSubStore table
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 512
	FROM	#receivedAFTempResult CR, @AFTempResultExistOnCSDBOnly T
											LEFT OUTER JOIN archFileCopyDedup AFCD  WITH (NOLOCK)
												ON	T.archFileId = AFCD.archFileId
													AND @SIDBStoreId = AFCd.SIDBStoreId
	WHERE	CR.archFileID = T.archFileID
			AND CR.SIDBSubStoreId = T.SIDBSubStoreId
			AND AFCD.archFileID IS NULL
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 128
	FROM	#receivedAFTempResult CR, @AFTempResultExistOnCSDBOnly T
	WHERE	CR.archFileID = T.archFileID
			AND CR.SIDBSubStoreId = T.SIDBSubStoreId
			AND CR.primaryObjects = 0
			AND CR.secondaryObjects = 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	INSERT INTO @AFTempResultExistOnCSDBOnlyANDMMDeletedAF
	SELECT	A.archFileId, A.SIDBSubStoreId, MD.SubStoreBitField, MD.MountPathId, MD.Status
	FROM	#receivedAFTempResult A, @AFTempResultExistOnCSDBOnly T, MMDeletedAF MD WITH (NOLOCK)
	WHERE	A.archFileID = T.archFileId
			AND A.SIDBSubStoreId = T.SIDBSubStoreId
			AND A.archFileId = MD.archFileId
			AND @SIDBStoreId = MD.SIDBStoreID
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore the rows for pruning bit is set for split number (corresponds to substore) in MMDeletedAF table
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 1
	FROM	#receivedAFTempResult A, @AFTempResultExistOnCSDBOnlyANDMMDeletedAF MD
	WHERE	A.archFileID = MD.archFileId
			AND A.SIDBSubStoreId = MD.SIDBSubStoreId
AND (MD.Status & 2) = 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore the rows for pruning bit is set for split number (corresponds to substore) in MMDeletedAF table
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 1
	FROM	#receivedAFTempResult A, @AFTempResultExistOnCSDBOnlyANDMMDeletedAF MD
	WHERE	A.archFileID = MD.archFileId
			AND A.SIDBSubStoreId = MD.SIDBSubStoreId
			AND (MD.subStoreBitField & POWER(2, A.SplitNumber)) > 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore the rows for pruning bit is set for split number (corresponds to substore) in MMTempDeletedAF table
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 1
	FROM	#receivedAFTempResult A, @AFTempResultExistOnCSDBOnly T, MMTempDeletedAF MD WITH (NOLOCK)
	WHERE	A.archFileID = T.archFileId
			AND A.SIDBSubStoreId = T.SIDBSubStoreId
			AND A.archFileId = MD.archFileId
			AND @SIDBStoreId = MD.SIDBStoreID
			AND (MD.subStoreBitField & POWER(2, A.SplitNumber)) > 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore the rows for cloud library in MMDeletedAF table
	-- Verify this for performance
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 1
	FROM	#receivedAFTempResult A, @AFTempResultExistOnCSDBOnlyANDMMDeletedAF MD, MMMountPath MP  WITH (NOLOCK)
	WHERE	A.archFileID = MD.archFileId
			AND A.SIDBSubStoreId = MD.SIDBSubStoreId
			AND MD.MountPathId = MP.MountPathId
			AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- On Full recon, ignore archive files in MMDeletedAF table
	IF EXISTS(	SELECT	*
				FROM	dbo.GetAllJobOptions(@JobId)
				WHERE	optionId=93390483 /*RECONSTRUCTDEDUPDBOPTION_FLAGS */
						AND Value = N'1')
	BEGIN
		UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 1
		FROM	#receivedAFTempResult A, @AFTempResultExistOnCSDBOnlyANDMMDeletedAF MD
		WHERE	A.archFileID = MD.archFileId
				AND A.SIDBSubStoreId = MD.SIDBSubStoreId
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_EXIT
	END
	-- Ignore the rows for recopied archive files
	UPDATE #receivedAFTempResult
SET		IgnoreReason |= 32
	FROM #receivedAFTempResult R, archFileSubStore S WITH (NOLOCK)
	WHERE	R.archFileId = S.archFileId
			AND @SIDBStoreId = S.SIDBStoreID
AND (S.flags & 8) <> 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- Ignore mismatch if the arch Files exists only on SIDB not in CSDB because micro pruning does not happen on SILO Copy
IF EXISTS (SELECT	1 FROM	IdxSIDBStore WHERE (SIDBStoreId = @SIDBStoreId AND (flags & 2097152)  > 0))
	BEGIN
		UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 64
WHERE	#receivedAFTempResult.DiffType = 1
				AND NOT EXISTS (SELECT 1 FROM #receivedAFTempResult CR
							WHERE	#receivedAFTempResult.archFileId = CR.archFileId
									AND #receivedAFTempResult.SIDBSubStoreId = CR.SIDBSubStoreId
AND CR.DiffType = 2)
	END
	-- Ignore mismatch if the arch Files exists only on SIDB not in CSDB because Log journal replay has completed successfully
IF EXISTS (SELECT 1 FROM JMMisc WHERE jobId = @JobId AND commCellId = 2 AND itemType = 75 AND (intData & 1 /*MM_RECON_LOG_JOURNAL_REPLAY_SUCCESS_JOB_FLAG*/) > 0)
	BEGIN
		UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 4096
WHERE	#receivedAFTempResult.DiffType = 1
				AND NOT EXISTS (SELECT 1 FROM #receivedAFTempResult CR
							WHERE	#receivedAFTempResult.archFileId = CR.archFileId
									AND #receivedAFTempResult.SIDBSubStoreId = CR.SIDBSubStoreId
AND CR.DiffType = 2)
	END
	-- Ignore if the object count on CS is higher than DDB, chunks for this archive file was sent during the add record phase and not during prune record phase
	UPDATE	#receivedAFTempResult
SET		IgnoreReason |= 1024
	FROm	#receivedAFTempResult R,
			(SELECT	CR.archFileId, CR.SIDBSubStoreId
			FROM	#receivedAFTempResult CR LEFT OUTER JOIN #receivedAFTempResult SR
						ON	SR.archFileId = CR.archFileId
							AND SR.SIDBSubStoreId = CR.SIDBSubStoreId
AND SR.DiffType = 1
AND CR.DiffType = 2
							AND CR.IgnoreReason = 0
							AND SR.IgnoreReason = 0
				WHERE	(CR.primaryObjects != SR.primaryObjects OR CR.secondaryObjects != SR.secondaryObjects)
					/*	AND CR.primaryObjects >= SR.primaryObjects
						AND CR.secondaryObjects >= SR.secondaryObjects
						-- Arch File was not sent during add record phase
						AND NOT EXISTS (SELECT * FROM archChunkToSyncDDBHistory H WHERE H.adminJobId = @JobId AND CR.archFileId = H.archFileId)
						-- Arch File is in to be pruned state
						AND EXISTS (SELECT *
									FROM MMDeletedAF D
									WHERE CR.archFileId = D.archFileId
										AND @SIDBStoreId = D.SIDBStoreId)
						-- Arch File was not sent for pruning on this substore
						AND NOT EXISTS (SELECT *
										FROM MMTempDeletedAF D
										WHERE CR.archFileId = D.archFileId
											AND @SIDBStoreId = D.SIDBStoreId
											AND @jobId = D.AdminJobId
											AND (D.subStoreBitField & POWER(2, CR.SplitNumber)) > 0) */
			) T
	WHERE	R.archFileId = T.archFileId
			AND R.SIDBSubStoreId = T.SIDBSubStoreId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	SELECT	@o_ExistOnBothWithDiffCount = COUNT(*)
	FROM	#receivedAFTempResult A, #receivedAFTempResult B
	WHERE	A.archFileId = B.archFileId
			AND A.SIDBSubStoreId = B.SIDBSubStoreId
AND A.DiffType = 1
AND B.DiffType = 2
			AND A.IgnoreReason = 0
			AND B.IgnoreReason = 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- We might the duplicate rows issue if the restart string is not set correctly and we were unable to read the restart string from job manager
	DELETE FROM archFileCopyDedupVerifyHistory
	WHERE	JobID = @JobId
			AND CommCellId = 2
			AND archFileId > @LastArchFileId
			AND SIDBStoreId = @SIDBStoreId
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	-- MR 143613: Upon restart if DDB sends the lastArchFileId again then Cleaning up from archFileCopyDedupVerifyHistory is necessary else it keeps failing
	-- with duplicate key error as seen in TR - 150810-156
	IF EXISTS (SELECT * FROM #receivedAFTempResult WHERE JobID = @JobId AND archFileId = @LastArchFileId)
	BEGIN
		DELETE FROM archFileCopyDedupVerifyHistory
		WHERE	JobID = @JobId
				AND CommCellId = 2
				AND archFileId = @LastArchFileId
				AND SIDBStoreId = @SIDBStoreId
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_EXIT
	END
	INSERT INTO archFileCopyDedupVerifyHistory
	SELECT	JobId, 2, @SIDBStoreId, SIDBSubStoreId, archFileId, primaryObjects, secondaryObjects, diffType, IgnoreReason, 0, 0, N''
	FROM	#receivedAFTempResult
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
	IF ((@LastPacket = 1) AND (EXISTS (	SELECT	*
										FROM	archFileCopyDedupVerifyHistory WITH (READUNCOMMITTED)
										WHERE	JobID = @JobId
												AND SIDBStoreId = @SIDBStoreId
AND DiffType = 2
												AND ReserveField1 = 0)))
	BEGIN
		DECLARE @markDDBValidationFailed INT = 1
DECLARE @reconOption INT = ISNULL(dbo.GetOptionInt(93390483, @JobId, 0, 0), 0)
		DECLARE @iIgnoreExistOnlyOnCSCount INT = 0
		SELECT	@iIgnoreExistOnlyOnCSCount = Value
		FROM	MMConfigs WITH (READUNCOMMITTED)
		WHERE	name = 'MMCONFIG_IGNORE_EXISTS_ONLY_ON_CS_COUNT'
		-- Ignore the validation difference when following conditions are met
		-- 1. No DDB Only files exist
		-- 2. Number of CS only files exist is less than MMConfigParam MMCONFIG_IGNORE_EXISTS_ONLY_ON_CS_COUNT
		-- 3. A. When incremental recon all the missing are AFs were written before the snap time
		--    B. OR When Full Recon
		IF ((NOT EXISTS (SELECT 1 FROM archFileCopyDedupVerifyHistory WITH (READUNCOMMITTED)
WHERE JobID = @JobId AND SIDBStoreId = @SIDBStoreId AND DiffType = 1 AND ReserveField1 = 0))
			AND ((SELECT COUNT(*) FROM archFileCopyDedupVerifyHistory WITH (READUNCOMMITTED)
WHERE JobID = @JobId AND SIDBStoreId = @SIDBStoreId AND DiffType = 2 AND ReserveField1 = 0) <= @iIgnoreExistOnlyOnCSCount))
		BEGIN
				DECLARE @jobCopyTable TABLE(archCopyId INT, archFileId INT, commCellId INT, jobId INT, afLastChunkCreateTime INT)
				DECLARE @l_copyId INT = 0
				INSERT INTO @jobCopyTable
				SELECT	DISTINCT ACM.archCopyId, ACM.archFileId, ACM.CommCellId, ACM.JobId, AC.createTime
				FROM
						(SELECT	archFileId, CommCellId, SIDBStoreId
						FROM	archFileCopyDedupVerifyHistory WITH (READUNCOMMITTED)
						WHERE	JobId = @JobId
								AND CommCellId = 2
AND DiffType = 2
								AND ReserveField1 = 0
						) VH
						INNER JOIN archFileCopyDedup AFCD WITH (READUNCOMMITTED) ON VH.archFileId = AFCD.archFileId AND VH.commCellId = AFCD.commCellId AND VH.SIDBStoreId = AFCD.SIDBStoreId
						INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AFCD.archFileId = AFC.archFileId AND AFCD.CommCellId = AFC.CommCellId AND AFCD.archCopyId = AFC.archCopyId
						INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId AND AFC.lastChunkNumber = ACM.chunkNumber
						INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON ACM.archCHunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
IF (((@reconOption != 1)
					AND NOT EXISTS (	SELECT	1
								FROM	#corruptedSIDBSubStoreList C
										INNER JOIN IdxSIDBSubStore SS WITH (READUNCOMMITTED) ON C.SIDBSubStoreId = SS.SubStoreId,
										@jobCopyTable J
								WHERE	SS.LastSnapTime < J.afLastChunkCreateTime))
OR (@reconOption = 1))
				BEGIN
					SET @markDDBValidationFailed = 0
					UPDATE JMDS
					SET		archCheckStatus = 6, -- ACS_FAILED
							archCheckEndTime = @now
					FROM	JMJobDataStats JMDS,
							(SELECT	DISTINCT JobId, CommCellId, archCopyId FROM @jobCopyTable) T
					WHERE JMDS.jobId = T.jobId
					AND JMDS.commCellId = T.CommCellId
					AND JMDS.archGrpCopyId = T.archCopyId
					SET @jobList = NULL
					SELECT	@jobList = COALESCE(@jobList+', ' ,'') + CAST(jobId as varchar(10))
					FROM	(SELECT	DISTINCT TOP 100 JobId FROM @jobCopyTable ORDER BY JobId) T
				END
		END
		IF (@markDDBValidationFailed = 1)
		BEGIN
			UPDATE	IDXSIDBSubStore
SET		Flags |= 4194304
			WHERE	EXISTS (SELECT	*
							FROM	archFileCopyDedupVerifyHistory H
							WHERE	H.JobID = @JobId
									AND H.SIDBStoreId = IDXSIDBSubStore.SIDBStoreId
									AND H.SIDBSubStoreId = IDXSIDBSubStore.SubStoreId
AND DiffType = 2
									AND ReserveField1 = 0)
		END
	END
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_EXIT
CX_EXIT:
	IF (@retVal <> 0)
		SELECT	-1 AS o_ErrorCode,
				-1 AS o_LastArchFileId,
				-1 AS o_NextLastArchFileId,
				-1 AS o_ExistOnlyOnSIDBCount,
				-1 AS o_ExistOnlyOnCSCount,
				-1 AS o_ExistOnBothWithDiffCount,
				'' AS o_jobIdStr
	ELSE
		SELECT	0 AS o_ErrorCode,
				@LastArchFileId AS o_LastArchFileId,
				@o_nextLastArchFileId AS o_NextLastArchFileId,
((SELECT COUNT(*) FROM #receivedAFTempResult WHERE DiffType = 1 AND IgnoreReason = 0) - @o_ExistOnBothWithDiffCount) AS o_ExistOnlyOnSIDBCount,
((SELECT COUNT(*) FROM #receivedAFTempResult WHERE DiffType = 2 AND IgnoreReason = 0) - @o_ExistOnBothWithDiffCount) AS o_ExistOnlyOnCSCount,
				@o_ExistOnBothWithDiffCount AS o_ExistOnBothWithDiffCount,
				@jobList o_jobIdStr
if object_id('tempdb.dbo.#receivedAFTempFromSIDB') is not null DROP TABLE #receivedAFTempFromSIDB
if object_id('tempdb.dbo.#receivedAFTemp') is not null DROP TABLE #receivedAFTemp
if object_id('tempdb.dbo.#receivedAFTempResult') is not null DROP TABLE #receivedAFTempResult
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSubStoreVerify')
	delete from GxQscripts where name = 'archFileSubStoreVerify'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSubStoreVerify')
	delete from GXDBVersions where aliasname = 'archFileSubStoreVerify'
GO

insert into GXDBVersions values(2, 'archFileSubStoreVerify',  '00010013005000120000', 'archFileSubStoreVerify', '00010013005000120000')
GO

