

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSubStoreRemove.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSubStoreRemove.sp,v $ $Id: archFileSubStoreRemove.sp,v 1.3.88.1 2018/03/20 19:52:43 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  archFileSubStoreRemove()
--  |
--  | Description:  Get the parameters selected for DataAging
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileSubStoreRemove <<<'

IF EXISTS (select * from sysobjects where name='archFileSubStoreRemove')
	drop procedure archFileSubStoreRemove
IF EXISTS (select * from GxQscripts where name='archFileSubStoreRemove')
	delete from GxQscripts where name = 'archFileSubStoreRemove'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSubStoreRemove')
	delete from GXDBVersions where aliasname = 'archFileSubStoreRemove'
GO
print '... Creating Procedure: archFileSubStoreRemove'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileSubStoreRemove
  @ArchFileId INTEGER,
  @VolumeId INTEGER,
  @SIDBStoreId INTEGER,
  @MountPathId INTEGER
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_RowCount integer;
SET NOCOUNT ON
	DECLARE 	@retVal		INTEGER
	SET 		@retVal 	= 0
	DECLARE		@rowCount	INTEGER
	-- For Volume pruning skip everything
	IF (@archFileId = 0 AND @VolumeId != 0)
	BEGIN
		SET 		@retVal 	= 0
		GOTO CX_EXIT
	END
	IF (@archFileId = 0 AND @SIDBStoreId = 0 AND @MountPathId = 0)
	BEGIN
		SET 		@retVal 	= -1
		GOTO CX_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#TobeDeleteArchFiles') IS NOT NULL DROP TABLE #TobeDeleteArchFiles
	CREATE TABLE #TobeDeleteArchFiles
	(
		archFileId INTEGER,
		SIDBStoreId INTEGER
	)
	IF (@archFileId != 0)
	BEGIN
		INSERT INTO #TobeDeleteArchFiles
		SELECT	archFileId, SIDBStoreId
		FROM	MMDeletedAF DAF WITH (NOLOCK)
		WHERE	DAF.archFileId = @archFileId AND DAF.VolumeId = @VolumeID
		GROUP BY archFileId, SIDBStoreId
		HAVING COUNT(*) = 1
	END
	ELSE IF (@SIDBStoreId != 0)
	BEGIN
		INSERT INTO #TobeDeleteArchFiles
		SELECT	DISTINCT archFileId, SIDBStoreId
		FROM	MMDeletedAF DAF WITH (NOLOCK)
		WHERE	DAF.SIDBStoreId = @SIDBStoreId
	END
	ELSE IF (@MountPathId != 0)
	BEGIN
		INSERT INTO #TobeDeleteArchFiles
		SELECT	DISTINCT archFileId, SIDBStoreId
		FROM	MMDeletedAF DAF WITH (NOLOCK)
		WHERE	DAF.MountPathId = @MountPathId
	END
	CREATE INDEX TobeDeleteArchFiles_archFileId_SIDBStoreId ON #TobeDeleteArchFiles(archFileId, SIDBStoreId)
	DELETE	FROM archFileSubStore
	FROM	archFileSubStore SS, #TobeDeleteArchFiles DAF
	WHERE	SS.archFileId = DAF.archFileId
			AND SS.SIDBStoreId = DAF.SIDBStoreId
	SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
	IF (@retVal != 0) GOTO CX_EXIT
CX_EXIT:
	IF (@retVal <> 0)
		SELECT	-1 AS o_ErrorCode,
				0 AS o_RowCount
	ELSE
		SELECT	0 AS o_ErrorCode,
				@rowCount AS o_RowCount
	IF OBJECT_ID('tempdb.dbo.#TobeDeleteArchFiles') IS NOT NULL DROP TABLE #TobeDeleteArchFiles
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSubStoreRemove')
	delete from GxQscripts where name = 'archFileSubStoreRemove'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSubStoreRemove')
	delete from GXDBVersions where aliasname = 'archFileSubStoreRemove'
GO

insert into GXDBVersions values(2, 'archFileSubStoreRemove',  '00010003008800010000', 'archFileSubStoreRemove', '00010003008800010000')
GO

