

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSubStoreInfoMoveToHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSubStoreInfoMoveToHistory.sp,v $ $Id: archFileSubStoreInfoMoveToHistory.sp,v 1.1.180.1 2018/03/22 00:57:52 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  archFileSubStoreInfoMoveToHistory()
--  |
--  | Description:  All arch file information older than 3 days of completed jobs will be moved from archFileSubStore to archFileSubStoreHistory
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileSubStoreInfoMoveToHistory <<<'

IF EXISTS (select * from sysobjects where name='archFileSubStoreInfoMoveToHistory')
	drop procedure archFileSubStoreInfoMoveToHistory
IF EXISTS (select * from GxQscripts where name='archFileSubStoreInfoMoveToHistory')
	delete from GxQscripts where name = 'archFileSubStoreInfoMoveToHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSubStoreInfoMoveToHistory')
	delete from GXDBVersions where aliasname = 'archFileSubStoreInfoMoveToHistory'
GO
print '... Creating Procedure: archFileSubStoreInfoMoveToHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileSubStoreInfoMoveToHistory
AS
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobAged INTEGER;
SET NOCOUNT ON
DECLARE @errorCode		INTEGER = 0
DECLARE @currentTime DateTime = dbo.GetDayStart(GetUTCDate(), 0)
DECLARE @fileTime int = dbo.GetUnixTime(DATEADD(d, -3, @currentTime))
if object_id('tempdb.dbo.#archFileSubStoreV') is not null DROP TABLE #archFileSubStoreV
CREATE TABLE #archFileSubStoreV (archFileId int NOT NULL, CommCellId int NOT NULL, SIDBStoreId int NOT NULL, SIDBSubStoreId int  NOT NULL, primaryObjects bigint, secondaryObjects bigint, jobid int, afCreateTime int, processed int, primary key (archFileId, commCellId, SIDBStoreId, SIDBSubStoreId))
DECLARE @archFileSubStoreV2 TABLE (archFileId int, CommCellId int, SIDBStoreId int, SIDBSubStoreId int, primaryObjects bigint, secondaryObjects bigint, jobid int, afCreateTime int, processed int)
DECLARE @archFileStoreV TABLE (archFileId int, CommCellId int, SIDBStoreId int)
-- Get arch file substore information for all the files created 3 days before
INSERT INTO #archFileSubStoreV
SELECT	S.*, AF.jobId, AF.cTime, 0
FROM	archFileSubStore S WITH (NOLOCK), archFile AF WITH (NOLOCK)
WHERE	S.archFileId = AF.id
		AND S.commCellId = AF.commCellId
		AND AF.cTime < @fileTime
IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
-- Delete the arch file substore information for non completed jobs
--DELETE FROM #archFileSubStoreV
--FROM	JMJobStats J WITH (NOLOCK), #archFileSubStoreV S
--WHERE	J.jobId = S.JobID
--		AND J.CommCellId = S.CommCellId
--		AND J.status = 1
DELETE FROM #archFileSubStoreV
FROM	#archFileSubStoreV S LEFT OUTER JOIN JMJobInfo J WITH (NOLOCK) ON J.jobId = S.JobID AND J.CommCellId = S.CommCellId
WHERE	J.JobID IS NOT NULL
IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
-- Process 1000 archive files at a time
INSERT INTO @archFileStoreV
SELECT	TOP 1000 archFileId, CommCellId, SIDBStoreId
FROM	#archFileSubStoreV
WHERE	processed = 0
ORDER BY archFileId, CommCellId, SIDBStoreId
IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
BEGIN TRANSACTION TransArchFileSubStoreInfo
WHILE EXISTS( SELECT * FROM @archFileStoreV)
BEGIN
	-- Get arch file sub store information for selected 1K archive files
	INSERT INTO @archFileSubStoreV2
	SELECT	SS.*
	FROM	#archFileSubStoreV SS, @archFileStoreV S
	WHERE	SS.archFileID = S.archFileID
			AND SS.CommCellId = S.CommCellId
			AND SS.SIDBStoreId = S.SIDBStoreId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
	-- Populate the arch file sub store information into history table
	INSERT INTO archFileSubStoreHistory
	SELECT	archFileId, commCellId, SIDBStoreId, SUBSTRING( (SELECT (CAST(S2.SIDBSubStoreId AS VARCHAR(10)) + ':' + CAST(S2.primaryObjects AS VARCHAR(20)) + ':' + CAST(S2.secondaryObjects AS VARCHAR(20))+ ';')
															FROM	@archFileSubStoreV2 S2
															WHERE	S2.archFileId = S1.archFileId
																	AND S2.commCellId = S1.commCellId
																	AND S2.SIDBStoreId = S1.SIDBStoreId
															FOR XML PATH ('')), 0, 99999999
															)
	FROM	@archFileSubStoreV2 S1
	GROUP BY archFileId, commCellId, SIDBStoreId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
	-- Update the processed flag
	UPDATE	#archFileSubStoreV
	SET		processed = 1
	FROM	#archFileSubStoreV SS, @archFileStoreV S
	WHERE	SS.archFileID = S.archFileID
			AND SS.CommCellId = S.CommCellId
			AND SS.SIDBStoreId = S.SIDBStoreId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
	-- Clean the current 1k arch File and arch File Sub Store info
	DELETE FROM @archFileStoreV
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
	DELETE FROM @archFileSubStoreV2
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
	-- Populate the next 1k archfiles for processing
	INSERT INTO @archFileStoreV
	SELECT	TOP 1000 archFileId, CommCellId, SIDBStoreId
	FROM	#archFileSubStoreV
	WHERE	processed = 0
	ORDER BY archFileId, CommCellId, SIDBStoreId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
END
DELETE FROM archFileSubStore
FROM	archFileSubStore S, #archFileSubStoreV SV
WHERE	S.archFileId = SV.archFileId
		AND S.CommCellId = SV.CommCellId
		AND S.SIDBStoreId = SV.SIDBStoreId
		AND S.SIDBSubStoreId = SV.SIDBSubStoreId
		AND SV.processed = 1
IF		@@ERROR != 0 GOTO CX_ERROR_EXIT_WITH_ROLLBACK
CX_EXIT:
	if object_id('tempdb.dbo.#archFileSubStoreV') is not null DROP TABLE #archFileSubStoreV
	COMMIT TRANSACTION TransArchFileSubStoreInfo
	SELECT	0
	RETURN
CX_ERROR_EXIT_WITH_ROLLBACK:
	ROLLBACK TRANSACTION TransArchFileSubStoreInfo
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#archFileSubStoreV') is not null DROP TABLE #archFileSubStoreV
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSubStoreInfoMoveToHistory')
	delete from GxQscripts where name = 'archFileSubStoreInfoMoveToHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSubStoreInfoMoveToHistory')
	delete from GXDBVersions where aliasname = 'archFileSubStoreInfoMoveToHistory'
GO

insert into GXDBVersions values(2, 'archFileSubStoreInfoMoveToHistory',  '00010001018000010000', 'archFileSubStoreInfoMoveToHistory', '00010001018000010000')
GO

