

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSizeOnMediaCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSizeOnMediaCreate.sp,v $ $Id: archFileSizeOnMediaCreate.sp,v 1.4.12.4 2018/03/27 09:02:23 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileSizeOnMediaCreate <<<'

IF EXISTS (select * from sysobjects where name='archFileSizeOnMediaCreate')
	drop procedure archFileSizeOnMediaCreate
IF EXISTS (select * from GxQscripts where name='archFileSizeOnMediaCreate')
	delete from GxQscripts where name = 'archFileSizeOnMediaCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSizeOnMediaCreate')
	delete from GXDBVersions where aliasname = 'archFileSizeOnMediaCreate'
GO
print '... Creating Procedure: archFileSizeOnMediaCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileSizeOnMediaCreate
  @i_filepath NVARCHAR(2048),
  @i_adminJobId BIGINT,
  @i_subStoreId INT,
  @i_copyId INT,
  @i_storeId INT
AS
  DECLARE @o_metaDataSize bigint;
  DECLARE @o_sizeOnMedia bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_dynQuery	nvarchar(MAX)
DECLARE @l_subStoreId INT = 0
DECLARE @l_maxJobId int = 0
DECLARE @l_rowCount int = 0
DECLARE @historyCount INT = 0
SET @historyCount = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMCONFIG_DDB_FINGERPRINTING_HISTORY_COUNT'), 2)
IF NOT EXISTS(select top 1 adminJobId from archFileSizeOnMediaInstances where adminJobId=@i_adminJobId)
BEGIN
	--Retain only last Job for the same commcellId and storeId unless
	--there are two entries with one as the current Job Id
	SET @l_rowCount = (SELECT COUNT(DISTINCT AF.adminJobId)
					FROM archFileSizeOnMediaInstances AF
					JOIN IdxSidbSubStore IDX WITH (NOLOCK)
					ON AF.subStoreId = IDX.SubStoreId
					WHERE IDX.SIDBStoreId = @i_storeId)
	IF(@l_rowCount > (@historyCount-1))
	BEGIN
		SET @l_maxJobId = (SELECT TOP 1 adminJobId
							FROM
							(	SELECT DISTINCT TOP (@historyCount-1) AF.adminJobId
								FROM archFileSizeOnMediaInstances AF
								JOIN IdxSidbSubStore IDX WITH (NOLOCK)
								ON AF.subStoreId = IDX.SubStoreId
								WHERE IDX.SIDBStoreId = @i_storeId
								GROUP BY AF.adminJobId
								ORDER BY AF.adminJobId DESC) AS TEMP_VIEW
							ORDER BY adminJobId ASC)
		DELETE AF
		FROM archFileSizeOnMediaInstances AS AF
		JOIN IdxSidbSubStore IDX WITH (NOLOCK)
		ON AF.subStoreId = IDX.SubStoreId
		WHERE IDX.SIDBStoreId = @i_storeId
		AND AF.adminJobId < @l_maxJobId
		DELETE FROM archFileSizeOnMedia
				WHERE adminJobId < @l_maxJobId
				AND storeId = @i_storeId
	END
END
--Inserting the csv data into table ArchFileSizeOnMediaStaging
IF OBJECT_ID('tempdb.[dbo].[#ArchFileSizeOnMediaStaging]', 'U') IS NOT NULL
  DROP TABLE [dbo].[#ArchFileSizeOnMediaStaging];
CREATE TABLE [dbo].[#ArchFileSizeOnMediaStaging]
(
	archFileId BIGINT,
	sizeOnMedia BIGINT
	PRIMARY KEY (archFileId));
SET @l_dynQuery=
	'BULK INSERT [dbo].[#ArchFileSizeOnMediaStaging]
	FROM ' + char(39) + @i_filePath + char(39) +
	'WITH
	(
		FIELDTERMINATOR = '','',
		ROWTERMINATOR = ''0x0A'',
		FIRSTROW = 2,
		KEEPNULLS
	)'
EXEC SQLAdminUtilExecQuery @l_dynQuery, 1;
--Populate archFileSizeOnMediaInstances if not already done
IF NOT EXISTS (SELECT subStoreId FROM [dbo].[archFileSizeOnMediaInstances]
 WHERE adminJobId = @i_adminJobId and subStoreId = @i_subStoreId)
BEGIN
	INSERT INTO [dbo].[archFileSizeOnMediaInstances]
	SELECT DISTINCT @i_adminJobId, SubStoreId, 0
		FROM [dbo].[IdxSIDBSubStore] WITH (NOLOCK)
		where SIDBStoreId = @i_storeId
END
--Attempt archFileSizeOnMedia population only if the jobID, subStoreId
--is marked as not complete
IF (SELECT isComplete FROM [dbo].[ArchFileSizeOnMediaInstances]
WHERE adminJobId = @i_adminJobId AND subStoreId = @i_subStoreId) = 0
BEGIN
--Existing archFileId for the particular job Id will
--be updated with new size when there are multiple splits
UPDATE AF
SET AF.sizeOnMedia = AF.sizeOnMedia + Stage.sizeOnMedia,
	AF.totalSize = AF.sizeOnMedia + Stage.sizeOnMedia + AF.metaDataSize
	FROM [dbo].[#ArchFileSizeOnMediaStaging] Stage
	INNER JOIN [dbo].[ArchFileSizeOnMedia] AF
	ON Stage.archFileId = AF.archFileId
	AND AF.storeId = @i_storeId
	AND AF.adminJobId = @i_adminJobId
--Entries not present in the table already will be added here
INSERT INTO [dbo].[ArchFileSizeOnMedia]
	(archFileID, sizeOnMedia, adminJobId, storeId, metaDataSize, totalSize)
	SELECT archFileID, sizeOnMedia, adminJobId, storeId, metaDataSize, sizeOnMedia + metaDataSize
	FROM
	(
		(SELECT Stage.archFileID, Stage.sizeOnMedia, @i_adminJobId AS adminJobId, @i_storeId AS storeId,
			((SELECT SUM(CM.physicalSize)
					FROM	archChunkMapping CM WITH (NOLOCK)
					JOIN	archCopySIDBStore ACSS WITH (NOLOCK) on ACSS.CopyId = CM.archCopyId
					WHERE	CM.archFileId = Stage.archFileID
							AND		ACSS.SIDBStoreId = @i_storeId)
			+ FCD.primaryObjSize
			- FCD.secondaryObjSize
			+ FCD.primaryMetaDataSize
			+ FCD.secondaryMetaDataSize) AS metaDataSize
		FROM [dbo].[#ArchFileSizeOnMediaStaging] Stage
		JOIN ArchFileCopyDedup FCD WITH (NOLOCK)
		ON FCD.archFileId = Stage.archFileID
		AND FCD.SIDBStoreId = @i_storeId
		WHERE NOT EXISTS
		(	SELECT AF.archFileID
			FROM [dbo].[ArchFileSizeOnMedia] AF
			WHERE Stage.archFileID = AF.archFileID
			AND AF.storeId = @i_storeId
			AND AF.adminJobId = @i_adminJobId
		))
	)TEMP_VIEW;
END
--Mark completion of archive file size calculation for the particular split
 UPDATE archFileSizeOnMediaInstances
 SET isComplete = 1
  WHERE adminJobId = @i_adminJobId AND subStoreId = @i_subStoreId
IF OBJECT_ID('tempdb.[dbo].[#ArchFileSizeOnMediaStaging]', 'U') IS NOT NULL
  DROP TABLE [dbo].[#ArchFileSizeOnMediaStaging];
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSizeOnMediaCreate')
	delete from GxQscripts where name = 'archFileSizeOnMediaCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSizeOnMediaCreate')
	delete from GXDBVersions where aliasname = 'archFileSizeOnMediaCreate'
GO

insert into GXDBVersions values(2, 'archFileSizeOnMediaCreate',  '00010004001200040000', 'archFileSizeOnMediaCreate', '00010004001200040000')
GO

