

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSetInvalidByJobNewSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSetInvalidByJobNewSP.sp,v $ $Id: archFileSetInvalidByJobNewSP.sp,v 1.1.2.1.8.1 2021/03/20 06:39:34 rthati Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archFileSetInvalidByJobNewSP')
BEGIN
	print '>>> Drop Stored Procedure: archFileSetInvalidByJobNewSP <<<'
	drop procedure archFileSetInvalidByJobNewSP
END
IF EXISTS (select * from GxQscripts where name='archFileSetInvalidByJobNewSP')
	delete from GxQscripts where name = 'archFileSetInvalidByJobNewSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSetInvalidByJobNewSP')
	delete from GXDBVersions where aliasname = 'archFileSetInvalidByJobNewSP'
GO
print '... Creating Procedure: archFileSetInvalidByJobNewSP'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archFileSetInvalidByJobNewSP
  @i_jobId int,
  @i_commCellId int,
  @i_afterTime int,
  @i_snapAFOnly int = 0,
  @i_AFName NVARCHAR(2048) = '',
  @i_AFIdList VARCHAR(MAX) = '',
  @i_AFType int = 0
AS
DECLARE @retVal		INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @nAFs INT
SET		@nAFs = 0
DECLARE @nSiloAFs INT
SET		@nSiloAFs = 0
DECLARE @tblSMVolId TABLE (SMVolumeId INT)
DECLARE	@tblSILOAppAF TABLE (archFileId INT, commCellId INT)
DECLARE	@tblAF TABLE (archFileId INT)
--Clean up archChunkToSF table, so that we start from beginning here
UPDATE	ArchChunkToSFArchFiles
SET		ProcessedItems = 0
WHERE	adminJobId = @i_jobId
DELETE FROM archChunkToSF
WHERE	adminJobId = @i_jobId
--Ignore the requrest if job has at least one edge drive archive file
IF EXISTS (	SELECT TOP 1 *
			FROM archFile AF WITH (NOLOCK)
			WHERE	jobId = @i_jobId
					AND commCellId = @i_commCellId
AND (AF.flags & (32768|2097152)) > 0)
BEGIN
	SET	@retVal = 0
	GOTO FINISH
END
-- Changes for reference copy. Invalidate AFs on jobId + commcellId + AF name.
IF (@i_AFIdList <> '')
BEGIN
	INSERT INTO @tblAF
	SELECT	_ID
	FROM	dbo.SplitIDs(@i_AFIdList)
	SELECT	@retVal = @@ERROR, @nAFs = @@ROWCOUNT
	IF	@retVal <> 0 GOTO FINISH
END
INSERT	INTO @tblSILOAppAF
SELECT	AF.id, AF.commCellId
FROM	archFile AF WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId
	AND AF.archGroupId = AGC.archGroupId AND AF.appId = AGC.siloAppId
	AND (@nAFs = 0 OR AF.id IN (SELECT archFileId FROM @tblAF))
SELECT	@retVal = @@ERROR, @nSiloAFs = @@ROWCOUNT
IF	@retVal <> 0 GOTO FINISH
-- Changes for reference copy. Invalidate AFs on jobId + commcellId + AF name.
IF (@i_AFName <> '')
BEGIN
	UPDATE archFile SET isValid = -1
	WHERE jobId = @i_jobId AND commCellId = @i_commCellId
	AND name = @i_AFName
	SELECT	@retVal = @@ERROR
	-- We are done here. Go to finish and exit.
	GOTO FINISH
END
/*
If @i_snapAFOnly is set we will consider only snap archive files (data and log).
Current requirement doesn't need bcd index AFs to be be processed when this parameter is set - if required have to be changed later
if arch file type mentioned mark those type as invalid or mark all archive files for the job
*/
UPDATE	archFile SET isValid = -1
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId AND cTime >= @i_afterTime
AND (@i_snapAFOnly = 0 OR flags & 2 > 0)
		AND (@nAFs = 0 OR id IN (SELECT archFileId FROM @tblAF))
		AND (@i_AFType = 0 OR fileType = @i_AFType)
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
/*
Do this only for snapAFOnly
*/
BEGIN
	-- For Primary Snap-Protect Job
	INSERT	INTO @tblSMVolId
	SELECT	DISTINCT SMV.SMVolumeId
	FROM 	archFile AF WITH (NOLOCK) INNER JOIN SMVolume SMV WITH (NOLOCK)
			ON AF.Id = SMV.ArchFileId
			AND AF.commCellId = SMV.CommCellId
	WHERE	AF.jobId = @i_jobId
			AND AF.commCellId = @i_commCellId
AND (@i_snapAFOnly = 1 AND AF.flags & 2 > 0)
			AND AF.cTime >= @i_afterTime
			AND (@nAFs = 0 OR AF.id IN (SELECT archFileId FROM @tblAF))
			AND (@i_AFType = 0 OR AF.fileType = @i_AFType)
	DECLARE @inputXML NVARCHAR(MAX)
	SET @inputXML = '<archPruneSnapArchiveFiles>'
	DECLARE @SMVolId INT = 0
	DECLARE GetSMVolIdsCursor CURSOR FOR
	SELECT DISTINCT SMVolumeId FROM @tblSMVolId
	OPEN GetSMVolIdsCursor
	FETCH GetSMVolIdsCursor INTO @SMVolId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @inputXML = @inputXML + '<SMVolumeId>' + CAST(@SMVolId AS NVARCHAR(100))  + '</SMVolumeId>'
		FETCH GetSMVolIdsCursor INTO @SMVolId
	END
	CLOSE GetSMVolIdsCursor
	DEALLOCATE GetSMVolIdsCursor
	SET @inputXML = @inputXML + '</archPruneSnapArchiveFiles>'
END
IF EXISTS (SELECT * FROM @tblSMVolId)
BEGIN
	DECLARE @tblRtn TABLE (retVal INT, SMVolumeId INT, MMErrCode INT, retStr VARCHAR(1024))
	INSERT INTO @tblRtn
	EXEC archPruneSnapArchiveFiles @inputXML
	SELECT @retVal = @@ERROR
	IF @retVal <> 0 GOTO FINISH
	SET @retVal = ISNULL((SELECT TOP 1 MMErrCode FROM @tblRtn WHERE MMErrCode > 0), 0)
	IF @retVal <> 0 GOTO FINISH
END
IF	@nSiloAFs > 0
BEGIN
	DECLARE	@tblVol TABLE (volumeId INT)
	INSERT	INTO @tblVol
	SELECT	siloVolumeId
	FROM	archFileSiloVolume SV WITH (NOLOCK), @tblSILOAppAF AF
	WHERE	SV.archFileId = AF.archFileId AND SV.commCellId = AF.commCellId
	IF @@ROWCOUNT > 0 AND @@ERROR = 0
	BEGIN
		DELETE	archFileSiloVolume
		FROM	@tblSILOAppAF AF
		WHERE	archFileSiloVolume.archFileId = AF.archFileId
			AND archFileSiloVolume.commCellId = AF.commCellId
		SELECT	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
		UPDATE	MMVolume SET SiloStatus = 1 /* SILO_VOLUME_TO_BE_MIGRATED */
		FROM	@tblVol V
		WHERE	MMVolume.VolumeId = V.VolumeId
			AND MMVolume.SiloStatus <> 1 /* SILO_VOLUME_TO_BE_MIGRATED */
		SELECT	@retVal = @@ERROR
	END
	UPDATE	IdxSIDBStore SET SIDBSiloJobId = 0
	WHERE	SIDBSiloJobId = @i_jobId
END
FINISH:
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSetInvalidByJobNewSP')
	delete from GxQscripts where name = 'archFileSetInvalidByJobNewSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSetInvalidByJobNewSP')
	delete from GXDBVersions where aliasname = 'archFileSetInvalidByJobNewSP'
GO

insert into GXDBVersions values(2, 'archFileSetInvalidByJobNewSP',  'v1.1.2.1.8.1', 'archFileSetInvalidByJobNewSP', 'v1.1.2.1.8.1')
GO

