

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileSetAgedViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileSetAgedViaTable.sp,v $ $Id: archFileSetAgedViaTable.sp,v 1.29.42.15 2020/01/05 03:53:37 bheemesh Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileSetAgedViaTable')
BEGIN
	print '>>> Drop Stored Procedure: archFileSetAgedViaTable <<<'
	drop procedure archFileSetAgedViaTable
END
IF EXISTS (select * from GxQscripts where name='archFileSetAgedViaTable')
	delete from GxQscripts where name = 'archFileSetAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSetAgedViaTable')
	delete from GXDBVersions where aliasname = 'archFileSetAgedViaTable'
GO
print '... Creating Procedure: archFileSetAgedViaTable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileSetAgedViaTable
  @i_agedByFlag bigint,
  @i_agedTime integer,
  @i_DADeletionFlags INT=0
AS
DECLARE @retVal	integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
DECLARE	@hasMagnetic INT
SET		@hasMagnetic = 0
DECLARE @oneConstReal REAL
SET			@oneConstReal = 1.0
DECLARE @rowCount INT = 0
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
*/
IF NOT EXISTS (SELECT 1 FROM #ToBeAgedAFC)
BEGIN
	SET @retVal = 0
	GOTO ERROR_EXIT
END
--
-- Check if DA is enabled before proceeding
--
if ( (@i_DADeletionFlags & 1 ) = 0)
begin
	declare @l_isDAEnabled integer
	set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
	if (@l_isDAEnabled = 0)
	begin
set @retVal = -1000
		GOTO ERROR_EXIT
	end
end
IF object_id('tempdb.dbo.#ToBeAgedAFCOnTransitiveCopy') IS NOT NULL DROP TABLE #ToBeAgedAFCOnTransitiveCopy
CREATE TABLE #ToBeAgedAFCOnTransitiveCopy (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
IF object_id('tempdb.dbo.#ToBeAgedACM') IS NOT NULL DROP TABLE #ToBeAgedACM
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, acCommcellId INT, archFileId INT, afCommcellId INT, archCopyId INT, physicalSize BIGINT, dedupSize BIGINT, JobId INT, appSizeFreedBytes BIGINT,
	PRIMARY KEY (archChunkId, acCommcellId, archFileId, afCommCellId, archCopyId))
IF object_id('tempdb.dbo.#ToBeAgedAC') IS NOT NULL DROP TABLE #ToBeAgedAC
CREATE TABLE #ToBeAgedAC (
	archChunkId BIGINT, commCellId INT, archCopyId INT, volumeId INT, version INT,
	cclip varchar(255), physicalSize BIGINT, SIDBStoreId INT, isMagnetic INT, MountPathId INT, ChunkPrunable INT,
 	PRIMARY KEY (archChunkId, commCellId, archCopyId))
IF object_id('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
IF object_id('tempdb.dbo.#ToBeAgedAFCWithoutChunks') IS NOT NULL DROP TABLE #ToBeAgedAFCWithoutChunks
CREATE TABLE #ToBeAgedAFCWithoutChunks (
	archFileId INT, commCellId INT, archCopyId INT, SIDBStoreId INT
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE INDEX Idx_tmpToBeAgedAFCWithoutChunks_1 ON #ToBeAgedAFCWithoutChunks (SIDBStoreId)
IF object_id('tempdb.dbo.#removableMedia') IS NOT NULL DROP TABLE #removableMedia
CREATE TABLE #removableMedia (volId INT)
--BEGIN TRY
	-- Prune the corresponding archive files on transitive copy
	INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
AND AFC.flags & 256 = 0
   SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
  INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archGroupCopy AGC WITH (NOLOCK), archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = AGC.id
			AND AGC.destMediaCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			AND AGC.destMediaCopyId > 0
AND AFC.flags & 256 = 0
    SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Get chunks of pruneable archive files
	INSERT	INTO #ToBeAgedACM
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, ACM.dedupedSize, ACM.JobId, ACM.unCompSize
	FROM	#ToBeAgedAFC T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
AND ACM.flags & 256 = 0
	UNION
	SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, ACM.dedupedSize, ACM.JobId, ACM.unCompSize
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
AND ACM.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	--Get all archive files without any chunks to populate MMDeletedAF table
	INSERT INTO #ToBeAgedAFCWithoutChunks
	SELECT T.archFileId, T.commCellId, T.archCopyId, 0
	FROM #ToBeAgedAFC T LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
	ON 	T.archFileId = ACM.archFileId
	AND	T.commCellId = ACM.commCellId
	AND 	T.archCopyId = ACM.archCopyId
	WHERE	ACM.archFileId IS NULL
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	--Get the SIDBStoreId for archive files
	UPDATE #ToBeAgedAFCWithoutChunks
	SET	SIDBStoreId = AFCD.SIDBStoreId
	FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopyDedup AFCD WITH (NOLOCK)
	WHERE	T.archFileId = AFCD.archFileId
	AND	T.commCellId = AFCD.commCellId
	AND 	T.archCopyId = AFCD.archCopyId
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	INSERT	INTO #ToBeAgedAC
	SELECT	DISTINCT AC.id, AC.commCellId, T.archCopyId, AC.volumeId, AC.version, AC.cclip, AC.physicalSize, 0, 0, 0, 1
	FROM	 #ToBeAgedACM T, archChunk AC WITH(NOLOCK)
	WHERE	AC.id = T.archChunkId
	AND AC.commCellId = T.acCommcellId
AND AC.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Flag magnetic chunks
	UPDATE	#ToBeAgedAC
	SET		isMagnetic = 1, SIDBStoreId = V.SIDBStoreId, MountPathId = MP.MountPathId
	FROM	#ToBeAgedAC T, MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
WHERE	T.volumeId = V.VolumeId AND V.RecordingFormatId = 10001
		AND	V.MediaSideId = MP.MediaSideId
	SELECT @rowCount = @@ROWCOUNT, @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	IF @rowCount > 0
		SET @hasMagnetic = 1
	IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE (name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING') AND value > 0)
	BEGIN
		INSERT INTO #removableMedia
		SELECT DISTINCT T.VolumeId
		FROM    #ToBeAgedAC T
		DELETE T
		FROM #removableMedia T
			LEFT OUTER JOIN MMVolume V WITH (NOLOCK) ON T.volId = V.VolumeId
LEFT OUTER JOIN MMMedia M WITH (NOLOCK) ON V.MediaId = M.MediaId AND (M.MediaTypeId >= 11001 AND M.MediaTypeId <= 11999)
			LEFT OUTER JOIN MMDrive D WITH (NOLOCK) ON M.MediaId = D.MediaId
			LEFT OUTER JOIN MMDriveController DC WITH (NOLOCK) ON D.DriveId = DC.DriveId
			LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = DC.ClientId
			LEFT OUTER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, DC.ClientId)
LEFT OUTER JOIN APP_Client CLIENT WITH (READUNCOMMITTED) ON CLIENT.id = ISNULL(MAP.PMClientId, DC.ClientId) AND ((CLIENT.releaseId > 16) OR ((CLIENT.releaseId = 16) AND (PKG.HighestSP >= 11)))
		WHERE M.MediaId IS NULL OR CLIENT.id IS NULL
		UPDATE	#ToBeAgedAC
		SET		isMagnetic = 1
		FROM	#ToBeAgedAC T
			LEFT OUTER JOIN MMDeletedAF D WITH (NOLOCK) ON T.archChunkId = D.archChunkId AND T.commCellId = D.chunkCommCellId
			INNER JOIN  #removableMedia V ON T.volumeId = V.VolId
		WHERE
		D.archChunkId IS NULL
		SELECT @rowCount = @@ROWCOUNT, @retVal = @@ERROR
		IF(@retVal <> 0)
			GOTO ERROR_EXIT
		IF @rowCount > 0 AND @hasMagnetic = 0
			SET @hasMagnetic = 1
	END
	-- Calculate appSizeFreedBytes ONLY for dedupe data
	INSERT INTO #tmpJobSizeInfo
	SELECT DISTINCT ACM.JobId, ACM.afCommcellId, 0, 0, 0
	FROM	#ToBeAgedACM ACM, #ToBeAgedAC AC
	WHERE	ACM.archChunkId = AC.archChunkId
	AND 	ACM.acCommcellId = AC.commCellId
	AND 	AC.SIDBStoreId > 0 AND ACM.appSizeFreedBytes = -1
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Get totalBackupSize, totalAppSize, totalIndexSize for dedupe jobs
	EXEC archGetJobSizeInfo 0
	UPDATE #ToBeAgedACM
	SET		appSizeFreedBytes = (CASE WHEN JI.totalBackupSize > 0
																	THEN CAST(((@oneConstReal * (JI.totalAppSize + JI.totalIndexSize) * ACM.physicalSize) / JI.totalBackupSize) AS BIGINT)
																	ELSE ACM.physicalSize
															END)
	FROM	#ToBeAgedACM ACM, #tmpJobSizeInfo JI
	WHERE ACM.JobId = JI.JobId
	AND  	ACM.afCommcellId = JI.CommCellId
	AND 	ACM.appSizeFreedBytes = -1
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Mark SMVolume as prunable
	UPDATE	SMVolume
SET		PruneFlags = 3
	FROM	#ToBeAgedAFC T, SMVolume A
	WHERE	A.archFileId = T.archFileId
		AND A.commCellId = T.commCellId
		AND A.CopyId = T.archCopyId
AND A.PruneFlags IN (0, 1, 2)
		AND (
				-- For non-VSA v2 cases bit will be 0
( A.VolumeFlags & CAST(4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ = 0 )
				-- For VSA v2 & v21 cases
				OR
				(
					-- VSA v2 and v21 child and parent SMVolume entries should have this VolumeFlags bit set if not dont proceed further
( A.VolumeFlags & CAST(4294967296 AS BIGINT) /*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB*/ > 0 )
					AND
					(
						-- Child VM/Guest client jobs
						A.jobid <> A.MasterJobId
						OR
						-- Parent without any dependent childresn
						NOT EXISTS	(
										SELECT    1 FROM SMVolume B WITH (READUNCOMMITTED)
										WHERE    A.MasterJobId = B.MasterJobId  	--all children + parent
										AND A.jobid <> B.jobid  	-- ONLY if there is a child entry B.jobid will be different
										AND A.CopyId = B.CopyId
										AND A.CommCellId = B.CommCellId
									)
					)
				)
			)
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	UPDATE	archFileCopy
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAFC T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND A.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	UPDATE	archFileCopy
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = (@i_agedByFlag | CAST(4294967296 AS BIGINT))
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND A.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Mark archive files and chunks as aged
	UPDATE	archChunkMapping
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAFC T, archChunkMapping A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND A.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	UPDATE	archChunkMapping
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = (@i_agedByFlag | CAST(4294967296 AS BIGINT))
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archChunkMapping A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND A.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Filter out chunks having non-aged archive files
	UPDATE T SET ChunkPrunable = 0
	FROM	#ToBeAgedAC T, archChunkMapping A WITH (NOLOCK)
	WHERE	A.archChunkId = T.archChunkId AND A.chunkCommCellId = T.commCellId
AND A.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	UPDATE	archChunk
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAC T, archChunk A
	WHERE	T.ChunkPrunable = 1 AND A.id = T.archChunkId AND A.commCellId = T.commCellId
AND A.flags & 256 = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- For archive files prior to 5.0
	-- Keep appSizeFreedBytes = 0 since these are older version archive files without dedupe
	IF @hasMagnetic = 1
	BEGIN
		INSERT	INTO MMDeletedAF
		SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, SUM(A.physicalSize),
				0, B.MountPathId, 0, A.afCommcellId, @i_agedTime, 0, 0, 0, 0, 0, 0
		FROM	#ToBeAgedACM A, #ToBeAgedAC B
		WHERE	A.archChunkId = B.archChunkId AND A.acCommcellId = B.commCellId
			AND B.version < 3 AND B.isMagnetic = 1
		GROUP	BY A.archFileId, B.volumeId, A.archCopyId, B.cclip, A.afCommcellId, B.MountPathId
			SET @retVal = @@ERROR
			IF(@retVal <> 0)
				GOTO ERROR_EXIT
	END
	-- For CV-Single-Instanced archive files
	-- Set appSizeFreedBytes only for dedupe chunks
	INSERT	INTO MMDeletedAF
SELECT	(case when @i_agedByFlag = 68719476736 then 0x7FFFFFFF else A.archFileId end), B.volumeId, 0, 0, A.archCopyId, B.cclip, A.dedupSize,
			A.archChunkId, B.MountPathId, B.SIDBStoreId, A.afCommcellId, @i_agedTime, 0, 0, 0, A.appSizeFreedBytes, 0, A.acCommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommcellId = B.commCellId
		AND B.SIDBStoreId > 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	INSERT INTO MMDeletedAF
	SELECT	archFileId, 0, 0, 0, archCopyId, 0, 0, 0, 0, SIDBStoreId, commCellId, @i_agedTime, 0, 0, 0, 0, 0, 0
	FROM #ToBeAgedAFCWithoutChunks
	WHERE	SIDBStoreId > 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	--We don't need these any more
	DELETE	#ToBeAgedAC WHERE ChunkPrunable = 0
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
	-- Keep appSizeFreedBytes = 0 for non dedupe chunks
	IF @hasMagnetic = 1
	BEGIN
		INSERT	INTO MMDeletedAF
		SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize,
				archChunkId, #ToBeAgedAC.MountPathId, 0, 0, @i_agedTime, 0, 0, 0, 0, 0, commCellId
		FROM	#ToBeAgedAC
		WHERE	isMagnetic = 1 AND SIDBStoreId = 0 AND version >= 3
			SET @retVal = @@ERROR
			IF(@retVal <> 0)
				GOTO ERROR_EXIT
	END
	-- Keep appSizeFreedBytes = 0 for non magnetic chunks
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, '', SUM(physicalSize),
			0, 0, 0, 0, @i_agedTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isMagnetic = 0 AND SIDBStoreId = 0
	GROUP BY volumeId, archCopyId, commCellId
	SET @retVal = @@ERROR
	IF(@retVal <> 0)
		GOTO ERROR_EXIT
--END TRY
--BEGIN CATCH
--	SET @retVal = (SELECT ERROR_NUMBER())
--END CATCH
ERROR_EXIT:
IF object_id('tempdb.dbo.#ToBeAgedAFCOnTransitiveCopy') IS NOT NULL DROP TABLE #ToBeAgedAFCOnTransitiveCopy
IF object_id('tempdb.dbo.#ToBeAgedACM') IS NOT NULL DROP TABLE #ToBeAgedACM
IF object_id('tempdb.dbo.#ToBeAgedAC') IS NOT NULL DROP TABLE #ToBeAgedAC
IF object_id('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF object_id('tempdb.dbo.#ToBeAgedAFCWithoutChunks') IS NOT NULL DROP TABLE #ToBeAgedAFCWithoutChunks
IF object_id('tempdb.dbo.#removableMedia') IS NOT NULL DROP TABLE #removableMedia
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileSetAgedViaTable')
	delete from GxQscripts where name = 'archFileSetAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileSetAgedViaTable')
	delete from GXDBVersions where aliasname = 'archFileSetAgedViaTable'
GO

insert into GXDBVersions values(2, 'archFileSetAgedViaTable',  '00010029004200150000', 'archFileSetAgedViaTable', '00010029004200150000')
GO

