

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileMediaByOffset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileMediaByOffset.sp,v $ $Id: archFileMediaByOffset.sp,v 1.10.294.2 2018/03/22 01:18:56 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileMediaByOffset <<<'

IF EXISTS (select * from sysobjects where name='archFileMediaByOffset')
	drop procedure archFileMediaByOffset
IF EXISTS (select * from GxQscripts where name='archFileMediaByOffset')
	delete from GxQscripts where name = 'archFileMediaByOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileMediaByOffset')
	delete from GXDBVersions where aliasname = 'archFileMediaByOffset'
GO
print '... Creating Procedure: archFileMediaByOffset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileMediaByOffset
  @i_copyPrecedence integer,
  @i_includeAgedData integer
AS
  DECLARE @r_mediaId integer;
  DECLARE @r_uniqueId char(64);
  DECLARE @r_barCode char(64);
  DECLARE @r_mediaTypeId integer;
  DECLARE @r_mediaTypeName varchar(32);
  DECLARE @r_attributes integer;
  DECLARE @r_PinMediaExpireTime datetime;
  DECLARE @r_mediaLocation integer;
  DECLARE @r_mediaLocationString NVARCHAR(64);
  DECLARE @r_exportLocation NVARCHAR(64);
  DECLARE @r_containerId integer;
  DECLARE @r_containerName NVARCHAR(64);
  DECLARE @r_libraryId integer;
  DECLARE @r_libraryName NVARCHAR(64);
  DECLARE @r_copyId integer;
  DECLARE @r_copyPrecedence integer;
  DECLARE @r_copyName NVARCHAR(64);
  DECLARE @r_spId integer;
  DECLARE @r_spName NVARCHAR(64);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* This temp table must be created and populated by the caller.
CREATE TABLE #tempArchFileOffset (
	archFileId int, commCellId int, fromPhysicalOffset bigint, toPhysicalOffset bigint)
*/
CREATE TABLE #tempAFChunk	(archChunkId bigint, archFileId int, commCellId int, archCopyId int, copyPrecedence int)
CREATE TABLE #tempChunk		(archChunkId bigint, commCellId int, archCopyId int)
CREATE TABLE #tempMedia		(
		archCopyId			int,
		MediaSideId			int,
		MediaId				int,
UniqueId			varchar(64),
BarCode				varchar(64),
		MediaTypeId			int,
MediaTypeName		varchar(32),
		LibraryId			int,
		ExportLocationId	int,
		MediaLocation		int,
		ContainerId			int,
		PinMediaExpireTime	int)
INSERT	INTO #tempAFChunk
SELECT	ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, AGC.copy
FROM	#tempArchFileOffset AFO,
		archChunkMapping ACM WITH (NOLOCK),
		archGroupCopy AGC WITH (NOLOCK)
WHERE	ACM.archFileId = AFO.archFileId AND ACM.commCellId = AFO.commCellId
	AND (ACM.physicalOffset + ACM.physicalSize) > AFO.fromPhysicalOffset AND ACM.physicalOffset < AFO.toPhysicalOffset
	AND (@i_includeAgedData <> 0 OR ACM.flags & 256 = 0)
	AND AGC.id = ACM.archCopyId
	AND (@i_copyPrecedence = 0 OR AGC.copy = @i_copyPrecedence)
INSERT	INTO #tempChunk
SELECT	DISTINCT A.archChunkId, A.commCellId, A.archCopyId
FROM	#tempAFChunk A,
		(SELECT	archFileId, commCellId, MIN(copyPrecedence) AS copyPrecedence
		FROM	#tempAFChunk
		GROUP BY archFileId, commCellId) B
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
	AND A.copyPrecedence = B.copyPrecedence
INSERT	INTO #tempMedia
SELECT	DISTINCT T.archCopyId, V.MediaSideId,
		M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, MT.MediaTypeName, M.LibraryId,
		M.ExportLocationId, M.MediaLocation, M.ContainerId, M.PinMediaExpireTime
FROM	MMVolume V WITH (NOLOCK),
		MMMedia M WITH (NOLOCK),
		(SELECT	DISTINCT AC.volumeId, TC.archCopyId
		FROM	archChunk AC WITH (NOLOCK), #tempChunk TC
		WHERE	AC.id = TC.archChunkId AND AC.commCellId = TC.commCellId) T,
		MMMediaType MT WITH (NOLOCK)
WHERE	V.VolumeId = T.volumeId
	AND M.MediaId = V.MediaId
	AND M.MediaTypeId = MT.MediaTypeId
--UPDATE	#tempMedia
--SET		BarCode = (case when MP.MountPathTypeId = 1 then (
--						SELECT	a.FriendlyName
--						FROM	MMCenteraInfo a WITH (NOLOCK),
--								MMMountPathToStorageDevice b WITH (NOLOCK)
--						WHERE	a.CenteraId = b.CenteraId AND b.MountPathId = MP.MountPathId)
--					else MP.MountPathName end)
--FROM	#tempMedia M,
--		MMMountPath MP WITH (NOLOCK)
--WHERE	M.MediaSideId = MP.MediaSideId AND M.MediaTypeId = CV_MAGNETIC_MEDIA
UPDATE	#tempMedia
SET		BarCode = 'N/A'
WHERE	MediaTypeId = 10001
SELECT	MediaId,
		UniqueId,
		BarCode,
		MediaTypeId,
		MediaTypeName,
		dbo.MMS2FUNC_GetGUIMediaAttribute(MediaId) as attributes,
		dbo.GetDateTime(PinMediaExpireTime) as PinMediaExpireTime,
		MediaLocation,
		dbo.GetMediaLocation(M.MediaId, M.MediaLocation, M.LibraryId, M.ExportLocationId) as mediaLocationString,
		(SELECT ExportLocation FROM MMExportLocation WITH (NOLOCK) WHERE ExportLocationId = M.ExportLocationId) as exportLocation,
		ContainerId,
		(SELECT ISNULL(ContainerName, 'N/A') FROM MMContainer WITH (NOLOCK) WHERE ContainerId = M.ContainerId) as containerName,
		LibraryId,
		(SELECT AliasName FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = M.LibraryId) as libraryName,
		AGC.id as copyId,
		AGC.copy as copyPrecedence,
		AGC.name as copyName,
		AG.id as spId,
		AG.name as spName
FROM 	#tempMedia M,
		archGroupCopy AGC WITH (NOLOCK),
		archGroup AG WITH (NOLOCK)
WHERE	AGC.id = M.archCopyId AND AG.id = AGC.archGroupId
ORDER BY BarCode
DROP TABLE #tempAFChunk
DROP TABLE #tempChunk
DROP TABLE #tempMedia
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archFileMediaByOffset')
	delete from GxQscripts where name = 'archFileMediaByOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileMediaByOffset')
	delete from GXDBVersions where aliasname = 'archFileMediaByOffset'
GO

insert into GXDBVersions values(2, 'archFileMediaByOffset',  '00010010029400020000', 'archFileMediaByOffset', '00010010029400020000')
GO

