

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileListByTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileListByTime.sp,v $ $Id: archFileListByTime.sp,v 1.1.2.7 2020/06/06 02:58:23 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileListByTime')
BEGIN
	print '>>> Drop Stored Procedure: archFileListByTime <<<'
	drop procedure archFileListByTime
END
IF EXISTS (select * from GxQscripts where name='archFileListByTime')
	delete from GxQscripts where name = 'archFileListByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileListByTime')
	delete from GXDBVersions where aliasname = 'archFileListByTime'
GO
print '... Creating Procedure: archFileListByTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileListByTime
  @i_appId integer,
  @i_backupSetId integer,
  @i_instanceId integer,
  @i_appTypeId integer,
  @i_clientId integer,
  @i_fileType integer,
  @i_beforeTime integer,
  @i_afilesCutTime integer,
  @i_maxNumOfAfiles integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_includeReplacedIndices integer,
  @i_flags integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @archFileId integer
  DECLARE @name NVARCHAR(2048)
  DECLARE @commCellId integer
  DECLARE @archGroupId integer
  DECLARE @copyId integer
  DECLARE @appId integer
  DECLARE @fileType integer
  DECLARE @createTime integer
  DECLARE @jobId integer
  DECLARE @backupLevel integer
  DECLARE @physicalSize bigint
  DECLARE @logicalSize bigint
  DECLARE @isSnapData integer
  DECLARE @isSnapCopy integer
  DECLARE @wasOriginalJobSnapBackup integer
  DECLARE @AFFlags integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
------------------------------
declare @l_errorCode Integer
SET @l_errorCode = 0
if (@i_beforeTime <= 0)
	set @i_beforeTime = 2147483647
DECLARE @lt_Jobs TABLE (
		jobId			int,
		commCellId		int,
		opType			int,
		startDate		int,
		fullcycleNum	int,
		bkpLevel		int,
		bkpAttributes	bigint)
DECLARE @l_useJobEndTime BIT = (@i_flags & 16)
IF @i_appId > 0
BEGIN
	IF(@l_useJobEndTime = 0) /*Only difference in If and Else parts should be to use servStartDate or servEndDate. Otherwise any change made in either block should be replicated in the other*/
		INSERT	INTO @lt_Jobs
		SELECT	jobId, commCellId, opType, servStartDate, fullcycleNum, bkpLevel, bkpAttributes
		FROM	JMBkpStats WITH (READUNCOMMITTED)
		WHERE	appId = @i_appId
		AND servStartDate <= @i_beforeTime AND status IN (1, 3, 14) AND opType <> 60
	ELSE
		INSERT	INTO @lt_Jobs
		SELECT	jobId, commCellId, opType, servStartDate, fullcycleNum, bkpLevel, bkpAttributes
		FROM	JMBkpStats WITH (READUNCOMMITTED)
		WHERE	appId = @i_appId
		AND servEndDate <= @i_beforeTime AND status IN (1, 3, 14) AND opType <> 60
END
ELSE IF (@i_flags & 8) > 0
BEGIN
	IF(@l_useJobEndTime = 0) /*Only difference in If and Else parts should be to use servStartDate or servEndDate. Otherwise any change made in either block should be replicated in the other*/
		INSERT	INTO @lt_Jobs
		SELECT	DISTINCT J.jobId, J.commCellId, J.opType, J.servStartDate, J.fullcycleNum, J.bkpLevel, J.bkpAttributes
		FROM	JMBkpStats J WITH (READUNCOMMITTED) , APP_Application A WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED)
		WHERE	J.appId = A.id
		AND J.servStartDate <= @i_beforeTime AND J.status IN (1, 3, 14) AND J.opType <> 60
		AND (@i_backupSetId = 0 OR A.backupSet = @i_backupSetId)
		AND (@i_instanceId = 0 OR A.instance = @i_instanceId)
		AND (@i_appTypeId = 0 OR A.appTypeId = @i_appTypeId)
		AND (@i_clientId = 0 OR A.clientId = @i_clientId)
AND AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND (AF.flags & 2) > 0
	ELSE
		INSERT	INTO @lt_Jobs
		SELECT	DISTINCT J.jobId, J.commCellId, J.opType, J.servStartDate, J.fullcycleNum, J.bkpLevel, J.bkpAttributes
		FROM	JMBkpStats J WITH (READUNCOMMITTED) , APP_Application A WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED)
		WHERE	J.appId = A.id
		AND J.servEndDate <= @i_beforeTime AND J.status IN (1, 3, 14) AND J.opType <> 60
		AND (@i_backupSetId = 0 OR A.backupSet = @i_backupSetId)
		AND (@i_instanceId = 0 OR A.instance = @i_instanceId)
		AND (@i_appTypeId = 0 OR A.appTypeId = @i_appTypeId)
		AND (@i_clientId = 0 OR A.clientId = @i_clientId)
AND AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND (AF.flags & 2) > 0
END
ELSE
BEGIN
	IF(@l_useJobEndTime = 0) /*Only difference in If and Else parts should be to use servStartDate or servEndDate. Otherwise any change made in either block should be replicated in the other*/
		INSERT	INTO @lt_Jobs
		SELECT	DISTINCT J.jobId, J.commCellId, J.opType, J.servStartDate, J.fullcycleNum, J.bkpLevel, J.bkpAttributes
		FROM	JMBkpStats J WITH (READUNCOMMITTED) , APP_Application A WITH (READUNCOMMITTED)
		WHERE	J.appId = A.id
		AND J.servStartDate <= @i_beforeTime AND J.status IN (1, 3, 14) AND J.opType <> 60
		AND (@i_backupSetId = 0 OR A.backupSet = @i_backupSetId)
		AND (@i_instanceId = 0 OR A.instance = @i_instanceId)
		AND (@i_appTypeId = 0 OR A.appTypeId = @i_appTypeId)
		AND (@i_clientId = 0 OR A.clientId = @i_clientId)
	ELSE
		INSERT	INTO @lt_Jobs
		SELECT	DISTINCT J.jobId, J.commCellId, J.opType, J.servStartDate, J.fullcycleNum, J.bkpLevel, J.bkpAttributes
		FROM	JMBkpStats J WITH (READUNCOMMITTED) , APP_Application A WITH (READUNCOMMITTED)
		WHERE	J.appId = A.id
		AND J.servEndDate <= @i_beforeTime AND J.status IN (1, 3, 14) AND J.opType <> 60
		AND (@i_backupSetId = 0 OR A.backupSet = @i_backupSetId)
		AND (@i_instanceId = 0 OR A.instance = @i_instanceId)
		AND (@i_appTypeId = 0 OR A.appTypeId = @i_appTypeId)
		AND (@i_clientId = 0 OR A.clientId = @i_clientId)
END
IF (@@ROWCOUNT = 0)
BEGIN
	-- no data
	SET @l_errorCode  = 100
	GOTO PROC_EXIT
END
IF((@i_fileType = 4) AND (@i_flags & 4 > 0))
BEGIN
	INSERT INTO @lt_Jobs
	SELECT JBKP.jobId, JBKP.commCellId, JBKP.opType, JBKP.servStartDate, JBKP.fullCycleNum, JBKP.bkpLevel, JBKP.bkpattributes FROM
	@lt_Jobs J INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON J.jobid = JDL.parentJobId AND J.commcellId = JDL.commcellId
	INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON JDL.childJobId = JBKP.jobId AND JDL.commcellId = JBKP.commcellId AND JBKP.status IN (1, 3, 14)
	LEFT OUTER JOIN @lt_Jobs J1 ON JBKP.jobId = J1.jobId AND JBKP.commCellId = J1.commCellId
	WHERE J1.jobId IS NULL
END
IF @i_flags & 1 = 1
BEGIN
			  DECLARE @lt_InstanceAppIds TABLE (AppId Integer)
              INSERT        INTO @lt_InstanceAppIds
              SELECT id
              FROM   APP_Application WITH (NOLOCK)
              WHERE Instance = @i_instanceId
              IF EXISTS (SELECT 1 FROM @lt_InstanceAppIds)
              BEGIN
DECLARE       @lt_LOgAFS TABLE (id INT, Name nvarChar(2048), commCellId INT, archGroupId INT, archCopyId INT,
                                                                     appId INT, fileType INT, cTime INT, jobId INT, backupLevel INT,
                                                                     physicalSize BIGINT, logicalSize BIGINT,snapFlag INT, isSnapCopy INT, wasSnap INT, flags INT, copyPrecedence INT)
                     IF(@l_useJobEndTime = 0)  /*Only difference in If and Else parts should be to use servStartDate or servEndDate. Otherwise any change made in either block should be replicated in the other*/
                     BEGIN
	                     INSERT INTO @lt_LOgAFS
	                     SELECT        AF.id, AF.name, AF.commcellId,  AF.archGroupId, AFC.archCopyId,
	                                  AF.appId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel,
	                                  AFC.physicalSize, AFC.logicalSize, AF.snapFlag, AGC.isSnapCopy, AF.wasSnap, AF.flags, AGC.copy
	                     FROM
	                     (
	                           SELECT TOP 1 AF1.id, AF1.name, AF1.commcellId, AF1.archGroupId, AF1.appId, AF1.fileType, AF1.cTime, AF1.jobId, AF1.backupLevel,
							   AGC.isSnapCopy, (AF1.flags & 2)/2 snapFlag, (case when JBS.opType IN (59/*SNAPBACKUP*/, 65/*SNAPBACKUP3RD*/) then 1 else 0 end) wasSnap,  AF1.flags
	                                  FROM @lt_InstanceAppIds APPS1
	                           INNER JOIN ArchFile AF1  WITH (NOLOCK)
	                                  ON AF1.AppId = APPS1.AppID
	                           INNER JOIN archFileCopy AFC WITH (NOLOCK)
	                                                ON AFC.archFileId = AF1.id
	                                                AND AFC.commCellId = AF1.commCellId
	                           INNER JOIN JMBkpStats JBS WITH (NOLOCK)
	                                  ON JBS.jobId = AF1.jobId AND JBS.commcellId = AF1.commcellId
	                           INNER JOIN archGroupCopy AGC WITH (NOLOCK)
	                                                ON AGC.id = AFC.archCopyId
	                                                       AND    (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))
	                                                       OR     @i_copyPrecedence = 0
	                                                       OR     @i_copyPrecedence = AGC.copy)
WHERE AF1.FileType = 4 AND AF1.isValid = 1 AND JBS.servStartDate > @i_beforetime
AND JBS.status IN (1, 3, 14) AND JBS.opType <> 60 /*SNAPTOTAPE*/ AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR AFC.flags & 256  = 0)
							   ORDER BY AF1.cTime
	                     ) AF    INNER JOIN archFileCopy AFC WITH (NOLOCK)
	                                                ON AFC.archFileId = AF.id
	                                                       AND AFC.commCellId = AF.commCellId
AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR AFC.flags & 256  = 0)
	                                         INNER JOIN archGroupCopy AGC WITH (NOLOCK)
	                                                ON AGC.id = AFC.archCopyId
	                                                       AND    (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))
	                                                       OR     @i_copyPrecedence = 0
	                                                       OR     @i_copyPrecedence = AGC.copy)
                     END
                     ELSE
                     BEGIN
	                     INSERT INTO @lt_LOgAFS
	                     SELECT        AF.id, AF.name, AF.commcellId,  AF.archGroupId, AFC.archCopyId,
	                                  AF.appId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel,
	                                  AFC.physicalSize, AFC.logicalSize, AF.snapFlag, AGC.isSnapCopy, AF.wasSnap, AF.flags, AGC.copy
	                     FROM
	                     (
	                           SELECT TOP 1 AF1.id, AF1.name, AF1.commcellId, AF1.archGroupId, AF1.appId, AF1.fileType, AF1.cTime, AF1.jobId, AF1.backupLevel,
							   AGC.isSnapCopy, (AF1.flags & 2)/2 snapFlag, (case when JBS.opType IN (59/*SNAPBACKUP*/, 65/*SNAPBACKUP3RD*/) then 1 else 0 end) wasSnap,  AF1.flags
	                                  FROM @lt_InstanceAppIds APPS1
	                           INNER JOIN ArchFile AF1  WITH (NOLOCK)
	                                  ON AF1.AppId = APPS1.AppID
	                           INNER JOIN archFileCopy AFC WITH (NOLOCK)
	                                                ON AFC.archFileId = AF1.id
	                                                AND AFC.commCellId = AF1.commCellId
	                           INNER JOIN JMBkpStats JBS WITH (NOLOCK)
	                                  ON JBS.jobId = AF1.jobId AND JBS.commcellId = AF1.commcellId
	                           INNER JOIN archGroupCopy AGC WITH (NOLOCK)
	                                                ON AGC.id = AFC.archCopyId
	                                                       AND    (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))
	                                                       OR     @i_copyPrecedence = 0
	                                                       OR     @i_copyPrecedence = AGC.copy)
WHERE AF1.FileType = 4 AND AF1.isValid = 1 AND JBS.servEndDate > @i_beforetime
AND JBS.status IN (1, 3, 14) AND JBS.opType <> 60 /*SNAPTOTAPE*/ AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR AFC.flags & 256  = 0)
							   ORDER BY AF1.cTime
	                     ) AF    INNER JOIN archFileCopy AFC WITH (NOLOCK)
	                                                ON AFC.archFileId = AF.id
	                                                       AND AFC.commCellId = AF.commCellId
AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR AFC.flags & 256  = 0)
	                                         INNER JOIN archGroupCopy AGC WITH (NOLOCK)
	                                                ON AGC.id = AFC.archCopyId
	                                                       AND    (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))
	                                                       OR     @i_copyPrecedence = 0
	                                                       OR     @i_copyPrecedence = AGC.copy)
                     END
              END
END
DELETE	@lt_Jobs
FROM	@lt_Jobs AF, APP_CommCell CC
WHERE	CC.id = AF.commCellId AND CC.type > 1
IF NOT EXISTS (SELECT * FROM @lt_Jobs)
BEGIN
	-- no data
	SET @l_errorCode  = 100
	GOTO PROC_EXIT
END
DECLARE @lt_JobCopy TABLE (
		jobId			int,
		commCellId		int,
		dataType		int,
		archGrpCopyId	int,
		copyPrecedence	int,
		isSnapCopy		int,
		appId			int,
		startDate		int,
		fullcycleNum	int,
		bkpLevel		int,
		bkpAttributes	bigint,
		wasSnap			int)
INSERT	INTO @lt_JobCopy
SELECT	JDS.jobId, JDS.commcellId, JDS.dataType, JDS.archGrpCopyId, AGC.copy, AGC.isSnapCopy,
		JDS.appId, J.startDate, J.fullcycleNum, J.bkpLevel, J.bkpAttributes, (case when J.opType IN (59, 65) then 1 else 0 end)
FROM	@lt_Jobs J
		INNER JOIN JMJobDataStats JDS
			ON J.jobId = JDS.jobId AND J.commcellId = JDS.commcellId
			AND JDS.status = 100
			AND (@i_includeAgedData <> 0 OR (JDS.disabled & 256) = 0)
		INNER JOIN archGroupCopy AGC
			ON AGC.id = JDS.archGrpCopyId
			AND	(@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup)
				 OR	@i_copyPrecedence = 0
				 OR	@i_copyPrecedence = AGC.copy)
IF @i_flags & 2 = 0 --For sync feature we need all files in time range
BEGIN
	IF @i_appTypeId IN (22/*CV_APPTYPE_ORACLE8*/, 61/*CV_APPTYPE_SAP_FOR_ORACLE*/, 62/*CV_APPTYPE_UNIX_DB2*/, 80/*CV_APPTYPE_ORACLE_RAC*/, 37/*CV_APPTYPE_DB2*/, 103/*CV_APPTYPE_DB2_DPF*/)
	BEGIN
		-- File Type 6 mean we are interested only for snap copy jobs
		IF (@i_fileType = 6)
		BEGIN
			DELETE	@lt_JobCopy
			WHERE	isSnapCopy <> 1
		END
		DECLARE	@MaxStartDate integer
		SELECT @MaxStartDate = ISNULL(MAX(startDate), 0) FROM @lt_JobCopy WHERE bkpLevel IN (1, 64, 1024, 32768) AND (bkpAttributes & 0x1000) <> 0
IF( (@i_flags & 4) = 0)
		BEGIN
			DELETE	@lt_JobCopy
			WHERE	/*startDate > @i_beforeTime --BeforeTime is already applied on @lt_jobs. This is not required
			OR */startDate < @MaxStartDate
		END
		ELSE
		BEGIN
			--Delete jobs before latest full except those log jobs that are linked with the latest full. Latest full can link with previous log jobs.
			DECLARE @lastFullJob Integer = 0
			DECLARE @lastFullJobCCId Integer = 0
			SELECT @lastFullJob = jobId, @lastFullJobCCId = commcellId from @lt_JobCopy WHERE startDate = @MaxStartDate
			DELETE T1
			FROM @lt_JobCopy T1
			WHERE T1.startDate < @MaxStartDate AND NOT EXISTS (SELECT 1 FROM JMJobDataLink JLINK WITH(NOLOCK) WHERE JLINK.childJobId = T1.jobId AND JLINK.commcellId = T1.commcellId AND JLINK.parentJobId = @lastFullJob AND JLINK.commcellId = @lastFullJobCCId)
		END
		--DELETE	@lt_JobCopy
		--WHERE	startDate > @i_beforeTime
		--	 OR startDate < ISNULL((SELECT MAX(startDate) FROM @lt_JobCopy WHERE bkpLevel IN (1, 1024, 32768) AND (bkpAttributes & 0x1000) <> 0), 0)
	END
	ELSE
		DELETE	@lt_JobCopy
		FROM	@lt_JobCopy JC,
				(SELECT appId, MAX(fullcycleNum) AS fullcycleNum FROM @lt_JobCopy GROUP BY appId) T
		WHERE	JC.appId = T.appId AND JC.fullcycleNum < T.fullcycleNum
END
IF NOT EXISTS (SELECT jobId FROM @lt_JobCopy)
BEGIN
	-- no jobs found
	SET @l_errorCode  = 102
	GOTO PROC_EXIT
END
-- now get all the archive files
PROC_EXIT:
IF	@l_errorCode > 0
	SELECT	-@l_errorCode , '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
ELSE
IF     @i_maxNumOfAfiles > 0
BEGIN
	   IF EXISTS(SELECT 1 FROM @lt_LOgAFS)
		SET @i_maxNumOfAfiles = @i_maxNumOfAfiles - 1
		SELECT id , Name , commCellId , archGroupId , archCopyId,
                           appId , fileType , cTime , jobId , backupLevel ,
                           physicalSize , logicalSize ,snapFlag , isSnapCopy , wasSnap, flags
						   FROM
		(
		SELECT TOP(@i_maxNumOfAfiles) AF.id, AF.name, AF.commCellId, AF.archGroupId, AFC.archCopyId,
					AF.appId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel,
					AFC.physicalSize, AFC.logicalSize, (AF.flags & 2)/2 snapFlag, J.isSnapCopy, J.wasSnap, AF.flags, J.copyPrecedence
		FROM   @lt_JobCopy J
					INNER JOIN archFile AF
							ON     AF.commCellId = J.commCellId AND AF.jobId = J.jobId AND AF.fileType = J.dataType
							AND AF.isValid = 1 AND AF.cTime > @i_afilesCutTime
					INNER JOIN archFileCopy AFC
							ON     AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId AND AFC.isValid = 1
					INNER JOIN archGroupCopy AGC
							ON  AFC.archCopyId = AGC.id
		WHERE  @i_fileType = 0 OR @i_fileType >= 1 AND dataType = @i_fileType OR @i_fileType  = 2 AND dataType in (2,6)
					AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, 5 = 5
		ORDER BY AF.cTime ASC, J.copyPrecedence ASC
		UNION
		SELECT        id , Name , commCellId , archGroupId , archCopyId,
					appId , fileType , cTime , jobId , backupLevel ,
					physicalSize , logicalSize ,snapFlag , isSnapCopy , wasSnap , flags, copyPrecedence
		FROM   @lt_LOgAFS
		) A
       ORDER BY cTime ASC, copyPrecedence ASC END ELSE
BEGIN
			SELECT id , Name , commCellId , archGroupId , archCopyId,
                           appId , fileType , cTime , jobId , backupLevel ,
                           physicalSize , logicalSize ,snapFlag , isSnapCopy , wasSnap , flags
						   FROM
              (
			  SELECT AF.id, AF.name, AF.commCellId, AF.archGroupId, AFC.archCopyId,
                           AF.appId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel,
                           AFC.physicalSize, AFC.logicalSize, (AF.flags & 2)/2 snapFlag, J.isSnapCopy, J.wasSnap, AF.flags, J.copyPrecedence
              FROM   @lt_JobCopy J
                           INNER JOIN archFile AF
                                  ON     AF.commCellId = J.commCellId AND AF.jobId = J.jobId AND AF.fileType = J.dataType
                                  AND AF.isValid = 1 AND AF.cTime > @i_afilesCutTime
                           INNER JOIN archFileCopy AFC
                                  ON     AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId AND AFC.isValid = 1
                           INNER JOIN archGroupCopy AGC
                                  ON  AFC.archCopyId = AGC.id
              WHERE  @i_fileType = 0 OR @i_fileType >= 1 AND dataType = @i_fileType OR @i_fileType  = 2 AND dataType in (2,6)
                           AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, 5 = 5
              UNION
              SELECT        id , Name , commCellId , archGroupId , archCopyId,
                           appId , fileType , cTime , jobId , backupLevel ,
                           physicalSize , logicalSize ,snapFlag , isSnapCopy , wasSnap , flags, copyPrecedence
              FROM   @lt_LOgAFS
			  ) A
              ORDER BY cTime ASC, copyPrecedence ASC END
GO

IF EXISTS (select * from GxQscripts where name = 'archFileListByTime')
	delete from GxQscripts where name = 'archFileListByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileListByTime')
	delete from GXDBVersions where aliasname = 'archFileListByTime'
GO

insert into GXDBVersions values(2, 'archFileListByTime',  '00010001000200070000', 'archFileListByTime', '00010001000200070000')
GO

