

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileLastIndexOfInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileLastIndexOfInstance.sp,v $ $Id: archFileLastIndexOfInstance.sp,v 1.8.204.3 2018/03/22 01:01:59 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileLastIndexOfInstance <<<'

IF EXISTS (select * from sysobjects where name='archFileLastIndexOfInstance')
	drop procedure archFileLastIndexOfInstance
IF EXISTS (select * from GxQscripts where name='archFileLastIndexOfInstance')
	delete from GxQscripts where name = 'archFileLastIndexOfInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileLastIndexOfInstance')
	delete from GXDBVersions where aliasname = 'archFileLastIndexOfInstance'
GO
print '... Creating Procedure: archFileLastIndexOfInstance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileLastIndexOfInstance
  @i_clientId integer,
  @i_appTypeId integer,
  @i_instanceId integer,
  @i_fileType integer,
  @i_toTime integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_errorCode integer
  DECLARE @r_afileId integer
  DECLARE @r_commCellId integer
  DECLARE @r_agroupId integer
  DECLARE @r_copyId integer
  DECLARE @r_fileType integer
  DECLARE @r_createTime integer
  DECLARE @r_jobId integer
  DECLARE @r_backupLevel integer
  DECLARE @r_appId integer
  DECLARE @r_backupSetId integer
  DECLARE @r_subclientName nchar(255)
  DECLARE @r_backupSetName nchar(255)
  DECLARE @r_instanceName nchar(255)
  DECLARE @r_appTypeName nchar(255)
  DECLARE @r_clientName nchar(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_errorCode	INT
DECLARE	@l_rowCount		INT
DECLARE	@l_archFileId	INT
DECLARE	@l_commCellId	INT
DECLARE	@l_archCopyId	INT
SET	@l_errorCode	= 0
SET	@l_rowCount		= 0
SET	@l_archFileId	= 0
SET	@l_commCellId	= 0
SET	@l_archCopyId	= 0
IF @i_toTime <= 0
	SET  @i_toTime = 0x7FFFFFFF
DECLARE @tblAFile TABLE (
	id INT, commCellId INT, archGroupId INT, appId INT,  fileType INT, flags INT, cTime INT, jobId INT, backupLevel INT)
INSERT INTO @tblAFile
SELECT	AF.id, AF.commCellId, AF.archGroupId, AF.appId, AF.fileType, AF.flags, AF.cTime, AF.jobId, AF.backupLevel
FROM	archFile AF WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
WHERE	AF.appId = APP.id
	AND APP.clientId = @i_clientId AND APP.appTypeId = @i_appTypeId AND APP.instance = @i_instanceId
	AND (@i_fileType = 0 OR @i_fileType = AF.fileType OR
(@i_fileType = 8 AND AF.fileType IN (2, 6)
AND (AF.flags & 8) <> 0  )
OR (@i_fileType = 62 AND AF.fileType IN (2, 6) ) )
	AND AF.cTime <= @i_toTime
	AND AF.isValid = 1
SELECT	@l_errorCode = @@ERROR, @l_rowCount = @@ROWCOUNT
IF	@l_errorCode = 0 AND @l_rowCount = 0
SET @l_errorCode = 78
IF	@l_errorCode <> 0
	GOTO FINISH
SELECT	TOP 1 @l_archFileId = b.archFileId, @l_commCellId = b.commCellId, @l_archCopyId = b.archCopyId
FROM	@tblAFile a, archFileCopy b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
WHERE	a.id = b.archFileId AND a.commCellId = b.commCellId AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
	AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
	AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ((@i_copyPrecedence = -1 AND c.id = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId))
OR @i_copyPrecedence = 0
		OR @i_copyPrecedence = c.copy)
ORDER BY
CASE WHEN @i_fileType = 62 AND (a.flags & 8 ) <> 0
THEN (a.flags & 8 ) ELSE 0 END DESC,
	a.cTime DESC, c.copy ASC
SELECT	@l_errorCode = @@ERROR, @l_rowCount = @@ROWCOUNT
IF	@l_errorCode = 0 AND @l_rowCount = 0
SET @l_errorCode = 79
FINISH:
IF @l_errorCode <> 0
	SELECT	TOP 1 @l_errorCode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, N'', N'',
			(SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = APP.instance),
			(SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = APP.appTypeId),
			(SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = APP.clientId)
	FROM	APP_Application APP WITH (NOLOCK)
	WHERE	clientId = @i_clientId AND appTypeId = @i_appTypeId AND instance = @i_instanceId
ELSE
	SELECT	0, AF.id, AF.commCellId, AF.archGroupId, @l_archCopyId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel,
			AF.appId, APP.backupSet, APP.subclientName, (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = APP.clientId),
			(SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = APP.instance),
			(SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = APP.appTypeId),
			(SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = APP.clientId)
	FROM	@tblAFile AF, APP_Application APP WITH (NOLOCK)
	WHERE	AF.id = @l_archFileId AND AF.commCellId = @l_commCellId
		AND AF.appId = APP.id
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileLastIndexOfInstance')
	delete from GxQscripts where name = 'archFileLastIndexOfInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileLastIndexOfInstance')
	delete from GXDBVersions where aliasname = 'archFileLastIndexOfInstance'
GO

insert into GXDBVersions values(2, 'archFileLastIndexOfInstance',  '00010008020400030000', 'archFileLastIndexOfInstance', '00010008020400030000')
GO

