

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileForPreparedJobCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileForPreparedJobCreate.sp,v $ $Id: archFileForPreparedJobCreate.sp,v 1.18.12.3 2019/03/22 10:04:32 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileForPreparedJobCreate')
BEGIN
	print '>>> Drop Stored Procedure: archFileForPreparedJobCreate <<<'
	drop procedure archFileForPreparedJobCreate
END
IF EXISTS (select * from GxQscripts where name='archFileForPreparedJobCreate')
	delete from GxQscripts where name = 'archFileForPreparedJobCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileForPreparedJobCreate')
	delete from GXDBVersions where aliasname = 'archFileForPreparedJobCreate'
GO
print '... Creating Procedure: archFileForPreparedJobCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileForPreparedJobCreate
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_newJobId INTEGER,
  @i_newCommCellId INTEGER,
  @i_newArchGrpId INTEGER,
  @i_newCopyId INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
SET NOCOUNT ON
CREATE	TABLE #SMVolumeIds	(SMVolumeId INT, newSMVolumeId INT)
CREATE	TABLE #SMSnapIds	(SMSnapId INT, newSMSnapId INT)
CREATE	TABLE #MetaDataIds	(MetaDataId INT, newMetaDataId INT)
DECLARE	@l_archFileId		INT
DECLARE	@l_SMVolumeId		INT
DECLARE	@l_newArchFileId	INT
DECLARE	@l_newSMVolumeId	INT
-- Create archFile, archFileCopy and SMVolume table entries
DECLARE ArchFileCur CURSOR FOR
SELECT	AF.id
FROM	archFile AF, SMVolume SV
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId
	AND SV.ArchFileId = AF.id AND SV.CommCellId = AF.commCellId
OPEN	ArchFileCur
FETCH	NEXT FROM ArchFileCur INTO @l_archFileId
WHILE	@@FETCH_STATUS = 0
BEGIN
	INSERT	INTO archFile
	SELECT	name, @i_newCommCellId, @i_newArchGrpId, objName1, flags,
			appId, fileType, cTime, @i_newJobId, backupLevel,
			isValid, cloudId, contentIndexTime, nPushedItems
	FROM	archFile
	WHERE	id = @l_archFileId AND commCellId = @i_commCellId
	SET		@l_newArchFileId = SCOPE_IDENTITY()
	INSERT	INTO archFileCopy
	SELECT	@l_newArchFileId, @i_newCommCellId, @i_newCopyId, flags, isValid,
			streamNum, lastChunkNumber, physicalSize, logicalSize, drivePoolId,
			encRSA, encKeyType, encKey, modifiedTime, mediaType, agedBy, encKeyId, unCompSize
	FROM	archFileCopy
	WHERE	archFileId = @l_archFileId AND commCellId = @i_commCellId
	INSERT	INTO archFileOracle
	SELECT	@l_newArchFileId, @i_newCommCellId, appId, instanceId, clientId, archFileName, fileType, flags, @i_newJobId
	FROM	archFileOracle
	WHERE	archFileId = @l_archFileId AND commCellId = @i_commCellId
	-- One archive file has only one SMVolumeId
	SELECT	@l_SMVolumeId = SMVolumeId
	FROM	SMVolume
	WHERE	CommCellId = @i_commCellId AND JobId = @i_jobId AND ArchFileId = @l_archFileId
	INSERT	INTO SMVolume (SourceclientId, MountHostId, CommCellId, JobId, ArchFileId,
			CopyId, AppId, AppTypeId, PruneFlags, VolumeFlags, VolumeStatus, VolumeStatusUpdateTime,
			MountStatus, MountStatusUpdateTime, LogicalUnmountTime, CreationTime, RetryCount,
			DevMode, UserId, GroupId, SnapSource, MountProxyId, RemoteOp, RemoteOpStatus, VmHostId,
			RecoveryPointId, OriginClientId, SourcePath, MountPath, SourceGUID, MountGUID,
			SourceDevice, MountDevice, MountOptions, ShadowSetId, ShadowCopyId, RepBasePath, RepRelativePath, OriginSourcePath, GUID,
			ReserveField1, ReserveField2, ReserveFieldStr)
	SELECT	SourceClientId, MountHostId, @i_newCommCellId, @i_newJobId, @l_newArchFileId,
			@i_newCopyId, AppId, AppTypeId, PruneFlags, VolumeFlags, VolumeStatus, VolumeStatusUpdateTime,
			MountStatus, MountStatusUpdateTime, LogicalUnmountTime, CreationTime, RetryCount,
			DevMode, UserId, GroupId, SnapSource, MountProxyId, RemoteOp, RemoteOpStatus, VmHostId,
			RecoveryPointId, OriginClientId, SourcePath, MountPath, SourceGUID, MountGUID,
			SourceDevice, MountDevice, MountOptions, ShadowSetId, ShadowCopyId, RepBasePath, RepRelativePath, OriginSourcePath, GUID,
			ReserveField1, ReserveField2, ReserveFieldStr
	FROM	SMVolume
	WHERE	SMVolumeId = @l_SMVolumeId
	SET		@l_newSMVolumeId = SCOPE_IDENTITY()
	INSERT	INTO #SMVolumeIds VALUES (@l_SMVolumeId, @l_newSMVolumeId)
	-- Create SMMetaData table entries for RefType 1
	INSERT	INTO SMMetaData(MetaDataType, RefType, RefId, PruneFlags, MetaData, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr)
	SELECT	MetaDataType, RefType, @l_newSMVolumeId, PruneFlags, MetaData, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr
	FROM	SMMetaData
	WHERE	RefType = 1 AND RefId = @l_SMVolumeId
	FETCH NEXT FROM ArchFileCur INTO @l_archFileId
END
CLOSE		ArchFileCur
DEALLOCATE	ArchFileCur
DECLARE	@l_SMVolSnapMapId	INT
DECLARE	@l_newVolSnapMapId	INT
DECLARE	@l_SMSnapId			INT
DECLARE	@l_MetaDataId		INT
DECLARE	@l_newSMSnapId		INT
DECLARE	@l_newMetaDataId	INT
-- Create SMSnap table entries
DECLARE SMSnapCur CURSOR FOR
SELECT	DISTINCT a.SMSnapId
FROM	SMVolSnapMap a, #SMVolumeIds b
WHERE	a.SMVolumeId = b.SMVolumeId
OPEN	SMSnapCur
FETCH	NEXT FROM SMSnapCur INTO @l_SMSnapId
WHILE	@@FETCH_STATUS = 0
BEGIN
	INSERT	INTO SMSnap (SnapShotEngineId, OriginalSnapEngineId, ControlHostId, GroupId, SnapType, SnapFlags, PruneFlags,
			SnapStatus, SnapStatusUpdateTime, CreationTime, ReplicationStatus, DeviceEntryType,
			ConnectionType, SnapSourceDevice, SnapDevice, ShadowCopyId, UniqueIdentifier,
			SourceIdentifier, TargetIdentifier, OrigCCId, GUID,
			ReserveField1, ReserveField2, ReserveFieldStr,
			ArrayVolumeId, LunId, UsedSpaceBytes, ReserveField3, ReserveField4)
	SELECT	SnapShotEngineId, OriginalSnapEngineId, ControlHostId, GroupId, SnapType, SnapFlags, PruneFlags,
			SnapStatus, SnapStatusUpdateTime, CreationTime, ReplicationStatus, DeviceEntryType,
			ConnectionType, SnapSourceDevice, SnapDevice, ShadowCopyId, UniqueIdentifier,
			SourceIdentifier, TargetIdentifier, OrigCCId, GUID,
			ReserveField1, ReserveField2, ReserveFieldStr,
			ArrayVolumeId, LunId, UsedSpaceBytes, ReserveField3, ReserveField4
	FROM	SMSnap
	WHERE	SMSnapId = @l_SMSnapId
	SET		@l_newSMSnapId = SCOPE_IDENTITY()
	INSERT	INTO #SMSnapIds VALUES (@l_SMSnapId, @l_newSMSnapId)
	-- Create SMMetaData table entries for RefType 2
	INSERT	INTO SMMetaData(MetaDataType, RefType, RefId, PruneFlags, MetaData, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr)
	SELECT	MetaDataType, RefType, @l_newSMSnapId, PruneFlags, MetaData, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr
	FROM	SMMetaData
	WHERE	RefType = 2 AND RefId = @l_SMSnapId
	FETCH	NEXT FROM SMSnapCur INTO @l_SMSnapId
END
CLOSE		SMSnapCur
DEALLOCATE	SMSnapCur
-- Create SMMetaData table entries for RefType other than 1 and 2
DECLARE MetaDataCur CURSOR FOR
SELECT	DISTINCT a.MetaDataId
FROM	SMVolSnapMap a, #SMVolumeIds b
WHERE	a.SMVolumeId = b.SMVolumeId AND a.MetaDataId > 0
OPEN	MetaDataCur
FETCH	NEXT FROM MetaDataCur INTO @l_MetaDataId
WHILE	@@FETCH_STATUS = 0
BEGIN
	INSERT	INTO SMMetaData(MetaDataType, RefType, RefId, PruneFlags, MetaData, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr)
	SELECT	MetaDataType, RefType, RefId, PruneFlags, MetaData, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr
	FROM	SMMetaData
	WHERE	MetaDataId = @l_MetaDataId
	SET		@l_newMetaDataId = SCOPE_IDENTITY()
	INSERT	INTO #MetaDataIds VALUES (@l_MetaDataId, @l_newMetaDataId)
	FETCH	NEXT FROM MetaDataCur INTO @l_MetaDataId
END
CLOSE		MetaDataCur
DEALLOCATE	MetaDataCur
-- Create SMVolSnapMap table entries and update SMMetaData.RefId
-- SMVolumeId and SMSnapId can have many to many relationship
DECLARE SMVolSnapMapCur CURSOR FOR
SELECT	a.SMVolSnapMapId, a.SMVolumeId, b.newSMVolumeId, a.SMSnapId, c.newSMSnapId, a.MetaDataId, ISNULL(d.newMetaDataId, 0)
FROM	SMVolSnapMap a
		INNER JOIN #SMVolumeIds b ON a.SMVolumeId = b.SMVolumeId
		INNER JOIN #SMSnapIds c ON a.SMSnapId = c.SMSnapId
		LEFT OUTER JOIN #MetaDataIds d ON a.MetaDataId = d.MetaDataId
OPEN	SMVolSnapMapCur
FETCH	NEXT FROM SMVolSnapMapCur INTO @l_SMVolSnapMapId, @l_SMVolumeId, @l_newSMVolumeId, @l_SMSnapId, @l_newSMSnapId, @l_MetaDataId, @l_newMetaDataId
WHILE	@@FETCH_STATUS = 0
BEGIN
	INSERT	INTO SMVolSnapMap (SMVolumeId, SMSnapId, MetaDataId, GroupId, PruneFlags, OrigCCId, GUID, ReserveField1, ReserveField2, ReserveFieldStr)
	SELECT	@l_newSMVolumeId, @l_newSMSnapId, @l_newMetaDataId,
			GroupId, PruneFlags, OrigCCId, GUID,
			ReserveField1, ReserveField2, ReserveFieldStr
	FROM	SMVolSnapMap
	WHERE	SMVolSnapMapId = @l_SMVolSnapMapId
	SET		@l_newVolSnapMapId = SCOPE_IDENTITY()
	UPDATE	SMMetaData
	SET		RefId = @l_newVolSnapMapId
	WHERE	MetaDataId = @l_newMetaDataId
		AND RefType = 3 AND RefId = @l_SMVolSnapMapId
	FETCH	NEXT FROM SMVolSnapMapCur INTO @l_SMVolSnapMapId, @l_SMVolumeId, @l_newSMVolumeId, @l_SMSnapId, @l_newSMSnapId, @l_MetaDataId, @l_newMetaDataId
END
CLOSE		SMVolSnapMapCur
DEALLOCATE	SMVolSnapMapCur
DROP TABLE	#SMVolumeIds
DROP TABLE	#SMSnapIds
DROP TABLE	#MetaDataIds
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileForPreparedJobCreate')
	delete from GxQscripts where name = 'archFileForPreparedJobCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileForPreparedJobCreate')
	delete from GXDBVersions where aliasname = 'archFileForPreparedJobCreate'
GO

insert into GXDBVersions values(2, 'archFileForPreparedJobCreate',  '00010018001200030000', 'archFileForPreparedJobCreate', '00010018001200030000')
GO

